"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGImageNode(QSGGeometryNode):
    """
    https://doc.qt.io/qt-5/qsgimagenode.html

    **Detailed Description**

    **Warning:** The image node class must have a texture before being added to
    the scene graph to be rendered.
    """

    class TextureCoordinatesTransformFlag(int):
        NoTransform: QSGImageNode = ...
        MirrorHorizontally: QSGImageNode = ...
        MirrorVertically: QSGImageNode = ...

    class TextureCoordinatesTransformMode(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QSGImageNode.TextureCoordinatesTransformMode",
                "QSGImageNode.TextureCoordinatesTransformFlag",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGImageNode.TextureCoordinatesTransformMode") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGImageNode.TextureCoordinatesTransformMode":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @staticmethod
    def rebuildGeometry(
        g: QSGGeometry,
        texture: "QSGTexture",
        rect: QtCore.QRectF,
        sourceRect: QtCore.QRectF,
        texCoordMode: typing.Union[
            "QSGImageNode.TextureCoordinatesTransformMode",
            "QSGImageNode.TextureCoordinatesTransformFlag",
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#rebuildGeometry

        **[static] void QSGImageNode::rebuildGeometry(QSGGeometry * g ,
        QSGTexture * texture , const QRectF & rect , QRectF sourceRect ,
        QSGImageNode::TextureCoordinatesTransformMode texCoordMode )**

        Updates the geometry **g** with the **texture** , the coordinates in
        **rect** , and the texture coordinates from **sourceRect**.

        **g** is assumed to be a triangle strip of four vertices of type
        **QSGGeometry::TexturedPoint2D** .

        **texCoordMode** is used for normalizing the **sourceRect**.
        """
        ...

    def ownsTexture(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#ownsTexture

        **[pure virtual] bool QSGImageNode::ownsTexture() const**

        Returns `true` if the node takes ownership of the texture; otherwise
        `false`.

        **See also** **setOwnsTexture** ().
        """
        ...

    def setOwnsTexture(self, owns: bool) -> None:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#setOwnsTexture

        **[pure virtual] void QSGImageNode::setOwnsTexture(bool owns )**

        Sets whether the node takes ownership of the texture to **owns**.

        By default, the node does not take ownership of the texture.

        **See also** **ownsTexture** ().
        """
        ...

    def textureCoordinatesTransform(
        self,
    ) -> "QSGImageNode.TextureCoordinatesTransformMode":
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#textureCoordinatesTransform

        **[pure virtual] QSGImageNode::TextureCoordinatesTransformMode
        QSGImageNode::textureCoordinatesTransform() const**

        Returns the mode used to generate texture coordinates for this node.

        **See also** **setTextureCoordinatesTransform** ().
        """
        ...

    def setTextureCoordinatesTransform(
        self,
        mode: typing.Union[
            "QSGImageNode.TextureCoordinatesTransformMode",
            "QSGImageNode.TextureCoordinatesTransformFlag",
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#setTextureCoordinatesTransform

        **[pure virtual] void QSGImageNode::setTextureCoordinatesTransform(QSGIm
        ageNode::TextureCoordinatesTransformMode mode )**

        Sets the method used to generate texture coordinates to **mode**. This
        can be used to obtain correct orientation of the texture. This is
        commonly needed when using a third-party OpenGL library to render to
        texture as OpenGL has an inverted y-axis relative to Qt Quick.

        **See also** **textureCoordinatesTransform** ().
        """
        ...

    def mipmapFiltering(self) -> "QSGTexture.Filtering":
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#mipmapFiltering

        **[pure virtual] QSGTexture::Filtering QSGImageNode::mipmapFiltering()
        const**

        Returns the mipmap filtering for this image node.

        **See also** **setMipmapFiltering** ().
        """
        ...

    def setMipmapFiltering(self, filtering: "QSGTexture.Filtering") -> None:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#setMipmapFiltering

        **[pure virtual] void
        QSGImageNode::setMipmapFiltering(QSGTexture::Filtering filtering )**

        Sets the mipmap filtering to be used for this image node to
        **filtering**.

        For smooth scaling between mip maps, use **QSGTexture::Linear** . For
        normal scaling, use **QSGTexture::Nearest** .

        **See also** **mipmapFiltering** ().
        """
        ...

    def filtering(self) -> "QSGTexture.Filtering":
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#filtering

        **[pure virtual] QSGTexture::Filtering QSGImageNode::filtering() const**

        Returns the filtering for this image node.

        **See also** **setFiltering** ().
        """
        ...

    def setFiltering(self, filtering: "QSGTexture.Filtering") -> None:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#setFiltering

        **[pure virtual] void QSGImageNode::setFiltering(QSGTexture::Filtering
        filtering )**

        Sets the filtering to be used for this image node to **filtering**.

        For smooth scaling, use **QSGTexture::Linear** . For normal scaling, use
        **QSGTexture::Nearest** .

        **See also** **filtering** ().
        """
        ...

    def texture(self) -> "QSGTexture":
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#texture

        **[pure virtual] QSGTexture *QSGImageNode::texture() const**

        Returns the texture for this image node.

        **See also** **setTexture** ().
        """
        ...

    def setTexture(self, texture: "QSGTexture") -> None:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#setTexture

        **[pure virtual] void QSGImageNode::setTexture(QSGTexture * texture )**

        Sets the texture of this image node to **texture**.

        Use **setOwnsTexture** () to set whether the node should take ownership
        of the texture. By default, the node does not take ownership.

        **Warning:** An image node must have a texture before being added to the
        scenegraph to be rendered.

        **See also** **texture** ().
        """
        ...

    def sourceRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#sourceRect

        **[pure virtual] QRectF QSGImageNode::sourceRect() const**

        Returns the source rect of this image node.

        **See also** **setSourceRect** ().
        """
        ...

    @typing.overload
    def setSourceRect(self, r: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#setSourceRect

        **[pure virtual] void QSGImageNode::setSourceRect(const QRectF & rect
        )**

        Sets the source rect of this image node to **rect**.

        **See also** **sourceRect** ().
        """
        ...

    @typing.overload
    def setSourceRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#setSourceRect-1

        **void QSGImageNode::setSourceRect(qreal x , qreal y , qreal w , qreal h
        )**

        This is an overloaded function.

        Sets the rectangle of this image node to show its texture from ( **x** ,
        **y** ) and have width **w** and height **h** relatively to the
        **QSGTexture::textureSize** .
        """
        ...

    def rect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#rect

        **[pure virtual] QRectF QSGImageNode::rect() const**

        Returns the target rect of this image node.

        **See also** **setRect** ().
        """
        ...

    @typing.overload
    def setRect(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#setRect

        **[pure virtual] void QSGImageNode::setRect(const QRectF & rect )**

        Sets the target rect of this image node to **rect**.

        **See also** **rect** ().
        """
        ...

    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-5/qsgimagenode.html#setRect-1

        **void QSGImageNode::setRect(qreal x , qreal y , qreal w , qreal h )**

        This is an overloaded function.

        Sets the rectangle of this image node to begin at ( **x** , **y** ) and
        have width **w** and height **h**.
        """
        ...
