"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGGeometry(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qsggeometry.html

    **Detailed Description**

    The QSGGeometry class stores the geometry of the primitives rendered with
    the scene graph. It contains vertex data and optionally index data. The mode
    used to draw the geometry is specified with **setDrawingMode** (), which
    maps directly to the graphics API's drawing mode, such as
    `GL_TRIANGLE_STRIP`, `GL_TRIANGLES`, or `GL_POINTS` in case of OpenGL.

    Vertices can be as simple as points defined by x and y values or can be more
    complex where each vertex contains a normal, texture coordinates and a 3D
    position. The **QSGGeometry::AttributeSet**  is used to describe how the
    vertex data is built up. The attribute set can only be specified on
    construction. The QSGGeometry class provides a few convenience attributes
    and attribute sets by default. The **defaultAttributes_Point2D** () function
    returns an attribute set to be used in normal solid color rectangles, while
    the **defaultAttributes_TexturedPoint2D**  function returns attributes to be
    used for textured 2D geometry. The vertex data is internally stored as a
    `void *` and is accessible with the **vertexData** () function. Convenience
    accessors for the common attribute sets are available with
    **vertexDataAsPoint2D** () and **vertexDataAsTexturedPoint2D** (). Vertex
    data is allocated by passing a vertex count to the constructor or by calling
    **allocate** () later.

    The QSGGeometry can optionally contain indices of either unsigned 32-bit,
    unsigned 16-bit, or unsigned 8-bit integers. The index type must be
    specified during construction and cannot be changed.

    Below is a snippet illustrating how a geometry composed of position and
    color vertices can be built.

    struct MyPoint2D {
            float x;
            float y;
            float r;
    float g;
            float b;
            float a;

            void set(float x_,
    float y_, float r_, float g_, float b_, float a_) {
                x = x_;
    y = y_;
                r = r_;
                g = g_;
                b = b_;
    a = a_;
            }
        };

        **QSGGeometry** ::Attribute
    MyPoint2D_Attributes[] = {
            **QSGGeometry** ::Attribute::create(0, 2,
    GL_FLOAT, true),
            **QSGGeometry** ::Attribute::create(1, 4, GL_FLOAT,
    false)
        };

        **QSGGeometry** ::AttributeSet MyPoint2D_AttributeSet
    = {
            2,
            sizeof(MyPoint2D),
            MyPoint2D_Attributes
    };

        ...

        geometry = new **QSGGeometry**
    (MyPoint2D_AttributeSet, 2);
        geometry->setDrawingMode(GL_LINES);
    MyPoint2D *vertices = static_cast<MyPoint2D *>(geometry->vertexData());
    vertices[0].set(0, 0, 1, 0, 0, 1);
        vertices[1].set(width(), height(), 0,
    0, 1, 1);

    The QSGGeometry is a software buffer and client-side in terms of OpenGL
    rendering, as the buffers used in 2D graphics typically consist of many
    small buffers that change every frame and do not benefit from being uploaded
    to graphics memory. However, the QSGGeometry supports hinting to the
    renderer that a buffer should be uploaded using the **setVertexDataPattern**
    () and **setIndexDataPattern** () functions. Whether this hint is respected
    or not is implementation specific.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.

    **See also** **QSGGeometryNode**  and **Scene Graph - Custom Geometry** .
    """

    class Type(int):
        ByteType: QSGGeometry = ...
        UnsignedByteType: QSGGeometry = ...
        ShortType: QSGGeometry = ...
        UnsignedShortType: QSGGeometry = ...
        IntType: QSGGeometry = ...
        UnsignedIntType: QSGGeometry = ...
        FloatType: QSGGeometry = ...
        Bytes2Type: QSGGeometry = ...
        Bytes3Type: QSGGeometry = ...
        Bytes4Type: QSGGeometry = ...
        DoubleType: QSGGeometry = ...

    class DrawingMode(int):
        DrawPoints: QSGGeometry = ...
        DrawLines: QSGGeometry = ...
        DrawLineLoop: QSGGeometry = ...
        DrawLineStrip: QSGGeometry = ...
        DrawTriangles: QSGGeometry = ...
        DrawTriangleStrip: QSGGeometry = ...
        DrawTriangleFan: QSGGeometry = ...

    class AttributeType(int):
        UnknownAttribute: QSGGeometry = ...
        PositionAttribute: QSGGeometry = ...
        ColorAttribute: QSGGeometry = ...
        TexCoordAttribute: QSGGeometry = ...
        TexCoord1Attribute: QSGGeometry = ...
        TexCoord2Attribute: QSGGeometry = ...

    class DataPattern(int):
        AlwaysUploadPattern: QSGGeometry = ...
        StreamPattern: QSGGeometry = ...
        DynamicPattern: QSGGeometry = ...
        StaticPattern: QSGGeometry = ...

    GL_POINTS: int = ...
    GL_LINES: int = ...
    GL_LINE_LOOP: int = ...
    GL_LINE_STRIP: int = ...
    GL_TRIANGLES: int = ...
    GL_TRIANGLE_STRIP: int = ...
    GL_TRIANGLE_FAN: int = ...
    GL_BYTE: int = ...
    GL_DOUBLE: int = ...
    GL_FLOAT: int = ...
    GL_INT: int = ...

    class Attribute(sip.simplewrapper):
        attributeType = ...
        isVertexCoordinate: int = ...
        position: int = ...
        tupleSize: int = ...
        type: int = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGGeometry.Attribute") -> None:
            ...

        @staticmethod
        def createWithAttributeType(
            pos: int,
            tupleSize: int,
            primitiveType: int,
            attributeType: "QSGGeometry.AttributeType",
        ) -> "QSGGeometry.Attribute":
            ...

        @staticmethod
        def create(
            pos: int, tupleSize: int, primitiveType: int, isPosition: bool = ...
        ) -> "QSGGeometry.Attribute":
            ...

    class AttributeSet(sip.simplewrapper):
        attributes: PyQt5 = ...
        count: int = ...
        stride: int = ...

        def __init__(
            self,
            attributes: typing.Iterable["QSGGeometry.Attribute"],
            stride: int = ...,
        ) -> None:
            ...

    class Point2D(sip.simplewrapper):
        x: float = ...
        y: float = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGGeometry.Point2D") -> None:
            ...

        def set(self, nx: float, ny: float) -> None:
            ...

    class TexturedPoint2D(sip.simplewrapper):
        tx: float = ...
        ty: float = ...
        x: float = ...
        y: float = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGGeometry.TexturedPoint2D") -> None:
            ...

        def set(self, nx: float, ny: float, ntx: float, nty: float) -> None:
            ...

    class ColoredPoint2D(sip.simplewrapper):
        a: int = ...
        b: int = ...
        g: int = ...
        r: int = ...
        x: float = ...
        y: float = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGGeometry.ColoredPoint2D") -> None:
            ...

        def set(self, nx: float, ny: float, nr: int, ng: int, nb: int, na: int) -> None:
            ...

    def __init__(
        self,
        attribs: "QSGGeometry.AttributeSet",
        vertexCount: int,
        indexCount: int = ...,
        indexType: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#QSGGeometry

        **QSGGeometry::QSGGeometry(const QSGGeometry::AttributeSet & attributes
        , int vertexCount , int indexCount = 0, int indexType =
        UnsignedShortType)**

        Constructs a geometry object based on **attributes**.

        The object allocate space for **vertexCount** vertices based on the
        accumulated size in **attributes** and for **indexCount**.

        The **indexType** maps to the OpenGL index type and can be
        `GL_UNSIGNED_SHORT` and `GL_UNSIGNED_BYTE`. On OpenGL implementations
        that support it, such as desktop OpenGL, `GL_UNSIGNED_INT` can also be
        used.

        Geometry objects are constructed with `GL_TRIANGLE_STRIP` as default
        drawing mode.

        The attribute structure is assumed to be POD and the geometry object
        assumes this will not go away. There is no memory management involved.
        """
        ...

    @staticmethod
    def updateColoredRectGeometry(g: "QSGGeometry", rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#updateColoredRectGeometry

        **[static] void QSGGeometry::updateColoredRectGeometry(QSGGeometry * g ,
        const QRectF & rect )**

        Updates the geometry **g** with the coordinates in **rect**.

        The function assumes the geometry object contains a single triangle
        strip of **QSGGeometry::ColoredPoint2D**  vertices
        """
        ...

    def sizeOfIndex(self) -> int:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#sizeOfIndex

        **int QSGGeometry::sizeOfIndex() const**

        Returns the byte size of the index type.

        This value is either `1` when index type is `GL_UNSIGNED_BYTE` or `2`
        when index type is `GL_UNSIGNED_SHORT`. For Desktop OpenGL,
        `GL_UNSIGNED_INT` with the value `4` is also supported.
        """
        ...

    def vertexDataAsColoredPoint2D(self) -> PyQt5.sip.array[QSGGeometry.ColoredPoint2D]:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#vertexDataAsColoredPoint2D

        **QSGGeometry::ColoredPoint2D
        *QSGGeometry::vertexDataAsColoredPoint2D()**

        Convenience function to access the vertex data as a mutable array of
        **QSGGeometry::ColoredPoint2D** .
        """
        ...

    def vertexDataAsTexturedPoint2D(
        self,
    ) -> PyQt5.sip.array[QSGGeometry.TexturedPoint2D]:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#vertexDataAsTexturedPoint2D

        **QSGGeometry::TexturedPoint2D
        *QSGGeometry::vertexDataAsTexturedPoint2D()**

        Convenience function to access the vertex data as a mutable array of
        **QSGGeometry::TexturedPoint2D** .
        """
        ...

    def vertexDataAsPoint2D(self) -> PyQt5.sip.array[QSGGeometry.Point2D]:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#vertexDataAsPoint2D

        **QSGGeometry::Point2D *QSGGeometry::vertexDataAsPoint2D()**

        Convenience function to access the vertex data as a mutable array of
        **QSGGeometry::Point2D** .
        """
        ...

    def indexDataAsUShort(self) -> PyQt5.sip.array[int]:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#indexDataAsUShort

        **quint16 *QSGGeometry::indexDataAsUShort()**

        Convenience function to access the index data as a mutable array of
        16-bit unsigned integers.
        """
        ...

    def indexDataAsUInt(self) -> PyQt5.sip.array[int]:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#indexDataAsUInt

        **uint *QSGGeometry::indexDataAsUInt()**

        Convenience function to access the index data as a mutable array of
        32-bit unsigned integers.
        """
        ...

    def setLineWidth(self, w: float) -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#setLineWidth

        **void QSGGeometry::setLineWidth(float width )**

        Sets the line or point width to be used for this geometry to **width**.
        This property only applies to line width when the **drawingMode**  is
        **DrawLines** , **DrawLineStrip** , or **DrawLineLoop** . For Desktop
        OpenGL, it also applies to point size when the **drawingMode**  is
        **DrawPoints** .

        **Note:** How line width and point size are treated is implementation
        dependent: The application should not rely on these, but rather create
        triangles or similar to draw areas. On OpenGL ES, line width support is
        limited and point size is unsupported.

        **See also** **lineWidth** () and **drawingMode** ().
        """
        ...

    def lineWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#lineWidth

        **float QSGGeometry::lineWidth() const**

        Gets the current line or point width or to be used for this geometry.
        This property only applies to line width when the **drawingMode**  is
        **DrawLines** , DarwLineStrip, or **DrawLineLoop** . For desktop OpenGL,
        it also applies to point size when the **drawingMode**  is
        **DrawPoints** .

        The default value is `1.0`

        **Note:** When not using OpenGL, support for point and line drawing may
        be limited. For example, some APIs do not support point sprites and so
        setting a size other than 1 is not possible. Some backends may be able
        implement support via geometry shaders, but this is not guaranteed to be
        always available.

        **See also** **setLineWidth** () and **drawingMode** ().
        """
        ...

    def markVertexDataDirty(self) -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#markVertexDataDirty

        **void QSGGeometry::markVertexDataDirty()**

        Mark that the vertices in this geometry has changed and must be uploaded
        again.

        This function only has an effect when the usage pattern for vertices is
        StaticData and the renderer that renders this geometry uploads the
        geometry into Vertex Buffer Objects (VBOs).
        """
        ...

    def markIndexDataDirty(self) -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#markIndexDataDirty

        **void QSGGeometry::markIndexDataDirty()**

        Mark that the vertices in this geometry has changed and must be uploaded
        again.

        This function only has an effect when the usage pattern for vertices is
        StaticData and the renderer that renders this geometry uploads the
        geometry into Vertex Buffer Objects (VBOs).
        """
        ...

    def vertexDataPattern(self) -> "QSGGeometry.DataPattern":
        """
        https://doc.qt.io/qt-5/qsggeometry.html#vertexDataPattern

        **QSGGeometry::DataPattern QSGGeometry::vertexDataPattern() const**

        Returns the usage pattern for vertices in this geometry. The default
        pattern is **AlwaysUploadPattern** .

        **See also** **setVertexDataPattern** ().
        """
        ...

    def setVertexDataPattern(self, p: "QSGGeometry.DataPattern") -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#setVertexDataPattern

        **void QSGGeometry::setVertexDataPattern(QSGGeometry::DataPattern p )**

        Sets the usage pattern for vertices to **p**.

        The default is **AlwaysUploadPattern** . When set to anything other than
        the default, the user must call **markVertexDataDirty** () after
        changing the vertex data, in addition to calling **QSGNode::markDirty**
        () with **QSGNode::DirtyGeometry** .

        **See also** **vertexDataPattern** ().
        """
        ...

    def indexDataPattern(self) -> "QSGGeometry.DataPattern":
        """
        https://doc.qt.io/qt-5/qsggeometry.html#indexDataPattern

        **QSGGeometry::DataPattern QSGGeometry::indexDataPattern() const**

        Returns the usage pattern for indices in this geometry. The default
        pattern is **AlwaysUploadPattern** .

        **See also** **setIndexDataPattern** ().
        """
        ...

    def setIndexDataPattern(self, p: "QSGGeometry.DataPattern") -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#setIndexDataPattern

        **void QSGGeometry::setIndexDataPattern(QSGGeometry::DataPattern p )**

        Sets the usage pattern for indices to **p**.

        The default is **AlwaysUploadPattern** . When set to anything other than
        the default, the user must call **markIndexDataDirty** () after changing
        the index data, in addition to calling **QSGNode::markDirty** () with
        **QSGNode::DirtyGeometry** .

        **See also** **indexDataPattern** ().
        """
        ...

    @staticmethod
    def updateTexturedRectGeometry(
        g: "QSGGeometry", rect: QtCore.QRectF, sourceRect: QtCore.QRectF
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#updateTexturedRectGeometry

        **[static] void QSGGeometry::updateTexturedRectGeometry(QSGGeometry * g
        , const QRectF & rect , const QRectF & textureRect )**

        Updates the geometry **g** with the coordinates in **rect** and texture
        coordinates from **textureRect**.

        **textureRect** should be in normalized coordinates.

        **g** is assumed to be a triangle strip of four vertices of type
        **QSGGeometry::TexturedPoint2D** .
        """
        ...

    @staticmethod
    def updateRectGeometry(g: "QSGGeometry", rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#updateRectGeometry

        **[static] void QSGGeometry::updateRectGeometry(QSGGeometry * g , const
        QRectF & rect )**

        Updates the geometry **g** with the coordinates in **rect**.

        The function assumes the geometry object contains a single triangle
        strip of **QSGGeometry::Point2D**  vertices
        """
        ...

    def sizeOfVertex(self) -> int:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#sizeOfVertex

        **int QSGGeometry::sizeOfVertex() const**

        Returns the size in bytes of one vertex.

        This value comes from the attributes.
        """
        ...

    def attributes(self) -> PyQt5.sip.array[QSGGeometry.Attribute]:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#attributes

        **const QSGGeometry::Attribute *QSGGeometry::attributes() const**

        Returns an array with the attributes of this geometry. The size of the
        array is given with **attributeCount** ().
        """
        ...

    def attributeCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#attributeCount

        **int QSGGeometry::attributeCount() const**

        Returns the number of attributes in the attrbute set used by this
        geometry.
        """
        ...

    def indexData(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#indexData

        **void *QSGGeometry::indexData()**

        Returns a pointer to the raw index data of this geometry object.

        **See also** **indexDataAsUShort** () and **indexDataAsUInt** ().
        """
        ...

    def indexCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#indexCount

        **int QSGGeometry::indexCount() const**

        Returns the number of indices in this geometry object.
        """
        ...

    def indexType(self) -> int:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#indexType

        **int QSGGeometry::indexType() const**

        Returns the primitive type used for indices in this geometry object.
        """
        ...

    def vertexData(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#vertexData

        **void *QSGGeometry::vertexData()**

        Returns a pointer to the raw vertex data of this geometry object.

        **See also** **vertexDataAsPoint2D** () and
        **vertexDataAsTexturedPoint2D** ().
        """
        ...

    def vertexCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#vertexCount

        **int QSGGeometry::vertexCount() const**

        Returns the number of vertices in this geometry object.
        """
        ...

    def allocate(self, vertexCount: int, indexCount: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#allocate

        **void QSGGeometry::allocate(int vertexCount , int indexCount = 0)**

        Resizes the vertex and index data of this geometry object to fit
        **vertexCount** vertices and **indexCount** indices.

        Vertex and index data will be invalidated after this call and the caller
        must mark the associated geometry node as dirty, by calling
        node->markDirty(**QSGNode::DirtyGeometry** ) to ensure that the renderer
        has a chance to update internal buffers.
        """
        ...

    def drawingMode(self) -> int:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#drawingMode

        **unsigned int QSGGeometry::drawingMode() const**

        Returns the drawing mode of this geometry.

        The default value is `GL_TRIANGLE_STRIP`.

        **See also** **setDrawingMode** ().
        """
        ...

    def setDrawingMode(self, mode: int) -> None:
        """
        https://doc.qt.io/qt-5/qsggeometry.html#setDrawingMode

        **void QSGGeometry::setDrawingMode(unsigned int mode )**

        Sets the **mode** to be used for drawing this geometry.

        The default value is **QSGGeometry::DrawTriangleStrip** .

        **See also** **drawingMode** () and **DrawingMode** .
        """
        ...

    @staticmethod
    def defaultAttributes_ColoredPoint2D() -> "QSGGeometry.AttributeSet":
        """
        https://doc.qt.io/qt-5/qsggeometry.html#defaultAttributes_ColoredPoint2D

        **[static] const QSGGeometry::AttributeSet
        &QSGGeometry::defaultAttributes_ColoredPoint2D()**

        Convenience function which returns attributes to be used for per vertex
        colored 2D drawing.
        """
        ...

    @staticmethod
    def defaultAttributes_TexturedPoint2D() -> "QSGGeometry.AttributeSet":
        """
        https://doc.qt.io/qt-5/qsggeometry.html#defaultAttributes_TexturedPoint2
        D

        **[static] const QSGGeometry::AttributeSet
        &QSGGeometry::defaultAttributes_TexturedPoint2D()**

        Convenience function which returns attributes to be used for textured 2D
        drawing.
        """
        ...

    @staticmethod
    def defaultAttributes_Point2D() -> "QSGGeometry.AttributeSet":
        """
        https://doc.qt.io/qt-5/qsggeometry.html#defaultAttributes_Point2D

        **[static] const QSGGeometry::AttributeSet
        &QSGGeometry::defaultAttributes_Point2D()**

        Convenience function which returns attributes to be used for 2D solid
        color drawing.
        """
        ...
