"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGAbstractRenderer(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qsgabstractrenderer.html

    **Detailed Description**

    A QSGAbstractRenderer created by a QSGEngine allows you to set your
    **QSGNode**  tree through **setRootNode** () and control the rendering
    viewport through **setDeviceRect** (), **setViewportRect** () and
    **setProjectionMatrixToRect** (). You can finally trigger the rendering to
    the desired framebuffer through **renderScene** ().

    The QSGAbstractRenderer is only available when used with a QSGEngine and
    isn't exposed when used internally by **QQuickWindow** .

    **See also** **QSGEngine**  and **QSGNode** .
    """

    class MatrixTransformFlag(int):
        MatrixTransformFlipY: QSGAbstractRenderer = ...

    class ClearModeBit(int):
        ClearColorBuffer: QSGAbstractRenderer = ...
        ClearDepthBuffer: QSGAbstractRenderer = ...
        ClearStencilBuffer: QSGAbstractRenderer = ...

    class ClearMode(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QSGAbstractRenderer.ClearMode", "QSGAbstractRenderer.ClearModeBit"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGAbstractRenderer.ClearMode") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGAbstractRenderer.ClearMode":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class MatrixTransformFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QSGAbstractRenderer.MatrixTransformFlags",
                "QSGAbstractRenderer.MatrixTransformFlag",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGAbstractRenderer.MatrixTransformFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGAbstractRenderer.MatrixTransformFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def renderScene(self, fboId: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#renderScene

        **[pure virtual] void QSGAbstractRenderer::renderScene(uint fboId = 0)**

        Render the scene to the specified **fboId**

        If **fboId** isn't specified, the scene graph will be rendered to the
        default framebuffer. You will have to call
        **QOpenGLContext::swapBuffers** () yourself afterward.

        The framebuffer specified by **fboId** will be bound automatically.

        **See also** **QOpenGLContext::swapBuffers** () and
        **QOpenGLFramebufferObject::handle** ().
        """
        ...

    def clearMode(self) -> "QSGAbstractRenderer.ClearMode":
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#clearMode

        **QSGAbstractRenderer::ClearMode QSGAbstractRenderer::clearMode()
        const**

        Flags defining which attachment of the framebuffer will be cleared
        before each scene render.

        **See also** **setClearMode** () and **clearColor** ().
        """
        ...

    def setClearMode(
        self,
        mode: typing.Union[
            "QSGAbstractRenderer.ClearMode", "QSGAbstractRenderer.ClearModeBit"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#setClearMode

        **void QSGAbstractRenderer::setClearMode(QSGAbstractRenderer::ClearMode
        mode )**

        Defines which attachment of the framebuffer should be cleared before
        each scene render with the **mode** flag.

        **See also** **clearMode** () and **setClearColor** ().
        """
        ...

    def clearColor(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#clearColor

        **QColor QSGAbstractRenderer::clearColor() const**

        Returns the color that clears the framebuffer at the beginning of the
        rendering.

        **See also** **setClearColor** () and **clearMode** ().
        """
        ...

    def setClearColor(
        self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#setClearColor

        **void QSGAbstractRenderer::setClearColor(const QColor & color )**

        Use **color** to clear the framebuffer when **clearMode** () is set to
        **QSGAbstractRenderer::ClearColorBuffer** .

        **See also** **clearColor** () and **setClearMode** ().
        """
        ...

    def projectionMatrix(self) -> QtGui.QMatrix4x4:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#projectionMatrix

        **QMatrix4x4 QSGAbstractRenderer::projectionMatrix() const**

        Returns the projection matrix

        **See also** **setProjectionMatrix** () and
        **setProjectionMatrixToRect** ().
        """
        ...

    def setProjectionMatrix(self, matrix: QtGui.QMatrix4x4) -> None:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#setProjectionMatrix

        **void QSGAbstractRenderer::setProjectionMatrix(const QMatrix4x4 &
        matrix )**

        Use **matrix** to project the **QSGNode**  coordinates onto surface
        pixels.

        **See also** **projectionMatrix** () and **setProjectionMatrixToRect**
        ().
        """
        ...

    @typing.overload
    def setProjectionMatrixToRect(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#setProjectionMatrixToRec
        t

        **void QSGAbstractRenderer::setProjectionMatrixToRect(const QRectF &
        rect )**

        Convenience method that calls **setProjectionMatrix** () with an
        orthographic matrix generated from **rect**.

        **Note:** This function assumes that the graphics API uses Y up in its
        normalized device coordinate system.

        **See also** **setProjectionMatrix** () and **projectionMatrix** ().
        """
        ...

    @typing.overload
    def setProjectionMatrixToRect(
        self,
        rect: QtCore.QRectF,
        flags: typing.Union[
            "QSGAbstractRenderer.MatrixTransformFlags",
            "QSGAbstractRenderer.MatrixTransformFlag",
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#setProjectionMatrixToRec
        t-1

        **void QSGAbstractRenderer::setProjectionMatrixToRect(const QRectF &
        rect , QSGAbstractRenderer::MatrixTransformFlags flags )**

        Convenience method that calls **setProjectionMatrix** () with an
        orthographic matrix generated from **rect**.

        Set **MatrixTransformFlipY**  in **flags** when the graphics API uses Y
        down in its normalized device coordinate system (for example, Vulkan).

        This function was introduced in Qt 5.14.

        **See also** **setProjectionMatrix** () and **projectionMatrix** ().
        """
        ...

    def viewportRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#viewportRect

        **QRect QSGAbstractRenderer::viewportRect() const**

        Returns the rect of the viewport to render.

        **See also** **setViewportRect** ().
        """
        ...

    @typing.overload
    def setViewportRect(self, rect: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#setViewportRect

        **void QSGAbstractRenderer::setViewportRect(const QRect & rect )**

        Sets **rect** as the geometry of the viewport to render on the surface.

        **See also** **viewportRect** ().
        """
        ...

    @typing.overload
    def setViewportRect(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#setViewportRect-1

        **void QSGAbstractRenderer::setViewportRect(const QSize & size )**

        This is an overloaded function.

        Sets the **size** of the viewport to render on the surface.

        **See also** **viewportRect** ().
        """
        ...

    def deviceRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#deviceRect

        **QRect QSGAbstractRenderer::deviceRect() const**

        Returns the device rect of the surface being rendered to.

        **See also** **setDeviceRect** ().
        """
        ...

    @typing.overload
    def setDeviceRect(self, rect: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#setDeviceRect

        **void QSGAbstractRenderer::setDeviceRect(const QRect & rect )**

        Sets **rect** as the geometry of the surface being rendered to.

        **See also** **deviceRect** ().
        """
        ...

    @typing.overload
    def setDeviceRect(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#setDeviceRect-1

        **void QSGAbstractRenderer::setDeviceRect(const QSize & size )**

        This is an overloaded function.

        Sets the **size** of the surface being rendered to.

        **See also** **deviceRect** ().
        """
        ...

    @property
    def sceneGraphChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qsgabstractrenderer.html#sceneGraphChanged

        **[signal] void QSGAbstractRenderer::sceneGraphChanged()**

        This signal is emitted on the first modification of a node in the tree
        after the last scene render.
        """
        ...
