"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick import *
from PyQt5 import sip


class QQuickPaintedItem(QQuickItem):
    """
    https://doc.qt.io/qt-5/qquickpainteditem.html

    **Detailed Description**

    The QQuickPaintedItem makes it possible to use the **QPainter**  API with
    the QML Scene Graph. It sets up a textured rectangle in the Scene Graph and
    uses a **QPainter**  to paint onto the texture. The render target can be
    either a **QImage**  or, when OpenGL is in use, a
    **QOpenGLFramebufferObject** . When the render target is a **QImage** ,
    **QPainter**  first renders into the image then the content is uploaded to
    the texture. When a **QOpenGLFramebufferObject**  is used, **QPainter**
    paints directly onto the texture. Call **update** () to trigger a repaint.

    To enable **QPainter**  to do anti-aliased rendering, use
    **setAntialiasing** ().

    To write your own painted item, you first create a subclass of
    QQuickPaintedItem, and then start by implementing its only pure virtual
    public function: **paint** (), which implements the actual painting. The
    painting will be inside the rectangle spanning from 0,0 to **width**
    (),**height** ().

    **Note:** It important to understand the performance implications such items
    can incur. See **QQuickPaintedItem::RenderTarget**  and
    **QQuickPaintedItem::renderTarget** .
    """

    class PerformanceHint(int):
        FastFBOResizing: QQuickPaintedItem = ...

    class RenderTarget(int):
        Image: QQuickPaintedItem = ...
        FramebufferObject: QQuickPaintedItem = ...
        InvertedYFramebufferObject: QQuickPaintedItem = ...

    class PerformanceHints(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QQuickPaintedItem.PerformanceHints",
                "QQuickPaintedItem.PerformanceHint",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QQuickPaintedItem.PerformanceHints") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QQuickPaintedItem.PerformanceHints":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, parent: typing.Optional[QQuickItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#QQuickPaintedItem

        **QQuickPaintedItem::QQuickPaintedItem(QQuickItem * parent = nullptr)**

        Constructs a QQuickPaintedItem with the given **parent** item.
        """
        ...

    def setTextureSize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#textureSize-prop

        **textureSize : QSize**

        Defines the size of the texture.

        Changing the texture's size does not affect the coordinate system used
        in **paint** (). A scale factor is instead applied so painting should
        still happen inside 0,0 to **width** (),**height** ().

        By default, the texture size will have the same size as this item.

        **Note:** If the item is on a window with a device pixel ratio different
        from 1, this scale factor will be implicitly applied to the texture
        size.

        **Access functions:**

        QSize **textureSize** () const
        void **setTextureSize** (const QSize &
        **size** )

        **Notifier signal:**

        void **textureSizeChanged** ()

        **Member Function Documentation**
        """
        ...

    def textureSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#textureSize-prop

        **textureSize : QSize**

        Defines the size of the texture.

        Changing the texture's size does not affect the coordinate system used
        in **paint** (). A scale factor is instead applied so painting should
        still happen inside 0,0 to **width** (),**height** ().

        By default, the texture size will have the same size as this item.

        **Note:** If the item is on a window with a device pixel ratio different
        from 1, this scale factor will be implicitly applied to the texture
        size.

        **Access functions:**

        QSize **textureSize** () const
        void **setTextureSize** (const QSize &
        **size** )

        **Notifier signal:**

        void **textureSizeChanged** ()

        **Member Function Documentation**
        """
        ...

    def itemChange(
        self, a0: QQuickItem.ItemChange, a1: QQuickItem.ItemChangeData
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#itemChange

        **[override virtual protected] void
        QQuickPaintedItem::itemChange(QQuickItem::ItemChange change , const
        QQuickItem::ItemChangeData & value )**

        Reimplements: **QQuickItem::itemChange** (QQuickItem::ItemChange change,
        const QQuickItem::ItemChangeData &value).
        """
        ...

    def releaseResources(self) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#releaseResources

        **[override virtual protected] void
        QQuickPaintedItem::releaseResources()**

        Reimplements: **QQuickItem::releaseResources** ().
        """
        ...

    def textureProvider(self) -> "QSGTextureProvider":
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#textureProvider

        **[override virtual] QSGTextureProvider
        *QQuickPaintedItem::textureProvider() const**

        Reimplements: **QQuickItem::textureProvider** () const.
        """
        ...

    def isTextureProvider(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#isTextureProvider

        **[override virtual] bool QQuickPaintedItem::isTextureProvider() const**

        Reimplements: **QQuickItem::isTextureProvider** () const.
        """
        ...

    def updatePaintNode(
        self, a0: "QSGNode", a1: QQuickItem.UpdatePaintNodeData
    ) -> "QSGNode":
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#updatePaintNode

        **[override virtual protected] QSGNode
        *QQuickPaintedItem::updatePaintNode(QSGNode * oldNode ,
        QQuickItem::UpdatePaintNodeData * data )**

        Reimplements: **QQuickItem::updatePaintNode** (QSGNode *oldNode,
        QQuickItem::UpdatePaintNodeData *updatePaintNodeData).
        """
        ...

    def contentsScaleChanged(self) -> None:
        ...

    def contentsSizeChanged(self) -> None:
        ...

    def paint(self, painter: QtGui.QPainter) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#paint

        **[pure virtual] void QQuickPaintedItem::paint(QPainter * painter )**

        This function, which is usually called by the QML Scene Graph, paints
        the contents of an item in local coordinates.

        The underlying texture will have a size defined by **textureSize**  when
        set, or the item's size, multiplied by the window's device pixel ratio.

        The function is called after the item has been filled with the
        **fillColor** .

        Reimplement this function in a **QQuickPaintedItem**  subclass to
        provide the item's painting implementation, using **painter**.

        **Note:** The QML Scene Graph uses two separate threads, the main thread
        does things such as processing events or updating animations while a
        second thread does the actual OpenGL rendering. As a consequence,
        paint() is not called from the main GUI thread but from the GL enabled
        renderer thread. At the moment paint() is called, the GUI thread is
        blocked and this is therefore thread-safe.

        **Warning:** Extreme caution must be used when creating QObjects,
        emitting signals, starting timers and similar inside this function as
        these will have affinity to the rendering thread.

        **See also** **width** (), **height** (), and **textureSize** .
        """
        ...

    def setRenderTarget(self, target: "QQuickPaintedItem.RenderTarget") -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#renderTarget-prop

        **renderTarget : RenderTarget**

        This property holds the item's render target.

        This property defines which render target the **QPainter**  renders
        into, it can be either **QQuickPaintedItem::Image** ,
        **QQuickPaintedItem::FramebufferObject**  or
        **QQuickPaintedItem::InvertedYFramebufferObject** .

        Each has certain benefits, typically performance versus quality. Using a
        framebuffer object avoids a costly upload of the image contents to the
        texture in graphics memory, while using an image enables high quality
        anti-aliasing.

        **Warning:** Resizing a framebuffer object is a costly operation, avoid
        using the **QQuickPaintedItem::FramebufferObject**  render target if the
        item gets resized often.

        By default, the render target is **QQuickPaintedItem::Image** .

        **Note:** Some Qt Quick backends may not support all render target
        options. For example, it is likely that non-OpenGL backends will lack
        support for **QQuickPaintedItem::FramebufferObject**  and
        **QQuickPaintedItem::InvertedYFramebufferObject** . Requesting these
        will then be ignored.

        **Access functions:**

        QQuickPaintedItem::RenderTarget **renderTarget** () const
        void
        **setRenderTarget** (QQuickPaintedItem::RenderTarget **target** )

        **Notifier signal:**

        void **renderTargetChanged** ()
        """
        ...

    def renderTarget(self) -> "QQuickPaintedItem.RenderTarget":
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#renderTarget-prop

        **renderTarget : RenderTarget**

        This property holds the item's render target.

        This property defines which render target the **QPainter**  renders
        into, it can be either **QQuickPaintedItem::Image** ,
        **QQuickPaintedItem::FramebufferObject**  or
        **QQuickPaintedItem::InvertedYFramebufferObject** .

        Each has certain benefits, typically performance versus quality. Using a
        framebuffer object avoids a costly upload of the image contents to the
        texture in graphics memory, while using an image enables high quality
        anti-aliasing.

        **Warning:** Resizing a framebuffer object is a costly operation, avoid
        using the **QQuickPaintedItem::FramebufferObject**  render target if the
        item gets resized often.

        By default, the render target is **QQuickPaintedItem::Image** .

        **Note:** Some Qt Quick backends may not support all render target
        options. For example, it is likely that non-OpenGL backends will lack
        support for **QQuickPaintedItem::FramebufferObject**  and
        **QQuickPaintedItem::InvertedYFramebufferObject** . Requesting these
        will then be ignored.

        **Access functions:**

        QQuickPaintedItem::RenderTarget **renderTarget** () const
        void
        **setRenderTarget** (QQuickPaintedItem::RenderTarget **target** )

        **Notifier signal:**

        void **renderTargetChanged** ()
        """
        ...

    def setFillColor(
        self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#fillColor-prop

        **fillColor : QColor**

        This property holds the item's background fill color.

        By default, the fill color is set to **Qt::transparent** .

        **Access functions:**

        QColor **fillColor** () const
        void **setFillColor** ( **const QColor
        &**)

        **Notifier signal:**

        void **fillColorChanged** ()
        """
        ...

    def fillColor(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#fillColor-prop

        **fillColor : QColor**

        This property holds the item's background fill color.

        By default, the fill color is set to **Qt::transparent** .

        **Access functions:**

        QColor **fillColor** () const
        void **setFillColor** ( **const QColor
        &**)

        **Notifier signal:**

        void **fillColorChanged** ()
        """
        ...

    def setContentsScale(self, a0: float) -> None:
        ...

    def contentsScale(self) -> float:
        ...

    def resetContentsSize(self) -> None:
        ...

    def setContentsSize(self, a0: QtCore.QSize) -> None:
        ...

    def contentsSize(self) -> QtCore.QSize:
        ...

    def contentsBoundingRect(self) -> QtCore.QRectF:
        ...

    def setPerformanceHints(
        self,
        hints: typing.Union[
            "QQuickPaintedItem.PerformanceHints", "QQuickPaintedItem.PerformanceHint"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#setPerformanceHints

        **void QQuickPaintedItem::setPerformanceHints(QQuickPaintedItem::Perform
        anceHints hints )**

        Sets the performance hints to **hints**

        By default, no performance hint is enabled/

        **See also** **setPerformanceHint** () and **performanceHints** ().
        """
        ...

    def setPerformanceHint(
        self, hint: "QQuickPaintedItem.PerformanceHint", enabled: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#setPerformanceHint

        **void
        QQuickPaintedItem::setPerformanceHint(QQuickPaintedItem::PerformanceHint
        hint , bool enabled = true)**

        Sets the given performance **hint** on the item if **enabled** is true;
        otherwise clears the performance hint.

        By default, no performance hint is enabled/

        **See also** **setPerformanceHints** () and **performanceHints** ().
        """
        ...

    def performanceHints(self) -> "QQuickPaintedItem.PerformanceHints":
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#performanceHints

        **QQuickPaintedItem::PerformanceHints
        QQuickPaintedItem::performanceHints() const**

        Returns the performance hints.

        By default, no performance hint is enabled.

        **See also** **setPerformanceHint** () and **setPerformanceHints** ().
        """
        ...

    def setMipmap(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#setMipmap

        **void QQuickPaintedItem::setMipmap(bool enable )**

        If **enable** is true, mipmapping is enabled on the associated texture.

        Mipmapping increases rendering speed and reduces aliasing artifacts when
        the item is scaled down.

        By default, mipmapping is not enabled.

        **See also** **mipmap** ().
        """
        ...

    def mipmap(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#mipmap

        **bool QQuickPaintedItem::mipmap() const**

        Returns true if mipmaps are enabled; otherwise, false is returned.

        By default, mipmapping is not enabled.

        **See also** **setMipmap** ().
        """
        ...

    def setAntialiasing(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#setAntialiasing

        **void QQuickPaintedItem::setAntialiasing(bool enable )**

        If **enable** is true, antialiased painting is enabled.

        By default, antialiasing is not enabled.

        **See also** **antialiasing** ().
        """
        ...

    def antialiasing(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#antialiasing

        **bool QQuickPaintedItem::antialiasing() const**

        Returns true if antialiased painting is enabled; otherwise, false is
        returned.

        By default, antialiasing is not enabled.

        **See also** **setAntialiasing** ().
        """
        ...

    def setOpaquePainting(self, opaque: bool) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#setOpaquePainting

        **void QQuickPaintedItem::setOpaquePainting(bool opaque )**

        If **opaque** is true, the item is opaque; otherwise, it is considered
        as translucent.

        Opaque items are not blended with the rest of the scene, you should set
        this to true if the content of the item is opaque to speed up rendering.

        By default, painted items are not opaque.

        **See also** **opaquePainting** ().
        """
        ...

    def opaquePainting(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#opaquePainting

        **bool QQuickPaintedItem::opaquePainting() const**

        Returns true if this item is opaque; otherwise, false is returned.

        By default, painted items are not opaque.

        **See also** **setOpaquePainting** ().
        """
        ...

    def update(self, rect: QtCore.QRect = ...) -> None:
        """
        https://doc.qt.io/qt-5/qquickpainteditem.html#update

        **void QQuickPaintedItem::update(const QRect & rect = QRect())**

        Schedules a redraw of the area covered by **rect** in this item. You can
        call this function whenever your item needs to be redrawn, such as if it
        changes appearance or size.

        This function does not cause an immediate paint; instead it schedules a
        paint request that is processed by the QML Scene Graph when the next
        frame is rendered. The item will only be redrawn if it is visible.

        **See also** **paint** ().
        """
        ...

    @property
    def fillColorChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def renderTargetChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def textureSizeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
