"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtQml
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick import *


class QQuickImageProvider(QtQml.QQmlImageProviderBase):
    """
    https://doc.qt.io/qt-5/qquickimageprovider.html

    **Detailed Description**

    QQuickImageProvider is used to provide advanced image loading features in
    QML applications. It allows images in QML to be:

    * Loaded using QPixmaps rather than actual image files
      * Loaded
    asynchronously in a separate thread

    To specify that an image should be loaded by an image provider, use the
    **"image:"** scheme for the URL source of the image, followed by the
    identifiers of the image provider and the requested image. For example:

    **Image**  { source: "image://myimageprovider/image.png" }

    This specifies that the image should be loaded by the image provider named
    "myimageprovider", and the image to be loaded is named "image.png". The QML
    engine invokes the appropriate image provider according to the providers
    that have been registered through **QQmlEngine::addImageProvider** ().

    Note that the identifiers are case-insensitive, but the rest of the URL will
    be passed on with preserved case. For example, the below snippet would still
    specify that the image is loaded by the image provider named
    "myimageprovider", but it would request a different image than the above
    snippet ("Image.png" instead of "image.png").

    **Image**  { source: "image://MyImageProvider/Image.png" }

    If you want the rest of the URL to be case insensitive, you will have to
    take care of that yourself inside your image provider.

    **An Example**

    Here are two images. Their `source` values indicate they should be loaded by
    an image provider named "colors", and the images to be loaded are "yellow"
    and "red", respectively:

    **Column**  {
            **Image**  { source: "image://colors/yellow" }
    **Image**  { source: "image://colors/red" }
        }

    When these images are loaded by QML, it looks for a matching image provider
    and calls its **requestImage** () or **requestPixmap** () method (depending
    on its **imageType** ()) to load the image. The method is called with the
    `id` parameter set to "yellow" for the first image, and "red" for the
    second.

    Here is an image provider implementation that can load the images requested
    by the above QML. This implementation dynamically generates **QPixmap**
    images that are filled with the requested color:

    class ColorImageProvider : public **QQuickImageProvider**
        {
        public:
    ColorImageProvider()
                       : **QQuickImageProvider**
    (**QQuickImageProvider** ::Pixmap)
            {
            }
    **QPixmap**  requestPixmap(const **QString**  &id, **QSize**  *size, const
    **QSize**  &requestedSize) override
            {
               int width = 100;
    int height = 50;

               if (size)
                  *size = **QSize**
    (width, height);
               **QPixmap**  pixmap(requestedSize.width() > 0 ?
    requestedSize.width() : width,
    requestedSize.height() > 0 ? requestedSize.height() : height);
    pixmap.fill(**QColor** (id).rgba());
               return pixmap;
            }
    };

    To make this provider accessible to QML, it is registered with the QML
    engine with a "colors" identifier:

    int main(int argc, char *argv[])
        {

            **QQuickView**  view;
    **QQmlEngine**  *engine = view.engine();
    engine->addImageProvider(QLatin1String("colors"), new ColorImageProvider);
    view.setSource(**QUrl** ::fromLocalFile(**QStringLiteral** ("imageprovider-
    example.qml")));
            view.show();
            return app.exec();
        }

    Now the images can be successfully loaded in QML:

    ![](images/imageprovider.png)

    See the **Image Provider Example**  for the complete implementation. Note
    that the example registers the provider via a **plugin**  instead of
    registering it in the application `main()` function as shown above.

    **Asynchronous Image Loading**

    Image providers that support **QImage**  or Texture loading automatically
    include support for asychronous loading of images. To enable asynchronous
    loading for an image source, set the `asynchronous` property to `true` for
    the relevant **Image**  or **BorderImage**  object. When this is enabled,
    the image request to the provider is run in a low priority thread, allowing
    image loading to be executed in the background, and reducing the performance
    impact on the user interface.

    To force asynchronous image loading, even for image sources that do not have
    the `asynchronous` property set to `true`, you may pass the
    `QQmlImageProviderBase::ForceAsynchronousImageLoading` flag to the image
    provider constructor. This ensures that all image requests for the provider
    are handled in a separate thread.

    Asynchronous loading for image providers that provide **QPixmap**  is only
    supported in platforms that have the ThreadedPixmaps feature, in platforms
    where pixmaps can only be created in the main thread (i.e. ThreadedPixmaps
    is not supported) if **asynchronous**  is set to `true`, the value is
    ignored and the image is loaded synchronously.

    Asynchronous image loading for providers of type other than
    **ImageResponse**  are executed on a single thread per engine basis. That
    means that a slow image provider will block the loading of any other
    request. To avoid that we suggest using **QQuickAsyncImageProvider**  and
    implement threading on the provider side via a `QThreadPool` or similar. See
    the **Image Response Provider Example**  for a complete implementation.

    **Image Caching**

    Images returned by a QQuickImageProvider are automatically cached, similar
    to any image loaded by the QML engine. When an image with a "image://"
    prefix is loaded from cache, **requestImage** () and **requestPixmap** ()
    will not be called for the relevant image provider. If an image should
    always be fetched from the image provider, and should not be cached at all,
    set the `cache` property to `false` for the relevant **Image**  or
    **BorderImage**  object.

    **See also** **QQmlEngine::addImageProvider** ().
    """

    @typing.overload
    def __init__(
        self,
        type: QtQml.QQmlImageProviderBase.ImageType,
        flags: typing.Union[
            QtQml.QQmlImageProviderBase.Flags, QtQml.QQmlImageProviderBase.Flag
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquickimageprovider.html#QQuickImageProvider

        **QQuickImageProvider::QQuickImageProvider(QQmlImageProviderBase::ImageT
        ype type , QQmlImageProviderBase::Flags flags = Flags())**

        Creates an image provider that will provide images of the given **type**
        and behave according to the given **flags**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QQuickImageProvider") -> None:
        """
        https://doc.qt.io/qt-5/qquickimageprovider.html#QQuickImageProvider

        **QQuickImageProvider::QQuickImageProvider(QQmlImageProviderBase::ImageT
        ype type , QQmlImageProviderBase::Flags flags = Flags())**

        Creates an image provider that will provide images of the given **type**
        and behave according to the given **flags**.
        """
        ...

    def requestTexture(
        self, id: str, requestedSize: QtCore.QSize
    ) -> typing.Tuple[QQuickTextureFactory, QtCore.QSize]:
        """
        https://doc.qt.io/qt-5/qquickimageprovider.html#requestTexture

        **[virtual] QQuickTextureFactory
        *QQuickImageProvider::requestTexture(const QString & id , QSize * size ,
        const QSize & requestedSize )**

        Implement this method to return the texture with **id**. The default
        implementation returns `nullptr`.

        The **id** is the requested image source, with the "image:" scheme and
        provider identifier removed. For example, if the image **source**  was
        "image://myprovider/icons/home", the given **id** would be "icons/home".

        The **requestedSize** corresponds to the **Image::sourceSize**
        requested by an Image item. If **requestedSize** is a valid size, the
        image returned should be of that size.

        In all cases, **size** must be set to the original size of the image.
        This is used to set the **width**  and **height**  of the relevant
        **Image**  if these values have not been set explicitly.

        **Note:** this method may be called by multiple threads, so ensure the
        implementation of this method is reentrant.
        """
        ...

    def requestPixmap(
        self, id: str, requestedSize: QtCore.QSize
    ) -> typing.Tuple[QtGui.QPixmap, QtCore.QSize]:
        """
        https://doc.qt.io/qt-5/qquickimageprovider.html#requestPixmap

        **[virtual] QPixmap QQuickImageProvider::requestPixmap(const QString &
        id , QSize * size , const QSize & requestedSize )**

        Implement this method to return the pixmap with **id**. The default
        implementation returns an empty pixmap.

        The **id** is the requested image source, with the "image:" scheme and
        provider identifier removed. For example, if the image **source**  was
        "image://myprovider/icons/home", the given **id** would be "icons/home".

        The **requestedSize** corresponds to the **Image::sourceSize**
        requested by an Image item. If **requestedSize** is a valid size, the
        image returned should be of that size.

        In all cases, **size** must be set to the original size of the image.
        This is used to set the **width**  and **height**  of the relevant
        **Image**  if these values have not been set explicitly.

        **Note:** this method may be called by multiple threads, so ensure the
        implementation of this method is reentrant.
        """
        ...

    def requestImage(
        self, id: str, requestedSize: QtCore.QSize
    ) -> typing.Tuple[QtGui.QImage, QtCore.QSize]:
        """
        https://doc.qt.io/qt-5/qquickimageprovider.html#requestImage

        **[virtual] QImage QQuickImageProvider::requestImage(const QString & id
        , QSize * size , const QSize & requestedSize )**

        Implement this method to return the image with **id**. The default
        implementation returns an empty image.

        The **id** is the requested image source, with the "image:" scheme and
        provider identifier removed. For example, if the image **source**  was
        "image://myprovider/icons/home", the given **id** would be "icons/home".

        The **requestedSize** corresponds to the **Image::sourceSize**
        requested by an Image item. If **requestedSize** is a valid size, the
        image returned should be of that size.

        In all cases, **size** must be set to the original size of the image.
        This is used to set the **width**  and **height**  of the relevant
        **Image**  if these values have not been set explicitly.

        **Note:** this method may be called by multiple threads, so ensure the
        implementation of this method is reentrant.
        """
        ...

    def flags(self) -> QtQml.QQmlImageProviderBase.Flags:
        """
        https://doc.qt.io/qt-5/qquickimageprovider.html#flags

        **[override virtual] QQmlImageProviderBase::Flags
        QQuickImageProvider::flags() const**

        Reimplements: **QQmlImageProviderBase::flags** () const.

        Returns the flags set for this provider.
        """
        ...

    def imageType(self) -> QtQml.QQmlImageProviderBase.ImageType:
        """
        https://doc.qt.io/qt-5/qquickimageprovider.html#imageType

        **[override virtual] QQmlImageProviderBase::ImageType
        QQuickImageProvider::imageType() const**

        Reimplements: **QQmlImageProviderBase::imageType** () const.

        Returns the image type supported by this provider.
        """
        ...
