"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtQml import *


class QQmlExpression(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qqmlexpression.html

    **Detailed Description**

    For example, given a file `main.qml` like this:

    import QtQuick 2.0

        **Item**  {
            width: 200; height: 200
    }

    The following code evaluates a JavaScript expression in the context of the
    above QML:

    **QQmlEngine**  *engine = new **QQmlEngine** ;
        **QQmlComponent**
    component(engine, **QUrl** ::fromLocalFile("main.qml"));
    **QObject**  *myObject = component.create();
        **QQmlExpression**  *expr =
    new **QQmlExpression** (engine->rootContext(), myObject, "width * 2");
    int result = expr->evaluate().toInt();  // result = 400
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#QQmlExpression

        **QQmlExpression::QQmlExpression()**

        Create an invalid QQmlExpression.

        As the expression will not have an associated **QQmlContext** , this
        will be a null expression object and its value will always be an invalid
        **QVariant** .
        """
        ...

    @typing.overload
    def __init__(
        self,
        a0: QQmlContext,
        a1: QtCore.QObject,
        a2: str,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#QQmlExpression-1

        **QQmlExpression::QQmlExpression(QQmlContext * ctxt , QObject * scope ,
        const QString & expression , QObject * parent = nullptr)**

        Create a QQmlExpression object that is a child of **parent**.

        The **expression** JavaScript will be executed in the **ctxt**
        **QQmlContext** . If specified, the **scope** object's properties will
        also be in scope during the expression's execution.
        """
        ...

    @typing.overload
    def __init__(
        self,
        a0: "QQmlScriptString",
        context: typing.Optional[QQmlContext] = ...,
        scope: typing.Optional[QtCore.QObject] = ...,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#QQmlExpression-2

        **QQmlExpression::QQmlExpression(const QQmlScriptString & script ,
        QQmlContext * ctxt = nullptr, QObject * scope = nullptr, QObject *
        parent = nullptr)**

        Create a QQmlExpression object that is a child of **parent**.

        The **script** provides the expression to be evaluated, the context to
        evaluate it in, and the scope object to evaluate it with. If provided,
        **ctxt** and **scope** will override the context and scope object
        provided by **script**.

        **See also** **QQmlScriptString** .
        """
        ...

    def evaluate(self) -> typing.Tuple[typing.Any, bool]:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#evaluate

        **QVariant QQmlExpression::evaluate(bool * valueIsUndefined = nullptr)**

        Evaulates the expression, returning the result of the evaluation, or an
        invalid **QVariant**  if the expression is invalid or has an error.

        **valueIsUndefined** is set to true if the expression resulted in an
        undefined value.

        **See also** **hasError** () and **error** ().
        """
        ...

    def error(self) -> QQmlError:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#error

        **QQmlError QQmlExpression::error() const**

        Return any error from the last call to **evaluate** (). If there was no
        error, this returns an invalid **QQmlError**  instance.

        **See also** **hasError** () and **clearError** ().
        """
        ...

    def clearError(self) -> None:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#clearError

        **void QQmlExpression::clearError()**

        Clear any expression errors. Calls to **hasError** () following this
        will return false.

        **See also** **hasError** () and **error** ().
        """
        ...

    def hasError(self) -> bool:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#hasError

        **bool QQmlExpression::hasError() const**

        Returns true if the last call to **evaluate** () resulted in an error,
        otherwise false.

        **See also** **error** () and **clearError** ().
        """
        ...

    def scopeObject(self) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#scopeObject

        **QObject *QQmlExpression::scopeObject() const**

        Returns the expression's scope object, if provided, otherwise 0.

        In addition to data provided by the expression's **QQmlContext** , the
        scope object's properties are also in scope during the expression's
        evaluation.
        """
        ...

    def setSourceLocation(self, fileName: str, line: int, column: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#setSourceLocation

        **void QQmlExpression::setSourceLocation(const QString & url , int line
        , int column = 0)**

        Set the location of this expression to **line** and **column** of
        **url**. This information is used by the script engine.
        """
        ...

    def columnNumber(self) -> int:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#columnNumber

        **int QQmlExpression::columnNumber() const**

        Returns the source file column number for this expression. The source
        location must have been previously set by calling **setSourceLocation**
        ().
        """
        ...

    def lineNumber(self) -> int:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#lineNumber

        **int QQmlExpression::lineNumber() const**

        Returns the source file line number for this expression. The source
        location must have been previously set by calling **setSourceLocation**
        ().
        """
        ...

    def sourceFile(self) -> str:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#sourceFile

        **QString QQmlExpression::sourceFile() const**

        Returns the source file URL for this expression. The source location
        must have been previously set by calling **setSourceLocation** ().
        """
        ...

    def setNotifyOnValueChanged(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#setNotifyOnValueChanged

        **void QQmlExpression::setNotifyOnValueChanged(bool notifyOnChange )**

        Sets whether the **valueChanged** () signal is emitted when the
        expression's evaluated value changes.

        If **notifyOnChange** is true, the **QQmlExpression**  will monitor
        properties involved in the expression's evaluation, and emit
        **QQmlExpression::valueChanged** () if they have changed. This allows an
        application to ensure that any value associated with the result of the
        expression remains up to date.

        If **notifyOnChange** is false (default), the **QQmlExpression**  will
        not montitor properties involved in the expression's evaluation, and
        **QQmlExpression::valueChanged** () will never be emitted. This is more
        efficient if an application wants a "one off" evaluation of the
        expression.

        **See also** **notifyOnValueChanged** ().
        """
        ...

    def notifyOnValueChanged(self) -> bool:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#notifyOnValueChanged

        **bool QQmlExpression::notifyOnValueChanged() const**

        Returns true if the **valueChanged** () signal is emitted when the
        expression's evaluated value changes.

        **See also** **setNotifyOnValueChanged** ().
        """
        ...

    def setExpression(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#setExpression

        **void QQmlExpression::setExpression(const QString & expression )**

        Set the expression to **expression**.

        **See also** **expression** ().
        """
        ...

    def expression(self) -> str:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#expression

        **QString QQmlExpression::expression() const**

        Returns the expression string.

        **See also** **setExpression** ().
        """
        ...

    def context(self) -> QQmlContext:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#context

        **QQmlContext *QQmlExpression::context() const**

        Returns the **QQmlContext**  this expression is associated with, or 0 if
        there is no association or the **QQmlContext**  has been destroyed.
        """
        ...

    def engine(self) -> QQmlEngine:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#engine

        **QQmlEngine *QQmlExpression::engine() const**

        Returns the **QQmlEngine**  this expression is associated with, or 0 if
        there is no association or the **QQmlEngine**  has been destroyed.
        """
        ...

    @property
    def valueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qqmlexpression.html#valueChanged

        **[signal] void QQmlExpression::valueChanged()**

        Emitted each time the expression value changes from the last time it was
        evaluated. The expression must have been evaluated at least once (by
        calling **QQmlExpression::evaluate** ()) before this signal will be
        emitted.
        """
        ...
