"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtQml import *


class QQmlComponent(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qqmlcomponent.html

    **Detailed Description**

    Components are reusable, encapsulated QML types with well-defined
    interfaces.

    A QQmlComponent instance can be created from a QML file. For example, if
    there is a `main.qml` file like this:

    import QtQuick 2.0

        **Item**  {
            width: 200
            height:
    200
        }

    The following code loads this QML file as a component, creates an instance
    of this component using **create** (), and then queries the **Item** 's
    **width**  value:

    **QQmlEngine**  *engine = new **QQmlEngine** ;
        QQmlComponent
    component(engine, **QUrl** ::fromLocalFile("main.qml"));
    **QObject**  *myObject = component.create();
        **QQuickItem**  *item =
    qobject_cast<**QQuickItem** *>(myObject);
        int width = item->width();  //
    width = 200

    To create instances of a component in code where a **QQmlEngine**  instance
    is not available, you can use **qmlContext** () or **qmlEngine** (). For
    example, in the scenario below, child items are being created within a
    **QQuickItem**  subclass:

    void MyCppItem::init()
        {
            **QQmlEngine**  *engine =
    qmlEngine(this);
            // Or:
            // QQmlEngine *engine =
    qmlContext(this)->engine();
            QQmlComponent component(engine, **QUrl**
    ::fromLocalFile("MyItem.qml"));
            **QQuickItem**  *childItem =
    qobject_cast<**QQuickItem** *>(component.create());
    childItem->setParentItem(this);
        }

    Note that these functions will return `null` when called inside the
    constructor of a **QObject**  subclass, as the instance will not yet have a
    context nor engine.

    **Network Components**

    If the URL passed to QQmlComponent is a network resource, or if the QML
    document references a network resource, the QQmlComponent has to fetch the
    network data before it is able to create objects. In this case, the
    QQmlComponent will have a **Loading**  **status** . An application will have
    to wait until the component is **Ready**  before calling
    **QQmlComponent::create** ().

    The following example shows how to load a QML file from a network resource.
    After creating the QQmlComponent, it tests whether the component is loading.
    If it is, it connects to the **QQmlComponent::statusChanged** () signal and
    otherwise calls the `continueLoading()` method directly. Note that
    **QQmlComponent::isLoading** () may be false for a network component if the
    component has been cached and is ready immediately.

    MyApplication::MyApplication()
        {
            // ...
            component = new
    QQmlComponent(engine, **QUrl** ("http://www.example.com/main.qml"));
    if (component->isLoading())
                **QObject** ::connect(component,
    SIGNAL(statusChanged(QQmlComponent::Status)),
    this, SLOT(continueLoading()));
            else
                continueLoading();
    }

        void MyApplication::continueLoading()
        {
            if
    (component->isError()) {
                **qWarning** () << component->errors();
    } else {
                **QObject**  *myObject = component->create();
            }
    }
    """

    class Status(int):
        Null: QQmlComponent = ...
        Ready: QQmlComponent = ...
        Loading: QQmlComponent = ...
        Error: QQmlComponent = ...

    class CompilationMode(int):
        PreferSynchronous: QQmlComponent = ...
        Asynchronous: QQmlComponent = ...

    @typing.overload
    def __init__(
        self, a0: QQmlEngine, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-1

        **QQmlComponent::QQmlComponent(QQmlEngine * engine , QObject * parent =
        nullptr)**

        Create a QQmlComponent with no data and give it the specified **engine**
        and **parent**. Set the data with **setData** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        a0: QQmlEngine,
        fileName: str,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-2

        **QQmlComponent::QQmlComponent(QQmlEngine * engine , const QString &
        fileName , QObject * parent = nullptr)**

        Create a QQmlComponent from the given **fileName** and give it the
        specified **parent** and **engine**.

        **See also** **loadUrl** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        a0: QQmlEngine,
        fileName: str,
        mode: "QQmlComponent.CompilationMode",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-3

        **QQmlComponent::QQmlComponent(QQmlEngine * engine , const QString &
        fileName , QQmlComponent::CompilationMode mode , QObject * parent =
        nullptr)**

        Create a QQmlComponent from the given **fileName** and give it the
        specified **parent** and **engine**. If **mode** is **Asynchronous** ,
        the component will be loaded and compiled asynchronously.

        **See also** **loadUrl** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        a0: QQmlEngine,
        url: QtCore.QUrl,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-4

        **QQmlComponent::QQmlComponent(QQmlEngine * engine , const QUrl & url ,
        QObject * parent = nullptr)**

        Create a QQmlComponent from the given **url** and give it the specified
        **parent** and **engine**.

        Ensure that the URL provided is full and correct, in particular, use
        **QUrl::fromLocalFile** () when loading a file from the local
        filesystem.

        Relative paths will be resolved against **QQmlEngine::baseUrl()** ,
        which is the current working directory unless specified.

        **See also** **loadUrl** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        a0: QQmlEngine,
        url: QtCore.QUrl,
        mode: "QQmlComponent.CompilationMode",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-5

        **QQmlComponent::QQmlComponent(QQmlEngine * engine , const QUrl & url ,
        QQmlComponent::CompilationMode mode , QObject * parent = nullptr)**

        Create a QQmlComponent from the given **url** and give it the specified
        **parent** and **engine**. If **mode** is **Asynchronous** , the
        component will be loaded and compiled asynchronously.

        Ensure that the URL provided is full and correct, in particular, use
        **QUrl::fromLocalFile** () when loading a file from the local
        filesystem.

        Relative paths will be resolved against **QQmlEngine::baseUrl()** ,
        which is the current working directory unless specified.

        **See also** **loadUrl** ().
        """
        ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-1

        **QQmlComponent::QQmlComponent(QQmlEngine * engine , QObject * parent =
        nullptr)**

        Create a QQmlComponent with no data and give it the specified **engine**
        and **parent**. Set the data with **setData** ().
        """
        ...

    def setInitialProperties(
        self, component: QtCore.QObject, properties: typing.Dict[str, typing.Any]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#setInitialProperties

        **void QQmlComponent::setInitialProperties(QObject * component , const
        QVariantMap & properties )**

        Set toplevel **properties** of the **component**.

        This method provides advanced control over component instance creation.
        In general, programmers should use
        **QQmlComponent::createWithInitialProperties**  to create a component.

        Use this method after **beginCreate**  and before **completeCreate**
        has been called. If a provided property does not exist, a warning is
        issued.

        This function was introduced in Qt 5.14.
        """
        ...

    def engine(self) -> QQmlEngine:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#engine

        **QQmlEngine *QQmlComponent::engine() const**

        Returns the **QQmlEngine**  of this component.

        This function was introduced in Qt 5.12.
        """
        ...

    def setData(
        self,
        a0: typing.Union[QtCore.QByteArray, bytes, bytearray],
        baseUrl: QtCore.QUrl,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#setData

        **[slot] void QQmlComponent::setData(const QByteArray & data , const
        QUrl & url )**

        Sets the **QQmlComponent**  to use the given QML **data**. If **url** is
        provided, it is used to set the component name and to provide a base
        path for items resolved by this component.
        """
        ...

    @typing.overload
    def loadUrl(self, url: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#loadUrl

        **[slot] void QQmlComponent::loadUrl(const QUrl & url )**

        Load the **QQmlComponent**  from the provided **url**.

        Ensure that the URL provided is full and correct, in particular, use
        **QUrl::fromLocalFile** () when loading a file from the local
        filesystem.

        Relative paths will be resolved against **QQmlEngine::baseUrl()** ,
        which is the current working directory unless specified.
        """
        ...

    @typing.overload
    def loadUrl(self, url: QtCore.QUrl, mode: "QQmlComponent.CompilationMode") -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#loadUrl-1

        **[slot] void QQmlComponent::loadUrl(const QUrl & url ,
        QQmlComponent::CompilationMode mode )**

        Load the **QQmlComponent**  from the provided **url**. If **mode** is
        **Asynchronous** , the component will be loaded and compiled
        asynchronously.

        Ensure that the URL provided is full and correct, in particular, use
        **QUrl::fromLocalFile** () when loading a file from the local
        filesystem.

        Relative paths will be resolved against **QQmlEngine::baseUrl()** ,
        which is the current working directory unless specified.
        """
        ...

    def creationContext(self) -> "QQmlContext":
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#creationContext

        **QQmlContext *QQmlComponent::creationContext() const**

        Returns the **QQmlContext**  the component was created in. This is only
        valid for components created directly from QML.
        """
        ...

    def completeCreate(self) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#completeCreate

        **[virtual] void QQmlComponent::completeCreate()**

        This method provides advanced control over component instance creation.
        In general, programmers should use **QQmlComponent::create** () to
        create a component.

        This function completes the component creation begun with
        **QQmlComponent::beginCreate** () and must be called afterwards.

        **See also** **beginCreate** ().
        """
        ...

    def beginCreate(self, a0: "QQmlContext") -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#beginCreate

        **[virtual] QObject *QQmlComponent::beginCreate(QQmlContext *
        publicContext )**

        This method provides advanced control over component instance creation.
        In general, programmers should use **QQmlComponent::create** () to
        create object instances.

        Create an object instance from this component. Returns `nullptr` if
        creation failed. **publicContext** specifies the context within which to
        create the object instance.

        When **QQmlComponent**  constructs an instance, it occurs in three
        steps:

        1. The object hierarchy is created, and constant values are assigned.
        2. Property bindings are evaluated for the first time.
          3. If
        applicable, **QQmlParserStatus::componentComplete** () is called on
        objects.

        QQmlComponent::beginCreate() differs from **QQmlComponent::create** ()
        in that it only performs step 1. **QQmlComponent::completeCreate** ()
        must be called to complete steps 2 and 3.

        This breaking point is sometimes useful when using attached properties
        to communicate information to an instantiated component, as it allows
        their initial values to be configured before property bindings take
        effect.

        The ownership of the returned object instance is transferred to the
        caller.

        **See also** **completeCreate** () and **QQmlEngine::ObjectOwnership** .
        """
        ...

    def createWithInitialProperties(
        self,
        initialProperties: typing.Dict[str, typing.Any],
        context: typing.Optional["QQmlContext"] = ...,
    ) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#createWithInitialProperties

        **QObject *QQmlComponent::createWithInitialProperties(const QVariantMap
        & initialProperties , QQmlContext * context = nullptr)**

        Create an object instance of this component, and initialize its toplevel
        properties with **initialProperties**. **context** specifies the context
        where the object instance is to be created.

        This function was introduced in Qt 5.14.

        **See also** **QQmlComponent::create** .
        """
        ...

    @typing.overload
    def create(self, context: typing.Optional["QQmlContext"] = ...) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#create

        **[virtual] QObject *QQmlComponent::create(QQmlContext * context =
        nullptr)**

        Create an object instance from this component. Returns `nullptr` if
        creation failed. **context** specifies the context within which to
        create the object instance.

        If **context** is `nullptr` (the default), it will create the instance
        in the **root context**  of the engine.

        The ownership of the returned object instance is transferred to the
        caller.

        If the object being created from this component is a visual item, it
        must have a visual parent, which can be set by calling
        **QQuickItem::setParentItem** (). See **Concepts - Visual Parent in Qt
        Quick**  for more details.

        **See also** **QQmlEngine::ObjectOwnership** .
        """
        ...

    @typing.overload
    def create(
        self,
        a0: "QQmlIncubator",
        context: typing.Optional["QQmlContext"] = ...,
        forContext: typing.Optional["QQmlContext"] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#create-1

        **void QQmlComponent::create(QQmlIncubator & incubator , QQmlContext *
        context = nullptr, QQmlContext * forContext = nullptr)**

        Create an object instance from this component using the provided
        **incubator**. **context** specifies the context within which to create
        the object instance.

        If **context** is 0 (the default), it will create the instance in the
        engine's **root context** .

        **forContext** specifies a context that this object creation depends
        upon. If the **forContext** is being created asynchronously, and the
        **QQmlIncubator::IncubationMode**  is
        **QQmlIncubator::AsynchronousIfNested** , this object will also be
        created asynchronously. If **forContext** is 0 (the default), the
        **context** will be used for this decision.

        The created object and its creation status are available via the
        **incubator**.

        **See also** **QQmlIncubator** .
        """
        ...

    def url(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#url-prop

        **url : const QUrl**

        The component URL. This is the URL passed to either the constructor, or
        the **loadUrl** (), or **setData** () methods.

        **Access functions:**

        QUrl **url** () const

        **Member Function Documentation**
        """
        ...

    def progress(self) -> float:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#progress-prop

        **progress : const qreal**

        The progress of loading the component, from 0.0 (nothing loaded) to 1.0
        (finished).

        **Access functions:**

        qreal **progress** () const

        **Notifier signal:**

        void ****progressChanged** ** (qreal **progress** )
        """
        ...

    def errors(self) -> typing.List["QQmlError"]:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#errors

        **QList<QQmlError> QQmlComponent::errors() const**

        Returns the list of errors that occurred during the last compile or
        create operation. An empty list is returned if **isError** () is not
        set.
        """
        ...

    def isLoading(self) -> bool:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#isLoading

        **bool QQmlComponent::isLoading() const**

        Returns true if **status** () == **QQmlComponent::Loading** .
        """
        ...

    def isError(self) -> bool:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#isError

        **bool QQmlComponent::isError() const**

        Returns true if **status** () == **QQmlComponent::Error** .
        """
        ...

    def isReady(self) -> bool:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#isReady

        **bool QQmlComponent::isReady() const**

        Returns true if **status** () == **QQmlComponent::Ready** .
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#isNull

        **bool QQmlComponent::isNull() const**

        Returns true if **status** () == **QQmlComponent::Null** .
        """
        ...

    def status(self) -> "QQmlComponent.Status":
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#status-prop

        **status : const Status**

        The component's current **status** .

        **Access functions:**

        QQmlComponent::Status **status** () const

        **Notifier signal:**

        void ****statusChanged** ** (QQmlComponent::Status **status** )
        """
        ...

    @property
    def progressChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#progressChanged

        **[signal] void QQmlComponent::progressChanged(qreal progress )**

        Emitted whenever the component's loading progress changes. **progress**
        will be the current progress between 0.0 (nothing loaded) and 1.0
        (finished).

        **Note:** Notifier signal for property **progress** .
        """
        ...

    @property
    def statusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qqmlcomponent.html#statusChanged

        **[signal] void QQmlComponent::statusChanged(QQmlComponent::Status
        status )**

        Emitted whenever the component's status changes. **status** will be the
        new status.

        **Note:** Notifier signal for property **status** .
        """
        ...
