"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtQml import *
from PyQt5 import sip


class QJSValueIterator(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qjsvalueiterator.html

    **Detailed Description**

    The QJSValueIterator constructor takes a **QJSValue**  as argument. After
    construction, the iterator is located at the very beginning of the sequence
    of properties. Here's how to iterate over all the properties of a
    **QJSValue** :

    **QJSValue**  object;
        ...
        **QJSValueIterator**  it(object);
    while (it.hasNext()) {
            it.next();
            **qDebug** () << it.name()
    << ": " << it.value().toString();
        }

    The **next** () advances the iterator. The **name** () and **value** ()
    functions return the name and value of the last item that was jumped over.

    Note that QJSValueIterator only iterates over the **QJSValue** 's own
    properties; i.e. it does not follow the prototype chain. You can use a loop
    like this to follow the prototype chain:

    **QJSValue**  obj = ...; // the object to iterate over
        while
    (obj.isObject()) {
            **QJSValueIterator**  it(obj);
            while
    (it.hasNext()) {
                it.next();
                **qDebug** () <<
    it.name();
            }
            obj = obj.prototype();
        }

    **See also** **QJSValue::property** ().
    """

    def __init__(
        self,
        value: typing.Union[QJSValue, QJSValue.SpecialValue, bool, int, float, str],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qjsvalueiterator.html#QJSValueIterator

        **QJSValueIterator::QJSValueIterator(const QJSValue & object )**

        Constructs an iterator for traversing **object**. The iterator is set to
        be at the front of the sequence of properties (before the first
        property).
        """
        ...

    def value(self) -> QJSValue:
        """
        https://doc.qt.io/qt-5/qjsvalueiterator.html#value

        **QJSValue QJSValueIterator::value() const**

        Returns the value of the last property that was jumped over using
        **next** ().

        **See also** **name** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qjsvalueiterator.html#name

        **QString QJSValueIterator::name() const**

        Returns the name of the last property that was jumped over using
        **next** ().

        **See also** **value** ().
        """
        ...

    def next(self) -> bool:
        """
        https://doc.qt.io/qt-5/qjsvalueiterator.html#next

        **bool QJSValueIterator::next()**

        Advances the iterator by one position. Returns true if there was at
        least one item ahead of the iterator (i.e. the iterator was **not**
        already at the back of the property sequence); otherwise returns false.

        **See also** **hasNext** () and **name** ().
        """
        ...

    def hasNext(self) -> bool:
        """
        https://doc.qt.io/qt-5/qjsvalueiterator.html#hasNext

        **bool QJSValueIterator::hasNext() const**

        Returns true if there is at least one item ahead of the iterator (i.e.
        the iterator is **not** at the back of the property sequence); otherwise
        returns false.

        **See also** **next** ().
        """
        ...
