"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtPositioning import *


class QNmeaPositionInfoSource(QGeoPositionInfoSource):
    """
    https://doc.qt.io/qt-5/qnmeapositioninfosource.html

    **Detailed Description**

    NMEA is a commonly used protocol for the specification of one's global
    position at a certain point in time. The QNmeaPositionInfoSource class reads
    NMEA data and uses it to provide positional data in the form of
    **QGeoPositionInfo**  objects.

    A QNmeaPositionInfoSource instance operates in either **RealTimeMode**  or
    **SimulationMode** . These modes allow NMEA data to be read from either a
    live source of positional data, or replayed for simulation purposes from
    previously recorded NMEA data.

    The source of NMEA data is set with **setDevice** ().

    Use **startUpdates** () to start receiving regular position updates and
    **stopUpdates** () to stop these updates. If you only require updates
    occasionally, you can call **requestUpdate** () to request a single update.

    In both cases the position information is received via the
    **positionUpdated** () signal and the last known position can be accessed
    with **lastKnownPosition** ().

    QNmeaPositionInfoSource supports reporting the accuracy of the horizontal
    and vertical position. To enable position accuracy reporting an estimate of
    the User Equivalent Range Error associated with the NMEA source must be set
    with **setUserEquivalentRangeError** ().
    """

    class UpdateMode(int):
        RealTimeMode: QNmeaPositionInfoSource = ...
        SimulationMode: QNmeaPositionInfoSource = ...

    def __init__(
        self,
        updateMode: "QNmeaPositionInfoSource.UpdateMode",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#QNmeaPositionInfoSou
        rce

        **QNmeaPositionInfoSource::QNmeaPositionInfoSource(QNmeaPositionInfoSour
        ce::UpdateMode updateMode , QObject * parent = nullptr)**

        Constructs a QNmeaPositionInfoSource instance with the given **parent**
        and **updateMode**.
        """
        ...

    def userEquivalentRangeError(self) -> float:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#userEquivalentRangeE
        rror

        **double QNmeaPositionInfoSource::userEquivalentRangeError() const**

        Returns the current User Equivalent Range Error (UERE). The UERE is used
        in calculating an estimate of the accuracy of the position information
        reported by the position info source. The default value is NaN which
        means no accuracy information will be provided.

        This function was introduced in Qt 5.3.

        **See also** **setUserEquivalentRangeError** ().
        """
        ...

    def setUserEquivalentRangeError(self, uere: float) -> None:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#setUserEquivalentRan
        geError

        **void QNmeaPositionInfoSource::setUserEquivalentRangeError(double uere
        )**

        Sets the User Equivalent Range Error (UERE) to **uere**. The UERE is
        used in calculating an estimate of the accuracy of the position
        information reported by the position info source. The UERE should be set
        to a value appropriate for the GPS device which generated the NMEA
        stream.

        The true UERE value is calculated from multiple error sources including
        errors introduced by the satellites and signal propogation delays
        through the atmosphere as well as errors introduced by the receiving GPS
        equipment. For details on GPS accuracy see <http://edu-
        observatory.org/gps/gps_accuracy.html>.

        A typical value for UERE is approximately 5.1.

        This function was introduced in Qt 5.3.

        **See also** **userEquivalentRangeError** ().
        """
        ...

    def parsePosInfoFromNmeaData(
        self, data: bytes, size: int, posInfo: QGeoPositionInfo
    ) -> typing.Tuple[bool, bool]:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#parsePosInfoFromNmea
        Data

        **[virtual protected] bool
        QNmeaPositionInfoSource::parsePosInfoFromNmeaData(const char * data ,
        int size , QGeoPositionInfo * posInfo , bool * hasFix )**

        Parses an NMEA sentence string into a **QGeoPositionInfo** .

        The default implementation will parse standard NMEA sentences. This
        method should be reimplemented in a subclass whenever the need to deal
        with non-standard NMEA sentences arises.

        The parser reads **size** bytes from **data** and uses that information
        to setup **posInfo** and **hasFix**. If **hasFix** is set to false then
        **posInfo** may contain only the time or the date and the time.

        Returns true if the sentence was succsesfully parsed, otherwise returns
        false and should not modifiy **posInfo** or **hasFix**.
        """
        ...

    def requestUpdate(self, timeout: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#requestUpdate

        **[override virtual slot] void
        QNmeaPositionInfoSource::requestUpdate(int msec = 0)**

        Reimplements: **QGeoPositionInfoSource::requestUpdate** (int timeout).
        """
        ...

    def stopUpdates(self) -> None:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#stopUpdates

        **[override virtual slot] void QNmeaPositionInfoSource::stopUpdates()**

        Reimplements: **QGeoPositionInfoSource::stopUpdates** ().
        """
        ...

    def startUpdates(self) -> None:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#startUpdates

        **[override virtual slot] void QNmeaPositionInfoSource::startUpdates()**

        Reimplements: **QGeoPositionInfoSource::startUpdates** ().
        """
        ...

    def error(self) -> QGeoPositionInfoSource.Error:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#error

        **[override virtual] QGeoPositionInfoSource::Error
        QNmeaPositionInfoSource::error() const**

        Reimplements: **QGeoPositionInfoSource::error** () const.
        """
        ...

    def minimumUpdateInterval(self) -> int:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#minimumUpdateInterva
        l

        **[override virtual] int
        QNmeaPositionInfoSource::minimumUpdateInterval() const**

        Reimplements an access function for property:
        **QGeoPositionInfoSource::minimumUpdateInterval** .
        """
        ...

    def supportedPositioningMethods(self) -> QGeoPositionInfoSource.PositioningMethods:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#supportedPositioning
        Methods

        **[override virtual] QGeoPositionInfoSource::PositioningMethods
        QNmeaPositionInfoSource::supportedPositioningMethods() const**

        Reimplements: **QGeoPositionInfoSource::supportedPositioningMethods** ()
        const.
        """
        ...

    def lastKnownPosition(
        self, fromSatellitePositioningMethodsOnly: bool = ...
    ) -> QGeoPositionInfo:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#lastKnownPosition

        **[override virtual] QGeoPositionInfo
        QNmeaPositionInfoSource::lastKnownPosition(bool
        fromSatellitePositioningMethodsOnly = false) const**

        Reimplements: **QGeoPositionInfoSource::lastKnownPosition** (bool
        fromSatellitePositioningMethodsOnly) const.
        """
        ...

    def setUpdateInterval(self, msec: int) -> None:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#setUpdateInterval

        **[override virtual] void QNmeaPositionInfoSource::setUpdateInterval(int
        msec )**

        Reimplements an access function for property:
        **QGeoPositionInfoSource::updateInterval** .
        """
        ...

    def device(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#device

        **QIODevice *QNmeaPositionInfoSource::device() const**

        Returns the NMEA data source.

        **See also** **setDevice** ().
        """
        ...

    def setDevice(self, source: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#setDevice

        **void QNmeaPositionInfoSource::setDevice(QIODevice * device )**

        Sets the NMEA data source to **device**. If the device is not open, it
        will be opened in **QIODevice::ReadOnly**  mode.

        The source device can only be set once and must be set before calling
        **startUpdates** () or **requestUpdate** ().

        **Note:** The **device** must emit **QIODevice::readyRead** () for the
        source to be notified when data is available for reading.
        **QNmeaPositionInfoSource**  does not assume the ownership of the
        device, and hence does not deallocate it upon destruction.

        **See also** **device** ().
        """
        ...

    def updateMode(self) -> "QNmeaPositionInfoSource.UpdateMode":
        """
        https://doc.qt.io/qt-5/qnmeapositioninfosource.html#updateMode

        **QNmeaPositionInfoSource::UpdateMode
        QNmeaPositionInfoSource::updateMode() const**

        Returns the update mode.
        """
        ...
