"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtPositioning import *


class QGeoSatelliteInfo(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qgeosatelliteinfo.html

    **Detailed Description**

    **See also** **QGeoSatelliteInfoSource** .
    """

    class SatelliteSystem(int):
        Undefined: QGeoSatelliteInfo = ...
        GPS: QGeoSatelliteInfo = ...
        GLONASS: QGeoSatelliteInfo = ...

    class Attribute(int):
        Elevation: QGeoSatelliteInfo = ...
        Azimuth: QGeoSatelliteInfo = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#QGeoSatelliteInfo

        **QGeoSatelliteInfo::QGeoSatelliteInfo()**

        Creates a satellite information object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoSatelliteInfo") -> None:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#QGeoSatelliteInfo-1

        **QGeoSatelliteInfo::QGeoSatelliteInfo(const QGeoSatelliteInfo & other
        )**

        Creates a satellite information object with the values of **other**.
        """
        ...

    def hasAttribute(self, attribute: "QGeoSatelliteInfo.Attribute") -> bool:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#hasAttribute

        **bool QGeoSatelliteInfo::hasAttribute(QGeoSatelliteInfo::Attribute
        attribute ) const**

        Returns true if the specified **attribute** is present in this update.
        """
        ...

    def removeAttribute(self, attribute: "QGeoSatelliteInfo.Attribute") -> None:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#removeAttribute

        **void QGeoSatelliteInfo::removeAttribute(QGeoSatelliteInfo::Attribute
        attribute )**

        Removes the specified **attribute** and its value.
        """
        ...

    def attribute(self, attribute: "QGeoSatelliteInfo.Attribute") -> float:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#attribute

        **qreal QGeoSatelliteInfo::attribute(QGeoSatelliteInfo::Attribute
        attribute ) const**

        Returns the value of the specified **attribute** as a qreal value.

        Returns -1 if the value has not been set.

        **See also** **hasAttribute** () and **setAttribute** ().
        """
        ...

    def setAttribute(
        self, attribute: "QGeoSatelliteInfo.Attribute", value: float
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#setAttribute

        **void QGeoSatelliteInfo::setAttribute(QGeoSatelliteInfo::Attribute
        attribute , qreal value )**

        Sets the value for **attribute** to **value**.

        **See also** **attribute** ().
        """
        ...

    def signalStrength(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#signalStrength

        **int QGeoSatelliteInfo::signalStrength() const**

        Returns the signal strength, or -1 if the value has not been set.

        **See also** **setSignalStrength** ().
        """
        ...

    def setSignalStrength(self, signalStrength: int) -> None:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#setSignalStrength

        **void QGeoSatelliteInfo::setSignalStrength(int signalStrength )**

        Sets the signal strength to **signalStrength** , in decibels.

        **See also** **signalStrength** ().
        """
        ...

    def satelliteIdentifier(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#satelliteIdentifier

        **int QGeoSatelliteInfo::satelliteIdentifier() const**

        Returns the satellite identifier number.

        The satellite identifier number can be used to identify a satellite
        inside the satellite system. For satellite system GPS the satellite
        identifier number represents the PRN (Pseudo-random noise) number. For
        satellite system GLONASS the satellite identifier number represents the
        slot number.

        **See also** **setSatelliteIdentifier** ().
        """
        ...

    def setSatelliteIdentifier(self, satId: int) -> None:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#setSatelliteIdentifier

        **void QGeoSatelliteInfo::setSatelliteIdentifier(int satId )**

        Sets the satellite identifier number to **satId**.

        The satellite identifier number can be used to identify a satellite
        inside the satellite system. For satellite system GPS the satellite
        identifier number represents the PRN (Pseudo-random noise) number. For
        satellite system GLONASS the satellite identifier number represents the
        slot number.

        **See also** **satelliteIdentifier** ().
        """
        ...

    def satelliteSystem(self) -> "QGeoSatelliteInfo.SatelliteSystem":
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#satelliteSystem

        **QGeoSatelliteInfo::SatelliteSystem
        QGeoSatelliteInfo::satelliteSystem() const**

        Returns the Satellite System (GPS, GLONASS, ...)

        **See also** **setSatelliteSystem** ().
        """
        ...

    def setSatelliteSystem(self, system: "QGeoSatelliteInfo.SatelliteSystem") -> None:
        """
        https://doc.qt.io/qt-5/qgeosatelliteinfo.html#setSatelliteSystem

        **void
        QGeoSatelliteInfo::setSatelliteSystem(QGeoSatelliteInfo::SatelliteSystem
        system )**

        Sets the Satellite System (GPS, GLONASS, ...) to **system**.

        **See also** **satelliteSystem** ().
        """
        ...
