"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtPositioning import *


class QGeoLocation(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qgeolocation.html

    **Detailed Description**

    A QGeoLocation consists of a coordinate and corresponding address, along
    with an optional bounding box which is the recommended region to be
    displayed when viewing the location.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeolocation.html#QGeoLocation

        **QGeoLocation::QGeoLocation()**

        Constructs an new location object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoLocation") -> None:
        """
        https://doc.qt.io/qt-5/qgeolocation.html#QGeoLocation-1

        **QGeoLocation::QGeoLocation(const QGeoLocation & other )**

        Constructs a copy of **other**
        """
        ...

    def setExtendedAttributes(self, data: typing.Dict[str, typing.Any]) -> None:
        """
        https://doc.qt.io/qt-5/qgeolocation.html#setExtendedAttributes

        **void QGeoLocation::setExtendedAttributes(const QVariantMap & data )**

        Sets the extended attributes of the location with the parameters
        specified in **data**.

        This function was introduced in Qt 5.13.

        **See also** **extendedAttributes** ().
        """
        ...

    def extendedAttributes(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-5/qgeolocation.html#extendedAttributes

        **QVariantMap QGeoLocation::extendedAttributes() const**

        Returns the extended attributes associated to this location. Extended
        attributes are backend-dependent and can be location-dependent.

        This function was introduced in Qt 5.13.

        **See also** **setExtendedAttributes** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgeolocation.html#isEmpty

        **bool QGeoLocation::isEmpty() const**

        Returns true if all fields of the location are 0; otherwise returns
        false.
        """
        ...

    def setBoundingBox(self, box: "QGeoRectangle") -> None:
        """
        https://doc.qt.io/qt-5/qgeolocation.html#setBoundingBox

        **void QGeoLocation::setBoundingBox(const QGeoRectangle & boundingBox
        )**

        Sets the **boundingBox** of the location.

        **See also** **boundingBox** ().
        """
        ...

    def boundingBox(self) -> "QGeoRectangle":
        """
        https://doc.qt.io/qt-5/qgeolocation.html#boundingBox

        **QGeoRectangle QGeoLocation::boundingBox() const**

        Returns a bounding box which represents the recommended region to
        display when viewing this location.

        For example, a building's location may have a region centered around the
        building, but the region is large enough to show it's immediate
        surrounding geographical context.

        **See also** **setBoundingBox** ().
        """
        ...

    def setCoordinate(self, position: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeolocation.html#setCoordinate

        **void QGeoLocation::setCoordinate(const QGeoCoordinate & coordinate )**

        Sets the **coordinate** of the location.

        **See also** **coordinate** ().
        """
        ...

    def coordinate(self) -> QGeoCoordinate:
        """
        https://doc.qt.io/qt-5/qgeolocation.html#coordinate

        **QGeoCoordinate QGeoLocation::coordinate() const**

        Returns the coordinate of the location.

        **See also** **setCoordinate** ().
        """
        ...

    def setAddress(self, address: QGeoAddress) -> None:
        """
        https://doc.qt.io/qt-5/qgeolocation.html#setAddress

        **void QGeoLocation::setAddress(const QGeoAddress & address )**

        Sets the **address** of the location.

        **See also** **address** ().
        """
        ...

    def address(self) -> QGeoAddress:
        """
        https://doc.qt.io/qt-5/qgeolocation.html#address

        **QGeoAddress QGeoLocation::address() const**

        Returns the address of the location.

        **See also** **setAddress** ().
        """
        ...
