"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtWidgets
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtOpenGL import *


class QGLWidget(QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-5/qglwidget.html

    **Detailed Description**

    QGLWidget provides functionality for displaying OpenGL graphics integrated
    into a Qt application. It is very simple to use. You inherit from it and use
    the subclass like any other **QWidget** , except that you have the choice
    between using **QPainter**  and standard OpenGL rendering commands.

    **Note:** This class is part of the legacy **Qt OpenGL**  module and, like
    the other `QGL` classes, should be avoided in the new applications. Instead,
    starting from Qt 5.4, prefer using **QOpenGLWidget**  and the `QOpenGL`
    classes.

    QGLWidget provides three convenient virtual functions that you can
    reimplement in your subclass to perform the typical OpenGL tasks:

    * **paintGL** () - Renders the OpenGL scene. Gets called whenever the widget
    needs to be updated.
      * **resizeGL** () - Sets up the OpenGL viewport,
    projection, etc. Gets called whenever the widget has been resized (and also
    when it is shown for the first time because all newly created widgets get a
    resize event automatically).
      * **initializeGL** () - Sets up the OpenGL
    rendering context, defines display lists, etc. Gets called once before the
    first time **resizeGL** () or **paintGL** () is called.

    Here is a rough outline of how a QGLWidget subclass might look:

    class MyGLDrawer : public **QGLWidget**
        {
            Q_OBJECT        //
    must include this if you use Qt signals/slots

        public:
    MyGLDrawer(**QWidget**  *parent)
                : **QGLWidget** (parent) {}
    protected:

            void initializeGL() override
            {
    // Set up the rendering context, define display lists etc.:
                ...
    glClearColor(0.0, 0.0, 0.0, 0.0);
                glEnable(GL_DEPTH_TEST);
    ...
            }

            void resizeGL(int w, int h) override
            {
    // setup viewport, projection etc.:
                glViewport(0, 0, (GLint)w,
    (GLint)h);
                ...
                glFrustum(...);
                ...
    }

            void paintGL() override
            {
                // draw the
    scene:
                ...
                glRotatef(...);
    glMaterialfv(...);
                glBegin(GL_QUADS);
    glVertex3f(...);
                glVertex3f(...);
                ...
    glEnd();
                ...
            }

        };

    If you need to trigger a repaint from places other than **paintGL** () (a
    typical example is when using **timers**  to animate scenes), you should
    call the widget's **updateGL** () function.

    Your widget's OpenGL rendering context is made current when **paintGL** (),
    **resizeGL** (), or **initializeGL** () is called. If you need to call the
    standard OpenGL API functions from other places (e.g. in your widget's
    constructor or in your own paint functions), you must call **makeCurrent**
    () first.

    QGLWidget provides functions for requesting a new display **format**  and
    you can also create widgets with customized rendering **contexts** .

    You can also share OpenGL display lists between QGLWidget objects (see the
    documentation of the QGLWidget constructors for details).

    Note that under Windows, the **QGLContext**  belonging to a QGLWidget has to
    be recreated when the QGLWidget is reparented. This is necessary due to
    limitations on the Windows platform. This will most likely cause problems
    for users that have subclassed and installed their own **QGLContext**  on a
    QGLWidget. It is possible to work around this issue by putting the QGLWidget
    inside a dummy widget and then reparenting the dummy widget, instead of the
    QGLWidget. This will side-step the issue altogether, and is what we
    recommend for users that need this kind of functionality.

    On macOS, when Qt is built with Cocoa support, a QGLWidget can't have any
    sibling widgets placed ontop of itself. This is due to limitations in the
    Cocoa API and is not supported by Apple.

    **Overlays**

    The QGLWidget creates a GL overlay context in addition to the normal context
    if overlays are supported by the underlying system.

    If you want to use overlays, you specify it in the **format** . (Note:
    Overlay must be requested in the format passed to the QGLWidget
    constructor.) Your GL widget should also implement some or all of these
    virtual methods:

    * **paintOverlayGL** ()
      * **resizeOverlayGL** ()
      *
    **initializeOverlayGL** ()

    These methods work in the same way as the normal **paintGL** () etc.
    functions, except that they will be called when the overlay context is made
    current. You can explicitly make the overlay context current by using
    **makeOverlayCurrent** (), and you can access the overlay context directly
    (e.g. to ask for its transparent color) by calling **overlayContext** ().

    On X servers in which the default visual is in an overlay plane, non-GL Qt
    windows can also be used for overlays.

    **Painting Techniques**

    As described above, subclass QGLWidget to render pure 3D content in the
    following way:

    * Reimplement the **QGLWidget::initializeGL** () and **QGLWidget::resizeGL**
    () to set up the OpenGL state and provide a perspective transformation.
      *
    Reimplement **QGLWidget::paintGL** () to paint the 3D scene, calling only
    OpenGL functions to draw on the widget.

    It is also possible to draw 2D graphics onto a QGLWidget subclass, it is
    necessary to reimplement **QGLWidget::paintEvent** () and do the following:

    * Construct a **QPainter**  object.
      * Initialize it for use on the widget
    with the **QPainter::begin** () function.
      * Draw primitives using
    **QPainter** 's member functions.
      * Call **QPainter::end** () to finish
    painting.

    **Threading**

    As of Qt version 4.8, support for doing threaded GL rendering has been
    improved. There are three scenarios that we currently support:

    * 1\\. Buffer swapping in a thread.

    Swapping buffers in a double buffered
    context may be a synchronous, locking call that may be a costly operation in
    some GL implementations. Especially so on embedded devices. It's not optimal
    to have the CPU idling while the GPU is doing a buffer swap. In those cases
    it is possible to do the rendering in the main thread and do the actual
    buffer swap in a separate thread. This can be done with the following steps:
    1\\. Call **doneCurrent** () in the main thread when the rendering is
    finished.

    2\\. Call **QGLContext::moveToThread** (swapThread) to transfer
    ownership of the context to the swapping thread.

    3\\. Notify the swapping
    thread that it can grab the context.

    4\\. Make the rendering context current
    in the swapping thread with **makeCurrent** () and then call **swapBuffers**
    ().

    5\\. Call **doneCurrent** () in the swapping thread.

    6\\. Call
    **QGLContext::moveToThread** (**qApp** ->**thread** ()) and notify the main
    thread that swapping is done.

    Doing this will free up the main thread so
    that it can continue with, for example, handling UI events or network
    requests. Even if there is a context swap involved, it may be preferable
    compared to having the main thread wait while the GPU finishes the swap
    operation. Note that this is highly implementation dependent.

      * 2\\.
    Texture uploading in a thread.

    Doing texture uploads in a thread may be
    very useful for applications handling large amounts of images that needs to
    be displayed, like for instance a photo gallery application. This is
    supported in Qt through the existing **bindTexture** () API. A simple way of
    doing this is to create two sharing QGLWidgets. One is made current in the
    main GUI thread, while the other is made current in the texture upload
    thread. The widget in the uploading thread is never shown, it is only used
    for sharing textures with the main thread. For each texture that is bound
    via **bindTexture** (), notify the main thread so that it can start using
    the texture.

      * 3\\. Using **QPainter**  to draw into a QGLWidget in a
    thread.

    In Qt 4.8, it is possible to draw into a QGLWidget using a
    **QPainter**  in a separate thread. Note that this is also possible for
    QGLPixelBuffers and QGLFramebufferObjects. Since this is only supported in
    the GL 2 paint engine, OpenGL 2.0 or OpenGL ES 2.0 is required.

    QGLWidgets
    can only be created in the main GUI thread. This means a call to
    **doneCurrent** () is necessary to release the GL context from the main
    thread, before the widget can be drawn into by another thread. You then need
    to call **QGLContext::moveToThread** () to transfer ownership of the context
    to the thread in which you want to make it current. Also, the main GUI
    thread will dispatch resize and paint events to a QGLWidget when the widget
    is resized, or parts of it becomes exposed or needs redrawing. It is
    therefore necessary to handle those events because the default
    implementations inside QGLWidget will try to make the QGLWidget's context
    current, which again will interfere with any threads rendering into the
    widget. Reimplement **QGLWidget::paintEvent** () and
    **QGLWidget::resizeEvent** () to notify the rendering thread that a resize
    or update is necessary, and be careful not to call the base class
    implementation. If you are rendering an animation, it might not be necessary
    to handle the paint event at all since the rendering thread is doing regular
    updates. Then it would be enough to reimplement **QGLWidget::paintEvent** ()
    to do nothing.

    As a general rule when doing threaded rendering: be aware that binding and
    releasing contexts in different threads have to be synchronized by the user.
    A GL rendering context can only be current in one thread at any time. If you
    try to open a **QPainter**  on a QGLWidget and the widget's rendering
    context is current in another thread, it will fail.

    In addition to this, rendering using raw GL calls in a separate thread is
    supported.

    **OpenGL is a trademark of Silicon Graphics, Inc. in the United States and
    other countries.**

    **See also** **QOpenGLWidget**  and **QGLPixelBuffer** .
    """

    @typing.overload
    def __init__(
        self,
        parent: typing.Optional[QtWidgets.QWidget] = ...,
        shareWidget: typing.Optional["QGLWidget"] = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#QGLWidget

        **QGLWidget::QGLWidget(QWidget * parent = nullptr, const QGLWidget *
        shareWidget = nullptr, Qt::WindowFlags f = Qt::WindowFlags())**

        Constructs an OpenGL widget with a **parent** widget.

        The **default format**  is used. The widget will be **invalid**  if the
        system has no **OpenGL support** .

        The **parent** and widget flag, **f** , arguments are passed to the
        **QWidget**  constructor.

        If **shareWidget** is a valid QGLWidget, this widget will share OpenGL
        display lists and texture objects with **shareWidget**. But if
        **shareWidget** and this widget have different **formats** , sharing
        might not be possible. You can check whether sharing is in effect by
        calling **isSharing** ().

        The initialization of OpenGL rendering state, etc. should be done by
        overriding the **initializeGL** () function, rather than in the
        constructor of your QGLWidget subclass.

        **See also** **QGLFormat::defaultFormat** () and **Textures Example** .
        """
        ...

    @typing.overload
    def __init__(
        self,
        context: QGLContext,
        parent: typing.Optional[QtWidgets.QWidget] = ...,
        shareWidget: typing.Optional["QGLWidget"] = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#QGLWidget-1

        **QGLWidget::QGLWidget(QGLContext * context , QWidget * parent =
        nullptr, const QGLWidget * shareWidget = nullptr, Qt::WindowFlags f =
        Qt::WindowFlags())**

        Constructs an OpenGL widget with parent **parent**.

        The **context** argument is a pointer to the QGLContext that you wish to
        be bound to this widget. This allows you to pass in your own QGLContext
        sub-classes.

        The widget will be **invalid**  if the system has no **OpenGL support**
        .

        The **parent** and widget flag, **f** , arguments are passed to the
        **QWidget**  constructor.

        If **shareWidget** is a valid QGLWidget, this widget will share OpenGL
        display lists and texture objects with **shareWidget**. But if
        **shareWidget** and this widget have different **formats** , sharing
        might not be possible. You can check whether sharing is in effect by
        calling **isSharing** ().

        The initialization of OpenGL rendering state, etc. should be done by
        overriding the **initializeGL** () function, rather than in the
        constructor of your QGLWidget subclass.

        **See also** **QGLFormat::defaultFormat** () and **isValid** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        format: QGLFormat,
        parent: typing.Optional[QtWidgets.QWidget] = ...,
        shareWidget: typing.Optional["QGLWidget"] = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#QGLWidget-2

        **QGLWidget::QGLWidget(const QGLFormat & format , QWidget * parent =
        nullptr, const QGLWidget * shareWidget = nullptr, Qt::WindowFlags f =
        Qt::WindowFlags())**

        Constructs an OpenGL widget with parent **parent**.

        The **format** argument specifies the desired **rendering options** . If
        the underlying OpenGL/Window system cannot satisfy all the features
        requested in **format** , the nearest subset of features will be used.
        After creation, the **format** () method will return the actual format
        obtained.

        The widget will be **invalid**  if the system has no **OpenGL support**
        .

        The **parent** and widget flag, **f** , arguments are passed to the
        **QWidget**  constructor.

        If **shareWidget** is a valid QGLWidget, this widget will share OpenGL
        display lists and texture objects with **shareWidget**. But if
        **shareWidget** and this widget have different **formats** , sharing
        might not be possible. You can check whether sharing is in effect by
        calling **isSharing** ().

        The initialization of OpenGL rendering state, etc. should be done by
        overriding the **initializeGL** () function, rather than in the
        constructor of your QGLWidget subclass.

        **See also** **QGLFormat::defaultFormat** () and **isValid** ().
        """
        ...

    def glDraw(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#glDraw

        **[virtual protected] void QGLWidget::glDraw()**

        Executes the virtual function **paintGL** ().

        The widget's rendering context will become the current context and
        **initializeGL** () will be called if it hasn't already been called.
        """
        ...

    def glInit(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#glInit

        **[virtual protected] void QGLWidget::glInit()**

        Initializes OpenGL for this widget's context. Calls the virtual function
        **initializeGL** ().
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#resizeEvent

        **[override virtual protected] void QGLWidget::resizeEvent(QResizeEvent
        * event )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).

        Handles resize events that are passed in the **event** parameter. Calls
        the virtual function **resizeGL** ().
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#paintEvent

        **[override virtual protected] void QGLWidget::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).

        Handles paint events passed in the **event** parameter. Will cause the
        virtual **paintGL** () function to be called.

        The widget's rendering context will become the current context and
        **initializeGL** () will be called if it hasn't already been called.
        """
        ...

    def autoBufferSwap(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglwidget.html#autoBufferSwap

        **[protected] bool QGLWidget::autoBufferSwap() const**

        Returns `true` if the widget is doing automatic GL buffer swapping;
        otherwise returns `false`.

        **See also** **setAutoBufferSwap** ().
        """
        ...

    def setAutoBufferSwap(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#setAutoBufferSwap

        **[protected] void QGLWidget::setAutoBufferSwap(bool on )**

        If **on** is true automatic GL buffer swapping is switched on; otherwise
        it is switched off.

        If **on** is true and the widget is using a double-buffered format, the
        background and foreground GL buffers will automatically be swapped after
        each **paintGL** () call.

        The buffer auto-swapping is on by default.

        **See also** **autoBufferSwap** (), **doubleBuffer** (), and
        **swapBuffers** ().
        """
        ...

    def paintOverlayGL(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#paintOverlayGL

        **[virtual protected] void QGLWidget::paintOverlayGL()**

        This virtual function is used in the same manner as **paintGL** ()
        except that it operates on the widget's overlay context instead of the
        widget's main context. This means that paintOverlayGL() is called
        whenever the widget's overlay needs to be painted. Reimplement it in a
        subclass.

        There is no need to call **makeOverlayCurrent** () because this has
        already been done when this function is called.
        """
        ...

    def resizeOverlayGL(self, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#resizeOverlayGL

        **[virtual protected] void QGLWidget::resizeOverlayGL(int width , int
        height )**

        This virtual function is used in the same manner as **paintGL** ()
        except that it operates on the widget's overlay context instead of the
        widget's main context. This means that resizeOverlayGL() is called
        whenever the widget has been resized. The new size is passed in
        **width** and **height**. Reimplement it in a subclass.

        There is no need to call **makeOverlayCurrent** () because this has
        already been done when this function is called.
        """
        ...

    def initializeOverlayGL(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#initializeOverlayGL

        **[virtual protected] void QGLWidget::initializeOverlayGL()**

        This virtual function is used in the same manner as **initializeGL** ()
        except that it operates on the widget's overlay context instead of the
        widget's main context. This means that initializeOverlayGL() is called
        once before the first call to **paintOverlayGL** () or
        **resizeOverlayGL** (). Reimplement it in a subclass.

        This function should set up any required OpenGL context rendering flags,
        defining display lists, etc. for the overlay context.

        There is no need to call **makeOverlayCurrent** () because this has
        already been done when this function is called.
        """
        ...

    def paintGL(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#paintGL

        **[virtual protected] void QGLWidget::paintGL()**

        This virtual function is called whenever the widget needs to be painted.
        Reimplement it in a subclass.

        There is no need to call **makeCurrent** () because this has already
        been done when this function is called.
        """
        ...

    def resizeGL(self, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#resizeGL

        **[virtual protected] void QGLWidget::resizeGL(int width , int height
        )**

        This virtual function is called whenever the widget has been resized.
        The new size is passed in **width** and **height**. Reimplement it in a
        subclass.

        There is no need to call **makeCurrent** () because this has already
        been done when this function is called.
        """
        ...

    def initializeGL(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#initializeGL

        **[virtual protected] void QGLWidget::initializeGL()**

        This virtual function is called once before the first call to
        **paintGL** () or **resizeGL** (), and then once whenever the widget has
        been assigned a new QGLContext. Reimplement it in a subclass.

        This function should set up any required OpenGL context rendering flags,
        defining display lists, etc.

        There is no need to call **makeCurrent** () because this has already
        been done when this function is called.
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qglwidget.html#event

        **[override virtual protected] bool QGLWidget::event(QEvent * e )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def updateOverlayGL(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#updateOverlayGL

        **[virtual slot] void QGLWidget::updateOverlayGL()**

        Updates the widget's overlay (if any). Will cause the virtual function
        **paintOverlayGL** () to be executed.

        The widget's rendering context will become the current context and
        **initializeGL** () will be called if it hasn't already been called.
        """
        ...

    def updateGL(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#updateGL

        **[virtual slot] void QGLWidget::updateGL()**

        Updates the widget by calling **glDraw** ().
        """
        ...

    def deleteTexture(self, tx_id: int) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#deleteTexture

        **void QGLWidget::deleteTexture(GLuint id )**

        Calls **QGLContext::deleteTexture** ( **id** ) on the currently set
        context.

        **See also** **bindTexture** ().
        """
        ...

    @typing.overload
    def drawTexture(
        self, target: QtCore.QRectF, textureId: int, textureTarget: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#drawTexture

        **void QGLWidget::drawTexture(const QRectF & target , GLuint textureId ,
        GLenum textureTarget = GL_TEXTURE_2D)**

        Calls the corresponding **QGLContext::drawTexture** () with **target** ,
        **textureId** , and **textureTarget** for this widget's context.

        This function was introduced in Qt 4.4.
        """
        ...

    @typing.overload
    def drawTexture(
        self,
        point: typing.Union[QtCore.QPointF, QtCore.QPoint],
        textureId: int,
        textureTarget: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#drawTexture-1

        **void QGLWidget::drawTexture(const QPointF & point , GLuint textureId ,
        GLenum textureTarget = GL_TEXTURE_2D)**

        Calls the corresponding **QGLContext::drawTexture** () with **point** ,
        **textureId** , and **textureTarget** for this widget's context.

        This function was introduced in Qt 4.4.
        """
        ...

    @typing.overload
    def bindTexture(
        self, image: QtGui.QImage, target: int = ..., format: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-5/qglwidget.html#bindTexture

        **GLuint QGLWidget::bindTexture(const QImage & image , GLenum target =
        GL_TEXTURE_2D, GLint format = GL_RGBA)**

        Calls QGLContext:::bindTexture( **image** , **target** , **format** ) on
        the currently set context.

        **See also** **deleteTexture** ().
        """
        ...

    @typing.overload
    def bindTexture(
        self, pixmap: QtGui.QPixmap, target: int = ..., format: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-5/qglwidget.html#bindTexture-1

        **GLuint QGLWidget::bindTexture(const QImage & image , GLenum target ,
        GLint format , QGLContext::BindOptions options )**

        This is an overloaded function.

        The binding **options** are a set of options used to decide how to bind
        the texture to the context.

        This function was introduced in Qt 4.6.
        """
        ...

    @typing.overload
    def bindTexture(self, fileName: str) -> int:
        """
        https://doc.qt.io/qt-5/qglwidget.html#bindTexture-2

        **GLuint QGLWidget::bindTexture(const QPixmap & pixmap , GLenum target ,
        GLint format , QGLContext::BindOptions options )**

        This is an overloaded function.

        Generates and binds a 2D GL texture to the current context, based on
        **pixmap**. The generated texture id is returned and can be used in

        The binding **options** are a set of options used to decide how to bind
        the texture to the context.

        This function was introduced in Qt 4.6.
        """
        ...

    @typing.overload
    def bindTexture(
        self,
        image: QtGui.QImage,
        target: int,
        format: int,
        options: typing.Union[QGLContext.BindOptions, QGLContext.BindOption],
    ) -> int:
        """
        https://doc.qt.io/qt-5/qglwidget.html#bindTexture-3

        **GLuint QGLWidget::bindTexture(const QPixmap & pixmap , GLenum target =
        GL_TEXTURE_2D, GLint format = GL_RGBA)**

        Calls QGLContext:::bindTexture( **pixmap** , **target** , **format** )
        on the currently set context.

        **See also** **deleteTexture** ().
        """
        ...

    @typing.overload
    def bindTexture(
        self,
        pixmap: QtGui.QPixmap,
        target: int,
        format: int,
        options: typing.Union[QGLContext.BindOptions, QGLContext.BindOption],
    ) -> int:
        """
        https://doc.qt.io/qt-5/qglwidget.html#bindTexture-4

        **GLuint QGLWidget::bindTexture(const QString & fileName )**

        This is an overloaded function.

        Calls **QGLContext::bindTexture** ( **fileName** ) on the currently set
        context.

        **See also** **deleteTexture** ().
        """
        ...

    def paintEngine(self) -> QtGui.QPaintEngine:
        ...

    @typing.overload
    def renderText(self, x: int, y: int, str: str, font: QtGui.QFont = ...) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#renderText

        **void QGLWidget::renderText(int x , int y , const QString & str , const
        QFont & font = QFont())**

        Renders the string **str** into the GL context of this widget.

        **x** and **y** are specified in window coordinates, with the origin in
        the upper left-hand corner of the window. If **font** is not specified,
        the currently set application font will be used to render the string. To
        change the color of the rendered text you can use the glColor() call (or
        the **qglColor** () convenience function), just before the renderText()
        call.

        **Note:** This function clears the stencil buffer.

        **Note:** This function is not supported on OpenGL/ES systems.

        **Note:** This function temporarily disables depth-testing when the text
        is drawn.

        **Note:** This function can only be used inside a
        **QPainter::beginNativePainting** ()/**QPainter::endNativePainting** ()
        block if a painter is active on the **QGLWidget** .
        """
        ...

    @typing.overload
    def renderText(
        self, x: float, y: float, z: float, str: str, font: QtGui.QFont = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#renderText-1

        **void QGLWidget::renderText(double x , double y , double z , const
        QString & str , const QFont & font = QFont())**

        This is an overloaded function.

        **x** , **y** and **z** are specified in scene or object coordinates
        relative to the currently set projection and model matrices. This can be
        useful if you want to annotate models with text labels and have the
        labels move with the model as it is rotated etc.

        **Note:** This function is not supported on OpenGL/ES systems.

        **Note:** If depth testing is enabled before this function is called,
        then the drawn text will be depth-tested against the models that have
        already been drawn in the scene. Use `glDisable(GL_DEPTH_TEST)` before
        calling this function to annotate the models without depth-testing the
        text.

        **Note:** This function can only be used inside a
        **QPainter::beginNativePainting** ()/**QPainter::endNativePainting** ()
        block if a painter is active on the **QGLWidget** .
        """
        ...

    @staticmethod
    def convertToGLFormat(img: QtGui.QImage) -> QtGui.QImage:
        """
        https://doc.qt.io/qt-5/qglwidget.html#convertToGLFormat

        **[static] QImage QGLWidget::convertToGLFormat(const QImage & img )**

        Converts the image **img** into the unnamed format expected by OpenGL
        functions such as glTexImage2D(). The returned image is not usable as a
        **QImage** , but **QImage::width** (), **QImage::height** () and
        **QImage::bits** () may be used with OpenGL. The GL format used is
        `GL_RGBA`.
        """
        ...

    def overlayContext(self) -> QGLContext:
        """
        https://doc.qt.io/qt-5/qglwidget.html#overlayContext

        **const QGLContext *QGLWidget::overlayContext() const**

        Returns the overlay context of this widget, or `nullptr` if this widget
        has no overlay.

        **See also** **context** ().
        """
        ...

    def makeOverlayCurrent(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#makeOverlayCurrent

        **void QGLWidget::makeOverlayCurrent()**

        Makes the overlay context of this widget current. Use this if you need
        to issue OpenGL commands to the overlay context outside of
        **initializeOverlayGL** (), **resizeOverlayGL** (), and
        **paintOverlayGL** ().

        Does nothing if this widget has no overlay.

        **See also** **makeCurrent** ().
        """
        ...

    def grabFrameBuffer(self, withAlpha: bool = ...) -> QtGui.QImage:
        """
        https://doc.qt.io/qt-5/qglwidget.html#grabFrameBuffer

        **QImage QGLWidget::grabFrameBuffer(bool withAlpha = false)**

        Returns an image of the frame buffer. If **withAlpha** is true the alpha
        channel is included.

        Depending on your hardware, you can explicitly select which color buffer
        to grab with a glReadBuffer() call before calling this function.

        On QNX the back buffer is not preserved when **swapBuffers** () is
        called. The back buffer where this function reads from, might thus not
        contain the same content as the front buffer. In order to retrieve what
        is currently visible on the screen, **swapBuffers** () has to be
        executed prior to this function call.
        """
        ...

    def renderPixmap(
        self, width: int = ..., height: int = ..., useContext: bool = ...
    ) -> QtGui.QPixmap:
        """
        https://doc.qt.io/qt-5/qglwidget.html#renderPixmap

        **QPixmap QGLWidget::renderPixmap(int w = 0, int h = 0, bool useContext
        = false)**

        Renders the current scene on a pixmap and returns the pixmap.

        You can use this method on both visible and invisible **QGLWidget**
        objects.

        Internally the function renders into a framebuffer object and performs
        pixel readback. This has a performance penalty, meaning that this
        function is not suitable to be called at a high frequency.

        After creating and binding the framebuffer object, the function will
        call **initializeGL** (), **resizeGL** (), and **paintGL** (). On the
        next normal update **initializeGL** () and **resizeGL** () will be
        triggered again since the size of the destination pixmap and the
        **QGLWidget** 's size may differ.

        The size of the pixmap will be **w** pixels wide and **h** pixels high
        unless one of these parameters is 0 (the default), in which case the
        pixmap will have the same size as the widget.

        Care must be taken when using framebuffer objects in **paintGL** () in
        combination with this function. To switch back to the default
        framebuffer, use **QGLFramebufferObject::bindDefault** (). Binding FBO 0
        is wrong since renderPixmap() uses a custom framebuffer instead of the
        one provided by the windowing system.

        **useContext** is ignored. Historically this parameter enabled the usage
        of the existing GL context. This is not supported anymore since
        additional contexts are never created.

        Overlays are not rendered onto the pixmap.

        If the GL rendering context and the desktop have different bit depths,
        the result will most likely look surprising.

        Note that the creation of display lists, modifications of the view
        frustum etc. should be done from within **initializeGL** (). If this is
        not done, the temporary QGLContext will not be initialized properly, and
        the rendered pixmap may be incomplete/corrupted.
        """
        ...

    def setContext(
        self,
        context: QGLContext,
        shareContext: typing.Optional[QGLContext] = ...,
        deleteOldContext: bool = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#context

        **QGLContext *QGLWidget::context() const**

        Returns the context of this widget.

        It is possible that the context is not valid (see **isValid** ()), for
        example, if the underlying hardware does not support the format
        attributes that were requested.

        **See also** **setContext** ().
        """
        ...

    def context(self) -> QGLContext:
        """
        https://doc.qt.io/qt-5/qglwidget.html#context

        **QGLContext *QGLWidget::context() const**

        Returns the context of this widget.

        It is possible that the context is not valid (see **isValid** ()), for
        example, if the underlying hardware does not support the format
        attributes that were requested.

        **See also** **setContext** ().
        """
        ...

    def format(self) -> QGLFormat:
        """
        https://doc.qt.io/qt-5/qglwidget.html#format

        **QGLFormat QGLWidget::format() const**

        Returns the format of the contained GL rendering context.

        **See also** **setFormat** ().
        """
        ...

    def swapBuffers(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#swapBuffers

        **void QGLWidget::swapBuffers()**

        Swaps the screen contents with an off-screen buffer. This only works if
        the widget's format specifies double buffer mode.

        Normally, there is no need to explicitly call this function because it
        is done automatically after each widget repaint, i.e. each time after
        **paintGL** () has been executed.

        **See also** **doubleBuffer** (), **setAutoBufferSwap** (), and
        **QGLFormat::setDoubleBuffer** ().
        """
        ...

    def doubleBuffer(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglwidget.html#doubleBuffer

        **bool QGLWidget::doubleBuffer() const**

        Returns `true` if the contained GL rendering context has double
        buffering; otherwise returns `false`.

        **See also** **QGLFormat::doubleBuffer** ().
        """
        ...

    def doneCurrent(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#doneCurrent

        **void QGLWidget::doneCurrent()**

        Makes no GL context the current context. Normally, you do not need to
        call this function; QGLContext calls it as necessary. However, it may be
        useful in multithreaded environments.
        """
        ...

    def makeCurrent(self) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#makeCurrent

        **void QGLWidget::makeCurrent()**

        Makes this widget the current widget for OpenGL operations, i.e. makes
        the widget's rendering context the current OpenGL rendering context.
        """
        ...

    def isSharing(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglwidget.html#isSharing

        **bool QGLWidget::isSharing() const**

        Returns `true` if this widget's GL context is shared with another GL
        context, otherwise false is returned. Context sharing might not be
        possible if the widgets use different formats.

        **See also** **format** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglwidget.html#isValid

        **bool QGLWidget::isValid() const**

        Returns `true` if the widget has a valid GL rendering context; otherwise
        returns `false`. A widget will be invalid if the system has no **OpenGL
        support** .
        """
        ...

    def qglClearColor(
        self, c: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#qglClearColor

        **void QGLWidget::qglClearColor(const QColor & c ) const**

        Convenience function for specifying the clearing color to OpenGL. Calls
        glClearColor (in RGBA mode) or glClearIndex (in color-index mode) with
        the color **c**. Applies to this widgets GL context.

        **See also** **qglColor** (), **QGLContext::currentContext** (), and
        **QColor** .
        """
        ...

    def qglColor(self, c: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None:
        """
        https://doc.qt.io/qt-5/qglwidget.html#qglColor

        **void QGLWidget::qglColor(const QColor & c ) const**

        Convenience function for specifying a drawing color to OpenGL. Calls
        glColor4 (in RGBA mode) or glIndex (in color-index mode) with the color
        **c**. Applies to this widgets GL context.

        **Note:** This function is not supported on OpenGL/ES 2.0 systems.

        **See also** **qglClearColor** (), **QGLContext::currentContext** (),
        and **QColor** .
        """
        ...
