"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNfc import *
from PyQt5 import sip


class QNearFieldTarget(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qnearfieldtarget.html

    **Detailed Description**

    QNearFieldTarget provides a generic interface for communicating with an NFC
    target device. Both NFC Forum devices and NFC Forum Tag targets are
    supported by this class. All target specific classes subclass this class.

    The **type** () function can be used to get the type of the target device.
    The **uid** () function returns the unique identifier of the target. The
    **AccessMethods**  flags returns from the **accessMethods** () function can
    be tested to determine which access methods are supported by the target.

    If the target supports **NdefAccess** , **hasNdefMessage** () can be called
    to test if the target has a stored NDEF message, **readNdefMessages** () and
    **writeNdefMessages** () functions can be used to get and set the NDEF
    message.

    If the target supports **TagTypeSpecificAccess** , **sendCommand** () can be
    used to send a single proprietary command to the target and retrieve the
    response. **sendCommands** () can be used to send multiple proprietary
    commands to the target and retrieve all of the responses.

    If the target supports **LlcpAccess** , the QLlcpSocket class can be used to
    connected to a service provided by the target.
    """

    class Error(int):
        NoError: QNearFieldTarget = ...
        UnknownError: QNearFieldTarget = ...
        UnsupportedError: QNearFieldTarget = ...
        TargetOutOfRangeError: QNearFieldTarget = ...
        NoResponseError: QNearFieldTarget = ...
        ChecksumMismatchError: QNearFieldTarget = ...
        InvalidParametersError: QNearFieldTarget = ...
        NdefReadError: QNearFieldTarget = ...
        NdefWriteError: QNearFieldTarget = ...
        CommandError: QNearFieldTarget = ...

    class AccessMethod(int):
        UnknownAccess: QNearFieldTarget = ...
        NdefAccess: QNearFieldTarget = ...
        TagTypeSpecificAccess: QNearFieldTarget = ...
        LlcpAccess: QNearFieldTarget = ...

    class Type(int):
        ProprietaryTag: QNearFieldTarget = ...
        NfcTagType1: QNearFieldTarget = ...
        NfcTagType2: QNearFieldTarget = ...
        NfcTagType3: QNearFieldTarget = ...
        NfcTagType4: QNearFieldTarget = ...
        MifareTag: QNearFieldTarget = ...

    class AccessMethods(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QNearFieldTarget.AccessMethods", "QNearFieldTarget.AccessMethod"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QNearFieldTarget.AccessMethods") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QNearFieldTarget.AccessMethods":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class RequestId(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, other: "QNearFieldTarget.RequestId") -> None:
            ...

        def refCount(self) -> int:
            ...

        def isValid(self) -> bool:
            ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#QNearFieldTarget

        **QNearFieldTarget::QNearFieldTarget(QObject * parent = nullptr)**

        Constructs a new near field target with **parent**.
        """
        ...

    def maxCommandLength(self) -> int:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#maxCommandLength

        **int QNearFieldTarget::maxCommandLength() const**

        Returns the maximum number of bytes that can be sent with
        **sendCommand** . 0 will be returned if the target does not support
        sending tag type specific commands.

        This function was introduced in Qt 5.9.

        **See also** **sendCommand** () and **sendCommands** ().
        """
        ...

    def disconnect(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#disconnect

        **bool QNearFieldTarget::disconnect()**

        Closes the connection to the target.

        Returns true only if an existing connection was successfully closed.

        This function was introduced in Qt 5.9.

        **See also** **keepConnection** () and **setKeepConnection** ().
        """
        ...

    def setKeepConnection(self, isPersistent: bool) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#setKeepConnection

        **bool QNearFieldTarget::setKeepConnection(bool isPersistent )**

        Preserves the connection to the target device after processing a command
        or reading/writing NDEF messages if **isPersistent** is `true`. By
        default, this behavior is not enabled.

        Returns `true` if enabling this feature was successful. A possible
        reason for a failure is the lack of support on the used platform.

        Enabling this feature requires to use the **disconnect** () function
        too, to close the connection manually and enable communication with the
        target from a different instance. Disabling this feature will also close
        an open connection.

        This function was introduced in Qt 5.9.

        **See also** **keepConnection** () and **disconnect** ().
        """
        ...

    def keepConnection(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#keepConnection

        **bool QNearFieldTarget::keepConnection() const**

        Returns true if this feature is enabled.

        This function was introduced in Qt 5.9.

        **See also** **setKeepConnection** () and **disconnect** ().
        """
        ...

    def reportError(
        self, error: "QNearFieldTarget.Error", id: "QNearFieldTarget.RequestId"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#reportError

        **[protected] void QNearFieldTarget::reportError(QNearFieldTarget::Error
        error , const QNearFieldTarget::RequestId & id )**

        Reports the **error** for the request **id** by appending the signal
        emission to the event queue.

        This function was introduced in Qt 5.12.
        """
        ...

    def handleResponse(
        self,
        id: "QNearFieldTarget.RequestId",
        response: typing.Union[QtCore.QByteArray, bytes, bytearray],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#handleResponse

        **[virtual protected] bool QNearFieldTarget::handleResponse(const
        QNearFieldTarget::RequestId & id , const QByteArray & response )**

        Handles the **response** received for the request **id**. Returns true
        if the response is handled; otherwise returns false.

        Classes reimplementing this virtual function should call the base class
        implementation to ensure that requests initiated by those classes are
        handled correctly.

        The default implementation stores the response such that it can be
        retrieved by **requestResponse** ().

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def setResponseForRequest(
        self,
        id: "QNearFieldTarget.RequestId",
        response: typing.Any,
        emitRequestCompleted: bool = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#setResponseForRequest

        **void QNearFieldTarget::setResponseForRequest(const
        QNearFieldTarget::RequestId & id , const QVariant & response , bool
        emitRequestCompleted = true)**

        Sets the decoded response for request **id** to **response**. If
        **emitRequestCompleted** is true the **requestCompleted** () signal will
        be emitted for **id** ; otherwise no signal will be emitted.

        **See also** **requestResponse** ().
        """
        ...

    def requestResponse(self, id: "QNearFieldTarget.RequestId") -> typing.Any:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#requestResponse

        **QVariant QNearFieldTarget::requestResponse(const
        QNearFieldTarget::RequestId & id )**

        Returns the decoded response for request **id**. If the request is
        unknown or has not yet been completed an invalid **QVariant**  is
        returned.
        """
        ...

    def waitForRequestCompleted(
        self, id: "QNearFieldTarget.RequestId", msecs: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#waitForRequestCompleted

        **[virtual] bool QNearFieldTarget::waitForRequestCompleted(const
        QNearFieldTarget::RequestId & id , int msecs = 5000)**

        Waits up to **msecs** milliseconds for the request **id** to complete.
        Returns true if the request completes successfully and the
        requestCompeted() signal is emitted; otherwise returns false.
        """
        ...

    def sendCommands(
        self,
        commands: typing.Iterable[typing.Union[QtCore.QByteArray, bytes, bytearray]],
    ) -> "QNearFieldTarget.RequestId":
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#sendCommands

        **[virtual] QNearFieldTarget::RequestId
        QNearFieldTarget::sendCommands(const QList<QByteArray> & commands )**

        Sends multiple **commands** to the near field target. Returns a request
        id which can be used to track the completion status of the request. An
        invalid request id will be returned if the target does not support
        sending tag type specific commands.

        If all commands complete successfully the **requestCompleted** () signal
        will be emitted; otherwise the **error** () signal will be emitted. If a
        command fails succeeding commands from this call will not be processed.

        Once the request completes the response for successfully completed
        requests can be retrieved from the **requestResponse** () function. The
        response of this request will be a **QList** <**QByteArray** >.

        **See also** **requestCompleted** () and **waitForRequestCompleted** ().
        """
        ...

    def sendCommand(
        self, command: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> "QNearFieldTarget.RequestId":
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#sendCommand

        **[virtual] QNearFieldTarget::RequestId
        QNearFieldTarget::sendCommand(const QByteArray & command )**

        Sends **command** to the near field target. Returns a request id which
        can be used to track the completion status of the request. An invalid
        request id will be returned if the target does not support sending tag
        type specific commands.

        The **requestCompleted** () signal will be emitted on successful
        completion of the request; otherwise the **error** () signal will be
        emitted.

        Once the request completes successfully the response can be retrieved
        from the **requestResponse** () function. The response of this request
        will be a **QByteArray** .

        **See also** **requestCompleted** () and **waitForRequestCompleted** ().
        """
        ...

    def writeNdefMessages(
        self, messages: typing.Iterable[QNdefMessage]
    ) -> "QNearFieldTarget.RequestId":
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#writeNdefMessages

        **[virtual] QNearFieldTarget::RequestId
        QNearFieldTarget::writeNdefMessages(const QList<QNdefMessage> & messages
        )**

        Writes the NDEF messages in **messages** to the target. Returns a
        request id which can be used to track the completion status of the
        request. An invalid request id will be returned if the target does not
        support reading NDEF messages.

        The **ndefMessagesWritten** () signal will be emitted when the write
        operation completes successfully; otherwise the **error** () signal is
        emitted.
        """
        ...

    def readNdefMessages(self) -> "QNearFieldTarget.RequestId":
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#readNdefMessages

        **[virtual] QNearFieldTarget::RequestId
        QNearFieldTarget::readNdefMessages()**

        Starts reading NDEF messages stored on the near field target. Returns a
        request id which can be used to track the completion status of the
        request. An invalid request id will be returned if the target does not
        support reading NDEF messages.

        An **ndefMessageRead** () signal will be emitted for each NDEF message.
        The **requestCompleted** () signal will be emitted was all NDEF messages
        have been read. The **error** () signal is emitted if an error occurs.
        """
        ...

    def hasNdefMessage(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#hasNdefMessage

        **[virtual] bool QNearFieldTarget::hasNdefMessage()**

        Returns true if at least one NDEF message is stored on the near field
        target; otherwise returns false.
        """
        ...

    def isProcessingCommand(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#isProcessingCommand

        **bool QNearFieldTarget::isProcessingCommand() const**

        Returns true if the target is processing commands; otherwise returns
        false.
        """
        ...

    def accessMethods(self) -> "QNearFieldTarget.AccessMethods":
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#accessMethods

        **[pure virtual] QNearFieldTarget::AccessMethods
        QNearFieldTarget::accessMethods() const**

        Returns the access methods support by this near field target.
        """
        ...

    def type(self) -> "QNearFieldTarget.Type":
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#type

        **[pure virtual] QNearFieldTarget::Type QNearFieldTarget::type() const**

        Returns the type of tag type of this near field target.
        """
        ...

    def url(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#url

        **[virtual] QUrl QNearFieldTarget::url() const**

        Returns the URL of the near field target.
        """
        ...

    def uid(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#uid

        **[pure virtual] QByteArray QNearFieldTarget::uid() const**

        Returns the UID of the near field target.
        """
        ...

    @property
    def disconnected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#disconnected

        **[signal] void QNearFieldTarget::disconnected()**

        This signal is emitted when the near field target moves out of
        proximity.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#error

        **[signal] void QNearFieldTarget::error(QNearFieldTarget::Error error ,
        const QNearFieldTarget::RequestId & id )**

        This signal is emitted when an error occurs while processing request
        **id**. The **error** parameter describes the error.
        """
        ...

    @property
    def ndefMessageRead(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#ndefMessageRead

        **[signal] void QNearFieldTarget::ndefMessageRead(const QNdefMessage &
        message )**

        This signal is emitted when a complete NDEF **message** has been read
        from the target.

        **See also** **readNdefMessages** ().
        """
        ...

    @property
    def ndefMessagesWritten(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#ndefMessagesWritten

        **[signal] void QNearFieldTarget::ndefMessagesWritten()**

        This signal is emitted when NDEF messages have been successfully written
        to the target.

        **See also** **writeNdefMessages** ().
        """
        ...

    @property
    def requestCompleted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldtarget.html#requestCompleted

        **[signal] void QNearFieldTarget::requestCompleted(const
        QNearFieldTarget::RequestId & id )**

        This signal is emitted when a request **id** completes.

        **See also** **sendCommand** ().
        """
        ...
