"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNfc import *
from PyQt5 import sip


class QNearFieldManager(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qnearfieldmanager.html

    **Detailed Description**

    NFC Forum devices support two modes of communications. The first mode, peer-
    to-peer communications, is used to communicate between two NFC Forum
    devices. The second mode, master/slave communications, is used to
    communicate between an NFC Forum device and an NFC Forum Tag or Contactless
    Card. The **targetDetected** () signal is emitted when a target device
    enters communications range. Communications can be initiated from the slot
    connected to this signal.

    NFC Forum devices generally operate as the master in master/slave
    communications. Some devices are also capable of operating as the slave, so
    called Card Emulation mode. In this mode the local NFC device emulates a NFC
    Forum Tag or Contactless Card.

    NFC Forum Tags can contain one or more messages in a standardized format.
    These messages are encapsulated by the **QNdefMessage**  class. Use the
    **registerNdefMessageHandler** () functions to register message handlers
    with particular criteria. Handlers can be unregistered with the
    **unregisterNdefMessageHandler** () function.

    Applications can connect to the **targetDetected** () and **targetLost** ()
    signals to get notified when an NFC Forum Tag enters or leaves proximity.
    Before these signals are emitted target detection must be started with the
    **startTargetDetection** () function. Target detection can be stopped with
    the **stopTargetDetection** () function. Before a detected target can be
    accessed it is necessary to request access rights. This must be done before
    the target device is touched. The **setTargetAccessModes** () function is
    used to set the types of access the application wants to perform on the
    detected target. When access is no longer required the target access modes
    should be set to **NoTargetAccess**  as other applications may be blocked
    from accessing targets. The current target access modes can be retried with
    the **targetAccessModes** () function.

    **Automatically launching NDEF message handlers**

    On some platforms it is possible to pre-register an application to receive
    NDEF messages matching a given criteria. This is useful to get the system to
    automatically launch your application when a matching NDEF message is
    received. This removes the need to have the user manually launch NDEF
    handling applications, prior to touching a tag, or to have those
    applications always running and using system resources.

    The process of registering the handler is different for each platform.
    Please refer to the platform documentation on how such a registration may be
    done. If the application has been registered as an NDEF message handler, the
    application only needs to call the **registerNdefMessageHandler** ()
    function:

    **QNearFieldManager**  *manager = new **QNearFieldManager** (this);
    manager->registerNdefMessageHandler(this,
    SLOT(handleNdefMessage(**QNdefMessage** ,**QNearFieldTarget** *)));

    Automatically launching NDEF message handlers is supported on **Android** .

    **NFC on Linux**

    The **Linux NFC project**  provides software to support NFC on Linux
    platforms. The neard daemon will allow access to the supported hardware via
    DBus interfaces. **QtNfc**  requires neard version 0.14 which can be built
    from source or installed via the appropriate Linux package manager. Not all
    API features are currently supported. To allow **QtNfc**  to access the DBus
    interfaces the neard daemon has to be running. In case of problems debug
    output can be enabled by enabling categorized logging for 'qt.nfc.neard'.
    """

    class AdapterState(int):
        Offline: QNearFieldManager = ...
        TurningOn: QNearFieldManager = ...
        Online: QNearFieldManager = ...
        TurningOff: QNearFieldManager = ...

    class TargetAccessMode(int):
        NoTargetAccess: QNearFieldManager = ...
        NdefReadTargetAccess: QNearFieldManager = ...
        NdefWriteTargetAccess: QNearFieldManager = ...
        TagTypeSpecificTargetAccess: QNearFieldManager = ...

    class TargetAccessModes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QNearFieldManager.TargetAccessModes",
                "QNearFieldManager.TargetAccessMode",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QNearFieldManager.TargetAccessModes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QNearFieldManager.TargetAccessModes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#QNearFieldManager

        **QNearFieldManager::QNearFieldManager(QObject * parent = nullptr)**

        Constructs a new near field manager with **parent**.
        """
        ...

    def isSupported(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#isSupported

        **bool QNearFieldManager::isSupported() const**

        Returns `true` if the underlying device has a NFC adapter; otherwise
        returns `false`.

        This function was introduced in Qt 5.12.

        **See also** **isAvailable** ().
        """
        ...

    def unregisterNdefMessageHandler(self, handlerId: int) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#unregisterNdefMessageHandl
        er

        **bool QNearFieldManager::unregisterNdefMessageHandler(int handlerId )**

        Unregisters the target detect handler identified by **handlerId**.

        Returns true on success; otherwise returns false.
        """
        ...

    @typing.overload
    def registerNdefMessageHandler(self, slot: PYQT_SLOT) -> int:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#registerNdefMessageHandler

        **int QNearFieldManager::registerNdefMessageHandler(QObject * object ,
        const char * method )**

        Registers **object** to receive notifications on **method** when a tag
        has been detected and has an NDEF message that matches a pre-registered
        message format. The **method** on **object** should have the prototype
        'void **targetDetected** (const **QNdefMessage**  &message,
        **QNearFieldTarget**  *target)'.

        Returns an identifier, which can be used to unregister the handler, on
        success; otherwise returns -1.

        This function is used to register a **QNearFieldManager**  instance to
        receive notifications when a NDEF message matching a pre-registered
        message format is received. See the section on **Automatically launching
        NDEF message handlers** .

        **Note:** The **target** parameter of **method** may not be available on
        all platforms, in which case **target** will be 0.
        """
        ...

    @typing.overload
    def registerNdefMessageHandler(
        self,
        typeNameFormat: QNdefRecord.TypeNameFormat,
        type: typing.Union[QtCore.QByteArray, bytes, bytearray],
        slot: PYQT_SLOT,
    ) -> int:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#registerNdefMessageHandler
        -1

        **int QNearFieldManager::registerNdefMessageHandler(QNdefRecord::TypeNam
        eFormat typeNameFormat , const QByteArray & type , QObject * object ,
        const char * method )**

        Registers **object** to receive notifications on **method** when a tag
        has been detected and has an NDEF record that matches **typeNameFormat**
        and **type**. The **method** on **object** should have the prototype
        'void **targetDetected** (const **QNdefMessage**  &message,
        **QNearFieldTarget**  *target)'.

        Returns an identifier, which can be used to unregister the handler, on
        success; otherwise returns -1.

        **Note:** The **target** parameter of **method** may not be available on
        all platforms, in which case **target** will be 0.

        **Note:** On platforms using neard registering message handlers is not
        supported.
        """
        ...

    @typing.overload
    def registerNdefMessageHandler(self, filter: QNdefFilter, slot: PYQT_SLOT) -> int:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#registerNdefMessageHandler
        -2

        **int QNearFieldManager::registerNdefMessageHandler(const QNdefFilter &
        filter , QObject * object , const char * method )**

        Registers **object** to receive notifications on **method** when a tag
        has been detected and has an NDEF message that matches **filter** is
        detected. The **method** on **object** should have the prototype 'void
        **targetDetected** (const **QNdefMessage**  &message,
        **QNearFieldTarget**  *target)'.

        Returns an identifier, which can be used to unregister the handler, on
        success; otherwise returns -1.

        **Note:** The **target** parameter of **method** may not be available on
        all platforms, in which case **target** will be 0.
        """
        ...

    def stopTargetDetection(self) -> None:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#stopTargetDetection

        **void QNearFieldManager::stopTargetDetection()**

        Stops detecting targets. The **targetDetected** () signal will no longer
        be emitted until another call to **startTargetDetection** () is made.
        """
        ...

    def startTargetDetection(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#startTargetDetection

        **bool QNearFieldManager::startTargetDetection()**

        Starts detecting targets and returns true if target detection is
        successfully started; otherwise returns false. Causes the
        **targetDetected** () signal to be emitted when a target is within
        proximity.

        **Note:** For platforms using neard: target detection will stop as soon
        as a tag has been detected.

        **See also** **stopTargetDetection** ().
        """
        ...

    def targetAccessModes(self) -> "QNearFieldManager.TargetAccessModes":
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#targetAccessModes

        **QNearFieldManager::TargetAccessModes
        QNearFieldManager::targetAccessModes() const**

        Returns current requested target access modes.

        **See also** **setTargetAccessModes** ().
        """
        ...

    def setTargetAccessModes(
        self,
        accessModes: typing.Union[
            "QNearFieldManager.TargetAccessModes", "QNearFieldManager.TargetAccessMode"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#setTargetAccessModes

        **void QNearFieldManager::setTargetAccessModes(QNearFieldManager::Target
        AccessModes accessModes )**

        Sets the requested target access modes to **accessModes**.

        **See also** **targetAccessModes** ().
        """
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#isAvailable

        **bool QNearFieldManager::isAvailable() const**

        Returns `true` if the device has a NFC adapter and it is turned on;
        otherwise returns `false`.

        **See also** **isSupported** ().
        """
        ...

    @property
    def adapterStateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#adapterStateChanged

        **[signal] void
        QNearFieldManager::adapterStateChanged(QNearFieldManager::AdapterState
        state )**

        This signal is emitted whenever the **state** of the NFC adapter
        changed.

        **Note:** Currently, this signal is only emitted on Android.

        This function was introduced in Qt 5.12.
        """
        ...

    @property
    def targetDetected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#targetDetected

        **[signal] void QNearFieldManager::targetDetected(QNearFieldTarget *
        target )**

        This signal is emitted whenever a target is detected. The **target**
        parameter represents the detected target.

        This signal will be emitted for all detected targets.

        **QNearFieldManager**  maintains ownership of **target** , however, it
        will not be destroyed until the **QNearFieldManager**  destructor is
        called. Ownership may be transferred by calling **setParent** ().

        Do not delete **target** from the slot connected to this signal, instead
        call **deleteLater** ().

        **Note:** that if **target** is deleted before it moves out of proximity
        the **targetLost** () signal will not be emitted.

        **See also** **targetLost** ().
        """
        ...

    @property
    def targetLost(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldmanager.html#targetLost

        **[signal] void QNearFieldManager::targetLost(QNearFieldTarget * target
        )**

        This signal is emitted whenever a target moves out of proximity. The
        **target** parameter represents the lost target.

        Do not delete **target** from the slot connected to this signal, instead
        use **deleteLater** ().

        **See also** **QNearFieldTarget::disconnected** ().
        """
        ...
