"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNetwork import *


class QSslSocket(QTcpSocket):
    """
    https://doc.qt.io/qt-5/qsslsocket.html

    **Detailed Description**

    QSslSocket establishes a secure, encrypted TCP connection you can use for
    transmitting encrypted data. It can operate in both client and server mode,
    and it supports modern SSL protocols, including SSL 3 and TLS 1.2. By
    default, QSslSocket uses only SSL protocols which are considered to be
    secure (**QSsl::SecureProtocols** ), but you can change the SSL protocol by
    calling **setProtocol** () as long as you do it before the handshake has
    started.

    SSL encryption operates on top of the existing TCP stream after the socket
    enters the **ConnectedState** . There are two simple ways to establish a
    secure connection using QSslSocket: With an immediate SSL handshake, or with
    a delayed SSL handshake occurring after the connection has been established
    in unencrypted mode.

    The most common way to use QSslSocket is to construct an object and start a
    secure connection by calling **connectToHostEncrypted** (). This method
    starts an immediate SSL handshake once the connection has been established.

    **QSslSocket**  *socket = new **QSslSocket** (this);
        connect(socket,
    SIGNAL(encrypted()), this, SLOT(ready()));
    socket->connectToHostEncrypted("imap.example.com", 993);

    As with a plain **QTcpSocket** , QSslSocket enters the **HostLookupState** ,
    **ConnectingState** , and finally the **ConnectedState** , if the connection
    is successful. The handshake then starts automatically, and if it succeeds,
    the **encrypted** () signal is emitted to indicate the socket has entered
    the encrypted state and is ready for use.

    Note that data can be written to the socket immediately after the return
    from **connectToHostEncrypted** () (i.e., before the **encrypted** () signal
    is emitted). The data is queued in QSslSocket until after the **encrypted**
    () signal is emitted.

    An example of using the delayed SSL handshake to secure an existing
    connection is the case where an SSL server secures an incoming connection.
    Suppose you create an SSL server class as a subclass of **QTcpServer** . You
    would override **QTcpServer::incomingConnection** () with something like the
    example below, which first constructs an instance of QSslSocket and then
    calls **setSocketDescriptor** () to set the new socket's descriptor to the
    existing one passed in. It then initiates the SSL handshake by calling
    **startServerEncryption** ().

    void SslServer::incomingConnection(qintptr socketDescriptor)
        {
    **QSslSocket**  *serverSocket = new **QSslSocket** ;
            if
    (serverSocket->setSocketDescriptor(socketDescriptor)) {
    addPendingConnection(serverSocket);
                connect(serverSocket,
    &**QSslSocket** ::encrypted, this, &SslServer::ready);
    serverSocket->startServerEncryption();
            } else {
                delete
    serverSocket;
            }
        }

    If an error occurs, QSslSocket emits the sslErrors() signal. In this case,
    if no action is taken to ignore the error(s), the connection is dropped. To
    continue, despite the occurrence of an error, you can call
    **ignoreSslErrors** (), either from within this slot after the error occurs,
    or any time after construction of the QSslSocket and before the connection
    is attempted. This will allow QSslSocket to ignore the errors it encounters
    when establishing the identity of the peer. Ignoring errors during an SSL
    handshake should be used with caution, since a fundamental characteristic of
    secure connections is that they should be established with a successful
    handshake.

    Once encrypted, you use QSslSocket as a regular **QTcpSocket** . When
    **readyRead** () is emitted, you can call **read** (), **canReadLine** ()
    and **readLine** (), or **getChar** () to read decrypted data from
    QSslSocket's internal buffer, and you can call **write** () or **putChar**
    () to write data back to the peer. QSslSocket will automatically encrypt the
    written data for you, and emit **encryptedBytesWritten** () once the data
    has been written to the peer.

    As a convenience, QSslSocket supports **QTcpSocket** 's blocking functions
    **waitForConnected** (), **waitForReadyRead** (), **waitForBytesWritten**
    (), and **waitForDisconnected** (). It also provides **waitForEncrypted**
    (), which will block the calling thread until an encrypted connection has
    been established.

    **QSslSocket**  socket;
    socket.connectToHostEncrypted("http.example.com", 443);
        if
    (!socket.waitForEncrypted()) {
            **qDebug** () <<
    socket.errorString();
            return false;
        }

        socket.write("GET
    / HTTP/1.0\\r\\n\\r\\n");
        while (socket.waitForReadyRead())
    **qDebug** () << socket.readAll().data();

    QSslSocket provides an extensive, easy-to-use API for handling cryptographic
    ciphers, private keys, and local, peer, and Certification Authority (CA)
    certificates. It also provides an API for handling errors that occur during
    the handshake phase.

    The following features can also be customized:

    * The socket's cryptographic cipher suite can be customized before the
    handshake phase with **QSslConfiguration::setCiphers** () and
    QSslConfiguration::setDefaultCiphers().
      * The socket's local certificate
    and private key can be customized before the handshake phase with
    **setLocalCertificate** () and **setPrivateKey** ().
      * The CA certificate
    database can be extended and customized with
    **QSslConfiguration::addCaCertificate** (),
    **QSslConfiguration::addCaCertificates** ().

    To extend the list of **default** CA certificates used by the SSL sockets
    during the SSL handshake you must update the default configuration, as in
    the snippet below:

    **QList** <**QSslCertificate** > certificates = getCertificates();
    **QSslConfiguration**  configuration = **QSslConfiguration**
    ::defaultConfiguration();
        configuration.addCaCertificates(certificates);
    **QSslConfiguration** ::setDefaultConfiguration(configuration);

    **Note:** If available, root certificates on Unix (excluding macOS) will be
    loaded on demand from the standard certificate directories. If you do not
    want to load root certificates on demand, you need to call either
    **QSslConfiguration::defaultConfiguration** ().setCaCertificates() before
    the first SSL handshake is made in your application (for example, via
    passing QSslSocket::systemCaCertificates() to it), or call
    **QSslConfiguration::defaultConfiguration** ()::setCaCertificates() on your
    QSslSocket instance prior to the SSL handshake.

    For more information about ciphers and certificates, refer to **QSslCipher**
    and **QSslCertificate** .

    This product includes software developed by the OpenSSL Project for use in
    the OpenSSL Toolkit (<http://www.openssl.org/>).

    **Note:** Be aware of the difference between the **bytesWritten** () signal
    and the **encryptedBytesWritten** () signal. For a **QTcpSocket** ,
    **bytesWritten** () will get emitted as soon as data has been written to the
    TCP socket. For a QSslSocket, **bytesWritten** () will get emitted when the
    data is being encrypted and **encryptedBytesWritten** () will get emitted as
    soon as data has been written to the TCP socket.

    **See also** **QSslCertificate** , **QSslCipher** , and **QSslError** .
    """

    class PeerVerifyMode(int):
        VerifyNone: QSslSocket = ...
        QueryPeer: QSslSocket = ...
        VerifyPeer: QSslSocket = ...
        AutoVerifyPeer: QSslSocket = ...

    class SslMode(int):
        UnencryptedMode: QSslSocket = ...
        SslClientMode: QSslSocket = ...
        SslServerMode: QSslSocket = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#QSslSocket

        **QSslSocket::QSslSocket(QObject * parent = nullptr)**

        Constructs a QSslSocket object. **parent** is passed to **QObject** 's
        constructor. The new socket's **cipher**  suite is set to the one
        returned by the static method defaultCiphers().
        """
        ...

    def sslHandshakeErrors(self) -> typing.List[QSslError]:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#sslHandshakeErrors

        **QList<QSslError> QSslSocket::sslHandshakeErrors() const**

        Returns a list of the last SSL errors that occurred. This is the same
        list as **QSslSocket**  passes via the sslErrors() signal. If the
        connection has been encrypted with no errors, this function will return
        an empty list.

        This function was introduced in Qt 5.15.

        **See also** **connectToHostEncrypted** ().
        """
        ...

    def ocspResponses(self) -> typing.List[QOcspResponse]:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#ocspResponses

        **QVector<QOcspResponse> QSslSocket::ocspResponses() const**

        This function returns Online Certificate Status Protocol responses that
        a server may send during a TLS handshake using OCSP stapling. The vector
        is empty if no definitive response or no response at all was received.

        This function was introduced in Qt 5.13.

        **See also** **QSslConfiguration::setOcspStaplingEnabled** ().
        """
        ...

    @staticmethod
    def sslLibraryBuildVersionString() -> str:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#sslLibraryBuildVersionString

        **[static] QString QSslSocket::sslLibraryBuildVersionString()**

        Returns the version string of the SSL library in use at compile time. If
        no SSL support is available then this will return an empty value.

        This function was introduced in Qt 5.4.

        **See also** **sslLibraryVersionString** ().
        """
        ...

    @staticmethod
    def sslLibraryBuildVersionNumber() -> int:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#sslLibraryBuildVersionNumber

        **[static] long QSslSocket::sslLibraryBuildVersionNumber()**

        Returns the version number of the SSL library in use at compile time. If
        no SSL support is available then this will return an undefined value.

        This function was introduced in Qt 5.4.

        **See also** **sslLibraryVersionNumber** ().
        """
        ...

    def sessionProtocol(self) -> QSsl.SslProtocol:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#sessionProtocol

        **QSsl::SslProtocol QSslSocket::sessionProtocol() const**

        Returns the socket's SSL/TLS protocol or UnknownProtocol if the
        connection isn't encrypted. The socket's protocol for the session is set
        during the handshake phase.

        This function was introduced in Qt 5.4.

        **See also** **protocol** () and **setProtocol** ().
        """
        ...

    def localCertificateChain(self) -> typing.List[QSslCertificate]:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#localCertificateChain

        **QList<QSslCertificate> QSslSocket::localCertificateChain() const**

        Returns the socket's local **certificate**  chain, or an empty list if
        no local certificates have been assigned.

        This function was introduced in Qt 5.1.

        **See also** **setLocalCertificateChain** ().
        """
        ...

    def setLocalCertificateChain(
        self, localChain: typing.Iterable[QSslCertificate]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setLocalCertificateChain

        **void QSslSocket::setLocalCertificateChain(const QList<QSslCertificate>
        & localChain )**

        Sets the certificate chain to be presented to the peer during the SSL
        handshake to be **localChain**.

        This function was introduced in Qt 5.1.

        **See also** **localCertificateChain** () and
        **QSslConfiguration::setLocalCertificateChain** ().
        """
        ...

    @staticmethod
    def sslLibraryVersionString() -> str:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#sslLibraryVersionString

        **[static] QString QSslSocket::sslLibraryVersionString()**

        Returns the version string of the SSL library in use. Note that this is
        the version of the library in use at run-time not compile time. If no
        SSL support is available then this will return an empty value.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def sslLibraryVersionNumber() -> int:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#sslLibraryVersionNumber

        **[static] long QSslSocket::sslLibraryVersionNumber()**

        Returns the version number of the SSL library in use. Note that this is
        the version of the library in use at run-time not compile time. If no
        SSL support is available then this will return an undefined value.

        This function was introduced in Qt 5.0.
        """
        ...

    def disconnectFromHost(self) -> None:
        ...

    def connectToHost(
        self,
        hostName: str,
        port: int,
        mode: typing.Union[
            QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag
        ] = ...,
        protocol: QAbstractSocket.NetworkLayerProtocol = ...,
    ) -> None:
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#resume

        **[override virtual] void QSslSocket::resume()**

        Reimplements: **QAbstractSocket::resume** ().

        Continues data transfer on the socket after it has been paused. If
        "**setPauseMode** (**QAbstractSocket::PauseOnSslErrors** );" has been
        called on this socket and a sslErrors() signal is received, calling this
        method is necessary for the socket to continue.

        This function was introduced in Qt 5.0.

        **See also** **QAbstractSocket::pauseMode** () and
        **QAbstractSocket::setPauseMode** ().
        """
        ...

    def setPeerVerifyName(self, hostName: str) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setPeerVerifyName

        **void QSslSocket::setPeerVerifyName(const QString & hostName )**

        Sets a different host name, given by **hostName** , for the certificate
        validation instead of the one used for the TCP connection.

        This function was introduced in Qt 4.8.

        **See also** **peerVerifyName** () and **connectToHostEncrypted** ().
        """
        ...

    def peerVerifyName(self) -> str:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#peerVerifyName

        **QString QSslSocket::peerVerifyName() const**

        Returns the different hostname for the certificate validation, as set by
        **setPeerVerifyName**  or by **connectToHostEncrypted** .

        This function was introduced in Qt 4.8.

        **See also** **setPeerVerifyName** () and **connectToHostEncrypted** ().
        """
        ...

    def socketOption(self, option: QAbstractSocket.SocketOption) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#socketOption

        **[override virtual] QVariant
        QSslSocket::socketOption(QAbstractSocket::SocketOption option )**

        Reimplements: **QAbstractSocket::socketOption**
        (QAbstractSocket::SocketOption option).

        Returns the value of the **option** option.

        This function was introduced in Qt 4.6.

        **See also** **setSocketOption** ().
        """
        ...

    def setSocketOption(
        self, option: QAbstractSocket.SocketOption, value: typing.Any
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setSocketOption

        **[override virtual] void
        QSslSocket::setSocketOption(QAbstractSocket::SocketOption option , const
        QVariant & value )**

        Reimplements: **QAbstractSocket::setSocketOption**
        (QAbstractSocket::SocketOption option, const QVariant &value).

        Sets the given **option** to the value described by **value**.

        This function was introduced in Qt 4.6.

        **See also** **socketOption** ().
        """
        ...

    def setSslConfiguration(self, config: QSslConfiguration) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setSslConfiguration

        **void QSslSocket::setSslConfiguration(const QSslConfiguration &
        configuration )**

        Sets the socket's SSL configuration to be the contents of
        **configuration**. This function sets the local certificate, the
        ciphers, the private key and the CA certificates to those stored in
        **configuration**.

        It is not possible to set the SSL-state related fields.

        This function was introduced in Qt 4.4.

        **See also** **sslConfiguration** (), **setLocalCertificate** (),
        **setPrivateKey** (), **QSslConfiguration::setCaCertificates** (), and
        **QSslConfiguration::setCiphers** ().
        """
        ...

    def sslConfiguration(self) -> QSslConfiguration:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#sslConfiguration

        **QSslConfiguration QSslSocket::sslConfiguration() const**

        Returns the socket's SSL configuration state. The default SSL
        configuration of a socket is to use the default ciphers, default CA
        certificates, no local private key or certificate.

        The SSL configuration also contains fields that can change with time
        without notice.

        This function was introduced in Qt 4.4.

        **See also** **setSslConfiguration** (), **localCertificate** (),
        **peerCertificate** (), **peerCertificateChain** (), **sessionCipher**
        (), **privateKey** (), **QSslConfiguration::ciphers** (), and
        **QSslConfiguration::caCertificates** ().
        """
        ...

    def encryptedBytesToWrite(self) -> int:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#encryptedBytesToWrite

        **qint64 QSslSocket::encryptedBytesToWrite() const**

        Returns the number of encrypted bytes that are waiting to be written to
        the network.

        This function was introduced in Qt 4.4.
        """
        ...

    def encryptedBytesAvailable(self) -> int:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#encryptedBytesAvailable

        **qint64 QSslSocket::encryptedBytesAvailable() const**

        Returns the number of encrypted bytes that are awaiting decryption.
        Normally, this function will return 0 because **QSslSocket**  decrypts
        its incoming data as soon as it can.

        This function was introduced in Qt 4.4.
        """
        ...

    def setReadBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setReadBufferSize

        **[override virtual] void QSslSocket::setReadBufferSize(qint64 size )**

        Reimplements: **QAbstractSocket::setReadBufferSize** (qint64 size).

        Sets the size of **QSslSocket** 's internal read buffer to be **size**
        bytes.

        This function was introduced in Qt 4.4.
        """
        ...

    def setPeerVerifyDepth(self, depth: int) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setPeerVerifyDepth

        **void QSslSocket::setPeerVerifyDepth(int depth )**

        Sets the maximum number of certificates in the peer's certificate chain
        to be checked during the SSL handshake phase, to **depth**. Setting a
        depth of 0 means that no maximum depth is set, indicating that the whole
        certificate chain should be checked.

        The certificates are checked in issuing order, starting with the peer's
        own certificate, then its issuer's certificate, and so on.

        This function was introduced in Qt 4.4.

        **See also** **peerVerifyDepth** () and **setPeerVerifyMode** ().
        """
        ...

    def peerVerifyDepth(self) -> int:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#peerVerifyDepth

        **int QSslSocket::peerVerifyDepth() const**

        Returns the maximum number of certificates in the peer's certificate
        chain to be checked during the SSL handshake phase, or 0 (the default)
        if no maximum depth has been set, indicating that the whole certificate
        chain should be checked.

        The certificates are checked in issuing order, starting with the peer's
        own certificate, then its issuer's certificate, and so on.

        This function was introduced in Qt 4.4.

        **See also** **setPeerVerifyDepth** () and **peerVerifyMode** ().
        """
        ...

    def setPeerVerifyMode(self, mode: "QSslSocket.PeerVerifyMode") -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setPeerVerifyMode

        **void QSslSocket::setPeerVerifyMode(QSslSocket::PeerVerifyMode mode )**

        Sets the socket's verify mode to **mode**. This mode decides whether
        **QSslSocket**  should request a certificate from the peer (i.e., the
        client requests a certificate from the server, or a server requesting a
        certificate from the client), and whether it should require that this
        certificate is valid.

        The default mode is **AutoVerifyPeer** , which tells **QSslSocket**  to
        use **VerifyPeer**  for clients and **QueryPeer**  for servers.

        Setting this mode after encryption has started has no effect on the
        current connection.

        This function was introduced in Qt 4.4.

        **See also** **peerVerifyMode** (), **setPeerVerifyDepth** (), and
        **mode** ().
        """
        ...

    def peerVerifyMode(self) -> "QSslSocket.PeerVerifyMode":
        """
        https://doc.qt.io/qt-5/qsslsocket.html#peerVerifyMode

        **QSslSocket::PeerVerifyMode QSslSocket::peerVerifyMode() const**

        Returns the socket's verify mode. This mode decides whether
        **QSslSocket**  should request a certificate from the peer (i.e., the
        client requests a certificate from the server, or a server requesting a
        certificate from the client), and whether it should require that this
        certificate is valid.

        The default mode is **AutoVerifyPeer** , which tells **QSslSocket**  to
        use **VerifyPeer**  for clients and **QueryPeer**  for servers.

        This function was introduced in Qt 4.4.

        **See also** **setPeerVerifyMode** (), **peerVerifyDepth** (), and
        **mode** ().
        """
        ...

    def writeData(self, data: bytes) -> int:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#writeData

        **[override virtual protected] qint64 QSslSocket::writeData(const char *
        data , qint64 len )**

        Reimplements: **QAbstractSocket::writeData** (const char *data, qint64
        size).
        """
        ...

    def readData(self, maxlen: int) -> bytes:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#readData

        **[override virtual protected] qint64 QSslSocket::readData(char * data ,
        qint64 maxlen )**

        Reimplements: **QAbstractSocket::readData** (char *data, qint64
        maxSize).
        """
        ...

    @typing.overload
    def ignoreSslErrors(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#ignoreSslErrors

        **[slot] void QSslSocket::ignoreSslErrors()**

        This slot tells **QSslSocket**  to ignore errors during **QSslSocket**
        's handshake phase and continue connecting. If you want to continue with
        the connection even if errors occur during the handshake phase, then you
        must call this slot, either from a slot connected to sslErrors(), or
        before the handshake phase. If you don't call this slot, either in
        response to errors or before the handshake, the connection will be
        dropped after the sslErrors() signal has been emitted.

        If there are no errors during the SSL handshake phase (i.e., the
        identity of the peer is established with no problems), **QSslSocket**
        will not emit the sslErrors() signal, and it is unnecessary to call this
        function.

        **Warning:** Be sure to always let the user inspect the errors reported
        by the sslErrors() signal, and only call this method upon confirmation
        from the user that proceeding is ok. If there are unexpected errors, the
        connection should be aborted. Calling this method without inspecting the
        actual errors will most likely pose a security risk for your
        application. Use it with great care!

        **See also** **sslErrors** ().
        """
        ...

    @typing.overload
    def ignoreSslErrors(self, errors: typing.Iterable[QSslError]) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#ignoreSslErrors-1

        **void QSslSocket::ignoreSslErrors(const QList<QSslError> & errors )**

        This is an overloaded function.

        This method tells **QSslSocket**  to ignore only the errors given in
        **errors**.

        **Note:** Because most SSL errors are associated with a certificate, for
        most of them you must set the expected certificate this SSL error is
        related to. If, for instance, you want to connect to a server that uses
        a self-signed certificate, consider the following snippet:

        **QList** <**QSslCertificate** > cert = **QSslCertificate**
        ::fromPath(QLatin1String("server-certificate.pem"));
            **QSslError**
        error(**QSslError** ::SelfSignedCertificate, cert.at(0));
            **QList**
        <**QSslError** > expectedSslErrors;
            expectedSslErrors.append(error);
        **QSslSocket**  socket;
            socket.ignoreSslErrors(expectedSslErrors);
        socket.connectToHostEncrypted("server.tld", 443);

        Multiple calls to this function will replace the list of errors that
        were passed in previous calls. You can clear the list of errors you want
        to ignore by calling this function with an empty list.

        This function was introduced in Qt 4.6.

        **See also** **sslErrors** () and **sslHandshakeErrors** ().
        """
        ...

    def startServerEncryption(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#startServerEncryption

        **[slot] void QSslSocket::startServerEncryption()**

        Starts a delayed SSL handshake for a server connection. This function
        can be called when the socket is in the **ConnectedState**  but still in
        **UnencryptedMode** . If it is not connected or it is already encrypted,
        the function has no effect.

        For server sockets, calling this function is the only way to initiate
        the SSL handshake. Most servers will call this function immediately upon
        receiving a connection, or as a result of having received a protocol-
        specific command to enter SSL mode (e.g, the server may respond to
        receiving the string "STARTTLS\\r\\n" by calling this function).

        The most common way to implement an SSL server is to create a subclass
        of **QTcpServer**  and reimplement **QTcpServer::incomingConnection**
        (). The returned socket descriptor is then passed to
        **QSslSocket::setSocketDescriptor** ().

        **See also** **connectToHostEncrypted** () and **startClientEncryption**
        ().
        """
        ...

    def startClientEncryption(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#startClientEncryption

        **[slot] void QSslSocket::startClientEncryption()**

        Starts a delayed SSL handshake for a client connection. This function
        can be called when the socket is in the **ConnectedState**  but still in
        the **UnencryptedMode** . If it is not yet connected, or if it is
        already encrypted, this function has no effect.

        Clients that implement STARTTLS functionality often make use of delayed
        SSL handshakes. Most other clients can avoid calling this function
        directly by using **connectToHostEncrypted** () instead, which
        automatically performs the handshake.

        **See also** **connectToHostEncrypted** () and **startServerEncryption**
        ().
        """
        ...

    @staticmethod
    def supportsSsl() -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#supportsSsl

        **[static] bool QSslSocket::supportsSsl()**

        Returns `true` if this platform supports SSL; otherwise, returns false.
        If the platform doesn't support SSL, the socket will fail in the
        connection phase.
        """
        ...

    def waitForDisconnected(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#waitForDisconnected

        **[override virtual] bool QSslSocket::waitForDisconnected(int msecs =
        30000)**

        Reimplements: **QAbstractSocket::waitForDisconnected** (int msecs).

        Waits until the socket has disconnected or **msecs** milliseconds,
        whichever comes first. If the connection has been disconnected, this
        function returns `true`; otherwise it returns `false`.

        **See also** **QAbstractSocket::waitForDisconnected** ().
        """
        ...

    def waitForBytesWritten(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#waitForBytesWritten

        **[override virtual] bool QSslSocket::waitForBytesWritten(int msecs =
        30000)**

        Reimplements: **QAbstractSocket::waitForBytesWritten** (int msecs).
        """
        ...

    def waitForReadyRead(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#waitForReadyRead

        **[override virtual] bool QSslSocket::waitForReadyRead(int msecs =
        30000)**

        Reimplements: **QAbstractSocket::waitForReadyRead** (int msecs).
        """
        ...

    def waitForEncrypted(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#waitForEncrypted

        **bool QSslSocket::waitForEncrypted(int msecs = 30000)**

        Waits until the socket has completed the SSL handshake and has emitted
        **encrypted** (), or **msecs** milliseconds, whichever comes first. If
        **encrypted** () has been emitted, this function returns true; otherwise
        (e.g., the socket is disconnected, or the SSL handshake fails), false is
        returned.

        The following example waits up to one second for the socket to be
        encrypted:

        socket->connectToHostEncrypted("imap", 993);
            if
        (socket->waitForEncrypted(1000))
                **qDebug** ("Encrypted!");

        If msecs is -1, this function will not time out.

        **See also** **startClientEncryption** (), **startServerEncryption** (),
        **encrypted** (), and **isEncrypted** ().
        """
        ...

    def waitForConnected(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#waitForConnected

        **[override virtual] bool QSslSocket::waitForConnected(int msecs =
        30000)**

        Reimplements: **QAbstractSocket::waitForConnected** (int msecs).

        Waits until the socket is connected, or **msecs** milliseconds,
        whichever happens first. If the connection has been established, this
        function returns `true`; otherwise it returns `false`.

        **See also** **QAbstractSocket::waitForConnected** ().
        """
        ...

    @staticmethod
    def systemCaCertificates() -> typing.List[QSslCertificate]:
        ...

    @staticmethod
    def defaultCaCertificates() -> typing.List[QSslCertificate]:
        ...

    @staticmethod
    def setDefaultCaCertificates(
        certificates: typing.Iterable[QSslCertificate],
    ) -> None:
        ...

    @staticmethod
    def addDefaultCaCertificate(certificate: QSslCertificate) -> None:
        ...

    @typing.overload
    @staticmethod
    def addDefaultCaCertificates(
        path: str,
        format: QSsl.EncodingFormat = ...,
        syntax: QtCore.QRegExp.PatternSyntax = ...,
    ) -> bool:
        ...

    @typing.overload
    @staticmethod
    def addDefaultCaCertificates(
        certificates: typing.Iterable[QSslCertificate],
    ) -> None:
        ...

    def caCertificates(self) -> typing.List[QSslCertificate]:
        ...

    def setCaCertificates(self, certificates: typing.Iterable[QSslCertificate]) -> None:
        ...

    def addCaCertificate(self, certificate: QSslCertificate) -> None:
        ...

    @typing.overload
    def addCaCertificates(
        self,
        path: str,
        format: QSsl.EncodingFormat = ...,
        syntax: QtCore.QRegExp.PatternSyntax = ...,
    ) -> bool:
        ...

    @typing.overload
    def addCaCertificates(self, certificates: typing.Iterable[QSslCertificate]) -> None:
        ...

    @staticmethod
    def supportedCiphers() -> typing.List[QSslCipher]:
        ...

    @staticmethod
    def defaultCiphers() -> typing.List[QSslCipher]:
        ...

    @staticmethod
    def setDefaultCiphers(ciphers: typing.Iterable[QSslCipher]) -> None:
        ...

    @typing.overload
    def setCiphers(self, ciphers: typing.Iterable[QSslCipher]) -> None:
        ...

    @typing.overload
    def setCiphers(self, ciphers: str) -> None:
        ...

    def ciphers(self) -> typing.List[QSslCipher]:
        ...

    def privateKey(self) -> QSslKey:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#privateKey

        **QSslKey QSslSocket::privateKey() const**

        Returns this socket's private key.

        **See also** **setPrivateKey** () and **localCertificate** ().
        """
        ...

    @typing.overload
    def setPrivateKey(self, key: QSslKey) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setPrivateKey

        **void QSslSocket::setPrivateKey(const QSslKey & key )**

        Sets the socket's private **key**  to **key**. The private key and the
        local **certificate**  are used by clients and servers that must prove
        their identity to SSL peers.

        Both the key and the local certificate are required if you are creating
        an SSL server socket. If you are creating an SSL client socket, the key
        and local certificate are required if your client must identify itself
        to an SSL server.

        **See also** **privateKey** () and **setLocalCertificate** ().
        """
        ...

    @typing.overload
    def setPrivateKey(
        self,
        fileName: str,
        algorithm: QSsl.KeyAlgorithm = ...,
        format: QSsl.EncodingFormat = ...,
        passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setPrivateKey-1

        **void QSslSocket::setPrivateKey(const QString & fileName ,
        QSsl::KeyAlgorithm algorithm = QSsl::Rsa, QSsl::EncodingFormat format =
        QSsl::Pem, const QByteArray & passPhrase = QByteArray())**

        This is an overloaded function.

        Reads the string in file **fileName** and decodes it using a specified
        **algorithm** and encoding **format** to construct an **SSL key** . If
        the encoded key is encrypted, **passPhrase** is used to decrypt it.

        The socket's private key is set to the constructed key. The private key
        and the local **certificate**  are used by clients and servers that must
        prove their identity to SSL peers.

        Both the key and the local certificate are required if you are creating
        an SSL server socket. If you are creating an SSL client socket, the key
        and local certificate are required if your client must identify itself
        to an SSL server.

        **See also** **privateKey** () and **setLocalCertificate** ().
        """
        ...

    def sessionCipher(self) -> QSslCipher:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#sessionCipher

        **QSslCipher QSslSocket::sessionCipher() const**

        Returns the socket's cryptographic **cipher** , or a null cipher if the
        connection isn't encrypted. The socket's cipher for the session is set
        during the handshake phase. The cipher is used to encrypt and decrypt
        data transmitted through the socket.

        **QSslSocket**  also provides functions for setting the ordered list of
        ciphers from which the handshake phase will eventually select the
        session cipher. This ordered list must be in place before the handshake
        phase begins.

        **See also** **QSslConfiguration::ciphers** (),
        **QSslConfiguration::setCiphers** (), **QSslConfiguration::setCiphers**
        (), **QSslConfiguration::ciphers** (), and
        **QSslConfiguration::supportedCiphers** ().
        """
        ...

    def peerCertificateChain(self) -> typing.List[QSslCertificate]:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#peerCertificateChain

        **QList<QSslCertificate> QSslSocket::peerCertificateChain() const**

        Returns the peer's chain of digital certificates, or an empty list of
        certificates.

        Peer certificates are checked automatically during the handshake phase.
        This function is normally used to fetch certificates for display, or for
        performing connection diagnostics. Certificates contain information
        about the peer and the certificate issuers, including host name, issuer
        names, and issuer public keys.

        The peer certificates are set in **QSslSocket**  during the handshake
        phase, so it is safe to call this function from a slot connected to the
        sslErrors() signal or the **encrypted** () signal.

        If an empty list is returned, it can mean the SSL handshake failed, or
        it can mean the host you are connected to doesn't have a certificate, or
        it can mean there is no connection.

        If you want to get only the peer's immediate certificate, use
        **peerCertificate** ().

        **See also** **peerCertificate** ().
        """
        ...

    def peerCertificate(self) -> QSslCertificate:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#peerCertificate

        **QSslCertificate QSslSocket::peerCertificate() const**

        Returns the peer's digital certificate (i.e., the immediate certificate
        of the host you are connected to), or a null certificate, if the peer
        has not assigned a certificate.

        The peer certificate is checked automatically during the handshake
        phase, so this function is normally used to fetch the certificate for
        display or for connection diagnostic purposes. It contains information
        about the peer, including its host name, the certificate issuer, and the
        peer's public key.

        Because the peer certificate is set during the handshake phase, it is
        safe to access the peer certificate from a slot connected to the
        sslErrors() signal or the **encrypted** () signal.

        If a null certificate is returned, it can mean the SSL handshake failed,
        or it can mean the host you are connected to doesn't have a certificate,
        or it can mean there is no connection.

        If you want to check the peer's complete chain of certificates, use
        **peerCertificateChain** () to get them all at once.

        **See also** **peerCertificateChain** ().
        """
        ...

    def localCertificate(self) -> QSslCertificate:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#localCertificate

        **QSslCertificate QSslSocket::localCertificate() const**

        Returns the socket's local **certificate** , or an empty certificate if
        no local certificate has been assigned.

        **See also** **setLocalCertificate** () and **privateKey** ().
        """
        ...

    @typing.overload
    def setLocalCertificate(self, certificate: QSslCertificate) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setLocalCertificate

        **void QSslSocket::setLocalCertificate(const QSslCertificate &
        certificate )**

        Sets the socket's local certificate to **certificate**. The local
        certificate is necessary if you need to confirm your identity to the
        peer. It is used together with the private key; if you set the local
        certificate, you must also set the private key.

        The local certificate and private key are always necessary for server
        sockets, but are also rarely used by client sockets if the server
        requires the client to authenticate.

        **Note:** Secure Transport SSL backend on macOS may update the default
        keychain (the default is probably your login keychain) by importing your
        local certificates and keys. This can also result in system dialogs
        showing up and asking for permission when your application is using
        these private keys. If such behavior is undesired, set the
        QT_SSL_USE_TEMPORARY_KEYCHAIN environment variable to a non-zero value;
        this will prompt **QSslSocket**  to use its own temporary keychain.

        **See also** **localCertificate** () and **setPrivateKey** ().
        """
        ...

    @typing.overload
    def setLocalCertificate(self, path: str, format: QSsl.EncodingFormat = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setLocalCertificate-1

        **void QSslSocket::setLocalCertificate(const QString & path ,
        QSsl::EncodingFormat format = QSsl::Pem)**

        This is an overloaded function.

        Sets the socket's local **certificate**  to the first one found in file
        **path** , which is parsed according to the specified **format**.
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#abort

        **void QSslSocket::abort()**

        Aborts the current connection and resets the socket. Unlike
        **disconnectFromHost** (), this function immediately closes the socket,
        clearing any pending data in the write buffer.

        **See also** **disconnectFromHost** () and **close** ().
        """
        ...

    def flush(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#flush

        **bool QSslSocket::flush()**

        This function writes as much as possible from the internal write buffer
        to the underlying network socket, without blocking. If any data was
        written, this function returns `true`; otherwise false is returned.

        Call this function if you need **QSslSocket**  to start sending buffered
        data immediately. The number of bytes successfully written depends on
        the operating system. In most cases, you do not need to call this
        function, because **QAbstractSocket**  will start sending data
        automatically once control goes back to the event loop. In the absence
        of an event loop, call **waitForBytesWritten** () instead.

        **See also** **write** () and **waitForBytesWritten** ().
        """
        ...

    def atEnd(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#atEnd

        **[override virtual] bool QSslSocket::atEnd() const**

        Reimplements: **QAbstractSocket::atEnd** () const.
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#close

        **[override virtual] void QSslSocket::close()**

        Reimplements: **QAbstractSocket::close** ().
        """
        ...

    def canReadLine(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#canReadLine

        **[override virtual] bool QSslSocket::canReadLine() const**

        Reimplements: **QAbstractSocket::canReadLine** () const.

        Returns `true` if you can read one while line (terminated by a single
        ASCII '\\n' character) of decrypted characters; otherwise, false is
        returned.
        """
        ...

    def bytesToWrite(self) -> int:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#bytesToWrite

        **[override virtual] qint64 QSslSocket::bytesToWrite() const**

        Reimplements: **QAbstractSocket::bytesToWrite** () const.

        Returns the number of unencrypted bytes that are waiting to be encrypted
        and written to the network.
        """
        ...

    def bytesAvailable(self) -> int:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#bytesAvailable

        **[override virtual] qint64 QSslSocket::bytesAvailable() const**

        Reimplements: **QAbstractSocket::bytesAvailable** () const.

        Returns the number of decrypted bytes that are immediately available for
        reading.
        """
        ...

    def setProtocol(self, protocol: QSsl.SslProtocol) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setProtocol

        **void QSslSocket::setProtocol(QSsl::SslProtocol protocol )**

        Sets the socket's SSL protocol to **protocol**. This will affect the
        next initiated handshake; calling this function on an already-encrypted
        socket will not affect the socket's protocol.

        **See also** **protocol** ().
        """
        ...

    def protocol(self) -> QSsl.SslProtocol:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#protocol

        **QSsl::SslProtocol QSslSocket::protocol() const**

        Returns the socket's SSL protocol. By default, **QSsl::SecureProtocols**
        is used.

        **See also** **setProtocol** ().
        """
        ...

    def isEncrypted(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#isEncrypted

        **bool QSslSocket::isEncrypted() const**

        Returns `true` if the socket is encrypted; otherwise, false is returned.

        An encrypted socket encrypts all data that is written by calling
        **write** () or **putChar** () before the data is written to the
        network, and decrypts all incoming data as the data is received from the
        network, before you call **read** (), **readLine** () or **getChar** ().

        **QSslSocket**  emits **encrypted** () when it enters encrypted mode.

        You can call **sessionCipher** () to find which cryptographic cipher is
        used to encrypt and decrypt your data.

        **See also** **mode** ().
        """
        ...

    def mode(self) -> "QSslSocket.SslMode":
        """
        https://doc.qt.io/qt-5/qsslsocket.html#mode

        **QSslSocket::SslMode QSslSocket::mode() const**

        Returns the current mode for the socket; either **UnencryptedMode** ,
        where **QSslSocket**  behaves identially to **QTcpSocket** , or one of
        **SslClientMode**  or **SslServerMode** , where the client is either
        negotiating or in encrypted mode.

        When the mode changes, **QSslSocket**  emits **modeChanged** ()

        **See also** **SslMode** .
        """
        ...

    def setSocketDescriptor(
        self,
        socketDescriptor: PyQt5.sip.voidptr,
        state: QAbstractSocket.SocketState = ...,
        mode: typing.Union[
            QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#setSocketDescriptor

        **[override virtual] bool QSslSocket::setSocketDescriptor(qintptr
        socketDescriptor , QAbstractSocket::SocketState state = ConnectedState,
        QIODevice::OpenMode openMode = ReadWrite)**

        Reimplements: **QAbstractSocket::setSocketDescriptor** (qintptr
        socketDescriptor, QAbstractSocket::SocketState socketState,
        QIODevice::OpenMode openMode).

        Initializes **QSslSocket**  with the native socket descriptor
        **socketDescriptor**. Returns `true` if **socketDescriptor** is accepted
        as a valid socket descriptor; otherwise returns `false`. The socket is
        opened in the mode specified by **openMode** , and enters the socket
        state specified by **state**.

        **Note:** It is not possible to initialize two sockets with the same
        native socket descriptor.

        **See also** **socketDescriptor** ().
        """
        ...

    @typing.overload
    def connectToHostEncrypted(
        self,
        hostName: str,
        port: int,
        mode: typing.Union[
            QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag
        ] = ...,
        protocol: QAbstractSocket.NetworkLayerProtocol = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#connectToHostEncrypted

        **void QSslSocket::connectToHostEncrypted(const QString & hostName ,
        quint16 port , QIODevice::OpenMode mode = ReadWrite,
        QAbstractSocket::NetworkLayerProtocol protocol = AnyIPProtocol)**

        Starts an encrypted connection to the device **hostName** on **port** ,
        using **mode** as the **OpenMode** . This is equivalent to calling
        **connectToHost** () to establish the connection, followed by a call to
        **startClientEncryption** (). The **protocol** parameter can be used to
        specify which network protocol to use (eg. IPv4 or IPv6).

        **QSslSocket**  first enters the **HostLookupState** . Then, after
        entering either the event loop or one of the waitFor...() functions, it
        enters the **ConnectingState** , emits **connected** (), and then
        initiates the SSL client handshake. At each state change, **QSslSocket**
        emits signal **stateChanged** ().

        After initiating the SSL client handshake, if the identity of the peer
        can't be established, signal sslErrors() is emitted. If you want to
        ignore the errors and continue connecting, you must call
        **ignoreSslErrors** (), either from inside a slot function connected to
        the sslErrors() signal, or prior to entering encrypted mode. If
        **ignoreSslErrors** () is not called, the connection is dropped, signal
        **disconnected** () is emitted, and **QSslSocket**  returns to the
        **UnconnectedState** .

        If the SSL handshake is successful, **QSslSocket**  emits **encrypted**
        ().

        **QSslSocket**  socket;
            connect(&socket, SIGNAL(encrypted()),
        receiver, SLOT(socketEncrypted()));
        socket.connectToHostEncrypted("imap", 993);
            socket->write("1
        CAPABILITY\\r\\n");

        **Note:** The example above shows that text can be written to the socket
        immediately after requesting the encrypted connection, before the
        **encrypted** () signal has been emitted. In such cases, the text is
        queued in the object and written to the socket **after** the connection
        is established and the **encrypted** () signal has been emitted.

        The default for **mode** is **ReadWrite** .

        If you want to create a **QSslSocket**  on the server side of a
        connection, you should instead call **startServerEncryption** () upon
        receiving the incoming connection through **QTcpServer** .

        **See also** **connectToHost** (), **startClientEncryption** (),
        **waitForConnected** (), and **waitForEncrypted** ().
        """
        ...

    @typing.overload
    def connectToHostEncrypted(
        self,
        hostName: str,
        port: int,
        sslPeerName: str,
        mode: typing.Union[
            QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag
        ] = ...,
        protocol: QAbstractSocket.NetworkLayerProtocol = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#connectToHostEncrypted-1

        **void QSslSocket::connectToHostEncrypted(const QString & hostName ,
        quint16 port , const QString & sslPeerName , QIODevice::OpenMode mode =
        ReadWrite, QAbstractSocket::NetworkLayerProtocol protocol =
        AnyIPProtocol)**

        This is an overloaded function.

        In addition to the original behaviour of connectToHostEncrypted, this
        overloaded method enables the usage of a different hostname (
        **sslPeerName** ) for the certificate validation instead of the one used
        for the TCP connection ( **hostName** ).

        This function was introduced in Qt 4.6.

        **See also** **connectToHostEncrypted** ().
        """
        ...

    @property
    def encrypted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#encrypted

        **[signal] void QSslSocket::encrypted()**

        This signal is emitted when **QSslSocket**  enters encrypted mode. After
        this signal has been emitted, **QSslSocket::isEncrypted** () will return
        true, and all further transmissions on the socket will be encrypted.

        **See also** **QSslSocket::connectToHostEncrypted** () and
        **QSslSocket::isEncrypted** ().
        """
        ...

    @property
    def encryptedBytesWritten(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#encryptedBytesWritten

        **[signal] void QSslSocket::encryptedBytesWritten(qint64 written )**

        This signal is emitted when **QSslSocket**  writes its encrypted data to
        the network. The **written** parameter contains the number of bytes that
        were successfully written.

        This function was introduced in Qt 4.4.

        **See also** **QIODevice::bytesWritten** ().
        """
        ...

    @property
    def modeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#modeChanged

        **[signal] void QSslSocket::modeChanged(QSslSocket::SslMode mode )**

        This signal is emitted when **QSslSocket**  changes from
        **QSslSocket::UnencryptedMode**  to either **QSslSocket::SslClientMode**
        or **QSslSocket::SslServerMode** . **mode** is the new mode.

        **See also** **QSslSocket::mode** ().
        """
        ...

    @property
    def newSessionTicketReceived(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#newSessionTicketReceived

        **[signal] void QSslSocket::newSessionTicketReceived()**

        If TLS 1.3 protocol was negotiated during a handshake, **QSslSocket**
        emits this signal after receiving NewSessionTicket message. Session and
        session ticket's lifetime hint are updated in the socket's
        configuration. The session can be used for session resumption (and a
        shortened handshake) in future TLS connections.

        **Note:** This functionality enabled only with OpenSSL backend and
        requires OpenSSL v 1.1.1 or above.

        This function was introduced in Qt 5.15.

        **See also** **QSslSocket::sslConfiguration** (),
        **QSslConfiguration::sessionTicket** (), and
        **QSslConfiguration::sessionTicketLifeTimeHint** ().
        """
        ...

    @property
    def peerVerifyError(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#peerVerifyError

        **[signal] void QSslSocket::peerVerifyError(const QSslError & error )**

        **QSslSocket**  can emit this signal several times during the SSL
        handshake, before encryption has been established, to indicate that an
        error has occurred while establishing the identity of the peer. The
        **error** is usually an indication that **QSslSocket**  is unable to
        securely identify the peer.

        This signal provides you with an early indication when something's
        wrong. By connecting to this signal, you can manually choose to tear
        down the connection from inside the connected slot before the handshake
        has completed. If no action is taken, **QSslSocket**  will proceed to
        emitting QSslSocket::sslErrors().

        This function was introduced in Qt 4.4.

        **See also** **sslErrors** ().
        """
        ...

    @property
    def preSharedKeyAuthenticationRequired(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#preSharedKeyAuthenticationRequire
        d

        **[signal] void QSslSocket::preSharedKeyAuthenticationRequired(QSslPreSh
        aredKeyAuthenticator * authenticator )**

        **QSslSocket**  emits this signal when it negotiates a PSK ciphersuite,
        and therefore a PSK authentication is then required.

        When using PSK, the client must send to the server a valid identity and
        a valid pre shared key, in order for the SSL handshake to continue.
        Applications can provide this information in a slot connected to this
        signal, by filling in the passed **authenticator** object according to
        their needs.

        **Note:** Ignoring this signal, or failing to provide the required
        credentials, will cause the handshake to fail, and therefore the
        connection to be aborted.

        **Note:** The **authenticator** object is owned by the socket and must
        not be deleted by the application.

        This function was introduced in Qt 5.5.

        **See also** **QSslPreSharedKeyAuthenticator** .
        """
        ...

    @property
    def sslErrors(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qsslsocket.html#sslErrors-1

        **[signal] void QSslSocket::sslErrors(const QList<QSslError> & errors
        )**

        **QSslSocket**  emits this signal after the SSL handshake to indicate
        that one or more errors have occurred while establishing the identity of
        the peer. The errors are usually an indication that **QSslSocket**  is
        unable to securely identify the peer. Unless any action is taken, the
        connection will be dropped after this signal has been emitted.

        If you want to continue connecting despite the errors that have
        occurred, you must call **QSslSocket::ignoreSslErrors** () from inside a
        slot connected to this signal. If you need to access the error list at a
        later point, you can call **sslHandshakeErrors** ().

        **errors** contains one or more errors that prevent **QSslSocket**  from
        verifying the identity of the peer.

        **Note:** You cannot use **Qt::QueuedConnection**  when connecting to
        this signal, or calling **QSslSocket::ignoreSslErrors** () will have no
        effect.

        **Note:** Signal **sslErrors** is overloaded in this class. To connect
        to this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(sslSocket, QOverload<const **QList** <**QSslError** >
        &>::of(&**QSslSocket** ::sslErrors),
                [=](const **QList**
        <**QSslError** > &errors){ /* ... */ });

        **See also** **peerVerifyError** ().
        """
        ...
