"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QSslDiffieHellmanParameters(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html

    **Detailed Description**

    QSslDiffieHellmanParameters provides an interface for setting Diffie-Hellman
    parameters to servers based on **QSslSocket** .

    **See also** **QSslSocket** , **QSslCipher** , and **QSslConfiguration** .
    """

    class Error(int):
        NoError: QSslDiffieHellmanParameters = ...
        InvalidInputDataError: QSslDiffieHellmanParameters = ...
        UnsafeParametersError: QSslDiffieHellmanParameters = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html#QSslDiffieHellma
        nParameters

        **QSslDiffieHellmanParameters::QSslDiffieHellmanParameters()**

        Constructs an empty QSslDiffieHellmanParameters instance.

        If an empty QSslDiffieHellmanParameters instance is set on a
        **QSslConfiguration**  object, Diffie-Hellman negotiation will be
        disabled.

        **See also** **isValid** () and **QSslConfiguration** .
        """
        ...

    @typing.overload
    def __init__(self, other: "QSslDiffieHellmanParameters") -> None:
        """
        https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html#QSslDiffieHellma
        nParameters-1

        **QSslDiffieHellmanParameters::QSslDiffieHellmanParameters(const
        QSslDiffieHellmanParameters & other )**

        Constructs an identical copy of **other**.
        """
        ...

    def __hash__(self) -> int:
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html#errorString

        **QString QSslDiffieHellmanParameters::errorString() const**

        Returns a human-readable description of the error that caused the
        **QSslDiffieHellmanParameters**  object to be invalid.
        """
        ...

    def error(self) -> "QSslDiffieHellmanParameters.Error":
        """
        https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html#error

        **QSslDiffieHellmanParameters::Error
        QSslDiffieHellmanParameters::error() const**

        Returns the error that caused the **QSslDiffieHellmanParameters**
        object to be invalid.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html#isValid

        **bool QSslDiffieHellmanParameters::isValid() const**

        Returns `true` if this is a valid **QSslDiffieHellmanParameters** ;
        otherwise false.

        This method should be used after constructing a
        **QSslDiffieHellmanParameters**  object to determine its validity.

        If a **QSslDiffieHellmanParameters**  object is not valid, you can use
        the **error** () method to determine what error prevented the object
        from being constructed.

        **See also** **error** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html#isEmpty

        **bool QSslDiffieHellmanParameters::isEmpty() const**

        Returns `true` if this is a an empty **QSslDiffieHellmanParameters**
        instance.

        Setting an empty **QSslDiffieHellmanParameters**  instance on a
        **QSslSocket** -based server will disable Diffie-Hellman key exchange.
        """
        ...

    @typing.overload
    @staticmethod
    def fromEncoded(
        encoded: typing.Union[QtCore.QByteArray, bytes, bytearray],
        encoding: QSsl.EncodingFormat = ...,
    ) -> "QSslDiffieHellmanParameters":
        """
        https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html#fromEncoded

        **[static] QSslDiffieHellmanParameters
        QSslDiffieHellmanParameters::fromEncoded(const QByteArray & encoded ,
        QSsl::EncodingFormat encoding = QSsl::Pem)**

        Constructs a **QSslDiffieHellmanParameters**  object using the byte
        array **encoded** in either PEM or DER form as specified by
        **encoding**.

        Use the **isValid** () method on the returned object to check whether
        the Diffie-Hellman parameters were valid and loaded correctly.

        **See also** **isValid** () and **QSslConfiguration** .
        """
        ...

    @typing.overload
    @staticmethod
    def fromEncoded(
        device: QtCore.QIODevice, encoding: QSsl.EncodingFormat = ...
    ) -> "QSslDiffieHellmanParameters":
        """
        https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html#fromEncoded-1

        **[static] QSslDiffieHellmanParameters
        QSslDiffieHellmanParameters::fromEncoded(QIODevice * device ,
        QSsl::EncodingFormat encoding = QSsl::Pem)**

        Constructs a **QSslDiffieHellmanParameters**  object by reading from
        **device** in either PEM or DER form as specified by **encoding**.

        Use the **isValid** () method on the returned object to check whether
        the Diffie-Hellman parameters were valid and loaded correctly.

        In particular, if **device** is `nullptr` or not open for reading, an
        invalid object will be returned.

        **See also** **isValid** () and **QSslConfiguration** .
        """
        ...

    @staticmethod
    def defaultParameters() -> "QSslDiffieHellmanParameters":
        """
        https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html#defaultParameter
        s

        **[static] QSslDiffieHellmanParameters
        QSslDiffieHellmanParameters::defaultParameters()**

        Returns the default **QSslDiffieHellmanParameters**  used by
        **QSslSocket** .

        This is currently the 1024-bit MODP group from RFC 2459, also known as
        the Second Oakley Group.
        """
        ...

    def swap(self, other: "QSslDiffieHellmanParameters") -> None:
        """
        https://doc.qt.io/qt-5/qssldiffiehellmanparameters.html#swap

        **void QSslDiffieHellmanParameters::swap(QSslDiffieHellmanParameters &
        other )**

        Swaps this **QSslDiffieHellmanParameters**  with **other**. This
        function is very fast and never fails.
        """
        ...
