"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtNetwork import *


class QNetworkCookieJar(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qnetworkcookiejar.html

    **Detailed Description**

    Cookies are small bits of information that stateless protocols like HTTP use
    to maintain some persistent information across requests.

    A cookie is set by a remote server when it replies to a request and it
    expects the same cookie to be sent back when further requests are sent.

    The cookie jar is the object that holds all cookies set in previous
    requests. Web browsers save their cookie jars to disk in order to conserve
    permanent cookies across invocations of the application.

    QNetworkCookieJar does not implement permanent storage: it only keeps the
    cookies in memory. Once the QNetworkCookieJar object is deleted, all cookies
    it held will be discarded as well. If you want to save the cookies, you
    should derive from this class and implement the saving to disk to your own
    storage format.

    This class implements only the basic security recommended by the cookie
    specifications and does not implement any cookie acceptance policy (it
    accepts all cookies set by any requests). In order to override those rules,
    you should reimplement the **cookiesForUrl** () and **setCookiesFromUrl** ()
    virtual functions. They are called by **QNetworkReply**  and
    **QNetworkAccessManager**  when they detect new cookies and when they
    require cookies.

    **See also** **QNetworkCookie** , **QNetworkAccessManager** ,
    **QNetworkReply** , **QNetworkRequest** , and
    **QNetworkAccessManager::setCookieJar** ().
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcookiejar.html#QNetworkCookieJar

        **QNetworkCookieJar::QNetworkCookieJar(QObject * parent = nullptr)**

        Creates a QNetworkCookieJar object and sets the parent object to be
        **parent**.

        The cookie jar is initialized to empty.
        """
        ...

    def validateCookie(self, cookie: QNetworkCookie, url: QtCore.QUrl) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkcookiejar.html#validateCookie

        **[virtual protected] bool QNetworkCookieJar::validateCookie(const
        QNetworkCookie & cookie , const QUrl & url ) const**

        Returns `true` if the domain and path of **cookie** are valid, false
        otherwise. The **url** parameter is used to determine if the domain
        specified in the cookie is allowed.

        This function was introduced in Qt 5.0.
        """
        ...

    def allCookies(self) -> typing.List[QNetworkCookie]:
        """
        https://doc.qt.io/qt-5/qnetworkcookiejar.html#allCookies

        **[protected] QList<QNetworkCookie> QNetworkCookieJar::allCookies()
        const**

        Returns all cookies stored in this cookie jar. This function is suitable
        for derived classes to save cookies to disk, as well as to implement
        cookie expiration and other policies.

        **See also** **setAllCookies** () and **cookiesForUrl** ().
        """
        ...

    def setAllCookies(self, cookieList: typing.Iterable[QNetworkCookie]) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcookiejar.html#setAllCookies

        **[protected] void QNetworkCookieJar::setAllCookies(const
        QList<QNetworkCookie> & cookieList )**

        Sets the internal list of cookies held by this cookie jar to be
        **cookieList**. This function is suitable for derived classes to
        implement loading cookies from permanent storage, or their own cookie
        acceptance policies by reimplementing **setCookiesFromUrl** ().

        **See also** **allCookies** () and **setCookiesFromUrl** ().
        """
        ...

    def deleteCookie(self, cookie: QNetworkCookie) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkcookiejar.html#deleteCookie

        **[virtual] bool QNetworkCookieJar::deleteCookie(const QNetworkCookie &
        cookie )**

        Deletes from cookie jar the cookie found to have the same identifier as
        **cookie**.

        Returns `true` if a cookie was deleted, false otherwise.

        This function was introduced in Qt 5.0.

        **See also** **QNetworkCookie::hasSameIdentifier** ().
        """
        ...

    def updateCookie(self, cookie: QNetworkCookie) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkcookiejar.html#updateCookie

        **[virtual] bool QNetworkCookieJar::updateCookie(const QNetworkCookie &
        cookie )**

        If a cookie with the same identifier as **cookie** exists in this cookie
        jar it will be updated. This function uses **insertCookie** ().

        Returns `true` if **cookie** was updated, false if no cookie in the jar
        matches the identifier of **cookie**.

        This function was introduced in Qt 5.0.

        **See also** **QNetworkCookie::hasSameIdentifier** ().
        """
        ...

    def insertCookie(self, cookie: QNetworkCookie) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkcookiejar.html#insertCookie

        **[virtual] bool QNetworkCookieJar::insertCookie(const QNetworkCookie &
        cookie )**

        Adds **cookie** to this cookie jar.

        Returns `true` if **cookie** was added, false otherwise.

        If a cookie with the same identifier already exists in the cookie jar,
        it will be overridden.

        This function was introduced in Qt 5.0.
        """
        ...

    def setCookiesFromUrl(
        self, cookieList: typing.Iterable[QNetworkCookie], url: QtCore.QUrl
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkcookiejar.html#setCookiesFromUrl

        **[virtual] bool QNetworkCookieJar::setCookiesFromUrl(const
        QList<QNetworkCookie> & cookieList , const QUrl & url )**

        Adds the cookies in the list **cookieList** to this cookie jar. Before
        being inserted cookies are normalized.

        Returns `true` if one or more cookies are set for **url** , otherwise
        false.

        If a cookie already exists in the cookie jar, it will be overridden by
        those in **cookieList**.

        The default **QNetworkCookieJar**  class implements only a very basic
        security policy (it makes sure that the cookies' domain and path match
        the reply's). To enhance the security policy with your own algorithms,
        override setCookiesFromUrl().

        Also, **QNetworkCookieJar**  does not have a maximum cookie jar size.
        Reimplement this function to discard older cookies to create room for
        new ones.

        **See also** **cookiesForUrl** (),
        **QNetworkAccessManager::setCookieJar** (), and
        **QNetworkCookie::normalize** ().
        """
        ...

    def cookiesForUrl(self, url: QtCore.QUrl) -> typing.List[QNetworkCookie]:
        """
        https://doc.qt.io/qt-5/qnetworkcookiejar.html#cookiesForUrl

        **[virtual] QList<QNetworkCookie> QNetworkCookieJar::cookiesForUrl(const
        QUrl & url ) const**

        Returns the cookies to be added to when a request is sent to **url**.
        This function is called by the default
        **QNetworkAccessManager::createRequest** (), which adds the cookies
        returned by this function to the request being sent.

        If more than one cookie with the same name is found, but with differing
        paths, the one with longer path is returned before the one with shorter
        path. In other words, this function returns cookies sorted decreasingly
        by path length.

        The default **QNetworkCookieJar**  class implements only a very basic
        security policy (it makes sure that the cookies' domain and path match
        the reply's). To enhance the security policy with your own algorithms,
        override cookiesForUrl().

        **See also** **setCookiesFromUrl** () and
        **QNetworkAccessManager::setCookieJar** ().
        """
        ...
