"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QNetworkConfigurationManager(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html

    **Detailed Description**

    QNetworkConfigurationManager provides access to the network configurations
    known to the system and enables applications to detect the system
    capabilities (with regards to network sessions) at runtime.

    A **QNetworkConfiguration**  abstracts a set of configuration options
    describing how a network interface has to be configured to connect to a
    particular target network. QNetworkConfigurationManager maintains and
    updates the global list of QNetworkConfigurations. Applications can access
    and filter this list via **allConfigurations** (). If a new configuration is
    added or an existing one is removed or changed the **configurationAdded**
    (), **configurationRemoved** () and **configurationChanged** () signals are
    emitted respectively.

    The **defaultConfiguration** () can be used when intending to immediately
    create a new network session without caring about the particular
    configuration. It returns a **QNetworkConfiguration::Discovered**
    configuration. If there are not any discovered ones an invalid configuration
    is returned.

    Some configuration updates may require some time to perform updates. A WLAN
    scan is such an example. Unless the platform performs internal updates it
    may be required to manually trigger configuration updates via
    **QNetworkConfigurationManager::updateConfigurations** (). The completion of
    the update process is indicated by emitting the **updateCompleted** ()
    signal. The update process ensures that every existing
    **QNetworkConfiguration**  instance is updated. There is no need to ask for
    a renewed configuration list via **allConfigurations** ().

    **See also** **QNetworkConfiguration** .
    """

    class Capability(int):
        CanStartAndStopInterfaces: QNetworkConfigurationManager = ...
        DirectConnectionRouting: QNetworkConfigurationManager = ...
        SystemSessionSupport: QNetworkConfigurationManager = ...
        ApplicationLevelRoaming: QNetworkConfigurationManager = ...
        ForcedRoaming: QNetworkConfigurationManager = ...
        DataStatistics: QNetworkConfigurationManager = ...
        NetworkSessionRequired: QNetworkConfigurationManager = ...

    class Capabilities(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QNetworkConfigurationManager.Capabilities",
                "QNetworkConfigurationManager.Capability",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QNetworkConfigurationManager.Capabilities") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QNetworkConfigurationManager.Capabilities":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#QNetworkConfigu
        rationManager

        **QNetworkConfigurationManager::QNetworkConfigurationManager(QObject *
        parent = nullptr)**

        Constructs a QNetworkConfigurationManager with the given **parent**.

        Note that to ensure a valid list of current configurations immediately
        available, updating is done during construction which causes some delay.
        """
        ...

    def isOnline(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#isOnline

        **bool QNetworkConfigurationManager::isOnline() const**

        Returns `true` if the system is considered to be connected to another
        device via an active network interface; otherwise returns `false`.

        This is equivalent to the following code snippet:

        **QNetworkConfigurationManager**  mgr;
            **QList**
        <**QNetworkConfiguration** > activeConfigs =
        mgr.allConfigurations(**QNetworkConfiguration** ::Active);
            if
        (activeConfigs.count() > 0)
                Q_ASSERT(mgr.isOnline());
            else
        Q_ASSERT(!mgr.isOnline());

        **See also** **onlineStateChanged** ().
        """
        ...

    def updateConfigurations(self) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#updateConfigura
        tions

        **[slot] void QNetworkConfigurationManager::updateConfigurations()**

        Initiates an update of all configurations. This may be used to initiate
        WLAN scans or other time consuming updates which may be required to
        obtain the correct state for configurations.

        This call is asynchronous. On completion of this update the
        **updateCompleted** () signal is emitted. If new configurations are
        discovered or old ones were removed or changed the update process may
        trigger the emission of one or multiple **configurationAdded** (),
        **configurationRemoved** () and **configurationChanged** () signals.

        If a configuration state changes as a result of this update all existing
        QNetworkConfiguration instances are updated automatically.

        **See also** **allConfigurations** ().
        """
        ...

    def configurationFromIdentifier(self, identifier: str) -> "QNetworkConfiguration":
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#configurationFr
        omIdentifier

        **QNetworkConfiguration
        QNetworkConfigurationManager::configurationFromIdentifier(const QString
        & identifier ) const**

        Returns the QNetworkConfiguration for **identifier** ; otherwise returns
        an invalid QNetworkConfiguration.

        **See also** **QNetworkConfiguration::identifier** ().
        """
        ...

    def allConfigurations(
        self,
        flags: typing.Union[
            "QNetworkConfiguration.StateFlags", "QNetworkConfiguration.StateFlag"
        ] = ...,
    ) -> typing.List["QNetworkConfiguration"]:
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#allConfiguratio
        ns

        **QList<QNetworkConfiguration> QNetworkConfigurationManager::allConfigur
        ations(QNetworkConfiguration::StateFlags filter =
        QNetworkConfiguration::StateFlags()) const**

        Returns the list of configurations which comply with the given
        **filter**.

        By default this function returns all (defined and undefined)
        configurations.

        A wireless network with a particular SSID may only be accessible in a
        certain area despite the fact that the system has a valid configuration
        for it. Therefore the filter flag may be used to limit the list to
        discovered and possibly connected configurations only.

        If **filter** is set to zero this function returns all possible
        configurations.

        Note that this function returns the states for all configurations as
        they are known at the time of this function call. If for instance a
        configuration of type WLAN is defined the system may have to perform a
        WLAN scan in order to determine whether it is actually available. To
        obtain the most accurate state **updateConfigurations** () should be
        used to update each configuration's state. Note that such an update may
        require some time. It's completion is signalled by **updateCompleted**
        (). In the absence of a configuration update this function returns the
        best estimate at the time of the call. Therefore, if WLAN configurations
        are of interest, it is recommended that **updateConfigurations** () is
        called once after **QNetworkConfigurationManager**  instantiation (WLAN
        scans are too time consuming to perform in constructor). After this the
        data is kept automatically up-to-date as the system reports any changes.
        """
        ...

    def defaultConfiguration(self) -> "QNetworkConfiguration":
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#defaultConfigur
        ation

        **QNetworkConfiguration
        QNetworkConfigurationManager::defaultConfiguration() const**

        Returns the default configuration to be used. This function always
        returns a discovered configuration; otherwise an invalid configuration.

        In some cases it may be required to call **updateConfigurations** () and
        wait for the **updateCompleted** () signal before calling this function.

        **See also** **allConfigurations** ().
        """
        ...

    def capabilities(self) -> "QNetworkConfigurationManager.Capabilities":
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#capabilities

        **QNetworkConfigurationManager::Capabilities
        QNetworkConfigurationManager::capabilities() const**

        Returns the capabilities supported by the current platform.
        """
        ...

    @property
    def configurationAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#configurationAd
        ded

        **[signal] void QNetworkConfigurationManager::configurationAdded(const
        QNetworkConfiguration & config )**

        This signal is emitted whenever a new network configuration is added to
        the system. The new configuration is specified by **config**.
        """
        ...

    @property
    def configurationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#configurationCh
        anged

        **[signal] void QNetworkConfigurationManager::configurationChanged(const
        QNetworkConfiguration & config )**

        This signal is emitted when the **state**  of **config** changes.
        """
        ...

    @property
    def configurationRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#configurationRe
        moved

        **[signal] void QNetworkConfigurationManager::configurationRemoved(const
        QNetworkConfiguration & config )**

        This signal is emitted when a configuration is about to be removed from
        the system. The removed configuration, specified by **config** , is
        invalid but retains name and identifier.
        """
        ...

    @property
    def onlineStateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#onlineStateChan
        ged

        **[signal] void QNetworkConfigurationManager::onlineStateChanged(bool
        isOnline )**

        This signal is emitted when the device changes from online to offline
        mode or vice versa. **isOnline** represents the new state of the device.

        The state is considered to be online for as long as
        **allConfigurations** (**QNetworkConfiguration::Active** ) returns a
        list with at least one entry.
        """
        ...

    @property
    def updateCompleted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkconfigurationmanager.html#updateCompleted

        **[signal] void QNetworkConfigurationManager::updateCompleted()**

        This signal is emitted when the configuration update has been completed.
        Such an update can be initiated via **updateConfigurations** ().
        """
        ...
