"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QNetworkConfiguration(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qnetworkconfiguration.html

    **Detailed Description**

    QNetworkConfiguration encapsulates a single access point or service network.
    In most cases a single access point configuration can be mapped to one
    network interface. However a single network interface may not always map to
    only one access point configuration. Multiple configurations for the same
    network device may enable multiple access points. An example device that
    could exhibit such a configuration might be a Smartphone which allows the
    user to manage multiple WLAN configurations while the device itself has only
    one WLAN network device.

    The QNetworkConfiguration also supports the concept of service networks.
    This concept allows the grouping of multiple access point configurations
    into one entity. Such a group is called service network and can be
    beneficial in cases whereby a network session to a particular destination
    network is required (e.g. a company network). When using a service network
    the user doesn't usually care which one of the connectivity options is
    chosen (e.g. corporate WLAN or VPN via GPRS) as long as he can reach the
    company's target server. Depending on the current position and time some of
    the access points that make up the service network may not even be
    available. Furthermore automated access point roaming can be enabled which
    enables the device to change the network interface configuration dynamically
    while maintaining the applications connection to the target network. It
    allows adaption to the changing environment and may enable optimization with
    regards to cost, speed or other network parameters.

    Special configurations of type **UserChoice**  provide a placeholder
    configuration which is resolved to an actual network configuration by the
    platform when a **session**  is **opened** . Not all platforms support the
    concept of a user choice configuration.

    **Configuration States**

    The list of available configurations can be obtained via
    **QNetworkConfigurationManager::allConfigurations** (). A configuration can
    have multiple states. The **Defined**  configuration state indicates that
    the configuration is stored on the device. However the configuration is not
    yet ready to be activated as e.g. a WLAN may not be available at the current
    time.

    The **Discovered**  state implies that the configuration is **Defined**  and
    the outside conditions are such that the configuration can be used
    immediately to open a new network session. An example of such an outside
    condition may be that the Ethernet cable is actually connected to the device
    or that the WLAN with the specified SSID is in range.

    The **Active**  state implies that the configuration is **Discovered** . A
    configuration in this state is currently being used by an application. The
    underlying network interface has a valid IP configuration and can transfer
    IP packets between the device and the target network.

    The **Undefined**  state indicates that the system has knowledge of possible
    target networks but cannot actually use that knowledge to connect to it. An
    example for such a state could be an encrypted WLAN that has been discovered
    but the user hasn't actually saved a configuration including the required
    password which would allow the device to connect to it.

    Depending on the type of configuration some states are transient in nature.
    A GPRS/UMTS connection may almost always be **Discovered**  if the GSM/UMTS
    network is available. However if the GSM/UMTS network loses the connection
    the associated configuration may change its state from **Discovered**  to
    **Defined**  as well. A similar use case might be triggered by WLAN
    availability. **QNetworkConfigurationManager::updateConfigurations** () can
    be used to manually trigger updates of states. Note that some platforms do
    not require such updates as they implicitly change the state once it has
    been discovered. If the state of a configuration changes all related
    QNetworkConfiguration instances change their state automatically.

    **See also** **QNetworkSession**  and **QNetworkConfigurationManager** .
    """

    class BearerType(int):
        BearerUnknown: QNetworkConfiguration = ...
        BearerEthernet: QNetworkConfiguration = ...
        BearerWLAN: QNetworkConfiguration = ...
        Bearer2G: QNetworkConfiguration = ...
        BearerCDMA2000: QNetworkConfiguration = ...
        BearerWCDMA: QNetworkConfiguration = ...
        BearerHSPA: QNetworkConfiguration = ...
        BearerBluetooth: QNetworkConfiguration = ...
        BearerWiMAX: QNetworkConfiguration = ...
        BearerEVDO: QNetworkConfiguration = ...
        BearerLTE: QNetworkConfiguration = ...
        Bearer3G: QNetworkConfiguration = ...
        Bearer4G: QNetworkConfiguration = ...

    class StateFlag(int):
        Undefined: QNetworkConfiguration = ...
        Defined: QNetworkConfiguration = ...
        Discovered: QNetworkConfiguration = ...
        Active: QNetworkConfiguration = ...

    class Purpose(int):
        UnknownPurpose: QNetworkConfiguration = ...
        PublicPurpose: QNetworkConfiguration = ...
        PrivatePurpose: QNetworkConfiguration = ...
        ServiceSpecificPurpose: QNetworkConfiguration = ...

    class Type(int):
        InternetAccessPoint: QNetworkConfiguration = ...
        ServiceNetwork: QNetworkConfiguration = ...
        UserChoice: QNetworkConfiguration = ...
        Invalid: QNetworkConfiguration = ...

    class StateFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QNetworkConfiguration.StateFlags", "QNetworkConfiguration.StateFlag"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QNetworkConfiguration.StateFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QNetworkConfiguration.StateFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#QNetworkConfiguration

        **QNetworkConfiguration::QNetworkConfiguration()**

        Constructs an invalid configuration object.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QNetworkConfiguration") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#QNetworkConfiguration-
        1

        **QNetworkConfiguration::QNetworkConfiguration(const
        QNetworkConfiguration & other )**

        Creates a copy of the QNetworkConfiguration object contained in
        **other**.
        """
        ...

    def setConnectTimeout(self, timeout: int) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#setConnectTimeout

        **bool QNetworkConfiguration::setConnectTimeout(int timeout )**

        Sets the connect timeout of this configuration to **timeout**. This
        allows control of the timeout used by `QAbstractSocket` to establish a
        connection.

        **Note:** **timeout** is in millisecond.

        **Warning:** This will have no effect if the bearer plugin doesn't have
        the CanStartAndStopInterfaces capability.

        Returns true if succeeded.

        This function was introduced in Qt 5.9.

        **See also** **connectTimeout** .
        """
        ...

    def connectTimeout(self) -> int:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#connectTimeout

        **int QNetworkConfiguration::connectTimeout() const**

        Returns the connect timeout of this configuration.

        This function was introduced in Qt 5.9.

        **See also** **setConnectTimeout** .
        """
        ...

    def swap(self, other: "QNetworkConfiguration") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#swap

        **void QNetworkConfiguration::swap(QNetworkConfiguration & other )**

        Swaps this network configuration with **other**. This function is very
        fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#isValid

        **bool QNetworkConfiguration::isValid() const**

        Returns `true` if this **QNetworkConfiguration**  object is valid. A
        configuration may become invalid if the user deletes the configuration
        or the configuration was default-constructed.

        The addition and removal of configurations can be monitored via the
        QNetworkConfigurationManager.

        **See also** **QNetworkConfigurationManager** .
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#name

        **QString QNetworkConfiguration::name() const**

        Returns the user visible name of this configuration.

        The name may either be the name of the underlying access point or the
        name for service network that this configuration represents.
        """
        ...

    def children(self) -> typing.List["QNetworkConfiguration"]:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#children

        **QList<QNetworkConfiguration> QNetworkConfiguration::children() const**

        Returns all sub configurations of this network configuration in priority
        order. The first sub configuration in the list has the highest priority.

        Only network configurations of type **ServiceNetwork**  can have
        children. Otherwise this function returns an empty list.
        """
        ...

    def isRoamingAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#isRoamingAvailable

        **bool QNetworkConfiguration::isRoamingAvailable() const**

        Returns `true` if this configuration supports roaming; otherwise false.
        """
        ...

    def identifier(self) -> str:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#identifier

        **QString QNetworkConfiguration::identifier() const**

        Returns the unique and platform specific identifier for this network
        configuration; otherwise an empty string.
        """
        ...

    def bearerTypeFamily(self) -> "QNetworkConfiguration.BearerType":
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#bearerTypeFamily

        **QNetworkConfiguration::BearerType
        QNetworkConfiguration::bearerTypeFamily() const**

        Returns the bearer type family used by this network configuration. The
        following table lists how **bearerType** () values map to
        bearerTypeFamily() values:

        bearer typebearer type family
        **BearerUnknown** , **Bearer2G** ,
        **BearerEthernet** , **BearerWLAN** , **BearerBluetooth** (same type)
        **BearerCDMA2000** , **BearerEVDO** , **BearerWCDMA** , **BearerHSPA** ,
        **Bearer3G** **Bearer3G**
        **BearerWiMAX** , **BearerLTE** ,
        **Bearer4G** **Bearer4G**

        An invalid network configuration always returns the **BearerUnknown**
        value.

        This function was introduced in Qt 5.2.

        **See also** **bearerType** () and **bearerTypeName** ().
        """
        ...

    def bearerTypeName(self) -> str:
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#bearerTypeName

        **QString QNetworkConfiguration::bearerTypeName() const**

        Returns the type of bearer used by this network configuration as a
        string.

        The string is not translated and therefore cannot be shown to the user.
        The subsequent table shows the fixed mappings between **BearerType**
        and the bearer type name for known types. If the **BearerType**  is
        unknown this function may return additional information if it is
        available; otherwise an empty string will be returned.

        **BearerType** Value
        **BearerUnknown** The session is based on an
        unknown or unspecified bearer type. The value of the string returned
        describes the bearer type.
        **BearerEthernet** Ethernet
        **BearerWLAN** WLAN
        **Bearer2G** 2G
        **Bearer3G** 3G
        **Bearer4G**
        4G
        **BearerCDMA2000** CDMA2000
        **BearerWCDMA** WCDMA
        **BearerHSPA** HSPA
        **BearerBluetooth** Bluetooth
        **BearerWiMAX**
        WiMAX
        **BearerEVDO** EVDO
        **BearerLTE** LTE

        This function returns an empty string if this is an invalid
        configuration, a network configuration of type
        **QNetworkConfiguration::ServiceNetwork**  or
        **QNetworkConfiguration::UserChoice** .

        **See also** **bearerType** () and **bearerTypeFamily** ().
        """
        ...

    def bearerType(self) -> "QNetworkConfiguration.BearerType":
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#bearerType

        **QNetworkConfiguration::BearerType QNetworkConfiguration::bearerType()
        const**

        Returns the type of bearer used by this network configuration.

        If the bearer type is **unknown**  the **bearerTypeName** () function
        can be used to retrieve a textural type name for the bearer.

        An invalid network configuration always returns the **BearerUnknown**
        value.

        **See also** **bearerTypeName** () and **bearerTypeFamily** ().
        """
        ...

    def purpose(self) -> "QNetworkConfiguration.Purpose":
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#purpose

        **QNetworkConfiguration::Purpose QNetworkConfiguration::purpose()
        const**

        Returns the purpose of this configuration.

        The purpose field may be used to programmatically determine the purpose
        of a configuration. Such information is usually part of the access point
        or service network meta data.
        """
        ...

    def type(self) -> "QNetworkConfiguration.Type":
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#type

        **QNetworkConfiguration::Type QNetworkConfiguration::type() const**

        Returns the type of the configuration.

        A configuration can represent a single access point configuration or a
        set of access point configurations. Such a set is called service
        network. A configuration that is based on a service network can
        potentially support roaming of network sessions.
        """
        ...

    def state(self) -> "QNetworkConfiguration.StateFlags":
        """
        https://doc.qt.io/qt-5/qnetworkconfiguration.html#state

        **QNetworkConfiguration::StateFlags QNetworkConfiguration::state()
        const**

        Returns the current state of the configuration.
        """
        ...
