"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QHttpPart(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qhttppart.html

    **Detailed Description**

    The QHttpPart class holds a body part to be used inside a HTTP multipart
    MIME message (which is represented by the **QHttpMultiPart**  class). A
    QHttpPart consists of a header block and a data block, which are separated
    by each other by two consecutive new lines. An example for one part would
    be:

    Content-Type: text/plain
        Content-Disposition: form-data; name="text"
    here goes the body

    For setting headers, use **setHeader** () and **setRawHeader** (), which
    behave exactly like **QNetworkRequest::setHeader** () and
    **QNetworkRequest::setRawHeader** ().

    For reading small pieces of data, use **setBody** (); for larger data blocks
    like e.g. images, use **setBodyDevice** (). The latter method saves memory
    by not copying the data internally, but reading directly from the device.
    This means that the device must be opened and readable at the moment when
    the multipart message containing the body part is sent on the network via
    **QNetworkAccessManager::post** ().

    To construct a QHttpPart with a small body, consider the following snippet
    (this produces the data shown in the example above):

    **QHttpPart**  textPart;
        textPart.setHeader(**QNetworkRequest**
    ::ContentTypeHeader, **QVariant** ("text/plain"));
    textPart.setHeader(**QNetworkRequest** ::ContentDispositionHeader,
    **QVariant** ("form-data; name=\\"text\\""));
        textPart.setBody("here goes
    the body");

    To construct a QHttpPart reading from a device (e.g. a file), the following
    can be applied:

    **QHttpPart**  imagePart;
        imagePart.setHeader(**QNetworkRequest**
    ::ContentTypeHeader, **QVariant** ("image/jpeg"));
    imagePart.setHeader(**QNetworkRequest** ::ContentDispositionHeader,
    **QVariant** ("form-data; name=\\"image\\""));
    imagePart.setRawHeader("Content-ID", "my@content.id"); // add any headers
    you like via setRawHeader()
        **QFile**  *file = new **QFile**
    ("image.jpg");
        file->open(**QIODevice** ::ReadOnly);
    imagePart.setBodyDevice(file);

    Be aware that QHttpPart does not take ownership of the device when set, so
    it is the developer's responsibility to destroy it when it is not needed
    anymore. A good idea might be to set the multipart message as parent object
    for the device, as documented at the documentation for **QHttpMultiPart** .

    **See also** **QHttpMultiPart**  and **QNetworkAccessManager** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qhttppart.html#QHttpPart

        **QHttpPart::QHttpPart()**

        Constructs an empty QHttpPart object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QHttpPart") -> None:
        """
        https://doc.qt.io/qt-5/qhttppart.html#QHttpPart-1

        **QHttpPart::QHttpPart(const QHttpPart & other )**

        Creates a copy of **other**.
        """
        ...

    def swap(self, other: "QHttpPart") -> None:
        """
        https://doc.qt.io/qt-5/qhttppart.html#swap

        **void QHttpPart::swap(QHttpPart & other )**

        Swaps this HTTP part with **other**. This function is very fast and
        never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def setBodyDevice(self, device: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qhttppart.html#setBodyDevice

        **void QHttpPart::setBodyDevice(QIODevice * device )**

        Sets the device to read the content from to **device**. For large
        amounts of data this method should be preferred over **setBody** (),
        because the content is not copied when using this method, but read
        directly from the device. **device** must be open and readable.
        **QHttpPart**  does not take ownership of **device** , i.e. the device
        must be closed and destroyed if necessary. if **device** is sequential
        (e.g. sockets, but not files), **QNetworkAccessManager::post** () should
        be called after **device** has emitted finished(). For unsetting the
        device and using data set via **setBody** (), use "setBodyDevice(0)".

        **See also** **setBody** () and **QNetworkAccessManager::post** ().
        """
        ...

    def setBody(self, body: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qhttppart.html#setBody

        **void QHttpPart::setBody(const QByteArray & body )**

        Sets the body of this MIME part to **body**. The body set with this
        method will be used unless the device is set via **setBodyDevice** ().
        For a large amount of data (e.g. an image), use **setBodyDevice** (),
        which will not copy the data internally.

        **See also** **setBodyDevice** ().
        """
        ...

    def setRawHeader(
        self,
        headerName: typing.Union[QtCore.QByteArray, bytes, bytearray],
        headerValue: typing.Union[QtCore.QByteArray, bytes, bytearray],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qhttppart.html#setRawHeader

        **void QHttpPart::setRawHeader(const QByteArray & headerName , const
        QByteArray & headerValue )**

        Sets the header **headerName** to be of value **headerValue**. If
        **headerName** corresponds to a known header (see
        **QNetworkRequest::KnownHeaders** ), the raw format will be parsed and
        the corresponding "cooked" header will be set as well.

        **Note:** Setting the same header twice overrides the previous setting.
        To accomplish the behaviour of multiple HTTP headers of the same name,
        you should concatenate the two values, separating them with a comma
        (",") and set one single raw header.

        **See also** **QNetworkRequest::KnownHeaders** , **setHeader** (), and
        **QNetworkRequest::setRawHeader** ().
        """
        ...

    def setHeader(
        self, header: "QNetworkRequest.KnownHeaders", value: typing.Any
    ) -> None:
        """
        https://doc.qt.io/qt-5/qhttppart.html#setHeader

        **void QHttpPart::setHeader(QNetworkRequest::KnownHeaders header , const
        QVariant & value )**

        Sets the value of the known header **header** to be **value** ,
        overriding any previously set headers.

        **See also** **QNetworkRequest::KnownHeaders** , **setRawHeader** (),
        and **QNetworkRequest::setHeader** ().
        """
        ...
