"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtNetwork import *


class QHttpMultiPart(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qhttpmultipart.html

    **Detailed Description**

    The QHttpMultiPart resembles a MIME multipart message, as described in RFC
    2046, which is to be sent over HTTP. A multipart message consists of an
    arbitrary number of body parts (see **QHttpPart** ), which are separated by
    a unique boundary. The boundary of the QHttpMultiPart is constructed with
    the string "boundary_.oOo.**_** " followed by random characters, and
    provides enough uniqueness to make sure it does not occur inside the parts
    itself. If desired, the boundary can still be set via **setBoundary** ().

    As an example, consider the following code snippet, which constructs a
    multipart message containing a text part followed by an image part:

    **QHttpMultiPart**  *multiPart = new **QHttpMultiPart** (**QHttpMultiPart**
    ::FormDataType);

        **QHttpPart**  textPart;
    textPart.setHeader(**QNetworkRequest** ::ContentDispositionHeader,
    **QVariant** ("form-data; name=\\"text\\""));
        textPart.setBody("my text");
    **QHttpPart**  imagePart;
        imagePart.setHeader(**QNetworkRequest**
    ::ContentTypeHeader, **QVariant** ("image/jpeg"));
    imagePart.setHeader(**QNetworkRequest** ::ContentDispositionHeader,
    **QVariant** ("form-data; name=\\"image\\""));
        **QFile**  *file = new
    **QFile** ("image.jpg");
        file->open(**QIODevice** ::ReadOnly);
    imagePart.setBodyDevice(file);
        file->setParent(multiPart); // we cannot
    delete the file now, so delete it with the multiPart
    multiPart->append(textPart);
        multiPart->append(imagePart);
    **QUrl**  url("http://my.server.tld");
        **QNetworkRequest**
    request(url);

        **QNetworkAccessManager**  manager;
    **QNetworkReply**  *reply = manager.post(request, multiPart);
    multiPart->setParent(reply); // delete the multiPart with the reply
        //
    here connect signals etc.

    **See also** **QHttpPart**  and **QNetworkAccessManager::post** ().
    """

    class ContentType(int):
        MixedType: QHttpMultiPart = ...
        RelatedType: QHttpMultiPart = ...
        FormDataType: QHttpMultiPart = ...
        AlternativeType: QHttpMultiPart = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qhttpmultipart.html#QHttpMultiPart

        **QHttpMultiPart::QHttpMultiPart(QObject * parent = nullptr)**

        Constructs a QHttpMultiPart with content type **MixedType**  and sets
        **parent** as the parent object.

        **See also** **QHttpMultiPart::ContentType** .
        """
        ...

    @typing.overload
    def __init__(
        self,
        contentType: "QHttpMultiPart.ContentType",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qhttpmultipart.html#QHttpMultiPart-1

        **QHttpMultiPart::QHttpMultiPart(QHttpMultiPart::ContentType contentType
        , QObject * parent = nullptr)**

        Constructs a QHttpMultiPart with content type **contentType** and sets
        parent as the parent object.

        **See also** **QHttpMultiPart::ContentType** .
        """
        ...

    def setBoundary(
        self, boundary: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qhttpmultipart.html#setBoundary

        **void QHttpMultiPart::setBoundary(const QByteArray & boundary )**

        Sets the boundary to **boundary**.

        Usually, you do not need to generate a boundary yourself; upon
        construction the boundary is initiated with the string
        "boundary_.oOo.**_** " followed by random characters, and provides
        enough uniqueness to make sure it does not occur inside the parts
        itself.

        **See also** **boundary** ().
        """
        ...

    def boundary(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qhttpmultipart.html#boundary

        **QByteArray QHttpMultiPart::boundary() const**

        returns the boundary.

        **See also** **setBoundary** ().
        """
        ...

    def setContentType(self, contentType: "QHttpMultiPart.ContentType") -> None:
        """
        https://doc.qt.io/qt-5/qhttpmultipart.html#setContentType

        **void QHttpMultiPart::setContentType(QHttpMultiPart::ContentType
        contentType )**

        Sets the content type to **contentType**. The content type will be used
        in the HTTP header section when sending the multipart message via
        **QNetworkAccessManager::post** (). In case you want to use a multipart
        subtype not contained in **QHttpMultiPart::ContentType** , you can add
        the "Content-Type" header field to the **QNetworkRequest**  by hand, and
        then use this request together with the multipart message for posting.

        **See also** **QHttpMultiPart::ContentType**  and
        **QNetworkAccessManager::post** ().
        """
        ...

    def append(self, httpPart: QHttpPart) -> None:
        """
        https://doc.qt.io/qt-5/qhttpmultipart.html#append

        **void QHttpMultiPart::append(const QHttpPart & httpPart )**

        Appends **httpPart** to this multipart.
        """
        ...
