"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNetwork import *


class QDnsLookup(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qdnslookup.html

    **Detailed Description**

    QDnsLookup uses the mechanisms provided by the operating system to perform
    DNS lookups. To perform a lookup you need to specify a **name**  and
    **type**  then invoke the **lookup()**  slot. The **finished()**  signal
    will be emitted upon completion.

    For example, you can determine which servers an XMPP chat client should
    connect to for a given domain with:

    void MyObject::lookupServers()
        {
            // Create a DNS lookup.
    dns = new **QDnsLookup** (this);
            connect(dns, SIGNAL(finished()),
    this, SLOT(handleServers()));

            // Find the XMPP servers for
    gmail.com
            dns->setType(**QDnsLookup** ::SRV);
    dns->setName("_xmpp-client._tcp.gmail.com");
            dns->lookup();
        }

    Once the request finishes you can handle the results with:

    void MyObject::handleServers()
        {
            // Check the lookup succeeded.
    if (dns->error() != **QDnsLookup** ::NoError) {
                **qWarning**
    ("DNS lookup failed");
                dns->deleteLater();
                return;
    }

            // Handle the results.
            const auto records =
    dns->serviceRecords();
            for (const **QDnsServiceRecord**  &record :
    records) {
                ...
            }
            dns->deleteLater();
        }

    **Note:** If you simply want to find the IP address(es) associated with a
    host name, or the host name associated with an IP address you should use
    **QHostInfo**  instead.
    """

    class Type(int):
        A: QDnsLookup = ...
        AAAA: QDnsLookup = ...
        ANY: QDnsLookup = ...
        CNAME: QDnsLookup = ...
        MX: QDnsLookup = ...
        NS: QDnsLookup = ...
        PTR: QDnsLookup = ...
        SRV: QDnsLookup = ...
        TXT: QDnsLookup = ...

    class Error(int):
        NoError: QDnsLookup = ...
        ResolverError: QDnsLookup = ...
        OperationCancelledError: QDnsLookup = ...
        InvalidRequestError: QDnsLookup = ...
        InvalidReplyError: QDnsLookup = ...
        ServerFailureError: QDnsLookup = ...
        ServerRefusedError: QDnsLookup = ...
        NotFoundError: QDnsLookup = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#QDnsLookup

        **QDnsLookup::QDnsLookup(QObject * parent = nullptr)**

        Constructs a QDnsLookup object and sets **parent** as the parent object.

        The **type**  property will default to **QDnsLookup::A** .
        """
        ...

    @typing.overload
    def __init__(
        self,
        type: "QDnsLookup.Type",
        name: str,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#QDnsLookup-1

        **QDnsLookup::QDnsLookup(QDnsLookup::Type type , const QString & name ,
        QObject * parent = nullptr)**

        Constructs a QDnsLookup object for the given **type** and **name** and
        sets **parent** as the parent object.
        """
        ...

    @typing.overload
    def __init__(
        self,
        type: "QDnsLookup.Type",
        name: str,
        nameserver: typing.Union["QHostAddress", "QHostAddress.SpecialAddress"],
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#QDnsLookup-2

        **QDnsLookup::QDnsLookup(QDnsLookup::Type type , const QString & name ,
        const QHostAddress & nameserver , QObject * parent = nullptr)**

        Constructs a QDnsLookup object for the given **type** , **name** and
        **nameserver** and sets **parent** as the parent object.

        This function was introduced in Qt 5.4.
        """
        ...

    def setNameserver(
        self, nameserver: typing.Union["QHostAddress", "QHostAddress.SpecialAddress"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#nameserver-prop

        **nameserver : QHostAddress**

        This property holds the nameserver to use for DNS lookup.

        **Access functions:**

        QHostAddress **nameserver** () const
        void **setNameserver** (const
        QHostAddress & **nameserver** )

        **Notifier signal:**

        void **nameserverChanged** (const QHostAddress & **nameserver** )
        """
        ...

    def nameserver(self) -> "QHostAddress":
        """
        https://doc.qt.io/qt-5/qdnslookup.html#nameserver-prop

        **nameserver : QHostAddress**

        This property holds the nameserver to use for DNS lookup.

        **Access functions:**

        QHostAddress **nameserver** () const
        void **setNameserver** (const
        QHostAddress & **nameserver** )

        **Notifier signal:**

        void **nameserverChanged** (const QHostAddress & **nameserver** )
        """
        ...

    def lookup(self) -> None:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#lookup

        **[slot] void QDnsLookup::lookup()**

        Performs the DNS lookup.

        The **finished()**  signal is emitted upon completion.
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#abort

        **[slot] void QDnsLookup::abort()**

        Aborts the DNS lookup operation.

        If the lookup is already finished, does nothing.
        """
        ...

    def textRecords(self) -> typing.List[QDnsTextRecord]:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#textRecords

        **QList<QDnsTextRecord> QDnsLookup::textRecords() const**

        Returns the list of text records associated with this lookup.
        """
        ...

    def serviceRecords(self) -> typing.List[QDnsServiceRecord]:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#serviceRecords

        **QList<QDnsServiceRecord> QDnsLookup::serviceRecords() const**

        Returns the list of service records associated with this lookup.

        The records are sorted according to **RFC 2782** , so if you use them to
        connect to servers, you should try them in the order they are listed.
        """
        ...

    def pointerRecords(self) -> typing.List[QDnsDomainNameRecord]:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#pointerRecords

        **QList<QDnsDomainNameRecord> QDnsLookup::pointerRecords() const**

        Returns the list of pointer records associated with this lookup.
        """
        ...

    def nameServerRecords(self) -> typing.List[QDnsDomainNameRecord]:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#nameServerRecords

        **QList<QDnsDomainNameRecord> QDnsLookup::nameServerRecords() const**

        Returns the list of name server records associated with this lookup.
        """
        ...

    def mailExchangeRecords(self) -> typing.List[QDnsMailExchangeRecord]:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#mailExchangeRecords

        **QList<QDnsMailExchangeRecord> QDnsLookup::mailExchangeRecords()
        const**

        Returns the list of mail exchange records associated with this lookup.

        The records are sorted according to **RFC 5321** , so if you use them to
        connect to servers, you should try them in the order they are listed.
        """
        ...

    def hostAddressRecords(self) -> typing.List[QDnsHostAddressRecord]:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#hostAddressRecords

        **QList<QDnsHostAddressRecord> QDnsLookup::hostAddressRecords() const**

        Returns the list of host address records associated with this lookup.
        """
        ...

    def canonicalNameRecords(self) -> typing.List[QDnsDomainNameRecord]:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#canonicalNameRecords

        **QList<QDnsDomainNameRecord> QDnsLookup::canonicalNameRecords() const**

        Returns the list of canonical name records associated with this lookup.
        """
        ...

    def setType(self, a0: "QDnsLookup.Type") -> None:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#type-prop

        **type : Type**

        This property holds the type of DNS lookup.

        **Access functions:**

        QDnsLookup::Type **type** () const
        void **setType** (
        **QDnsLookup::Type** )

        **Notifier signal:**

        void ****typeChanged** ** (QDnsLookup::Type **type** )

        **Member Function Documentation**
        """
        ...

    def type(self) -> "QDnsLookup.Type":
        """
        https://doc.qt.io/qt-5/qdnslookup.html#type-prop

        **type : Type**

        This property holds the type of DNS lookup.

        **Access functions:**

        QDnsLookup::Type **type** () const
        void **setType** (
        **QDnsLookup::Type** )

        **Notifier signal:**

        void ****typeChanged** ** (QDnsLookup::Type **type** )

        **Member Function Documentation**
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#name-prop

        **name : QString**

        This property holds the name to lookup.

        **Note:** The name will be encoded using IDNA, which means it's
        unsuitable for querying SRV records compatible with the DNS-SD
        specification.

        **Access functions:**

        QString **name** () const
        void **setName** (const QString & **name** )

        **Notifier signal:**

        void ****nameChanged** ** (const QString & **name** )
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#name-prop

        **name : QString**

        This property holds the name to lookup.

        **Note:** The name will be encoded using IDNA, which means it's
        unsuitable for querying SRV records compatible with the DNS-SD
        specification.

        **Access functions:**

        QString **name** () const
        void **setName** (const QString & **name** )

        **Notifier signal:**

        void ****nameChanged** ** (const QString & **name** )
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#isFinished

        **bool QDnsLookup::isFinished() const**

        Returns whether the reply has finished or was aborted.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#errorString-prop

        **errorString : const QString**

        This property holds a human-readable description of the error if the DNS
        lookup failed.

        **Access functions:**

        QString **errorString** () const

        **Notifier signal:**

        void ****finished** ** ()
        """
        ...

    def error(self) -> "QDnsLookup.Error":
        """
        https://doc.qt.io/qt-5/qdnslookup.html#error-prop

        **error : const Error**

        This property holds the type of error that occurred if the DNS lookup
        failed, or **NoError** .

        **Access functions:**

        QDnsLookup::Error **error** () const

        **Notifier signal:**

        void ****finished** ** ()
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#finished

        **[signal] void QDnsLookup::finished()**

        This signal is emitted when the reply has finished processing.

        **Note:** Notifier signal for property **error** . Notifier signal for
        property **errorString** .
        """
        ...

    @property
    def nameChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#nameChanged

        **[signal] void QDnsLookup::nameChanged(const QString & name )**

        This signal is emitted when the lookup **name**  changes. **name** is
        the new lookup name.

        **Note:** Notifier signal for property **name** .
        """
        ...

    @property
    def nameserverChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def typeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdnslookup.html#typeChanged

        **[signal] void QDnsLookup::typeChanged(QDnsLookup::Type type )**

        This signal is emitted when the lookup **type**  changes. **type** is
        the new lookup type.

        **Note:** Notifier signal for property **type** .
        """
        ...
