"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QAbstractSocket(QtCore.QIODevice):
    """
    https://doc.qt.io/qt-5/qabstractsocket.html

    **Detailed Description**

    QAbstractSocket is the base class for **QTcpSocket**  and **QUdpSocket**
    and contains all common functionality of these two classes. If you need a
    socket, you have two options:

    * Instantiate **QTcpSocket**  or **QUdpSocket** .
      * Create a native socket
    descriptor, instantiate QAbstractSocket, and call **setSocketDescriptor** ()
    to wrap the native socket.

    TCP (Transmission Control Protocol) is a reliable, stream-oriented,
    connection-oriented transport protocol. UDP (User Datagram Protocol) is an
    unreliable, datagram-oriented, connectionless protocol. In practice, this
    means that TCP is better suited for continuous transmission of data, whereas
    the more lightweight UDP can be used when reliability isn't important.

    QAbstractSocket's API unifies most of the differences between the two
    protocols. For example, although UDP is connectionless, **connectToHost** ()
    establishes a virtual connection for UDP sockets, enabling you to use
    QAbstractSocket in more or less the same way regardless of the underlying
    protocol. Internally, QAbstractSocket remembers the address and port passed
    to **connectToHost** (), and functions like **read** () and **write** () use
    these values.

    At any time, QAbstractSocket has a state (returned by **state** ()). The
    initial state is **UnconnectedState** . After calling **connectToHost** (),
    the socket first enters **HostLookupState** . If the host is found,
    QAbstractSocket enters **ConnectingState**  and emits the **hostFound** ()
    signal. When the connection has been established, it enters
    **ConnectedState**  and emits **connected** (). If an error occurs at any
    stage, **errorOccurred** () is emitted. Whenever the state changes,
    **stateChanged** () is emitted. For convenience, **isValid** () returns
    `true` if the socket is ready for reading and writing, but note that the
    socket's state must be **ConnectedState**  before reading and writing can
    occur.

    Read or write data by calling **read** () or **write** (), or use the
    convenience functions **readLine** () and **readAll** (). QAbstractSocket
    also inherits **getChar** (), **putChar** (), and **ungetChar** () from
    **QIODevice** , which work on single bytes. The **bytesWritten** () signal
    is emitted when data has been written to the socket. Note that Qt does not
    limit the write buffer size. You can monitor its size by listening to this
    signal.

    The **readyRead** () signal is emitted every time a new chunk of data has
    arrived. **bytesAvailable** () then returns the number of bytes that are
    available for reading. Typically, you would connect the **readyRead** ()
    signal to a slot and read all available data there. If you don't read all
    the data at once, the remaining data will still be available later, and any
    new incoming data will be appended to QAbstractSocket's internal read
    buffer. To limit the size of the read buffer, call **setReadBufferSize** ().

    To close the socket, call **disconnectFromHost** (). QAbstractSocket enters
    **QAbstractSocket::ClosingState** . After all pending data has been written
    to the socket, QAbstractSocket actually closes the socket, enters
    **QAbstractSocket::UnconnectedState** , and emits **disconnected** (). If
    you want to abort a connection immediately, discarding all pending data,
    call **abort** () instead. If the remote host closes the connection,
    QAbstractSocket will emit **errorOccurred**
    (**QAbstractSocket::RemoteHostClosedError** ), during which the socket state
    will still be **ConnectedState** , and then the **disconnected** () signal
    will be emitted.

    The port and address of the connected peer is fetched by calling
    **peerPort** () and **peerAddress** (). **peerName** () returns the host
    name of the peer, as passed to **connectToHost** (). **localPort** () and
    **localAddress** () return the port and address of the local socket.

    QAbstractSocket provides a set of functions that suspend the calling thread
    until certain signals are emitted. These functions can be used to implement
    blocking sockets:

    * **waitForConnected** () blocks until a connection has been established.
    * **waitForReadyRead** () blocks until new data is available for reading.
    * **waitForBytesWritten** () blocks until one payload of data has been
    written to the socket.
      * **waitForDisconnected** () blocks until the
    connection has closed.

    We show an example:

    int numRead = 0, numReadTotal = 0;
            char buffer[50];
    forever {
                numRead  = socket.read(buffer, 50);
    // do whatever with array

                numReadTotal += numRead;
    if (numRead == 0 && !socket.waitForReadyRead())
                    break;
    }

    If **waitForReadyRead()**  returns `false`, the connection has been closed
    or an error has occurred.

    Programming with a blocking socket is radically different from programming
    with a non-blocking socket. A blocking socket doesn't require an event loop
    and typically leads to simpler code. However, in a GUI application, blocking
    sockets should only be used in non-GUI threads, to avoid freezing the user
    interface. See the **fortuneclient**  and **blockingfortuneclient**
    examples for an overview of both approaches.

    **Note:** We discourage the use of the blocking functions together with
    signals. One of the two possibilities should be used.

    QAbstractSocket can be used with **QTextStream**  and **QDataStream** 's
    stream operators (operator<<() and operator>>()). There is one issue to be
    aware of, though: You must make sure that enough data is available before
    attempting to read it using operator>>().

    **See also** **QNetworkAccessManager**  and **QTcpServer** .
    """

    class PauseMode(int):
        PauseNever: QAbstractSocket = ...
        PauseOnSslErrors: QAbstractSocket = ...

    class BindFlag(int):
        DefaultForPlatform: QAbstractSocket = ...
        ShareAddress: QAbstractSocket = ...
        DontShareAddress: QAbstractSocket = ...
        ReuseAddressHint: QAbstractSocket = ...

    class SocketOption(int):
        LowDelayOption: QAbstractSocket = ...
        KeepAliveOption: QAbstractSocket = ...
        MulticastTtlOption: QAbstractSocket = ...
        MulticastLoopbackOption: QAbstractSocket = ...
        TypeOfServiceOption: QAbstractSocket = ...
        SendBufferSizeSocketOption: QAbstractSocket = ...
        ReceiveBufferSizeSocketOption: QAbstractSocket = ...
        PathMtuSocketOption: QAbstractSocket = ...

    class SocketState(int):
        UnconnectedState: QAbstractSocket = ...
        HostLookupState: QAbstractSocket = ...
        ConnectingState: QAbstractSocket = ...
        ConnectedState: QAbstractSocket = ...
        BoundState: QAbstractSocket = ...
        ListeningState: QAbstractSocket = ...
        ClosingState: QAbstractSocket = ...

    class SocketError(int):
        ConnectionRefusedError: QAbstractSocket = ...
        RemoteHostClosedError: QAbstractSocket = ...
        HostNotFoundError: QAbstractSocket = ...
        SocketAccessError: QAbstractSocket = ...
        SocketResourceError: QAbstractSocket = ...
        SocketTimeoutError: QAbstractSocket = ...
        DatagramTooLargeError: QAbstractSocket = ...
        NetworkError: QAbstractSocket = ...
        AddressInUseError: QAbstractSocket = ...
        SocketAddressNotAvailableError: QAbstractSocket = ...
        UnsupportedSocketOperationError: QAbstractSocket = ...
        UnfinishedSocketOperationError: QAbstractSocket = ...
        ProxyAuthenticationRequiredError: QAbstractSocket = ...
        SslHandshakeFailedError: QAbstractSocket = ...
        ProxyConnectionRefusedError: QAbstractSocket = ...
        ProxyConnectionClosedError: QAbstractSocket = ...
        ProxyConnectionTimeoutError: QAbstractSocket = ...
        ProxyNotFoundError: QAbstractSocket = ...
        ProxyProtocolError: QAbstractSocket = ...
        OperationError: QAbstractSocket = ...
        SslInternalError: QAbstractSocket = ...
        SslInvalidUserDataError: QAbstractSocket = ...
        TemporaryError: QAbstractSocket = ...
        UnknownSocketError: QAbstractSocket = ...

    class NetworkLayerProtocol(int):
        IPv4Protocol: QAbstractSocket = ...
        IPv6Protocol: QAbstractSocket = ...
        AnyIPProtocol: QAbstractSocket = ...
        UnknownNetworkLayerProtocol: QAbstractSocket = ...

    class SocketType(int):
        TcpSocket: QAbstractSocket = ...
        UdpSocket: QAbstractSocket = ...
        SctpSocket: QAbstractSocket = ...
        UnknownSocketType: QAbstractSocket = ...

    class BindMode(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QAbstractSocket.BindMode", "QAbstractSocket.BindFlag"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QAbstractSocket.BindMode") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QAbstractSocket.BindMode":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class PauseModes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QAbstractSocket.PauseModes", "QAbstractSocket.PauseMode"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QAbstractSocket.PauseModes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QAbstractSocket.PauseModes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(
        self, socketType: "QAbstractSocket.SocketType", parent: QtCore.QObject
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#QAbstractSocket

        **QAbstractSocket::QAbstractSocket(QAbstractSocket::SocketType
        socketType , QObject * parent )**

        Creates a new abstract socket of type **socketType**. The **parent**
        argument is passed to **QObject** 's constructor.

        **See also** **socketType** (), **QTcpSocket** , and **QUdpSocket** .
        """
        ...

    def setProtocolTag(self, tag: str) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setProtocolTag

        **void QAbstractSocket::setProtocolTag(const QString & tag )**

        Sets the protocol tag for this socket to **tag**.

        This function was introduced in Qt 5.13.

        **See also** **protocolTag** ().
        """
        ...

    def protocolTag(self) -> str:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#protocolTag

        **QString QAbstractSocket::protocolTag() const**

        Returns the protocol tag for this socket. If the protocol tag is set
        then this is passed to **QNetworkProxyQuery**  when this is created
        internally to indicate the protocol tag to be used.

        This function was introduced in Qt 5.13.

        **See also** **setProtocolTag** () and **QNetworkProxyQuery** .
        """
        ...

    @typing.overload
    def bind(
        self,
        address: typing.Union["QHostAddress", "QHostAddress.SpecialAddress"],
        port: int = ...,
        mode: typing.Union[
            "QAbstractSocket.BindMode", "QAbstractSocket.BindFlag"
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#bind

        **bool QAbstractSocket::bind(const QHostAddress & address , quint16 port
        = 0, QAbstractSocket::BindMode mode = DefaultForPlatform)**

        Binds to **address** on port **port** , using the **BindMode**
        **mode**.

        For UDP sockets, after binding, the signal **QUdpSocket::readyRead** ()
        is emitted whenever a UDP datagram arrives on the specified address and
        port. Thus, this function is useful to write UDP servers.

        For TCP sockets, this function may be used to specify which interface to
        use for an outgoing connection, which is useful in case of multiple
        network interfaces.

        By default, the socket is bound using the **DefaultForPlatform**
        **BindMode** . If a port is not specified, a random port is chosen.

        On success, the function returns `true` and the socket enters
        **BoundState** ; otherwise it returns `false`.

        This function was introduced in Qt 5.0.
        """
        ...

    @typing.overload
    def bind(
        self,
        port: int = ...,
        mode: typing.Union[
            "QAbstractSocket.BindMode", "QAbstractSocket.BindFlag"
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#bind-1

        **bool QAbstractSocket::bind(quint16 port = 0, QAbstractSocket::BindMode
        mode = DefaultForPlatform)**

        This is an overloaded function.

        Binds to **QHostAddress** :Any on port **port** , using the **BindMode**
        **mode**.

        By default, the socket is bound using the **DefaultForPlatform**
        **BindMode** . If a port is not specified, a random port is chosen.

        This function was introduced in Qt 5.0.
        """
        ...

    def setPauseMode(
        self,
        pauseMode: typing.Union[
            "QAbstractSocket.PauseModes", "QAbstractSocket.PauseMode"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setPauseMode

        **void QAbstractSocket::setPauseMode(QAbstractSocket::PauseModes
        pauseMode )**

        Controls whether to pause upon receiving a notification. The
        **pauseMode** parameter specifies the conditions in which the socket
        should be paused. The only notification currently supported is
        QSslSocket::sslErrors(). If set to **PauseOnSslErrors** , data transfer
        on the socket will be paused and needs to be enabled explicitly again by
        calling **resume** (). By default this option is set to **PauseNever** .
        This option must be called before connecting to the server, otherwise it
        will result in undefined behavior.

        This function was introduced in Qt 5.0.

        **See also** **pauseMode** () and **resume** ().
        """
        ...

    def pauseMode(self) -> "QAbstractSocket.PauseModes":
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#pauseMode

        **QAbstractSocket::PauseModes QAbstractSocket::pauseMode() const**

        Returns the pause mode of this socket.

        This function was introduced in Qt 5.0.

        **See also** **setPauseMode** () and **resume** ().
        """
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#resume

        **[virtual] void QAbstractSocket::resume()**

        Continues data transfer on the socket. This method should only be used
        after the socket has been set to pause upon notifications and a
        notification has been received. The only notification currently
        supported is QSslSocket::sslErrors(). Calling this method if the socket
        is not paused results in undefined behavior.

        This function was introduced in Qt 5.0.

        **See also** **pauseMode** () and **setPauseMode** ().
        """
        ...

    def socketOption(self, option: "QAbstractSocket.SocketOption") -> typing.Any:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#socketOption

        **[virtual] QVariant
        QAbstractSocket::socketOption(QAbstractSocket::SocketOption option )**

        Returns the value of the **option** option.

        This function was introduced in Qt 4.6.

        **See also** **setSocketOption** ().
        """
        ...

    def setSocketOption(
        self, option: "QAbstractSocket.SocketOption", value: typing.Any
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setSocketOption

        **[virtual] void
        QAbstractSocket::setSocketOption(QAbstractSocket::SocketOption option ,
        const QVariant & value )**

        Sets the given **option** to the value described by **value**.

        **Note:** On Windows Runtime, **QAbstractSocket::KeepAliveOption**  must
        be set before the socket is connected.

        This function was introduced in Qt 4.6.

        **See also** **socketOption** ().
        """
        ...

    def setPeerName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setPeerName

        **[protected] void QAbstractSocket::setPeerName(const QString & name )**

        Sets the host name of the remote peer to **name**.

        You can call this function in a subclass of **QAbstractSocket**  to
        change the return value of the **peerName** () function after a
        connection has been established. This feature is commonly used by proxy
        connections for virtual connection settings.

        This function was introduced in Qt 4.1.

        **See also** **peerName** ().
        """
        ...

    def setPeerAddress(
        self, address: typing.Union["QHostAddress", "QHostAddress.SpecialAddress"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setPeerAddress

        **[protected] void QAbstractSocket::setPeerAddress(const QHostAddress &
        address )**

        Sets the address of the remote side of the connection to **address**.

        You can call this function in a subclass of **QAbstractSocket**  to
        change the return value of the **peerAddress** () function after a
        connection has been established. This feature is commonly used by proxy
        connections for virtual connection settings.

        This function was introduced in Qt 4.1.

        **See also** **peerAddress** (), **setPeerPort** (), and
        **setLocalAddress** ().
        """
        ...

    def setPeerPort(self, port: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setPeerPort

        **[protected] void QAbstractSocket::setPeerPort(quint16 port )**

        Sets the port of the remote side of the connection to **port**.

        You can call this function in a subclass of **QAbstractSocket**  to
        change the return value of the **peerPort** () function after a
        connection has been established. This feature is commonly used by proxy
        connections for virtual connection settings.

        This function was introduced in Qt 4.1.

        **See also** **peerPort** (), **setPeerAddress** (), and
        **setLocalPort** ().
        """
        ...

    def setLocalAddress(
        self, address: typing.Union["QHostAddress", "QHostAddress.SpecialAddress"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setLocalAddress

        **[protected] void QAbstractSocket::setLocalAddress(const QHostAddress &
        address )**

        Sets the address on the local side of a connection to **address**.

        You can call this function in a subclass of **QAbstractSocket**  to
        change the return value of the **localAddress** () function after a
        connection has been established. This feature is commonly used by proxy
        connections for virtual connection settings.

        Note that this function does not bind the local address of the socket
        prior to a connection (e.g., **QAbstractSocket::bind** ()).

        This function was introduced in Qt 4.1.

        **See also** **localAddress** (), **setLocalPort** (), and
        **setPeerAddress** ().
        """
        ...

    def setLocalPort(self, port: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setLocalPort

        **[protected] void QAbstractSocket::setLocalPort(quint16 port )**

        Sets the port on the local side of a connection to **port**.

        You can call this function in a subclass of **QAbstractSocket**  to
        change the return value of the **localPort** () function after a
        connection has been established. This feature is commonly used by proxy
        connections for virtual connection settings.

        Note that this function does not bind the local port of the socket prior
        to a connection (e.g., **QAbstractSocket::bind** ()).

        This function was introduced in Qt 4.1.

        **See also** **localPort** (), **localAddress** (), **setLocalAddress**
        (), and **setPeerPort** ().
        """
        ...

    def setSocketError(self, socketError: "QAbstractSocket.SocketError") -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setSocketError

        **[protected] void
        QAbstractSocket::setSocketError(QAbstractSocket::SocketError socketError
        )**

        Sets the type of error that last occurred to **socketError**.

        **See also** **setSocketState** () and **setErrorString** ().
        """
        ...

    def setSocketState(self, state: "QAbstractSocket.SocketState") -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setSocketState

        **[protected] void
        QAbstractSocket::setSocketState(QAbstractSocket::SocketState state )**

        Sets the state of the socket to **state**.

        **See also** **state** ().
        """
        ...

    def writeData(self, data: bytes) -> int:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#writeData

        **[override virtual protected] qint64 QAbstractSocket::writeData(const
        char * data , qint64 size )**

        Reimplements: **QIODevice::writeData** (const char *data, qint64
        maxSize).
        """
        ...

    def readLineData(self, maxlen: int) -> bytes:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#readLineData

        **[override virtual protected] qint64 QAbstractSocket::readLineData(char
        * data , qint64 maxlen )**

        Reimplements: **QIODevice::readLineData** (char *data, qint64 maxSize).
        """
        ...

    def readData(self, maxlen: int) -> bytes:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#readData

        **[override virtual protected] qint64 QAbstractSocket::readData(char *
        data , qint64 maxSize )**

        Reimplements: **QIODevice::readData** (char *data, qint64 maxSize).
        """
        ...

    def proxy(self) -> "QNetworkProxy":
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#proxy

        **QNetworkProxy QAbstractSocket::proxy() const**

        Returns the network proxy for this socket. By default
        **QNetworkProxy::DefaultProxy**  is used, which means this socket will
        query the default proxy settings for the application.

        This function was introduced in Qt 4.1.

        **See also** **setProxy** (), **QNetworkProxy** , and
        **QNetworkProxyFactory** .
        """
        ...

    def setProxy(self, networkProxy: "QNetworkProxy") -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setProxy

        **void QAbstractSocket::setProxy(const QNetworkProxy & networkProxy )**

        Sets the explicit network proxy for this socket to **networkProxy**.

        To disable the use of a proxy for this socket, use the
        **QNetworkProxy::NoProxy**  proxy type:

        socket->setProxy(**QNetworkProxy** ::NoProxy);

        The default value for the proxy is **QNetworkProxy::DefaultProxy** ,
        which means the socket will use the application settings: if a proxy is
        set with **QNetworkProxy::setApplicationProxy** , it will use that;
        otherwise, if a factory is set with
        **QNetworkProxyFactory::setApplicationProxyFactory** , it will query
        that factory with type **QNetworkProxyQuery::TcpSocket** .

        This function was introduced in Qt 4.1.

        **See also** **proxy** (), **QNetworkProxy** , and
        **QNetworkProxyFactory::queryProxy** ().
        """
        ...

    def waitForDisconnected(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#waitForDisconnected

        **[virtual] bool QAbstractSocket::waitForDisconnected(int msecs =
        30000)**

        Waits until the socket has disconnected, up to **msecs** milliseconds.
        If the connection was successfully disconnected, this function returns
        `true`; otherwise it returns `false` (if the operation timed out, if an
        error occurred, or if this **QAbstractSocket**  is already
        disconnected). In the case where it returns `false`, you can call
        **error** () to determine the cause of the error.

        The following example waits up to one second for a connection to be
        closed:

        socket->disconnectFromHost();
            if (socket->state() ==
        **QAbstractSocket** ::UnconnectedState
                ||
        socket->waitForDisconnected(1000)) {
                    **qDebug**
        ("Disconnected!");
            }

        If msecs is -1, this function will not time out.

        **Note:** This function may fail randomly on Windows. Consider using the
        event loop and the **disconnected** () signal if your software will run
        on Windows.

        **See also** **disconnectFromHost** () and **close** ().
        """
        ...

    def waitForBytesWritten(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#waitForBytesWritten

        **[override virtual] bool QAbstractSocket::waitForBytesWritten(int msecs
        = 30000)**

        Reimplements: **QIODevice::waitForBytesWritten** (int msecs).

        This function blocks until at least one byte has been written on the
        socket and the **bytesWritten()**  signal has been emitted. The function
        will timeout after **msecs** milliseconds; the default timeout is 30000
        milliseconds.

        The function returns `true` if the **bytesWritten** () signal is
        emitted; otherwise it returns `false` (if an error occurred or the
        operation timed out).

        **Note:** This function may fail randomly on Windows. Consider using the
        event loop and the **bytesWritten** () signal if your software will run
        on Windows.

        **See also** **waitForReadyRead** ().
        """
        ...

    def waitForReadyRead(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#waitForReadyRead

        **[override virtual] bool QAbstractSocket::waitForReadyRead(int msecs =
        30000)**

        Reimplements: **QIODevice::waitForReadyRead** (int msecs).

        This function blocks until new data is available for reading and the
        **readyRead()**  signal has been emitted. The function will timeout
        after **msecs** milliseconds; the default timeout is 30000 milliseconds.

        The function returns `true` if the **readyRead** () signal is emitted
        and there is new data available for reading; otherwise it returns
        `false` (if an error occurred or the operation timed out).

        **Note:** This function may fail randomly on Windows. Consider using the
        event loop and the **readyRead** () signal if your software will run on
        Windows.

        **See also** **waitForBytesWritten** ().
        """
        ...

    def waitForConnected(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#waitForConnected

        **[virtual] bool QAbstractSocket::waitForConnected(int msecs = 30000)**

        Waits until the socket is connected, up to **msecs** milliseconds. If
        the connection has been established, this function returns `true`;
        otherwise it returns `false`. In the case where it returns `false`, you
        can call **error** () to determine the cause of the error.

        The following example waits up to one second for a connection to be
        established:

        socket->connectToHost("imap", 143);
            if
        (socket->waitForConnected(1000))
                **qDebug** ("Connected!");

        If msecs is -1, this function will not time out.

        **Note:** This function may wait slightly longer than **msecs** ,
        depending on the time it takes to complete the host lookup.

        **Note:** Multiple calls to this functions do not accumulate the time.
        If the function times out, the connecting process will be aborted.

        **Note:** This function may fail randomly on Windows. Consider using the
        event loop and the **connected** () signal if your software will run on
        Windows.

        **See also** **connectToHost** () and **connected** ().
        """
        ...

    def flush(self) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#flush

        **bool QAbstractSocket::flush()**

        This function writes as much as possible from the internal write buffer
        to the underlying network socket, without blocking. If any data was
        written, this function returns `true`; otherwise false is returned.

        Call this function if you need **QAbstractSocket**  to start sending
        buffered data immediately. The number of bytes successfully written
        depends on the operating system. In most cases, you do not need to call
        this function, because **QAbstractSocket**  will start sending data
        automatically once control goes back to the event loop. In the absence
        of an event loop, call **waitForBytesWritten** () instead.

        **See also** **write** () and **waitForBytesWritten** ().
        """
        ...

    def atEnd(self) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#atEnd

        **[override virtual] bool QAbstractSocket::atEnd() const**

        Reimplements: **QIODevice::atEnd** () const.

        Returns `true` if no more data is currently available for reading;
        otherwise returns `false`.

        This function is most commonly used when reading data from the socket in
        a loop. For example:

        // This slot is connected to QAbstractSocket::readyRead()
             void
        SocketClass::readyReadSlot()
             {
                 while (!socket.atEnd()) {
        **QByteArray**  data = socket.read(100);
                     ....
                 }
        }

        **See also** **bytesAvailable** () and **readyRead** ().
        """
        ...

    def isSequential(self) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#isSequential

        **[override virtual] bool QAbstractSocket::isSequential() const**

        Reimplements: **QIODevice::isSequential** () const.
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#close

        **[override virtual] void QAbstractSocket::close()**

        Reimplements: **QIODevice::close** ().

        Closes the I/O device for the socket and calls **disconnectFromHost** ()
        to close the socket's connection.

        See **QIODevice::close** () for a description of the actions that occur
        when an I/O device is closed.

        **See also** **abort** ().
        """
        ...

    @typing.overload
    def error(self) -> "QAbstractSocket.SocketError":
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#error

        **QAbstractSocket::SocketError QAbstractSocket::error() const**

        Returns the type of error that last occurred.

        **See also** **state** () and **errorString** ().
        """
        ...

    @typing.overload
    def error(self, a0: "QAbstractSocket.SocketError") -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#error

        **QAbstractSocket::SocketError QAbstractSocket::error() const**

        Returns the type of error that last occurred.

        **See also** **state** () and **errorString** ().
        """
        ...

    def state(self) -> "QAbstractSocket.SocketState":
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#state

        **QAbstractSocket::SocketState QAbstractSocket::state() const**

        Returns the state of the socket.

        **See also** **error** ().
        """
        ...

    def socketType(self) -> "QAbstractSocket.SocketType":
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#socketType

        **QAbstractSocket::SocketType QAbstractSocket::socketType() const**

        Returns the socket type (TCP, UDP, or other).

        **See also** **QTcpSocket**  and **QUdpSocket** .
        """
        ...

    def socketDescriptor(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#socketDescriptor

        **[virtual] qintptr QAbstractSocket::socketDescriptor() const**

        Returns the native socket descriptor of the **QAbstractSocket**  object
        if this is available; otherwise returns -1.

        If the socket is using **QNetworkProxy** , the returned descriptor may
        not be usable with native socket functions.

        The socket descriptor is not available when **QAbstractSocket**  is in
        **UnconnectedState** .

        **See also** **setSocketDescriptor** ().
        """
        ...

    def setSocketDescriptor(
        self,
        socketDescriptor: PyQt5.sip.voidptr,
        state: "QAbstractSocket.SocketState" = ...,
        mode: typing.Union[
            QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setSocketDescriptor

        **[virtual] bool QAbstractSocket::setSocketDescriptor(qintptr
        socketDescriptor , QAbstractSocket::SocketState socketState =
        ConnectedState, QIODevice::OpenMode openMode = ReadWrite)**

        Initializes **QAbstractSocket**  with the native socket descriptor
        **socketDescriptor**. Returns `true` if **socketDescriptor** is accepted
        as a valid socket descriptor; otherwise returns `false`. The socket is
        opened in the mode specified by **openMode** , and enters the socket
        state specified by **socketState**. Read and write buffers are cleared,
        discarding any pending data.

        **Note:** It is not possible to initialize two abstract sockets with the
        same native socket descriptor.

        **See also** **socketDescriptor** ().
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#abort

        **void QAbstractSocket::abort()**

        Aborts the current connection and resets the socket. Unlike
        **disconnectFromHost** (), this function immediately closes the socket,
        discarding any pending data in the write buffer.

        **See also** **disconnectFromHost** () and **close** ().
        """
        ...

    def setReadBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#setReadBufferSize

        **[virtual] void QAbstractSocket::setReadBufferSize(qint64 size )**

        Sets the size of **QAbstractSocket** 's internal read buffer to be
        **size** bytes.

        If the buffer size is limited to a certain size, **QAbstractSocket**
        won't buffer more than this size of data. Exceptionally, a buffer size
        of 0 means that the read buffer is unlimited and all incoming data is
        buffered. This is the default.

        This option is useful if you only read the data at certain points in
        time (e.g., in a real-time streaming application) or if you want to
        protect your socket against receiving too much data, which may
        eventually cause your application to run out of memory.

        Only **QTcpSocket**  uses **QAbstractSocket** 's internal buffer;
        **QUdpSocket**  does not use any buffering at all, but rather relies on
        the implicit buffering provided by the operating system. Because of
        this, calling this function on **QUdpSocket**  has no effect.

        **See also** **readBufferSize** () and **read** ().
        """
        ...

    def readBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#readBufferSize

        **qint64 QAbstractSocket::readBufferSize() const**

        Returns the size of the internal read buffer. This limits the amount of
        data that the client can receive before you call **read** () or
        **readAll** ().

        A read buffer size of 0 (the default) means that the buffer has no size
        limit, ensuring that no data is lost.

        **See also** **setReadBufferSize** () and **read** ().
        """
        ...

    def peerName(self) -> str:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#peerName

        **QString QAbstractSocket::peerName() const**

        Returns the name of the peer as specified by **connectToHost** (), or an
        empty **QString**  if **connectToHost** () has not been called.

        **See also** **peerAddress** (), **peerPort** (), and **setPeerName**
        ().
        """
        ...

    def peerAddress(self) -> "QHostAddress":
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#peerAddress

        **QHostAddress QAbstractSocket::peerAddress() const**

        Returns the address of the connected peer if the socket is in
        **ConnectedState** ; otherwise returns **QHostAddress::Null** .

        **See also** **peerName** (), **peerPort** (), **localAddress** (), and
        **setPeerAddress** ().
        """
        ...

    def peerPort(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#peerPort

        **quint16 QAbstractSocket::peerPort() const**

        Returns the port of the connected peer if the socket is in
        **ConnectedState** ; otherwise returns 0.

        **See also** **peerAddress** (), **localPort** (), and **setPeerPort**
        ().
        """
        ...

    def localAddress(self) -> "QHostAddress":
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#localAddress

        **QHostAddress QAbstractSocket::localAddress() const**

        Returns the host address of the local socket if available; otherwise
        returns **QHostAddress::Null** .

        This is normally the main IP address of the host, but can be
        **QHostAddress::LocalHost**  (127.0.0.1) for connections to the local
        host.

        **See also** **localPort** (), **peerAddress** (), and
        **setLocalAddress** ().
        """
        ...

    def localPort(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#localPort

        **quint16 QAbstractSocket::localPort() const**

        Returns the host port number (in native byte order) of the local socket
        if available; otherwise returns 0.

        **See also** **localAddress** (), **peerPort** (), and **setLocalPort**
        ().
        """
        ...

    def canReadLine(self) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#canReadLine

        **[override virtual] bool QAbstractSocket::canReadLine() const**

        Reimplements: **QIODevice::canReadLine** () const.

        Returns `true` if a line of data can be read from the socket; otherwise
        returns `false`.

        **See also** **readLine** ().
        """
        ...

    def bytesToWrite(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#bytesToWrite

        **[override virtual] qint64 QAbstractSocket::bytesToWrite() const**

        Reimplements: **QIODevice::bytesToWrite** () const.

        Returns the number of bytes that are waiting to be written. The bytes
        are written when control goes back to the event loop or when **flush**
        () is called.

        **See also** **bytesAvailable** () and **flush** ().
        """
        ...

    def bytesAvailable(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#bytesAvailable

        **[override virtual] qint64 QAbstractSocket::bytesAvailable() const**

        Reimplements: **QIODevice::bytesAvailable** () const.

        Returns the number of incoming bytes that are waiting to be read.

        **See also** **bytesToWrite** () and **read** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#isValid

        **bool QAbstractSocket::isValid() const**

        Returns `true` if the socket is valid and ready for use; otherwise
        returns `false`.

        **Note:** The socket's state must be **ConnectedState**  before reading
        and writing can occur.

        **See also** **state** ().
        """
        ...

    def disconnectFromHost(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#disconnectFromHost

        **[virtual] void QAbstractSocket::disconnectFromHost()**

        Attempts to close the socket. If there is pending data waiting to be
        written, **QAbstractSocket**  will enter **ClosingState**  and wait
        until all data has been written. Eventually, it will enter
        **UnconnectedState**  and emit the **disconnected** () signal.

        **See also** **connectToHost** ().
        """
        ...

    @typing.overload
    def connectToHost(
        self,
        hostName: str,
        port: int,
        mode: typing.Union[
            QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag
        ] = ...,
        protocol: "QAbstractSocket.NetworkLayerProtocol" = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#connectToHost

        **[virtual] void QAbstractSocket::connectToHost(const QString & hostName
        , quint16 port , QIODevice::OpenMode openMode = ReadWrite,
        QAbstractSocket::NetworkLayerProtocol protocol = AnyIPProtocol)**

        Attempts to make a connection to **hostName** on the given **port**. The
        **protocol** parameter can be used to specify which network protocol to
        use (eg. IPv4 or IPv6).

        The socket is opened in the given **openMode** and first enters
        **HostLookupState** , then performs a host name lookup of **hostName**.
        If the lookup succeeds, **hostFound** () is emitted and
        **QAbstractSocket**  enters **ConnectingState** . It then attempts to
        connect to the address or addresses returned by the lookup. Finally, if
        a connection is established, **QAbstractSocket**  enters
        **ConnectedState**  and emits **connected** ().

        At any point, the socket can emit **errorOccurred** () to signal that an
        error occurred.

        **hostName** may be an IP address in string form (e.g., "43.195.83.32"),
        or it may be a host name (e.g., "example.com"). **QAbstractSocket**
        will do a lookup only if required. **port** is in native byte order.

        **See also** **state** (), **peerName** (), **peerAddress** (),
        **peerPort** (), and **waitForConnected** ().
        """
        ...

    @typing.overload
    def connectToHost(
        self,
        address: typing.Union["QHostAddress", "QHostAddress.SpecialAddress"],
        port: int,
        mode: typing.Union[
            QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#connectToHost-1

        **[virtual] void QAbstractSocket::connectToHost(const QHostAddress &
        address , quint16 port , QIODevice::OpenMode openMode = ReadWrite)**

        This is an overloaded function.

        Attempts to make a connection to **address** on port **port**.
        """
        ...

    @property
    def connected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#connected

        **[signal] void QAbstractSocket::connected()**

        This signal is emitted after **connectToHost** () has been called and a
        connection has been successfully established.

        **Note:** On some operating systems the connected() signal may be
        directly emitted from the **connectToHost** () call for connections to
        the localhost.

        **See also** **connectToHost** () and **disconnected** ().
        """
        ...

    @property
    def disconnected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#disconnected

        **[signal] void QAbstractSocket::disconnected()**

        This signal is emitted when the socket has been disconnected.

        **Warning:** If you need to delete the **sender** () of this signal in a
        slot connected to it, use the **deleteLater()**  function.

        **See also** **connectToHost** (), **disconnectFromHost** (), and
        **abort** ().
        """
        ...

    @property
    def errorOccurred(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#errorOccurred

        **[signal] void
        QAbstractSocket::errorOccurred(QAbstractSocket::SocketError socketError
        )**

        This signal is emitted after an error occurred. The **socketError**
        parameter describes the type of error that occurred.

        When this signal is emitted, the socket may not be ready for a reconnect
        attempt. In that case, attempts to reconnect should be done from the
        event loop. For example, use a **QTimer::singleShot** () with 0 as the
        timeout.

        **QAbstractSocket::SocketError**  is not a registered metatype, so for
        queued connections, you will have to register it with
        **Q_DECLARE_METATYPE** () and **qRegisterMetaType** ().

        This function was introduced in Qt 5.15.

        **See also** **error** (), **errorString** (), and **Creating Custom Qt
        Types** .
        """
        ...

    @property
    def hostFound(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#hostFound

        **[signal] void QAbstractSocket::hostFound()**

        This signal is emitted after **connectToHost** () has been called and
        the host lookup has succeeded.

        **Note:** Since Qt 4.6.3 **QAbstractSocket**  may emit hostFound()
        directly from the **connectToHost** () call since a DNS result could
        have been cached.

        **See also** **connected** ().
        """
        ...

    @property
    def proxyAuthenticationRequired(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#proxyAuthenticationRequired

        **[signal] void QAbstractSocket::proxyAuthenticationRequired(const
        QNetworkProxy & proxy , QAuthenticator * authenticator )**

        This signal can be emitted when a **proxy** that requires authentication
        is used. The **authenticator** object can then be filled in with the
        required details to allow authentication and continue the connection.

        **Note:** It is not possible to use a QueuedConnection to connect to
        this signal, as the connection will fail if the authenticator has not
        been filled in with new information when the signal returns.

        This function was introduced in Qt 4.3.

        **See also** **QAuthenticator**  and **QNetworkProxy** .
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractsocket.html#stateChanged

        **[signal] void
        QAbstractSocket::stateChanged(QAbstractSocket::SocketState socketState
        )**

        This signal is emitted whenever **QAbstractSocket** 's state changes.
        The **socketState** parameter is the new state.

        **QAbstractSocket::SocketState**  is not a registered metatype, so for
        queued connections, you will have to register it with
        **Q_DECLARE_METATYPE** () and **qRegisterMetaType** ().

        **See also** **state** () and **Creating Custom Qt Types** .
        """
        ...
