"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtWidgets
from PyQt5 import QtMultimedia
from PyQt5 import QtCore
from PyQt5.QtMultimediaWidgets import *


class QGraphicsVideoItem(
    QtWidgets.QGraphicsObject, QtMultimedia.QMediaBindableInterface
):
    """
    https://doc.qt.io/qt-5/qgraphicsvideoitem.html

    **Detailed Description**

    Attaching a QGraphicsVideoItem to a **QMediaObject**  allows it to display
    the video or image output of that media object. A QGraphicsVideoItem is
    attached to a media object by passing a pointer to the **QMediaObject**  to
    the **setMediaObject** () function.

    player = new **QMediaPlayer** (this);

        **QGraphicsVideoItem**  *item
    = new **QGraphicsVideoItem** ;
        player->setVideoOutput(item);
    graphicsView->scene()->addItem(item);
        graphicsView->show();
    player->setMedia(**QUrl** ("http://example.com/myclip4.ogv"));
    player->play();

    **Note** : Only a single display output can be attached to a media object at
    one time.

    **See also** **QMediaObject** , **QMediaPlayer** , and **QVideoWidget** .
    """

    def __init__(self, parent: typing.Optional[QtWidgets.QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#QGraphicsVideoItem

        **QGraphicsVideoItem::QGraphicsVideoItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a graphics item that displays video.

        The **parent** is passed to **QGraphicsItem** .
        """
        ...

    def videoSurface(self) -> QtMultimedia.QAbstractVideoSurface:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#videoSurface-prop

        **videoSurface : QAbstractVideoSurface* const**

        Returns the underlying video surface that can render video frames to the
        current item. This property is never `nullptr`. Example of how to render
        video frames to **QGraphicsVideoItem** :

        **QGraphicsVideoItem**  *item = new **QGraphicsVideoItem** ;
        graphicsView->scene()->addItem(item);
            graphicsView->show();
        **QImage**  img = **QImage** ("images/qt-
        logo.png").convertToFormat(**QImage** ::Format_ARGB32);
        **QVideoSurfaceFormat**  format(img.size(), **QVideoFrame**
        ::Format_ARGB32);
            item->videoSurface()->start(format);
        item->videoSurface()->present(img);

        This property was introduced in Qt 5.15.

        **Access functions:**

        QAbstractVideoSurface * **videoSurface** () const

        **See also** **QMediaPlayer::setVideoOutput** .

        **Member Function Documentation**
        """
        ...

    def setMediaObject(self, object: QtMultimedia.QMediaObject) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#mediaObject-prop

        **mediaObject : QMediaObject* const**

        This property holds the media object which provides the video displayed
        by a graphics item.

        **Access functions:**

        virtual QMediaObject * **mediaObject** () const override
        """
        ...

    def itemChange(
        self, change: QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any
    ) -> typing.Any:
        ...

    def timerEvent(self, event: QtCore.QTimerEvent) -> None:
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: QtWidgets.QStyleOptionGraphicsItem,
        widget: typing.Optional[QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#paint

        **[override virtual] void QGraphicsVideoItem::paint(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget = nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#boundingRect

        **[override virtual] QRectF QGraphicsVideoItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect** () const.
        """
        ...

    def nativeSize(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#nativeSize-prop

        **nativeSize : const QSizeF**

        This property holds the native size of the video.

        **Access functions:**

        QSizeF **nativeSize** () const

        **Notifier signal:**

        void ****nativeSizeChanged** ** (const QSizeF & **size** )
        """
        ...

    def setSize(self, size: QtCore.QSizeF) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#size-prop

        **size : QSizeF**

        This property holds the video item's size.

        **QGraphicsVideoItem**  will draw video scaled to fit size according to
        its fillMode.

        **Access functions:**

        QSizeF **size** () const
        void **setSize** (const QSizeF & **size** )
        """
        ...

    def size(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#size-prop

        **size : QSizeF**

        This property holds the video item's size.

        **QGraphicsVideoItem**  will draw video scaled to fit size according to
        its fillMode.

        **Access functions:**

        QSizeF **size** () const
        void **setSize** (const QSizeF & **size** )
        """
        ...

    def setOffset(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#offset-prop

        **offset : QPointF**

        This property holds the video item's offset.

        **QGraphicsVideoItem**  will draw video using the offset for its top
        left corner.

        **Access functions:**

        QPointF **offset** () const
        void **setOffset** (const QPointF &
        **offset** )
        """
        ...

    def offset(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#offset-prop

        **offset : QPointF**

        This property holds the video item's offset.

        **QGraphicsVideoItem**  will draw video using the offset for its top
        left corner.

        **Access functions:**

        QPointF **offset** () const
        void **setOffset** (const QPointF &
        **offset** )
        """
        ...

    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how a video is scaled to fit the graphics item's size.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how a video is scaled to fit the graphics item's size.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def mediaObject(self) -> QtMultimedia.QMediaObject:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#mediaObject-prop

        **mediaObject : QMediaObject* const**

        This property holds the media object which provides the video displayed
        by a graphics item.

        **Access functions:**

        virtual QMediaObject * **mediaObject** () const override
        """
        ...

    @property
    def nativeSizeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsvideoitem.html#nativeSizeChanged

        **[signal] void QGraphicsVideoItem::nativeSizeChanged(const QSizeF &
        size )**

        Signals that the native **size** of the video has changed.

        **Note:** Notifier signal for property **nativeSize** .
        """
        ...
