"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QVideoWindowControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qvideowindowcontrol.html

    **Detailed Description**

    The **winId** () property QVideoWindowControl allows a platform specific
    window ID to be set as the video render target of a **QMediaService** . The
    **displayRect** () property is used to set the region of the window the
    video should be rendered to, and the **aspectRatioMode** () property
    indicates how the video should be scaled to fit the **displayRect** ().

    **QVideoWindowControl**  *windowControl =
    mediaService->requestControl<**QVideoWindowControl**  *>();
    windowControl->setWinId(widget->winId());
    windowControl->setDisplayRect(widget->rect());
    windowControl->setAspectRatioMode(Qt::KeepAspectRatio);

    QVideoWindowControl is one of a number of possible video output controls.

    The interface name of QVideoWindowControl is `org.qt-
    project.qt.videowindowcontrol/5.0` as defined in **QVideoWindowControl_iid**
    .

    **See also** **QMediaService::requestControl** () and **QVideoWidget** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#QVideoWindowControl

        **[protected] QVideoWindowControl::QVideoWindowControl(QObject * parent
        = nullptr)**

        Constructs a new video window control with the given **parent**.
        """
        ...

    def setSaturation(self, saturation: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#setSaturation

        **[pure virtual] void QVideoWindowControl::setSaturation(int saturation
        )**

        Sets a **saturation** adjustment for a video overlay.

        Valid saturation values range between -100 and 100, the default is 0.

        **See also** **saturation** ().
        """
        ...

    def saturation(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#saturation

        **[pure virtual] int QVideoWindowControl::saturation() const**

        Returns the saturation adjustment applied to a video overlay.

        Value saturation values range between -100 and 100, the default is 0.

        **See also** **setSaturation** ().
        """
        ...

    def setHue(self, hue: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#setHue

        **[pure virtual] void QVideoWindowControl::setHue(int hue )**

        Sets a **hue** adjustment for a video overlay.

        Valid hue values range between -100 and 100, the default is 0.

        **See also** **hue** ().
        """
        ...

    def hue(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#hue

        **[pure virtual] int QVideoWindowControl::hue() const**

        Returns the hue adjustment applied to a video overlay.

        Value hue values range between -100 and 100, the default is 0.

        **See also** **setHue** ().
        """
        ...

    def setContrast(self, contrast: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#setContrast

        **[pure virtual] void QVideoWindowControl::setContrast(int contrast )**

        Sets the **contrast** adjustment for a video overlay.

        Valid contrast values range between -100 and 100, the default is 0.

        **See also** **contrast** ().
        """
        ...

    def contrast(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#contrast

        **[pure virtual] int QVideoWindowControl::contrast() const**

        Returns the contrast adjustment applied to a video overlay.

        Valid contrast values range between -100 and 100, the default is 0.

        **See also** **setContrast** ().
        """
        ...

    def setBrightness(self, brightness: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#setBrightness

        **[pure virtual] void QVideoWindowControl::setBrightness(int brightness
        )**

        Sets a **brightness** adjustment for a video overlay.

        Valid brightness values range between -100 and 100, the default is 0.

        **See also** **brightness** ().
        """
        ...

    def brightness(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#brightness

        **[pure virtual] int QVideoWindowControl::brightness() const**

        Returns the brightness adjustment applied to a video overlay.

        Valid brightness values range between -100 and 100, the default is 0.

        **See also** **setBrightness** ().
        """
        ...

    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#setAspectRatioMode

        **[pure virtual] void
        QVideoWindowControl::setAspectRatioMode(Qt::AspectRatioMode mode )**

        Sets the aspect ratio **mode** which determines how video is scaled to
        the fit the display region with respect to its aspect ratio.

        **See also** **aspectRatioMode** ().
        """
        ...

    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#aspectRatioMode

        **[pure virtual] Qt::AspectRatioMode
        QVideoWindowControl::aspectRatioMode() const**

        Returns how video is scaled to fit the display region with respect to
        its aspect ratio.

        **See also** **setAspectRatioMode** ().
        """
        ...

    def nativeSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#nativeSize

        **[pure virtual] QSize QVideoWindowControl::nativeSize() const**

        Returns a suggested size for the video display based on the resolution
        and aspect ratio of the video.
        """
        ...

    def repaint(self) -> None:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#repaint

        **[pure virtual] void QVideoWindowControl::repaint()**

        Repaints the last frame.
        """
        ...

    def setFullScreen(self, fullScreen: bool) -> None:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#setFullScreen

        **[pure virtual] void QVideoWindowControl::setFullScreen(bool fullScreen
        )**

        Sets whether a video overlay is a **fullScreen** overlay.

        **See also** **isFullScreen** ().
        """
        ...

    def isFullScreen(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#isFullScreen

        **[pure virtual] bool QVideoWindowControl::isFullScreen() const**

        Identifies if a video overlay is a fullScreen overlay.

        Returns true if the video overlay is fullScreen, and false otherwise.
        """
        ...

    def setDisplayRect(self, rect: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#setDisplayRect

        **[pure virtual] void QVideoWindowControl::setDisplayRect(const QRect &
        rect )**

        Sets the sub- **rect** of a window where video is displayed.

        **See also** **displayRect** ().
        """
        ...

    def displayRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#displayRect

        **[pure virtual] QRect QVideoWindowControl::displayRect() const**

        Returns the sub-rect of a window where video is displayed.

        **See also** **setDisplayRect** ().
        """
        ...

    def setWinId(self, id: PyQt5.sip.voidptr) -> None:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#setWinId

        **[pure virtual] void QVideoWindowControl::setWinId(WId id )**

        Sets the **id** of the window a video overlay end point renders to.

        **See also** **winId** ().
        """
        ...

    def winId(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#winId

        **[pure virtual] WId QVideoWindowControl::winId() const**

        Returns the ID of the window a video overlay end point renders to.

        **See also** **setWinId** ().
        """
        ...

    @property
    def brightnessChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#brightnessChanged

        **[signal] void QVideoWindowControl::brightnessChanged(int brightness
        )**

        Signals that a video overlay's **brightness** adjustment has changed.
        """
        ...

    @property
    def contrastChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#contrastChanged

        **[signal] void QVideoWindowControl::contrastChanged(int contrast )**

        Signals that a video overlay's **contrast** adjustment has changed.
        """
        ...

    @property
    def fullScreenChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#fullScreenChanged

        **[signal] void QVideoWindowControl::fullScreenChanged(bool fullScreen
        )**

        Signals that the **fullScreen** state of a video overlay has changed.
        """
        ...

    @property
    def hueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#hueChanged

        **[signal] void QVideoWindowControl::hueChanged(int hue )**

        Signals that a video overlay's **hue** adjustment has changed.
        """
        ...

    @property
    def nativeSizeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#nativeSizeChanged

        **[signal] void QVideoWindowControl::nativeSizeChanged()**

        Signals that the native dimensions of the video have changed.
        """
        ...

    @property
    def saturationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowindowcontrol.html#saturationChanged

        **[signal] void QVideoWindowControl::saturationChanged(int saturation
        )**

        Signals that a video overlay's **saturation** adjustment has changed.
        """
        ...
