"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QVideoProbe(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qvideoprobe.html

    **Detailed Description**

    **QMediaPlayer**  *player = new **QMediaPlayer** ();
        **QVideoProbe**
    *probe = new **QVideoProbe** ;

        connect(probe,
    SIGNAL(videoFrameProbed(**QVideoFrame** )), this,
    SLOT(processFrame(**QVideoFrame** )));

        probe->setSource(player); //
    Returns true, hopefully.

        player->setVideoOutput(myVideoSurface);
    player->setMedia(**QUrl** ::fromLocalFile("observation.mp4"));
    player->play(); // Start receiving frames as they get presented to
    myVideoSurface

    This same approach works with the **QCamera**  object as well, to receive
    viewfinder or video frames as they are captured.

    **See also** **QAudioProbe** , **QMediaPlayer** , and **QCamera** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qvideoprobe.html#QVideoProbe

        **QVideoProbe::QVideoProbe(QObject * parent = nullptr)**

        Creates a new QVideoProbe class with **parent**. After setting the
        source to monitor with **setSource** (), the **videoFrameProbed** ()
        signal will be emitted when video frames are flowing in the source media
        object.
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvideoprobe.html#isActive

        **bool QVideoProbe::isActive() const**

        Returns true if this probe is monitoring something, or false otherwise.

        The source being monitored does not need to be active.
        """
        ...

    @typing.overload
    def setSource(self, source: QMediaObject) -> bool:
        """
        https://doc.qt.io/qt-5/qvideoprobe.html#setSource

        **bool QVideoProbe::setSource(QMediaObject * source )**

        Sets the media object to monitor to **source**.

        If **source** is zero, this probe will be deactivated and this function
        wil return true.

        If the media object does not support monitoring video, this function
        will return false.

        Any previously monitored objects will no longer be monitored. Passing in
        the same object will be ignored, but monitoring will continue.
        """
        ...

    @typing.overload
    def setSource(self, source: QMediaRecorder) -> bool:
        """
        https://doc.qt.io/qt-5/qvideoprobe.html#setSource-1

        **bool QVideoProbe::setSource(QMediaRecorder * mediaRecorder )**

        Starts monitoring the given **mediaRecorder**.

        If there is no mediaObject associated with **mediaRecorder** , or if it
        is zero, this probe will be deactivated and this function wil return
        true.

        If the media recorder instance does not support monitoring video, this
        function will return false.

        Any previously monitored objects will no longer be monitored. Passing in
        the same object will be ignored, but monitoring will continue.
        """
        ...

    @property
    def flush(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideoprobe.html#flush

        **[signal] void QVideoProbe::flush()**

        This signal should be emitted when it is required to release all frames.
        Application must release all outstanding references to video frames.
        """
        ...

    @property
    def videoFrameProbed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideoprobe.html#videoFrameProbed

        **[signal] void QVideoProbe::videoFrameProbed(const QVideoFrame & frame
        )**

        This signal should be emitted when a video **frame** is processed in the
        media service.
        """
        ...
