"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QSound(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qsound.html

    **Detailed Description**

    Qt provides the most commonly required audio operation in GUI applications:
    asynchronously playing a sound file. This is most easily accomplished using
    the static **play** () function:

    **QSound** ::play("mysounds/bells.wav");

    Alternatively, create a QSound object from the sound file first and then
    call the **play** () slot:

    **QSound**  bells("mysounds/bells.wav");
        bells.play();

    In both cases, the file may either be a local file or in a **resource** .

    Once created a QSound object can be queried for its **fileName** () and
    total number of **loops** () (i.e. the number of times the sound will play).
    The number of repetitions can be altered using the **setLoops** () function.
    While playing the sound, the **loopsRemaining** () function returns the
    remaining number of repetitions. Use the **isFinished** () function to
    determine whether the sound has finished playing.

    Sounds played using a QSound object may use more memory than the static
    **play** () function, but it may also play more immediately (depending on
    the underlying platform audio facilities).

    If you require finer control over playing sounds, consider the
    **QSoundEffect**  or **QAudioOutput**  classes.

    **See also** **QSoundEffect** .
    """

    class Loop(int):
        Infinite: QSound = ...

    def __init__(
        self, filename: str, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsound.html#QSound

        **QSound::QSound(const QString & filename , QObject * parent =
        nullptr)**

        Constructs a QSound object from the file specified by the given
        **filename** and with the given **parent**.

        The file can either be a local file or in a **resource** .

        **See also** **play** ().
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qsound.html#stop

        **[slot] void QSound::stop()**

        Stops the sound playing.

        **See also** **play** ().
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsound.html#isFinished

        **bool QSound::isFinished() const**

        Returns true if the sound has finished playing; otherwise returns false.
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-5/qsound.html#fileName

        **QString QSound::fileName() const**

        Returns the filename associated with this **QSound**  object.

        **See also** **QSound** ().
        """
        ...

    def setLoops(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qsound.html#setLoops

        **void QSound::setLoops(int number )**

        Sets the sound to repeat the given **number** of times when it is
        played.

        Note that passing the value `QSound::Infinite` will cause the sound to
        loop indefinitely.

        **See also** **loops** ().
        """
        ...

    def loopsRemaining(self) -> int:
        """
        https://doc.qt.io/qt-5/qsound.html#loopsRemaining

        **int QSound::loopsRemaining() const**

        Returns the remaining number of times the sound will loop (for all
        positive values this value decreases each time the sound is played).
        Return value of `QSound::Infinite` indicates infinite number of loops

        **See also** **loops** () and **isFinished** ().
        """
        ...

    def loops(self) -> int:
        """
        https://doc.qt.io/qt-5/qsound.html#loops

        **int QSound::loops() const**

        Returns the number of times the sound will play. Return value of
        `QSound::Infinite` indicates infinite number of loops

        **See also** **loopsRemaining** () and **setLoops** ().
        """
        ...

    @typing.overload
    @staticmethod
    def play(filename: str) -> None:
        """
        https://doc.qt.io/qt-5/qsound.html#play

        **[static] void QSound::play(const QString & filename )**

        Plays the sound stored in the file specified by the given **filename**.

        The file can either be a local file or in a **resource** .

        **See also** **stop** (), **loopsRemaining** (), and **isFinished** ().
        """
        ...

    @typing.overload
    def play(self) -> None:
        """
        https://doc.qt.io/qt-5/qsound.html#play-1

        **[slot] void QSound::play()**

        This is an overloaded function.

        Starts playing the sound specified by this **QSound**  object.

        The function returns immediately. Depending on the platform audio
        facilities, other sounds may stop or be mixed with the new sound. The
        sound can be played again at any time, possibly mixing or replacing
        previous plays of the sound.

        **See also** **fileName** ().
        """
        ...
