"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QRadioTuner(QMediaObject):
    """
    https://doc.qt.io/qt-5/qradiotuner.html

    **Detailed Description**

    You can control the systems analog radio device using this interface, for
    example:

    radio = new **QRadioTuner** ;
        connect(radio,
    SIGNAL(frequencyChanged(int)), this, SLOT(freqChanged(int)));
        if
    (radio->isBandSupported(**QRadioTuner** ::FM)) {
    radio->setBand(**QRadioTuner** ::FM);
    radio->setFrequency(yourRadioStationFrequency);
    radio->setVolume(100);
            radio->start();
        }

    The radio object will emit signals for any changes in state such as:
    **bandChanged** (), **frequencyChanged** (), **stereoStatusChanged** (),
    **searchingChanged** (), **signalStrengthChanged** (), **volumeChanged** (),
    **mutedChanged** ().

    You can change between the frequency bands using **setBand** () however it
    is recommended that you check to make sure the band is available first using
    **isBandSupported** ().

    **See also** **QRadioData**  and **Radio Overview** .
    """

    class SearchMode(int):
        SearchFast: QRadioTuner = ...
        SearchGetStationId: QRadioTuner = ...

    class StereoMode(int):
        ForceStereo: QRadioTuner = ...
        ForceMono: QRadioTuner = ...
        Auto: QRadioTuner = ...

    class Error(int):
        NoError: QRadioTuner = ...
        ResourceError: QRadioTuner = ...
        OpenError: QRadioTuner = ...
        OutOfRangeError: QRadioTuner = ...

    class Band(int):
        AM: QRadioTuner = ...
        FM: QRadioTuner = ...
        SW: QRadioTuner = ...
        LW: QRadioTuner = ...
        FM2: QRadioTuner = ...

    class State(int):
        ActiveState: QRadioTuner = ...
        StoppedState: QRadioTuner = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#QRadioTuner

        **QRadioTuner::QRadioTuner(QObject * parent = nullptr)**

        Constructs a radio tuner based on a media service allocated by the
        default media service provider.

        The **parent** is passed to **QMediaObject** .
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#stop

        **[slot] void QRadioTuner::stop()**

        Deactivate the radio device.
        """
        ...

    def start(self) -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#start

        **[slot] void QRadioTuner::start()**

        Activate the radio device.
        """
        ...

    def setMuted(self, muted: bool) -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#muted-prop

        **muted : bool**

        This property holds whether a radio tuner's audio output is muted.

        **Access functions:**

        bool **isMuted** () const
        void **setMuted** (bool **muted** )

        **Notifier signal:**

        void ****mutedChanged** ** (bool **muted** )
        """
        ...

    def setVolume(self, volume: int) -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#volume-prop

        **volume : int**

        This property holds the volume of a radio tuner's audio output as a
        percentage.

        **Access functions:**

        int **volume** () const
        void **setVolume** (int **volume** )

        **Notifier signal:**

        void ****volumeChanged** ** (int **volume** )

        **Member Function Documentation**
        """
        ...

    def setFrequency(self, frequency: int) -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#setFrequency

        **[slot] void QRadioTuner::setFrequency(int frequency )**

        Sets a radio tuner's **frequency**.

        If the tuner is set to a frequency outside the current **band** , the
        band will be changed to one occupied by the new frequency.

        **Note:** Setter function for property **frequency** .

        **See also** **frequency** ().
        """
        ...

    def setBand(self, band: "QRadioTuner.Band") -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#setBand

        **[slot] void QRadioTuner::setBand(QRadioTuner::Band band )**

        Sets a radio tuner's frequency **band**.

        Changing the band will reset the **frequency**  to the new band's
        minimum frequency.

        **Note:** Setter function for property **band** .

        **See also** **band** ().
        """
        ...

    def cancelSearch(self) -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#cancelSearch

        **[slot] void QRadioTuner::cancelSearch()**

        Stops scanning for a signal.

        **See also** **searchForward** (), **searchBackward** (), and
        **searching** .
        """
        ...

    def searchAllStations(self, searchMode: "QRadioTuner.SearchMode" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#searchAllStations

        **[slot] void QRadioTuner::searchAllStations(QRadioTuner::SearchMode
        searchMode = QRadioTuner::SearchFast)**

        Search all stations in current band

        Emits **QRadioTuner::stationFound** (int, **QString** ) for every found
        station. After searching is completed, **QRadioTuner::searchingChanged**
        (bool) is emitted (false). If **searchMode** is set to
        **SearchGetStationId** , searching waits for station id (PI) on each
        frequency.

        **See also** **searchForward** (), **searchBackward** (), and
        **searching** .
        """
        ...

    def searchBackward(self) -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#searchBackward

        **[slot] void QRadioTuner::searchBackward()**

        Starts a backwards scan for a signal, starting from the current
        **frequency** .

        **See also** **searchForward** (), **cancelSearch** (), and
        **searching** .
        """
        ...

    def searchForward(self) -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#searchForward

        **[slot] void QRadioTuner::searchForward()**

        Starts a forward scan for a signal, starting from the current
        **frequency** .

        **See also** **searchBackward** (), **cancelSearch** (), and
        **searching** .
        """
        ...

    def radioData(self) -> QRadioData:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#radioData-prop

        **radioData : QRadioData* const**

        holds an instance of **QRadioData**

        The instance of QRadioData is already bound to this instance of
        **QRadioTuner** .

        **Access functions:**

        QRadioData * **radioData** () const
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#errorString

        **QString QRadioTuner::errorString() const**

        Returns a description of a radio tuner's error state.

        **See also** **error** ().
        """
        ...

    def isAntennaConnected(self) -> bool:
        ...

    def isSearching(self) -> bool:
        ...

    def isMuted(self) -> bool:
        ...

    def volume(self) -> int:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#volume-prop

        **volume : int**

        This property holds the volume of a radio tuner's audio output as a
        percentage.

        **Access functions:**

        int **volume** () const
        void **setVolume** (int **volume** )

        **Notifier signal:**

        void ****volumeChanged** ** (int **volume** )

        **Member Function Documentation**
        """
        ...

    def signalStrength(self) -> int:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#signalStrength-prop

        **signalStrength : const int**

        This property holds the strength of the current radio signal as a
        percentage.

        **Access functions:**

        int **signalStrength** () const

        **Notifier signal:**

        void ****signalStrengthChanged** ** (int **strength** )
        """
        ...

    def stereoMode(self) -> "QRadioTuner.StereoMode":
        """
        https://doc.qt.io/qt-5/qradiotuner.html#stereoMode-prop

        **stereoMode : StereoMode**

        This property holds the stereo mode of a radio tuner.

        **Access functions:**

        QRadioTuner::StereoMode **stereoMode** () const
        void **setStereoMode**
        (QRadioTuner::StereoMode **mode** )
        """
        ...

    def setStereoMode(self, mode: "QRadioTuner.StereoMode") -> None:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#stereoMode-prop

        **stereoMode : StereoMode**

        This property holds the stereo mode of a radio tuner.

        **Access functions:**

        QRadioTuner::StereoMode **stereoMode** () const
        void **setStereoMode**
        (QRadioTuner::StereoMode **mode** )
        """
        ...

    def isStereo(self) -> bool:
        ...

    def frequencyRange(self, band: "QRadioTuner.Band") -> typing.Tuple[int, int]:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#frequencyRange

        **QPair<int, int> QRadioTuner::frequencyRange(QRadioTuner::Band band )
        const**

        Returns a frequency **band** 's minimum and maximum frequency.
        """
        ...

    def frequencyStep(self, band: "QRadioTuner.Band") -> int:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#frequencyStep

        **int QRadioTuner::frequencyStep(QRadioTuner::Band band ) const**

        Returns the number of Hertz to increment the frequency by when stepping
        through frequencies within a given **band**.
        """
        ...

    def frequency(self) -> int:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#frequency-prop

        **frequency : int**

        This property holds the frequency in Hertz a radio tuner is tuned to.

        **Access functions:**

        int **frequency** () const
        void ****setFrequency** ** (int
        **frequency** )

        **Notifier signal:**

        void ****frequencyChanged** ** (int **frequency** )
        """
        ...

    def isBandSupported(self, b: "QRadioTuner.Band") -> bool:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#isBandSupported

        **bool QRadioTuner::isBandSupported(QRadioTuner::Band band ) const**

        Identifies if a frequency **band** is supported by a radio tuner.

        Returns true if the band is supported, and false if it is not.
        """
        ...

    def band(self) -> "QRadioTuner.Band":
        """
        https://doc.qt.io/qt-5/qradiotuner.html#band-prop

        **band : Band**

        This property holds the frequency band a radio tuner is tuned to.

        **Access functions:**

        QRadioTuner::Band **band** () const
        void ****setBand** **
        (QRadioTuner::Band **band** )

        **Notifier signal:**

        void ****bandChanged** ** (QRadioTuner::Band **band** )

        **See also** **QRadioTuner::Band** .
        """
        ...

    def state(self) -> "QRadioTuner.State":
        """
        https://doc.qt.io/qt-5/qradiotuner.html#state-prop

        **state : const State**

        Return the current radio tuner state.

        **Access functions:**

        QRadioTuner::State **state** () const

        **Notifier signal:**

        void ****stateChanged** ** (QRadioTuner::State **state** )

        **See also** **QRadioTuner::State** .
        """
        ...

    def availability(self) -> QMultimedia.AvailabilityStatus:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#availability

        **[override virtual] QMultimedia::AvailabilityStatus
        QRadioTuner::availability() const**

        Reimplements: **QMediaObject::availability** () const.

        Returns the availability of the radio tuner.
        """
        ...

    @property
    def antennaConnectedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def bandChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#bandChanged

        **[signal] void QRadioTuner::bandChanged(QRadioTuner::Band band )**

        Signals a radio tuner's **band** has changed.

        **Note:** Notifier signal for property **band** .
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#error

        **QRadioTuner::Error QRadioTuner::error() const**

        Returns the error state of a radio tuner.

        **See also** **errorString** ().
        """
        ...

    @property
    def frequencyChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#frequencyChanged

        **[signal] void QRadioTuner::frequencyChanged(int frequency )**

        Signals that the **frequency** a radio tuner is tuned to has changed.

        **Note:** Notifier signal for property **frequency** .
        """
        ...

    @property
    def mutedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#mutedChanged

        **[signal] void QRadioTuner::mutedChanged(bool muted )**

        Signals that the **muted** state of a radio tuner's audio output has
        changed.

        **Note:** Notifier signal for property **muted** .
        """
        ...

    @property
    def searchingChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#searchingChanged

        **[signal] void QRadioTuner::searchingChanged(bool searching )**

        Signals that the **searching** state of a radio tuner has changed.

        **Note:** Notifier signal for property **searching** .
        """
        ...

    @property
    def signalStrengthChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#signalStrengthChanged

        **[signal] void QRadioTuner::signalStrengthChanged(int strength )**

        Signals that the **strength** of the signal received by a radio tuner
        has changed.

        **Note:** Notifier signal for property **signalStrength** .
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#stateChanged

        **[signal] void QRadioTuner::stateChanged(QRadioTuner::State state )**

        This signal is emitted when the state changes to **state**.

        **Note:** Notifier signal for property **state** .
        """
        ...

    @property
    def stationFound(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#stationFound

        **[signal] void QRadioTuner::stationFound(int frequency , QString
        stationId )**

        Signals that a station was found in **frequency** with **stationId**
        Program Identification code.
        """
        ...

    @property
    def stereoStatusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#stereoStatusChanged

        **[signal] void QRadioTuner::stereoStatusChanged(bool stereo )**

        Signals that the **stereo** state of a radio tuner has changed.

        **Note:** Notifier signal for property **stereo** .
        """
        ...

    @property
    def volumeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotuner.html#volumeChanged

        **[signal] void QRadioTuner::volumeChanged(int volume )**

        Signals that the **volume** of a radio tuner's audio output has changed.

        **Note:** Notifier signal for property **volume** .
        """
        ...
