"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMetaDataReaderControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qmetadatareadercontrol.html

    **Detailed Description**

    If a **QMediaService**  can provide read or write access to the meta-data of
    its current media it will implement QMetaDataReaderControl. This control
    provides functions for both retrieving and setting meta-data values. Meta-
    data may be addressed by the keys defined in the **QMediaMetaData**
    namespace.

    The functionality provided by this control is exposed to application code by
    the meta-data members of **QMediaObject** , and so meta-data access is
    potentially available in any of the media object classes. Any media service
    may implement QMetaDataReaderControl.

    The interface name of QMetaDataReaderControl is `org.qt-
    project.qt.metadatareadercontrol/5.0` as defined in
    **QMetaDataReaderControl_iid** .

    **See also** **QMediaService::requestControl** () and **QMediaObject** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmetadatareadercontrol.html#QMetaDataReaderContro
        l

        **[protected] QMetaDataReaderControl::QMetaDataReaderControl(QObject *
        parent = nullptr)**

        Construct a QMetaDataReaderControl with **parent**. This class is meant
        as a base class for service specific meta data providers so this
        constructor is protected.
        """
        ...

    def availableMetaData(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmetadatareadercontrol.html#availableMetaData

        **[pure virtual] QStringList QMetaDataReaderControl::availableMetaData()
        const**

        Returns a list of keys there is meta-data available for.
        """
        ...

    def metaData(self, key: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmetadatareadercontrol.html#metaData

        **[pure virtual] QVariant QMetaDataReaderControl::metaData(const QString
        & key ) const**

        Returns the meta-data for the given **key**.
        """
        ...

    def isMetaDataAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmetadatareadercontrol.html#isMetaDataAvailable

        **[pure virtual] bool QMetaDataReaderControl::isMetaDataAvailable()
        const**

        Identifies if meta-data is available from a media service.

        Returns true if the meta-data is available and false otherwise.
        """
        ...

    @property
    def metaDataAvailableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmetadatareadercontrol.html#metaDataAvailableChan
        ged

        **[signal] void QMetaDataReaderControl::metaDataAvailableChanged(bool
        available )**

        Signal the availability of meta-data has changed, **available** will be
        true if the multimedia object has meta-data.
        """
        ...

    @property
    def metaDataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmetadatareadercontrol.html#metaDataChanged

        **[signal] void QMetaDataReaderControl::metaDataChanged()**

        Signal the changes of meta-data.

        If multiple meta-data elements are changed, metaDataChanged(const
        **QString**  &key, const **QVariant**  &value) signal is emitted for
        each of them with metaDataChanged() changed emitted once.

        **Note:** Signal **metaDataChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(metaDataReaderControl,
        QOverload<>::of(&**QMetaDataReaderControl** ::metaDataChanged),
        [=](){ /* ... */ });
        """
        ...

    @property
    def metaDataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmetadatareadercontrol.html#metaDataChanged-1

        **[signal] void QMetaDataReaderControl::metaDataChanged(const QString &
        key , const QVariant & value )**

        Signal the changes of one meta-data element **value** with the given
        **key**.

        **Note:** Signal **metaDataChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(metaDataReaderControl, QOverload<const **QString**  &, const
        **QVariant**  &>::of(&**QMetaDataReaderControl** ::metaDataChanged),
        [=](const **QString**  &key, const **QVariant**  &value){ /* ... */ });
        """
        ...
