"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaService(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qmediaservice.html

    **Detailed Description**

    Media services provide implementations of the functionality promised by
    media objects, and allow multiple providers to implement a **QMediaObject**
    .

    To provide the functionality of a **QMediaObject**  media services implement
    **QMediaControl**  interfaces. Services typically implement one core media
    control which provides the core feature of a media object, and some number
    of additional controls which provide either optional features of the media
    object, or features of a secondary media object or peripheral object.

    A pointer to media service's **QMediaControl**  implementation can be
    obtained by passing the control's interface name to the **requestControl**
    () function.

    **QMediaPlayerControl**  *control = qobject_cast<**QMediaPlayerControl**
    *>(
                mediaService->requestControl("org.qt-
    project.qt.mediaplayercontrol/5.0"));

    Media objects can use services loaded dynamically from plug-ins or
    implemented statically within an applications. Plug-in based services should
    also implement the **QMediaServiceProviderPlugin**  interface. Static
    services should implement the QMediaServiceProvider interface. In general,
    implementing a QMediaService is outside of the scope of this documentation
    and support on the relevant mailing lists or IRC channels should be sought.

    **See also** **QMediaObject**  and **QMediaControl** .
    """

    def __init__(self, parent: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-5/qmediaservice.html#QMediaService

        **[protected] QMediaService::QMediaService(QObject * parent )**

        Construct a media service with the given **parent**. This class is meant
        as a base class for Multimedia services so this constructor is
        protected.
        """
        ...

    def releaseControl(self, control: QMediaControl) -> None:
        """
        https://doc.qt.io/qt-5/qmediaservice.html#releaseControl

        **[pure virtual] void QMediaService::releaseControl(QMediaControl *
        control )**

        Releases a **control** back to the service.
        """
        ...

    def requestControl(self, name: str) -> QMediaControl:
        """
        https://doc.qt.io/qt-5/qmediaservice.html#requestControl

        **[pure virtual] QMediaControl *QMediaService::requestControl(const char
        * interface )**

        Returns a pointer to the media control implementing **interface**.

        If the service does not implement the control, or if it is unavailable a
        null pointer is returned instead.

        Controls must be returned to the service when no longer needed using the
        **releaseControl** () function.
        """
        ...
