"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaRecorderControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qmediarecordercontrol.html

    **Detailed Description**

    Generally you will use the **QMediaRecorder**  class in application code -
    this class is mostly used when implementing a new **QMediaService**  or if
    there is access to specific low level functionality not otherwise present in
    **QMediaRecorder** .

    If a **QMediaService**  can record media it will implement
    QMediaRecorderControl. This control provides a means to set the **output
    location** , and record, pause and stop recording via the **setState** ()
    method. It also provides feedback on the **duration**  of the recording.

    The interface name of QMediaRecorderControl is `org.qt-
    project.qt.mediarecordercontrol/5.0` as defined in
    **QMediaRecorderControl_iid** .

    **See also** **QMediaService::requestControl** () and **QMediaRecorder** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#QMediaRecorderControl

        **[protected] QMediaRecorderControl::QMediaRecorderControl(QObject *
        parent = nullptr)**

        Constructs a media recorder control with the given **parent**.
        """
        ...

    def setVolume(self, volume: float) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#setVolume

        **[pure virtual slot] void QMediaRecorderControl::setVolume(qreal volume
        )**

        Sets the audio **volume** of a media recorder control.

        The volume is scaled linearly, ranging from `0` (silence) to `100` (full
        volume).

        **See also** **volume** ().
        """
        ...

    def setMuted(self, muted: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#setMuted

        **[pure virtual slot] void QMediaRecorderControl::setMuted(bool muted
        )**

        Sets the **muted** state of a media recorder.

        **See also** **isMuted** ().
        """
        ...

    def setState(self, state: QMediaRecorder.State) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#setState

        **[pure virtual slot] void
        QMediaRecorderControl::setState(QMediaRecorder::State state )**

        Set the media recorder **state**.

        **See also** **state** ().
        """
        ...

    def applySettings(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#applySettings

        **[pure virtual] void QMediaRecorderControl::applySettings()**

        Commits the encoder settings and performs pre-initialization to reduce
        delays when recording is started.
        """
        ...

    def volume(self) -> float:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#volume

        **[pure virtual] qreal QMediaRecorderControl::volume() const**

        Returns the audio volume of a media recorder control.

        **See also** **setVolume** ().
        """
        ...

    def isMuted(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#isMuted

        **[pure virtual] bool QMediaRecorderControl::isMuted() const**

        Returns true if the recorder is muted, and false if it is not.
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#duration

        **[pure virtual] qint64 QMediaRecorderControl::duration() const**

        Return the current duration in milliseconds.
        """
        ...

    def status(self) -> QMediaRecorder.Status:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#status

        **[pure virtual] QMediaRecorder::Status QMediaRecorderControl::status()
        const**

        Return the current recording status.
        """
        ...

    def state(self) -> QMediaRecorder.State:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#state

        **[pure virtual] QMediaRecorder::State QMediaRecorderControl::state()
        const**

        Return the current recording state.

        **See also** **setState** ().
        """
        ...

    def setOutputLocation(self, location: QtCore.QUrl) -> bool:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#setOutputLocation

        **[pure virtual] bool QMediaRecorderControl::setOutputLocation(const
        QUrl & location )**

        Sets the output **location** and returns if this operation is
        successful. If file at the output location already exists, it should be
        overwritten.

        The **location** can be relative or empty; in this case the service
        should use the system specific place and file naming scheme.

        After recording has started, the backend should report the actual file
        location with **actualLocationChanged** () signal.

        **See also** **outputLocation** ().
        """
        ...

    def outputLocation(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#outputLocation

        **[pure virtual] QUrl QMediaRecorderControl::outputLocation() const**

        Returns the current output location being used.

        **See also** **setOutputLocation** ().
        """
        ...

    @property
    def actualLocationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#actualLocationChanged

        **[signal] void QMediaRecorderControl::actualLocationChanged(const QUrl
        & location )**

        Signals that the actual media **location** has changed. This signal
        should be emitted at start of recording.
        """
        ...

    @property
    def durationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#durationChanged

        **[signal] void QMediaRecorderControl::durationChanged(qint64 duration
        )**

        Signals that the **duration** of the recorded media has changed.

        This only emitted when there is a discontinuous change in the duration
        such as being reset to 0.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#error

        **[signal] void QMediaRecorderControl::error(int error , const QString &
        errorString )**

        Signals that an **error** has occurred. The **errorString** describes
        the error.
        """
        ...

    @property
    def mutedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#mutedChanged

        **[signal] void QMediaRecorderControl::mutedChanged(bool muted )**

        Signals that the **muted** state of a media recorder has changed.
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#stateChanged

        **[signal] void
        QMediaRecorderControl::stateChanged(QMediaRecorder::State state )**

        Signals that the **state** of a media recorder has changed.
        """
        ...

    @property
    def statusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#statusChanged

        **[signal] void
        QMediaRecorderControl::statusChanged(QMediaRecorder::Status status )**

        Signals that the **status** of a media recorder has changed.
        """
        ...

    @property
    def volumeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecordercontrol.html#volumeChanged

        **[signal] void QMediaRecorderControl::volumeChanged(qreal gain )**

        Signals that the audio **gain** value has changed.
        """
        ...
