"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtNetwork
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaPlaylist(QtCore.QObject, QMediaBindableInterface):
    """
    https://doc.qt.io/qt-5/qmediaplaylist.html

    **Detailed Description**

    QMediaPlaylist is intended to be used with other media objects, like
    **QMediaPlayer** .

    QMediaPlaylist allows to access the service intrinsic playlist functionality
    if available, otherwise it provides the local memory playlist
    implementation.

    playlist = new **QMediaPlaylist** ;
        playlist->addMedia(**QUrl**
    ("http://example.com/movie1.mp4"));
        playlist->addMedia(**QUrl**
    ("http://example.com/movie2.mp4"));
        playlist->addMedia(**QUrl**
    ("http://example.com/movie3.mp4"));
        playlist->setCurrentIndex(1);
    player = new **QMediaPlayer** ;
        player->setPlaylist(playlist);
    videoWidget = new **QVideoWidget** ;
    player->setVideoOutput(videoWidget);
        videoWidget->show();
    player->play();

    Depending on playlist source implementation, most of the playlist mutating
    operations can be asynchronous.

    **See also** **QMediaContent** .
    """

    class Error(int):
        NoError: QMediaPlaylist = ...
        FormatError: QMediaPlaylist = ...
        FormatNotSupportedError: QMediaPlaylist = ...
        NetworkError: QMediaPlaylist = ...
        AccessDeniedError: QMediaPlaylist = ...

    class PlaybackMode(int):
        CurrentItemOnce: QMediaPlaylist = ...
        CurrentItemInLoop: QMediaPlaylist = ...
        Sequential: QMediaPlaylist = ...
        Loop: QMediaPlaylist = ...
        Random: QMediaPlaylist = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#QMediaPlaylist

        **QMediaPlaylist::QMediaPlaylist(QObject * parent = nullptr)**

        Create a new playlist object with the given **parent**.
        """
        ...

    def setMediaObject(self, object: QMediaObject) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#mediaObject

        **[override virtual] QMediaObject *QMediaPlaylist::mediaObject() const**

        Reimplements: **QMediaBindableInterface::mediaObject** () const.

        Returns the **QMediaObject**  instance that this **QMediaPlaylist**  is
        bound too, or 0 otherwise.
        """
        ...

    def setCurrentIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#setCurrentIndex

        **[slot] void QMediaPlaylist::setCurrentIndex(int playlistPosition )**

        Activate media content from playlist at position **playlistPosition**.

        **Note:** Setter function for property **currentIndex** .

        **See also** **currentIndex** ().
        """
        ...

    def previous(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#previous

        **[slot] void QMediaPlaylist::previous()**

        Return to the previous media content in playlist.
        """
        ...

    def next(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#next

        **[slot] void QMediaPlaylist::next()**

        Advance to the next media content in playlist.
        """
        ...

    def shuffle(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#shuffle

        **[slot] void QMediaPlaylist::shuffle()**

        Shuffle items in the playlist.
        """
        ...

    def moveMedia(self, from_: int, to: int) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#moveMedia

        **bool QMediaPlaylist::moveMedia(int from , int to )**

        Move the item from position **from** to position **to**.

        Returns true if the operation is successful, otherwise false.

        This function was introduced in Qt 5.7.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#errorString

        **QString QMediaPlaylist::errorString() const**

        Returns the string describing the last error condition.
        """
        ...

    def error(self) -> "QMediaPlaylist.Error":
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#error

        **QMediaPlaylist::Error QMediaPlaylist::error() const**

        Returns the last error condition.
        """
        ...

    @typing.overload
    def save(self, location: QtCore.QUrl, format: typing.Optional[str] = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#save

        **bool QMediaPlaylist::save(const QUrl & location , const char * format
        = nullptr)**

        Save playlist to **location**. If **format** is specified, it is used,
        otherwise format is guessed from location name.

        Returns true if playlist was saved successfully, otherwise returns
        false.
        """
        ...

    @typing.overload
    def save(self, device: QtCore.QIODevice, format: str) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#save-1

        **bool QMediaPlaylist::save(QIODevice * device , const char * format )**

        Save playlist to **QIODevice**  **device** using format **format**.

        Returns true if playlist was saved successfully, otherwise returns
        false.
        """
        ...

    @typing.overload
    def load(
        self, request: QtNetwork.QNetworkRequest, format: typing.Optional[str] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#load

        **void QMediaPlaylist::load(const QNetworkRequest & request , const char
        * format = nullptr)**

        Load playlist using network **request**. If **format** is specified, it
        is used, otherwise format is guessed from playlist name and data.

        New items are appended to playlist.

        **QMediaPlaylist::loaded** () signal is emitted if playlist was loaded
        successfully, otherwise the playlist emits **loadFailed** ().
        """
        ...

    @typing.overload
    def load(self, location: QtCore.QUrl, format: typing.Optional[str] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#load-1

        **void QMediaPlaylist::load(const QUrl & location , const char * format
        = nullptr)**

        Load playlist from **location**. If **format** is specified, it is used,
        otherwise format is guessed from location name and data.

        New items are appended to playlist.

        **QMediaPlaylist::loaded** () signal is emitted if playlist was loaded
        successfully, otherwise the playlist emits **loadFailed** ().
        """
        ...

    @typing.overload
    def load(
        self, device: QtCore.QIODevice, format: typing.Optional[str] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#load-2

        **void QMediaPlaylist::load(QIODevice * device , const char * format =
        nullptr)**

        Load playlist from **QIODevice**  **device**. If **format** is
        specified, it is used, otherwise format is guessed from device data.

        New items are appended to playlist.

        **QMediaPlaylist::loaded** () signal is emitted if playlist was loaded
        successfully, otherwise the playlist emits **loadFailed** ().
        """
        ...

    def clear(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#clear

        **bool QMediaPlaylist::clear()**

        Remove all the items from the playlist.

        Returns true if the operation is successful, otherwise return false.
        """
        ...

    @typing.overload
    def removeMedia(self, pos: int) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#removeMedia

        **bool QMediaPlaylist::removeMedia(int pos )**

        Remove the item from the playlist at position **pos**.

        Returns true if the operation is successful, otherwise return false.
        """
        ...

    @typing.overload
    def removeMedia(self, start: int, end: int) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#removeMedia-1

        **bool QMediaPlaylist::removeMedia(int start , int end )**

        Remove items in the playlist from **start** to **end** inclusive.

        Returns true if the operation is successful, otherwise return false.
        """
        ...

    @typing.overload
    def insertMedia(self, index: int, content: QMediaContent) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#insertMedia

        **bool QMediaPlaylist::insertMedia(int pos , const QMediaContent &
        content )**

        Insert the media **content** to the playlist at position **pos**.

        Returns true if the operation is successful, otherwise returns false.
        """
        ...

    @typing.overload
    def insertMedia(self, index: int, items: typing.Iterable[QMediaContent]) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#insertMedia-1

        **bool QMediaPlaylist::insertMedia(int pos , const QList<QMediaContent>
        & items )**

        Insert multiple media content **items** to the playlist at position
        **pos**.

        Returns true if the operation is successful, otherwise returns false.
        """
        ...

    @typing.overload
    def addMedia(self, content: QMediaContent) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#addMedia

        **bool QMediaPlaylist::addMedia(const QMediaContent & content )**

        Append the media **content** to the playlist.

        Returns true if the operation is successful, otherwise returns false.
        """
        ...

    @typing.overload
    def addMedia(self, items: typing.Iterable[QMediaContent]) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#addMedia-1

        **bool QMediaPlaylist::addMedia(const QList<QMediaContent> & items )**

        Append multiple media content **items** to the playlist.

        Returns true if the operation is successful, otherwise returns false.
        """
        ...

    def isReadOnly(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#isReadOnly

        **bool QMediaPlaylist::isReadOnly() const**

        Returns true if the playlist can be modified, otherwise returns false.

        **See also** **mediaCount** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#isEmpty

        **bool QMediaPlaylist::isEmpty() const**

        Returns true if the playlist contains no items, otherwise returns false.

        **See also** **mediaCount** ().
        """
        ...

    def mediaCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#mediaCount

        **int QMediaPlaylist::mediaCount() const**

        Returns the number of items in the playlist.

        **See also** **isEmpty** ().
        """
        ...

    def media(self, index: int) -> QMediaContent:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#media

        **QMediaContent QMediaPlaylist::media(int index ) const**

        Returns the media content at **index** in the playlist.
        """
        ...

    def previousIndex(self, steps: int = ...) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#previousIndex

        **int QMediaPlaylist::previousIndex(int steps = 1) const**

        Returns the index of the item, which would be current after calling
        **previous** () **steps** times.

        **See also** **QMediaPlaylist::playbackMode** () and **nextIndex** ().
        """
        ...

    def nextIndex(self, steps: int = ...) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#nextIndex

        **int QMediaPlaylist::nextIndex(int steps = 1) const**

        Returns the index of the item, which would be current after calling
        **next** () **steps** times.

        Returned value depends on the size of playlist, current position and
        playback mode.

        **See also** **QMediaPlaylist::playbackMode** () and **previousIndex**
        ().
        """
        ...

    def currentMedia(self) -> QMediaContent:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#currentMedia

        **QMediaContent QMediaPlaylist::currentMedia() const**

        Returns the current media content.

        **Note:** Getter function for property currentMedia.
        """
        ...

    def currentIndex(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#currentIndex

        **int QMediaPlaylist::currentIndex() const**

        Returns position of the current media content in the playlist.

        **Note:** Getter function for property currentIndex.

        **See also** **setCurrentIndex** ().
        """
        ...

    def setPlaybackMode(self, mode: "QMediaPlaylist.PlaybackMode") -> None:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#playbackMode-prop

        **playbackMode : QMediaPlaylist::PlaybackMode**

        This property defines the order that items in the playlist are played.

        **Access functions:**

        QMediaPlaylist::PlaybackMode **playbackMode** () const
        void
        **setPlaybackMode** (QMediaPlaylist::PlaybackMode **mode** )

        **Notifier signal:**

        void ****playbackModeChanged** ** (QMediaPlaylist::PlaybackMode **mode**
        )

        **See also** **QMediaPlaylist::PlaybackMode** .

        **Member Function Documentation**
        """
        ...

    def playbackMode(self) -> "QMediaPlaylist.PlaybackMode":
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#playbackMode-prop

        **playbackMode : QMediaPlaylist::PlaybackMode**

        This property defines the order that items in the playlist are played.

        **Access functions:**

        QMediaPlaylist::PlaybackMode **playbackMode** () const
        void
        **setPlaybackMode** (QMediaPlaylist::PlaybackMode **mode** )

        **Notifier signal:**

        void ****playbackModeChanged** ** (QMediaPlaylist::PlaybackMode **mode**
        )

        **See also** **QMediaPlaylist::PlaybackMode** .

        **Member Function Documentation**
        """
        ...

    def mediaObject(self) -> QMediaObject:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#mediaObject

        **[override virtual] QMediaObject *QMediaPlaylist::mediaObject() const**

        Reimplements: **QMediaBindableInterface::mediaObject** () const.

        Returns the **QMediaObject**  instance that this **QMediaPlaylist**  is
        bound too, or 0 otherwise.
        """
        ...

    @property
    def currentIndexChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#currentIndexChanged

        **[signal] void QMediaPlaylist::currentIndexChanged(int position )**

        Signal emitted when playlist position changed to **position**.

        **Note:** Notifier signal for property **currentIndex** .
        """
        ...

    @property
    def currentMediaChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#currentMediaChanged

        **[signal] void QMediaPlaylist::currentMediaChanged(const QMediaContent
        & content )**

        Signal emitted when current media changes to **content**.

        **Note:** Notifier signal for property **currentMedia** .
        """
        ...

    @property
    def loadFailed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#loadFailed

        **[signal] void QMediaPlaylist::loadFailed()**

        Signal emitted if failed to load playlist.
        """
        ...

    @property
    def loaded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#loaded

        **[signal] void QMediaPlaylist::loaded()**

        Signal emitted when playlist finished loading.
        """
        ...

    @property
    def mediaAboutToBeInserted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#mediaAboutToBeInserted

        **[signal] void QMediaPlaylist::mediaAboutToBeInserted(int start , int
        end )**

        Signal emitted when items are to be inserted at **start** and ending at
        **end**.
        """
        ...

    @property
    def mediaAboutToBeRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#mediaAboutToBeRemoved

        **[signal] void QMediaPlaylist::mediaAboutToBeRemoved(int start , int
        end )**

        Signal emitted when item are to be deleted at **start** and ending at
        **end**.
        """
        ...

    @property
    def mediaChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#mediaChanged

        **[signal] void QMediaPlaylist::mediaChanged(int start , int end )**

        This signal is emitted after media has been changed in the playlist
        between **start** and **end** positions inclusive.
        """
        ...

    @property
    def mediaInserted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#mediaInserted

        **[signal] void QMediaPlaylist::mediaInserted(int start , int end )**

        This signal is emitted after media has been inserted into the playlist.
        The new items are those between **start** and **end** inclusive.
        """
        ...

    @property
    def mediaRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#mediaRemoved

        **[signal] void QMediaPlaylist::mediaRemoved(int start , int end )**

        This signal is emitted after media has been removed from the playlist.
        The removed items are those between **start** and **end** inclusive.
        """
        ...

    @property
    def playbackModeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplaylist.html#playbackModeChanged

        **[signal] void
        QMediaPlaylist::playbackModeChanged(QMediaPlaylist::PlaybackMode mode
        )**

        Signal emitted when playback mode changed to **mode**.

        **Note:** Notifier signal for property **playbackMode** .
        """
        ...
