"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaPlayerControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qmediaplayercontrol.html

    **Detailed Description**

    If a **QMediaService**  can play media is will implement
    QMediaPlayerControl. This control provides a means to set the **media**  to
    play, **start** , **pause**  and **stop**  playback, **seek** , and control
    the **volume** . It also provides feedback on the **duration**  of the
    media, the current **position** , and **buffering**  progress.

    The functionality provided by this control is exposed to application code
    through the **QMediaPlayer**  class.

    The interface name of QMediaPlayerControl is `org.qt-
    project.qt.mediaplayercontrol/5.0` as defined in **QMediaPlayerControl_iid**
    .

    **See also** **QMediaService::requestControl** () and **QMediaPlayer** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#QMediaPlayerControl

        **[protected] QMediaPlayerControl::QMediaPlayerControl(QObject * parent
        = nullptr)**

        Constructs a new media player control with the given **parent**.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#stop

        **[pure virtual] void QMediaPlayerControl::stop()**

        Stops playback of the current media.

        If successful the player control will immediately enter the **stopped**
        state.
        """
        ...

    def pause(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#pause

        **[pure virtual] void QMediaPlayerControl::pause()**

        Pauses playback of the current media.

        If successful the player control will immediately enter the **paused**
        state.

        **See also** **state** (), **play** (), and **stop** ().
        """
        ...

    def play(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#play

        **[pure virtual] void QMediaPlayerControl::play()**

        Starts playback of the current media.

        If successful the player control will immediately enter the **playing**
        state.

        **See also** **state** ().
        """
        ...

    def setMedia(self, media: QMediaContent, stream: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#setMedia

        **[pure virtual] void QMediaPlayerControl::setMedia(const QMediaContent
        & media , QIODevice * stream )**

        Sets the current **media** source. If a **stream** is supplied; data
        will be read from that instead of attempting to resolve the media
        source. The media source may still be used to supply media information
        such as mime type.

        Setting the media to a null **QMediaContent**  will cause the control to
        discard all information relating to the current media source and to
        cease all I/O operations related to that media.

        Qt resource files are never passed as is. If the service supports
        **QMediaServiceProviderHint::StreamPlayback** , a **stream** is
        supplied, pointing to an opened **QFile** . Otherwise, the resource is
        copied into a temporary file and **media** contains the url to that
        file.

        **See also** **media** ().
        """
        ...

    def mediaStream(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#mediaStream

        **[pure virtual] const QIODevice *QMediaPlayerControl::mediaStream()
        const**

        Returns the current media stream. This is only a valid if a stream was
        passed to **setMedia** ().

        **See also** **setMedia** ().
        """
        ...

    def media(self) -> QMediaContent:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#media

        **[pure virtual] QMediaContent QMediaPlayerControl::media() const**

        Returns the current media source.

        **See also** **setMedia** ().
        """
        ...

    def setPlaybackRate(self, rate: float) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#setPlaybackRate

        **[pure virtual] void QMediaPlayerControl::setPlaybackRate(qreal rate
        )**

        Sets the **rate** of playback.

        **See also** **playbackRate** ().
        """
        ...

    def playbackRate(self) -> float:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#playbackRate

        **[pure virtual] qreal QMediaPlayerControl::playbackRate() const**

        Returns the rate of playback.

        **See also** **setPlaybackRate** ().
        """
        ...

    def availablePlaybackRanges(self) -> "QMediaTimeRange":
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#availablePlaybackRanges

        **[pure virtual] QMediaTimeRange
        QMediaPlayerControl::availablePlaybackRanges() const**

        Returns a range of times in milliseconds that can be played back.

        Usually for local files this is a continuous interval equal to
        [0..**duration** ()] or an empty time range if seeking is not supported,
        but for network sources it refers to the buffered parts of the media.
        """
        ...

    def isSeekable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#isSeekable

        **[pure virtual] bool QMediaPlayerControl::isSeekable() const**

        Identifies if the current media is seekable.

        Returns true if it possible to seek within the current media, and false
        otherwise.
        """
        ...

    def isVideoAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#isVideoAvailable

        **[pure virtual] bool QMediaPlayerControl::isVideoAvailable() const**

        Identifies if there is video output available for the current media.

        Returns true if video output is available and false otherwise.
        """
        ...

    def isAudioAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#isAudioAvailable

        **[pure virtual] bool QMediaPlayerControl::isAudioAvailable() const**

        Identifies if there is audio output available for the current media.

        Returns true if audio output is available and false otherwise.
        """
        ...

    def bufferStatus(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#bufferStatus

        **[pure virtual] int QMediaPlayerControl::bufferStatus() const**

        Returns the buffering progress of the current media. Progress is
        measured in the percentage of the buffer filled.
        """
        ...

    def setMuted(self, mute: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#setMuted

        **[pure virtual] void QMediaPlayerControl::setMuted(bool mute )**

        Sets the **mute** state of a player control.

        **See also** **isMuted** ().
        """
        ...

    def isMuted(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#isMuted

        **[pure virtual] bool QMediaPlayerControl::isMuted() const**

        Returns the mute state of a player control.
        """
        ...

    def setVolume(self, volume: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#setVolume

        **[pure virtual] void QMediaPlayerControl::setVolume(int volume )**

        Sets the audio **volume** of a player control.

        The volume is scaled linearly, ranging from `0` (silence) to `100` (full
        volume).

        **See also** **volume** ().
        """
        ...

    def volume(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#volume

        **[pure virtual] int QMediaPlayerControl::volume() const**

        Returns the audio volume of a player control.

        **See also** **setVolume** ().
        """
        ...

    def setPosition(self, position: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#setPosition

        **[pure virtual] void QMediaPlayerControl::setPosition(qint64 position
        )**

        Sets the playback **position** of the current media. This will initiate
        a seek and it may take some time for playback to reach the position set.

        **See also** **position** ().
        """
        ...

    def position(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#position

        **[pure virtual] qint64 QMediaPlayerControl::position() const**

        Returns the current playback position in milliseconds.

        **See also** **setPosition** ().
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#duration

        **[pure virtual] qint64 QMediaPlayerControl::duration() const**

        Returns the duration of the current media in milliseconds.
        """
        ...

    def mediaStatus(self) -> QMediaPlayer.MediaStatus:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#mediaStatus

        **[pure virtual] QMediaPlayer::MediaStatus
        QMediaPlayerControl::mediaStatus() const**

        Returns the status of the current media.
        """
        ...

    def state(self) -> QMediaPlayer.State:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#state

        **[pure virtual] QMediaPlayer::State QMediaPlayerControl::state()
        const**

        Returns the state of a player control.
        """
        ...

    @property
    def audioAvailableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#audioAvailableChanged

        **[signal] void QMediaPlayerControl::audioAvailableChanged(bool
        audioAvailable )**

        Signals that there has been a change in the availability of audio output
        **audioAvailable**.

        **See also** **isAudioAvailable** ().
        """
        ...

    @property
    def availablePlaybackRangesChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#availablePlaybackRangesC
        hanged

        **[signal] void
        QMediaPlayerControl::availablePlaybackRangesChanged(const
        QMediaTimeRange & ranges )**

        Signals that the available media playback **ranges** have changed.

        **See also** **QMediaPlayerControl::availablePlaybackRanges** ().
        """
        ...

    @property
    def bufferStatusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#bufferStatusChanged

        **[signal] void QMediaPlayerControl::bufferStatusChanged(int
        percentFilled )**

        Signal the amount of the local buffer filled as a percentage by
        **percentFilled**.

        **See also** **bufferStatus** ().
        """
        ...

    @property
    def durationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#durationChanged

        **[signal] void QMediaPlayerControl::durationChanged(qint64 duration )**

        Signals that the **duration** of the current media has changed.

        **See also** **duration** ().
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#error

        **[signal] void QMediaPlayerControl::error(int error , const QString &
        errorString )**

        Signals that an **error** has occurred. The **errorString** provides a
        more detailed explanation.
        """
        ...

    @property
    def mediaChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#mediaChanged

        **[signal] void QMediaPlayerControl::mediaChanged(const QMediaContent &
        content )**

        Signals that the current media **content** has changed.
        """
        ...

    @property
    def mediaStatusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#mediaStatusChanged

        **[signal] void
        QMediaPlayerControl::mediaStatusChanged(QMediaPlayer::MediaStatus status
        )**

        Signals that the **status** of the current media has changed.

        **See also** **mediaStatus** ().
        """
        ...

    @property
    def mutedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#mutedChanged

        **[signal] void QMediaPlayerControl::mutedChanged(bool mute )**

        Signals a change in the **mute** status of a player control.

        **See also** **isMuted** ().
        """
        ...

    @property
    def playbackRateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#playbackRateChanged

        **[signal] void QMediaPlayerControl::playbackRateChanged(qreal rate )**

        Signal emitted when playback rate changes to **rate**.
        """
        ...

    @property
    def positionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#positionChanged

        **[signal] void QMediaPlayerControl::positionChanged(qint64 position )**

        Signals the playback **position** has changed.

        This is only emitted in when there has been a discontinous change in the
        playback postion, such as a seek or the position being reset.

        **See also** **position** ().
        """
        ...

    @property
    def seekableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#seekableChanged

        **[signal] void QMediaPlayerControl::seekableChanged(bool seekable )**

        Signals that the **seekable** state of a player control has changed.

        **See also** **isSeekable** ().
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#stateChanged

        **[signal] void QMediaPlayerControl::stateChanged(QMediaPlayer::State
        newState )**

        Signals that the state of a player control has changed to **newState**.

        **See also** **state** ().
        """
        ...

    @property
    def videoAvailableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#videoAvailableChanged

        **[signal] void QMediaPlayerControl::videoAvailableChanged(bool
        videoAvailable )**

        Signal that the availability of visual content has changed to
        **videoAvailable**.

        **See also** **isVideoAvailable** ().
        """
        ...

    @property
    def volumeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayercontrol.html#volumeChanged

        **[signal] void QMediaPlayerControl::volumeChanged(int volume )**

        Signals the audio **volume** of a player control has changed.

        **See also** **volume** ().
        """
        ...
