"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaContainerControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qmediacontainercontrol.html

    **Detailed Description**

    If a **QMediaService**  supports writing encoded data it will implement
    QMediaContainerControl. This control provides information about the output
    containers supported by a media service and allows one to be selected as the
    current output containers.

    The functionality provided by this control is exposed to application code
    through the **QMediaRecorder**  class.

    The interface name of QMediaContainerControl is `org.qt-
    project.qt.mediacontainercontrol/5.0` as defined in
    **QMediaContainerControl_iid** .

    **See also** **QMediaService::requestControl** () and **QMediaRecorder** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediacontainercontrol.html#QMediaContainerContro
        l

        **[protected] QMediaContainerControl::QMediaContainerControl(QObject *
        parent = nullptr)**

        Constructs a new media container control with the given **parent**.
        """
        ...

    def containerDescription(self, formatMimeType: str) -> str:
        """
        https://doc.qt.io/qt-5/qmediacontainercontrol.html#containerDescription

        **[pure virtual] QString
        QMediaContainerControl::containerDescription(const QString &
        formatMimeType ) const**

        Returns a description of the container **formatMimeType**.
        """
        ...

    def setContainerFormat(self, format: str) -> None:
        """
        https://doc.qt.io/qt-5/qmediacontainercontrol.html#setContainerFormat

        **[pure virtual] void QMediaContainerControl::setContainerFormat(const
        QString & format )**

        Sets the current container **format**.

        **See also** **containerFormat** ().
        """
        ...

    def containerFormat(self) -> str:
        """
        https://doc.qt.io/qt-5/qmediacontainercontrol.html#containerFormat

        **[pure virtual] QString QMediaContainerControl::containerFormat()
        const**

        Returns the selected container format.

        **See also** **setContainerFormat** ().
        """
        ...

    def supportedContainers(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmediacontainercontrol.html#supportedContainers

        **[pure virtual] QStringList
        QMediaContainerControl::supportedContainers() const**

        Returns a list of MIME types of supported container formats.
        """
        ...
