"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QImageEncoderSettings(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qimageencodersettings.html

    **Detailed Description**

    A image encoder settings object is used to specify the image encoder
    settings used by **QCameraImageCapture** . Image encoder settings are
    selected by constructing a QImageEncoderSettings object, setting the desired
    properties and then passing it to a **QCameraImageCapture**  instance using
    the QCameraImageCapture::setImageSettings() function.

    **QImageEncoderSettings**  imageSettings;
    imageSettings.setCodec("image/jpeg");
        imageSettings.setResolution(1600,
    1200);

        imageCapture->setEncodingSettings(imageSettings);

    **See also** **QImageEncoderControl** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#QImageEncoderSettings

        **QImageEncoderSettings::QImageEncoderSettings()**

        Constructs a null image encoder settings object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QImageEncoderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#QImageEncoderSettings-
        1

        **QImageEncoderSettings::QImageEncoderSettings(const
        QImageEncoderSettings & other )**

        Constructs a copy of the image encoder settings object **other**.
        """
        ...

    def setEncodingOptions(self, options: typing.Dict[str, typing.Any]) -> None:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#setEncodingOptions

        **void QImageEncoderSettings::setEncodingOptions(const QVariantMap &
        options )**

        Replace all the encoding options with **options**.

        The supported set and meaning of encoding options are system and
        selected codec specific.

        **See also** **encodingOptions** (), **encodingOption** (), and
        **setEncodingOption** ().
        """
        ...

    def setEncodingOption(self, option: str, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#setEncodingOption

        **void QImageEncoderSettings::setEncodingOption(const QString & option ,
        const QVariant & value )**

        Set the encoding **option** **value**.

        The supported set and meaning of encoding options are system and
        selected codec specific.

        **See also** **encodingOption** () and **setEncodingOptions** ().
        """
        ...

    def encodingOptions(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#encodingOptions

        **QVariantMap QImageEncoderSettings::encodingOptions() const**

        Returns the all the encoding options as **QVariantMap** .

        **See also** **encodingOption** () and **setEncodingOptions** ().
        """
        ...

    def encodingOption(self, option: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#encodingOption

        **QVariant QImageEncoderSettings::encodingOption(const QString & option
        ) const**

        Returns the value of encoding **option**.

        **See also** **setEncodingOption** () and **encodingOptions** ().
        """
        ...

    def setQuality(self, quality: "QMultimedia.EncodingQuality") -> None:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#setQuality

        **void QImageEncoderSettings::setQuality(QMultimedia::EncodingQuality
        quality )**

        Sets the image encoding **quality**.

        **See also** **quality** ().
        """
        ...

    def quality(self) -> "QMultimedia.EncodingQuality":
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#quality

        **QMultimedia::EncodingQuality QImageEncoderSettings::quality() const**

        Returns the image encoding quality.

        **See also** **setQuality** ().
        """
        ...

    @typing.overload
    def setResolution(self, a0: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#setResolution

        **void QImageEncoderSettings::setResolution(const QSize & resolution )**

        Sets the **resolution** of the encoded image.

        An empty **QSize**  indicates the encoder should make an optimal choice
        based on what is available from the image source and the limitations of
        the codec.

        **See also** **resolution** ().
        """
        ...

    @typing.overload
    def setResolution(self, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#setResolution-1

        **void QImageEncoderSettings::setResolution(int width , int height )**

        Sets the **width** and **height** of the resolution of the encoded
        image.

        This is an overloaded function.
        """
        ...

    def resolution(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#resolution

        **QSize QImageEncoderSettings::resolution() const**

        Returns the resolution of the encoded image.

        **See also** **setResolution** ().
        """
        ...

    def setCodec(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#setCodec

        **void QImageEncoderSettings::setCodec(const QString & codec )**

        Sets the image **codec**.

        **See also** **codec** ().
        """
        ...

    def codec(self) -> str:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#codec

        **QString QImageEncoderSettings::codec() const**

        Returns the image codec.

        **See also** **setCodec** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qimageencodersettings.html#isNull

        **bool QImageEncoderSettings::isNull() const**

        Identifies if a image encoder settings object is uninitalized.

        Returns true if the settings are null, and false if they are not.
        """
        ...
