"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCustomAudioRoleControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcustomaudiorolecontrol.html

    **Detailed Description**

    If a **QMediaService**  supports audio roles it may implement
    QCustomAudioRoleControl in order to provide access to roles unknown to Qt.

    The functionality provided by this control is exposed to application code
    through the **QMediaPlayer**  class.

    The interface name of QCustomAudioRoleControl is `org.qt-
    project.qt.customaudiorolecontrol/5.11` as defined in
    **QCustomAudioRoleControl_iid** .

    **See also** **QMediaService::requestControl** () and **QMediaPlayer** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcustomaudiorolecontrol.html#QCustomAudioRoleCont
        rol

        **[protected] QCustomAudioRoleControl::QCustomAudioRoleControl(QObject *
        parent = nullptr)**

        Construct a QCustomAudioRoleControl with the given **parent**.
        """
        ...

    def supportedCustomAudioRoles(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qcustomaudiorolecontrol.html#supportedCustomAudio
        Roles

        **[pure virtual] QStringList
        QCustomAudioRoleControl::supportedCustomAudioRoles() const**

        Returns a list of custom audio roles that the media service supports. An
        empty list may indicate that the supported custom audio roles aren't
        known. The list may not be complete.
        """
        ...

    def setCustomAudioRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-5/qcustomaudiorolecontrol.html#setCustomAudioRole

        **[pure virtual] void QCustomAudioRoleControl::setCustomAudioRole(const
        QString & role )**

        Sets the audio **role** of the media played by the media service.

        **See also** **customAudioRole** ().
        """
        ...

    def customAudioRole(self) -> str:
        """
        https://doc.qt.io/qt-5/qcustomaudiorolecontrol.html#customAudioRole

        **[pure virtual] QString QCustomAudioRoleControl::customAudioRole()
        const**

        Returns the audio role of the media played by the media service.

        **See also** **setCustomAudioRole** ().
        """
        ...

    @property
    def customAudioRoleChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcustomaudiorolecontrol.html#customAudioRoleChang
        ed

        **[signal] void QCustomAudioRoleControl::customAudioRoleChanged(const
        QString & role )**

        Signal emitted when the audio **role** has changed.
        """
        ...
