"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraZoomControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcamerazoomcontrol.html

    **Detailed Description**

    The interface name of QCameraZoomControl is `org.qt-
    project.qt.camerazoomcontrol/5.0` as defined in **QCameraZoomControl_iid** .

    **See also** **QMediaService::requestControl** () and **QCamera** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#QCameraZoomControl

        **[protected] QCameraZoomControl::QCameraZoomControl(QObject * parent =
        nullptr)**

        Constructs a camera zoom control object with **parent**.
        """
        ...

    def zoomTo(self, optical: float, digital: float) -> None:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#zoomTo

        **[pure virtual] void QCameraZoomControl::zoomTo(qreal optical , qreal
        digital )**

        Sets **optical** and **digital** zoom values.

        Zooming can be asynchronous with value changes reported with
        **currentDigitalZoomChanged** () and **currentOpticalZoomChanged** ()
        signals.

        The backend should expect and correctly handle frequent zoomTo() calls
        during zoom animations or slider movements.
        """
        ...

    def currentDigitalZoom(self) -> float:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#currentDigitalZoom

        **[pure virtual] qreal QCameraZoomControl::currentDigitalZoom() const**

        Return the current digital zoom value.
        """
        ...

    def currentOpticalZoom(self) -> float:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#currentOpticalZoom

        **[pure virtual] qreal QCameraZoomControl::currentOpticalZoom() const**

        Return the current optical zoom value.
        """
        ...

    def requestedDigitalZoom(self) -> float:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#requestedDigitalZoom

        **[pure virtual] qreal QCameraZoomControl::requestedDigitalZoom()
        const**

        Return the requested digital zoom value.
        """
        ...

    def requestedOpticalZoom(self) -> float:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#requestedOpticalZoom

        **[pure virtual] qreal QCameraZoomControl::requestedOpticalZoom()
        const**

        Return the requested optical zoom value.
        """
        ...

    def maximumDigitalZoom(self) -> float:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#maximumDigitalZoom

        **[pure virtual] qreal QCameraZoomControl::maximumDigitalZoom() const**

        Returns the maximum digital zoom value, or 1.0 if digital zoom is not
        supported.
        """
        ...

    def maximumOpticalZoom(self) -> float:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#maximumOpticalZoom

        **[pure virtual] qreal QCameraZoomControl::maximumOpticalZoom() const**

        Returns the maximum optical zoom value, or 1.0 if optical zoom is not
        supported.
        """
        ...

    @property
    def currentDigitalZoomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#currentDigitalZoomChanged

        **[signal] void QCameraZoomControl::currentDigitalZoomChanged(qreal zoom
        )**

        Signal emitted when the current digital **zoom** value changed.
        """
        ...

    @property
    def currentOpticalZoomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#currentOpticalZoomChanged

        **[signal] void QCameraZoomControl::currentOpticalZoomChanged(qreal zoom
        )**

        Signal emitted when the current optical **zoom** value changed.
        """
        ...

    @property
    def maximumDigitalZoomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#maximumDigitalZoomChanged

        **[signal] void QCameraZoomControl::maximumDigitalZoomChanged(qreal zoom
        )**

        Signal emitted when the maximum supported digital **zoom** value
        changed.

        The maximum supported zoom value can depend on other camera settings,
        like capture mode or resolution.
        """
        ...

    @property
    def maximumOpticalZoomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#maximumOpticalZoomChanged

        **[signal] void QCameraZoomControl::maximumOpticalZoomChanged(qreal zoom
        )**

        Signal emitted when the maximum supported optical **zoom** value
        changed.

        The maximum supported zoom value can depend on other camera settings,
        like focusing mode.
        """
        ...

    @property
    def requestedDigitalZoomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#requestedDigitalZoomChang
        ed

        **[signal] void QCameraZoomControl::requestedDigitalZoomChanged(qreal
        zoom )**

        Signal emitted when the requested digital **zoom** value changed.
        """
        ...

    @property
    def requestedOpticalZoomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerazoomcontrol.html#requestedOpticalZoomChang
        ed

        **[signal] void QCameraZoomControl::requestedOpticalZoomChanged(qreal
        zoom )**

        Signal emitted when the requested optical **zoom** value changed.
        """
        ...
