"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraViewfinderSettingsControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcameraviewfindersettingscontrol.html

    **Detailed Description**

    The interface name of QCameraViewfinderSettingsControl is `org.qt-
    project.qt.cameraviewfindersettingscontrol/5.0` as defined in
    **QCameraViewfinderSettingsControl_iid** .

    **Warning:** New backends should implement
    **QCameraViewfinderSettingsControl2**  instead. Application developers
    should request this control only if **QCameraViewfinderSettingsControl2**
    is not available.

    **See also** **QMediaService::requestControl** (),
    **QCameraViewfinderSettingsControl2** , and **QCamera** .
    """

    class ViewfinderParameter(int):
        Resolution: QCameraViewfinderSettingsControl = ...
        PixelAspectRatio: QCameraViewfinderSettingsControl = ...
        MinimumFrameRate: QCameraViewfinderSettingsControl = ...
        MaximumFrameRate: QCameraViewfinderSettingsControl = ...
        PixelFormat: QCameraViewfinderSettingsControl = ...
        UserParameter: QCameraViewfinderSettingsControl = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettingscontrol.html#QCameraView
        finderSettingsControl

        **[protected] QCameraViewfinderSettingsControl::QCameraViewfinderSetting
        sControl(QObject * parent = nullptr)**

        Constructs a camera viewfinder control object with **parent**.
        """
        ...

    def setViewfinderParameter(
        self,
        parameter: "QCameraViewfinderSettingsControl.ViewfinderParameter",
        value: typing.Any,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettingscontrol.html#setViewfind
        erParameter

        **[pure virtual] void QCameraViewfinderSettingsControl::setViewfinderPar
        ameter(QCameraViewfinderSettingsControl::ViewfinderParameter parameter ,
        const QVariant & value )**

        Set the prefferred **value** of viewfinder **parameter**.

        Calling this while the camera is active may result in the camera being
        stopped and reloaded. If video recording is in progress, this call may
        be ignored.

        If an unsupported parameter is specified the camera may fail to load, or
        the setting may be ignored.

        Viewfinder parameters may also depend on other camera settings,
        especially in video capture mode. If camera configuration conflicts with
        viewfinder settings, the camara configuration is usually preferred.

        **See also** **viewfinderParameter** ().
        """
        ...

    def viewfinderParameter(
        self, parameter: "QCameraViewfinderSettingsControl.ViewfinderParameter"
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettingscontrol.html#viewfinderP
        arameter

        **[pure virtual] QVariant QCameraViewfinderSettingsControl::viewfinderPa
        rameter(QCameraViewfinderSettingsControl::ViewfinderParameter parameter
        ) const**

        Returns the value of viewfinder **parameter**.

        **See also** **setViewfinderParameter** ().
        """
        ...

    def isViewfinderParameterSupported(
        self, parameter: "QCameraViewfinderSettingsControl.ViewfinderParameter"
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettingscontrol.html#isViewfinde
        rParameterSupported

        **[pure virtual] bool QCameraViewfinderSettingsControl::isViewfinderPara
        meterSupported(QCameraViewfinderSettingsControl::ViewfinderParameter
        parameter ) const**

        Returns true if configuration of viewfinder **parameter** is supported
        by camera backend.
        """
        ...
