"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraImageCaptureControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html

    **Detailed Description**

    The interface name of QCameraImageCaptureControl is `org.qt-
    project.qt.cameraimagecapturecontrol/5.0` as defined in
    **QCameraImageCaptureControl_iid** .

    **See also** **QMediaService::requestControl** ().
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#QCameraImageCaptu
        reControl

        **[protected]
        QCameraImageCaptureControl::QCameraImageCaptureControl(QObject * parent
        = nullptr)**

        Constructs a new image capture control object with the given **parent**
        """
        ...

    def cancelCapture(self) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#cancelCapture

        **[pure virtual] void QCameraImageCaptureControl::cancelCapture()**

        Cancel pending capture requests.
        """
        ...

    def capture(self, fileName: str) -> int:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#capture

        **[pure virtual] int QCameraImageCaptureControl::capture(const QString &
        fileName )**

        Initiates the capture of an image to **fileName**. The **fileName** can
        be relative or empty, in this case the service should use the system
        specific place and file naming scheme.

        The Camera service should save all the capture parameters like exposure
        settings or image processing parameters, so changes to camera parameters
        after capture() is called do not affect previous capture requests.

        Returns the capture request id number, which is used later with
        **imageExposed** (), **imageCaptured** () and **imageSaved** () signals.
        """
        ...

    def setDriveMode(self, mode: QCameraImageCapture.DriveMode) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#setDriveMode

        **[pure virtual] void
        QCameraImageCaptureControl::setDriveMode(QCameraImageCapture::DriveMode
        mode )**

        Sets the current camera drive **mode**.

        **See also** **driveMode** ().
        """
        ...

    def driveMode(self) -> QCameraImageCapture.DriveMode:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#driveMode

        **[pure virtual] QCameraImageCapture::DriveMode
        QCameraImageCaptureControl::driveMode() const**

        Returns the current camera drive mode.

        **See also** **setDriveMode** ().
        """
        ...

    def isReadyForCapture(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#isReadyForCapture

        **[pure virtual] bool QCameraImageCaptureControl::isReadyForCapture()
        const**

        Identifies if a capture control is ready to perform a capture
        immediately (all the resources necessary for image capture are
        allocated, hardware initialized, flash is charged, etc).

        Returns true if the camera is ready for capture; and false if it is not.

        It's permissible to call **capture** () while the camera status is
        **QCamera::ActiveStatus**  regardless of isReadyForCapture property
        value. If camera is not ready to capture image immediately, the capture
        request is queued with all the related camera settings to be executed as
        soon as possible.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#error

        **[signal] void QCameraImageCaptureControl::error(int id , int error ,
        const QString & errorString )**

        Signals the capture request **id** failed with **error** code and
        message **errorString**.

        **See also** **QCameraImageCapture::Error** .
        """
        ...

    @property
    def imageAvailable(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#imageAvailable

        **[signal] void QCameraImageCaptureControl::imageAvailable(int requestId
        , const QVideoFrame & buffer )**

        Signals that a captured **buffer** with a **requestId** is available.
        """
        ...

    @property
    def imageCaptured(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#imageCaptured

        **[signal] void QCameraImageCaptureControl::imageCaptured(int requestId
        , const QImage & preview )**

        Signals that an image with it **requestId** has been captured and a
        **preview** is available.
        """
        ...

    @property
    def imageExposed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#imageExposed

        **[signal] void QCameraImageCaptureControl::imageExposed(int requestId
        )**

        Signals that an image with it **requestId** has just been exposed. This
        signal can be used for the shutter sound or other indicaton.
        """
        ...

    @property
    def imageMetadataAvailable(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#imageMetadataAvai
        lable

        **[signal] void QCameraImageCaptureControl::imageMetadataAvailable(int
        id , const QString & key , const QVariant & value )**

        Signals that a metadata for an image with request **id** is available.
        Signal also contains the **key** and **value** of the metadata.

        This signal should be emitted between **imageExposed**  and
        **imageSaved**  signals.
        """
        ...

    @property
    def imageSaved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#imageSaved

        **[signal] void QCameraImageCaptureControl::imageSaved(int requestId ,
        const QString & fileName )**

        Signals that a captured image with a **requestId** has been saved to
        **fileName**.
        """
        ...

    @property
    def readyForCaptureChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapturecontrol.html#readyForCaptureCh
        anged

        **[signal] void QCameraImageCaptureControl::readyForCaptureChanged(bool
        ready )**

        Signals that a capture control's **ready** state has changed.
        """
        ...
