"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QCameraFocusZone(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qcamerafocuszone.html

    **Detailed Description**

    For cameras that support autofocusing, in order for a camera to autofocus on
    part of a sensor frame, it considers different zones within the frame. Which
    zones to use, and where the zones are located vary between different
    cameras.

    This class exposes what zones are used by a particular camera, and a list of
    the zones can be retrieved by a **QCameraFocus**  instance.

    You can use this information to present visual feedback - for example,
    drawing rectangles around areas of the camera frame that are in focus, or
    changing the color of a zone as it comes into focus.

    focus->setFocusPointMode(**QCameraFocus** ::FocusPointAuto);
        const
    **QList** <QCameraFocusZone> zones = focus->focusZones();
        for (const
    QCameraFocusZone &zone : zones) {
            if (zone.status() ==
    QCameraFocusZone::Focused) {
                // Draw a green box at zone.area()
    } else if (zone.status() == QCameraFocusZone::Selected) {
                //
    This area is selected for autofocusing, but is not in focus
                //
    Draw a yellow box at zone.area()
            }
        }

    **See also** **QCameraFocus** .
    """

    class FocusZoneStatus(int):
        Invalid: QCameraFocusZone = ...
        Unused: QCameraFocusZone = ...
        Selected: QCameraFocusZone = ...
        Focused: QCameraFocusZone = ...

    def __init__(self, other: "QCameraFocusZone") -> None:
        """
        https://doc.qt.io/qt-5/qcamerafocuszone.html#QCameraFocusZone

        **QCameraFocusZone::QCameraFocusZone(const QCameraFocusZone & other )**

        Creates a new QCameraFocusZone as a copy of **other**.
        """
        ...

    def status(self) -> "QCameraFocusZone.FocusZoneStatus":
        """
        https://doc.qt.io/qt-5/qcamerafocuszone.html#status

        **QCameraFocusZone::FocusZoneStatus QCameraFocusZone::status() const**

        Returns the current status of this focus zone.
        """
        ...

    def area(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qcamerafocuszone.html#area

        **QRectF QCameraFocusZone::area() const**

        Returns the area of the camera frame that this focus zone encompasses.

        Coordinates are in frame relative coordinates - `QPointF(0,0)` is the
        top left of the frame, and `QPointF(1,1)` is the bottom right.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcamerafocuszone.html#isValid

        **bool QCameraFocusZone::isValid() const**

        Returns true if this focus zone has a valid area and status.
        """
        ...
