"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraFlashControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcameraflashcontrol.html

    **Detailed Description**

    You can set the type of flash effect used when an image is captured, and
    test to see if the flash hardware is ready to fire.

    You can retrieve this control from the camera object in the usual way:

    Some camera devices may not have flash hardware, or may not be configurable.
    In that case, there will be no QCameraFlashControl available.

    The interface name of QCameraFlashControl is `org.qt-
    project.qt.cameraflashcontrol/5.0` as defined in **QCameraFlashControl_iid**
    .

    **See also** **QCamera** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcameraflashcontrol.html#QCameraFlashControl

        **[protected] QCameraFlashControl::QCameraFlashControl(QObject * parent
        = nullptr)**

        Constructs a camera flash control object with **parent**.
        """
        ...

    def isFlashReady(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraflashcontrol.html#isFlashReady

        **[pure virtual] bool QCameraFlashControl::isFlashReady() const**

        Returns true if flash is charged.
        """
        ...

    def isFlashModeSupported(
        self, mode: typing.Union[QCameraExposure.FlashModes, QCameraExposure.FlashMode]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraflashcontrol.html#isFlashModeSupported

        **[pure virtual] bool
        QCameraFlashControl::isFlashModeSupported(QCameraExposure::FlashModes
        mode ) const**

        Return true if the reqested flash **mode** is supported. Some
        **QCameraExposure::FlashMode**  values can be combined, for example
        **QCameraExposure::FlashManual**  |
        **QCameraExposure::FlashSlowSyncRearCurtain**
        """
        ...

    def setFlashMode(
        self, mode: typing.Union[QCameraExposure.FlashModes, QCameraExposure.FlashMode]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameraflashcontrol.html#setFlashMode

        **[pure virtual] void
        QCameraFlashControl::setFlashMode(QCameraExposure::FlashModes mode )**

        Set the current flash **mode**.

        Usually a single **QCameraExposure::FlashMode**  flag is used, but some
        non conflicting flags combination are also allowed, like
        **QCameraExposure::FlashManual**  |
        **QCameraExposure::FlashSlowSyncRearCurtain** .

        **See also** **flashMode** ().
        """
        ...

    def flashMode(self) -> QCameraExposure.FlashModes:
        """
        https://doc.qt.io/qt-5/qcameraflashcontrol.html#flashMode

        **[pure virtual] QCameraExposure::FlashModes
        QCameraFlashControl::flashMode() const**

        Returns the current flash mode.

        **See also** **setFlashMode** ().
        """
        ...

    @property
    def flashReady(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraflashcontrol.html#flashReady

        **[signal] void QCameraFlashControl::flashReady(bool ready )**

        Signal emitted when flash state changes to **ready**.
        """
        ...
