"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraExposureControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcameraexposurecontrol.html

    **Detailed Description**

    The **QCameraExposure**  class is the usual method of adjusting exposure
    related parameters when using camera functionality. This class provides a
    more complete but less easy to use interface, and also forms the interface
    to implement when writing a new implementation of **QCamera**
    functionality.

    You can adjust a number of parameters that will affect images and video
    taken with the corresponding **QCamera**  object - see the
    **ExposureParameter**  enumeration.

    The interface name of QCameraExposureControl is `org.qt-
    project.qt.cameraexposurecontrol/5.0` as defined in
    **QCameraExposureControl_iid** .

    **See also** **QCameraExposure**  and **QCamera** .
    """

    class ExposureParameter(int):
        ISO: QCameraExposureControl = ...
        Aperture: QCameraExposureControl = ...
        ShutterSpeed: QCameraExposureControl = ...
        ExposureCompensation: QCameraExposureControl = ...
        FlashPower: QCameraExposureControl = ...
        FlashCompensation: QCameraExposureControl = ...
        TorchPower: QCameraExposureControl = ...
        SpotMeteringPoint: QCameraExposureControl = ...
        ExposureMode: QCameraExposureControl = ...
        MeteringMode: QCameraExposureControl = ...
        ExtendedExposureParameter: QCameraExposureControl = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposurecontrol.html#QCameraExposureContro
        l

        **[protected] QCameraExposureControl::QCameraExposureControl(QObject *
        parent = nullptr)**

        Constructs a camera exposure control object with **parent**.
        """
        ...

    def setValue(
        self, parameter: "QCameraExposureControl.ExposureParameter", value: typing.Any
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraexposurecontrol.html#setValue

        **[pure virtual] bool QCameraExposureControl::setValue(QCameraExposureCo
        ntrol::ExposureParameter parameter , const QVariant & value )**

        Set the exposure **parameter** to **value**. If a null or invalid
        **QVariant**  is passed, backend should choose the value automatically,
        and if possible report the actual value to user with
        **QCameraExposureControl::actualValue** ().

        Returns true if parameter is supported and value is correct.

        This function was introduced in Qt 5.0.
        """
        ...

    def actualValue(
        self, parameter: "QCameraExposureControl.ExposureParameter"
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qcameraexposurecontrol.html#actualValue

        **[pure virtual] QVariant QCameraExposureControl::actualValue(QCameraExp
        osureControl::ExposureParameter parameter ) const**

        Returns the actual exposure **parameter** value, or invalid QVariant()
        if the value is unknown or not supported.

        The actual parameter value may differ for the requested one if automatic
        mode is selected or camera supports only limited set of values within
        the supported range.

        This function was introduced in Qt 5.0.
        """
        ...

    def requestedValue(
        self, parameter: "QCameraExposureControl.ExposureParameter"
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qcameraexposurecontrol.html#requestedValue

        **[pure virtual] QVariant QCameraExposureControl::requestedValue(QCamera
        ExposureControl::ExposureParameter parameter ) const**

        Returns the requested exposure **parameter** value.

        This function was introduced in Qt 5.0.
        """
        ...

    def supportedParameterRange(
        self, parameter: "QCameraExposureControl.ExposureParameter"
    ) -> typing.Tuple[typing.List[typing.Any], bool]:
        """
        https://doc.qt.io/qt-5/qcameraexposurecontrol.html#supportedParameterRan
        ge

        **[pure virtual] QVariantList QCameraExposureControl::supportedParameter
        Range(QCameraExposureControl::ExposureParameter parameter , bool *
        continuous ) const**

        Returns the list of supported **parameter** values;

        If the camera supports arbitrary exposure parameter value within the
        supported range, * **continuous** is set to true, otherwise *
        **continuous** is set to false.

        This function was introduced in Qt 5.0.
        """
        ...

    def isParameterSupported(
        self, parameter: "QCameraExposureControl.ExposureParameter"
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraexposurecontrol.html#isParameterSupported

        **[pure virtual] bool QCameraExposureControl::isParameterSupported(QCame
        raExposureControl::ExposureParameter parameter ) const**

        Returns true is exposure **parameter** is supported by backend.

        This function was introduced in Qt 5.0.
        """
        ...

    @property
    def actualValueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraexposurecontrol.html#actualValueChanged

        **[signal] void QCameraExposureControl::actualValueChanged(int parameter
        )**

        Signal emitted when the actual exposure **parameter** value has changed,
        usually in result of auto exposure algorithms or manual exposure
        parameter applied.

        This function was introduced in Qt 5.0.
        """
        ...

    @property
    def parameterRangeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraexposurecontrol.html#parameterRangeChanged

        **[signal] void QCameraExposureControl::parameterRangeChanged(int
        parameter )**

        Signal emitted when the supported range of exposure **parameter** values
        has changed.

        This function was introduced in Qt 5.0.
        """
        ...

    @property
    def requestedValueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraexposurecontrol.html#requestedValueChanged

        **[signal] void QCameraExposureControl::requestedValueChanged(int
        parameter )**

        Signal emitted when the requested exposure **parameter** value has
        changed, usually in result of **setValue** () call.

        This function was introduced in Qt 5.0.
        """
        ...
