"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QCameraExposure(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qcameraexposure.html

    **Detailed Description**
    """

    class MeteringMode(int):
        MeteringMatrix: QCameraExposure = ...
        MeteringAverage: QCameraExposure = ...
        MeteringSpot: QCameraExposure = ...

    class ExposureMode(int):
        ExposureAuto: QCameraExposure = ...
        ExposureManual: QCameraExposure = ...
        ExposurePortrait: QCameraExposure = ...
        ExposureNight: QCameraExposure = ...
        ExposureBacklight: QCameraExposure = ...
        ExposureSpotlight: QCameraExposure = ...
        ExposureSports: QCameraExposure = ...
        ExposureSnow: QCameraExposure = ...
        ExposureBeach: QCameraExposure = ...
        ExposureLargeAperture: QCameraExposure = ...
        ExposureSmallAperture: QCameraExposure = ...
        ExposureAction: QCameraExposure = ...
        ExposureLandscape: QCameraExposure = ...
        ExposureNightPortrait: QCameraExposure = ...
        ExposureTheatre: QCameraExposure = ...
        ExposureSunset: QCameraExposure = ...
        ExposureSteadyPhoto: QCameraExposure = ...
        ExposureFireworks: QCameraExposure = ...
        ExposureParty: QCameraExposure = ...
        ExposureCandlelight: QCameraExposure = ...
        ExposureBarcode: QCameraExposure = ...
        ExposureModeVendor: QCameraExposure = ...

    class FlashMode(int):
        FlashAuto: QCameraExposure = ...
        FlashOff: QCameraExposure = ...
        FlashOn: QCameraExposure = ...
        FlashRedEyeReduction: QCameraExposure = ...
        FlashFill: QCameraExposure = ...
        FlashTorch: QCameraExposure = ...
        FlashVideoLight: QCameraExposure = ...
        FlashSlowSyncFrontCurtain: QCameraExposure = ...
        FlashSlowSyncRearCurtain: QCameraExposure = ...
        FlashManual: QCameraExposure = ...

    class FlashModes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QCameraExposure.FlashModes", "QCameraExposure.FlashMode"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QCameraExposure.FlashModes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QCameraExposure.FlashModes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def setAutoShutterSpeed(self) -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#setAutoShutterSpeed

        **[slot] void QCameraExposure::setAutoShutterSpeed()**

        Turn on auto shutter speed
        """
        ...

    def setManualShutterSpeed(self, seconds: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#setManualShutterSpeed

        **[slot] void QCameraExposure::setManualShutterSpeed(qreal seconds )**

        Set the manual shutter speed to **seconds**
        """
        ...

    def setAutoAperture(self) -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#setAutoAperture

        **[slot] void QCameraExposure::setAutoAperture()**

        Turn on auto aperture
        """
        ...

    def setManualAperture(self, aperture: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#setManualAperture

        **[slot] void QCameraExposure::setManualAperture(qreal aperture )**

        Sets the manual camera **aperture** value.
        """
        ...

    def setAutoIsoSensitivity(self) -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#setAutoIsoSensitivity

        **[slot] void QCameraExposure::setAutoIsoSensitivity()**

        Turn on auto sensitivity
        """
        ...

    def setManualIsoSensitivity(self, iso: int) -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#setManualIsoSensitivity

        **[slot] void QCameraExposure::setManualIsoSensitivity(int iso )**

        Sets the manual sensitivity to **iso**
        """
        ...

    def setExposureCompensation(self, ev: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#exposureCompensation-prop

        **exposureCompensation : qreal**

        Exposure compensation in EV units.

        Exposure compensation property allows to adjust the automatically
        calculated exposure.

        **Access functions:**

        qreal **exposureCompensation** () const
        void
        **setExposureCompensation** (qreal **ev** )

        **Notifier signal:**

        void ****exposureCompensationChanged** ** (qreal **value** )
        """
        ...

    def setMeteringMode(self, mode: "QCameraExposure.MeteringMode") -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#meteringMode-prop

        **meteringMode : QCameraExposure::MeteringMode**

        This property holds the metering mode being used.

        **Access functions:**

        QCameraExposure::MeteringMode **meteringMode** () const
        void
        **setMeteringMode** (QCameraExposure::MeteringMode **mode** )

        **See also** **QCameraExposure::isMeteringModeSupported** ().
        """
        ...

    def setExposureMode(self, mode: "QCameraExposure.ExposureMode") -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#exposureMode-prop

        **exposureMode : QCameraExposure::ExposureMode**

        This property holds the exposure mode being used.

        **Access functions:**

        QCameraExposure::ExposureMode **exposureMode** () const
        void
        **setExposureMode** (QCameraExposure::ExposureMode **mode** )

        **See also** **QCameraExposure::isExposureModeSupported** ().
        """
        ...

    def setFlashMode(
        self,
        mode: typing.Union["QCameraExposure.FlashModes", "QCameraExposure.FlashMode"],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#flashMode-prop

        **flashMode : QCameraExposure::FlashModes**

        This property holds the flash mode being used.

        Usually the single **QCameraExposure::FlashMode**  flag is used, but
        some non conflicting flags combination are also allowed, like
        **QCameraExposure::FlashManual**  |
        **QCameraExposure::FlashSlowSyncRearCurtain** .

        **Access functions:**

        QCameraExposure::FlashModes **flashMode** () const
        void
        **setFlashMode** (QCameraExposure::FlashModes **mode** )

        **See also** **QCameraExposure::isFlashModeSupported** () and
        **QCameraExposure::isFlashReady** ().
        """
        ...

    def supportedShutterSpeeds(self) -> typing.Tuple[typing.List[float], bool]:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#supportedShutterSpeeds

        **QList<qreal> QCameraExposure::supportedShutterSpeeds(bool * continuous
        = nullptr) const**

        Returns the list of shutter speed values in seconds camera supports.

        If the camera supports arbitrary shutter speed values within the
        supported range, * **continuous** is set to true, otherwise *
        **continuous** is set to false.
        """
        ...

    def supportedApertures(self) -> typing.Tuple[typing.List[float], bool]:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#supportedApertures

        **QList<qreal> QCameraExposure::supportedApertures(bool * continuous =
        nullptr) const**

        Returns the list of aperture values camera supports. The apertures list
        can change depending on the focal length, in such a case the
        **apertureRangeChanged** () signal is emitted.

        If the camera supports arbitrary aperture values within the supported
        range, * **continuous** is set to true, otherwise * **continuous** is
        set to false.
        """
        ...

    def supportedIsoSensitivities(self) -> typing.Tuple[typing.List[int], bool]:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#supportedIsoSensitivities

        **QList<int> QCameraExposure::supportedIsoSensitivities(bool *
        continuous = nullptr) const**

        Returns the list of ISO senitivities camera supports.

        If the camera supports arbitrary ISO sensitivities within the supported
        range, * **continuous** is set to true, otherwise * **continuous** is
        set to false.
        """
        ...

    def requestedShutterSpeed(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#requestedShutterSpeed

        **qreal QCameraExposure::requestedShutterSpeed() const**

        Returns the requested manual shutter speed in seconds or -1.0 if
        automatic shutter speed is turned on.
        """
        ...

    def requestedAperture(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#requestedAperture

        **qreal QCameraExposure::requestedAperture() const**

        Returns the requested manual aperture or -1.0 if automatic aperture is
        turned on.
        """
        ...

    def requestedIsoSensitivity(self) -> int:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#requestedIsoSensitivity

        **int QCameraExposure::requestedIsoSensitivity() const**

        Returns the requested ISO sensitivity or -1 if automatic ISO is turned
        on.
        """
        ...

    def shutterSpeed(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#shutterSpeed

        **qreal QCameraExposure::shutterSpeed() const**

        Returns the current shutter speed in seconds.

        **Note:** Getter function for property shutterSpeed.
        """
        ...

    def aperture(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#aperture-prop

        **aperture : const qreal**

        Lens aperture is specified as an F number, the ratio of the focal length
        to effective aperture diameter.

        **Access functions:**

        qreal **aperture** () const

        **Notifier signal:**

        void ****apertureChanged** ** (qreal **value** )

        **See also** **supportedApertures** (), **setAutoAperture** (),
        **setManualAperture** (), and **requestedAperture** ().
        """
        ...

    def isoSensitivity(self) -> int:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#isoSensitivity-prop

        **isoSensitivity : const int**

        This property holds the sensor ISO sensitivity.

        **Access functions:**

        int **isoSensitivity** () const

        **Notifier signal:**

        void ****isoSensitivityChanged** ** (int **value** )

        **See also** **supportedIsoSensitivities** (), **setAutoIsoSensitivity**
        (), and **setManualIsoSensitivity** ().
        """
        ...

    def setSpotMeteringPoint(
        self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#setSpotMeteringPoint

        **void QCameraExposure::setSpotMeteringPoint(const QPointF & point )**

        Allows setting the spot metering point to **point**.

        **See also** **spotMeteringPoint** ().
        """
        ...

    def spotMeteringPoint(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#spotMeteringPoint

        **QPointF QCameraExposure::spotMeteringPoint() const**

        When supported, the spot metering point is the (normalized) position of
        the point of the image where exposure metering will be performed. This
        is typically used to indicate an "interesting" area of the image that
        should be exposed properly.

        The coordinates are relative frame coordinates: **QPointF** (0,0) points
        to the left top frame point, **QPointF** (0.5,0.5) points to the frame
        center, which is typically the default spot metering point.

        The spot metering point is only used with spot metering mode.

        **See also** **setSpotMeteringPoint** ().
        """
        ...

    def isMeteringModeSupported(self, mode: "QCameraExposure.MeteringMode") -> bool:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#isMeteringModeSupported

        **bool
        QCameraExposure::isMeteringModeSupported(QCameraExposure::MeteringMode
        mode ) const**

        Returns true if the metering **mode** is supported.
        """
        ...

    def meteringMode(self) -> "QCameraExposure.MeteringMode":
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#meteringMode-prop

        **meteringMode : QCameraExposure::MeteringMode**

        This property holds the metering mode being used.

        **Access functions:**

        QCameraExposure::MeteringMode **meteringMode** () const
        void
        **setMeteringMode** (QCameraExposure::MeteringMode **mode** )

        **See also** **QCameraExposure::isMeteringModeSupported** ().
        """
        ...

    def exposureCompensation(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#exposureCompensation-prop

        **exposureCompensation : qreal**

        Exposure compensation in EV units.

        Exposure compensation property allows to adjust the automatically
        calculated exposure.

        **Access functions:**

        qreal **exposureCompensation** () const
        void
        **setExposureCompensation** (qreal **ev** )

        **Notifier signal:**

        void ****exposureCompensationChanged** ** (qreal **value** )
        """
        ...

    def isExposureModeSupported(self, mode: "QCameraExposure.ExposureMode") -> bool:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#isExposureModeSupported

        **bool
        QCameraExposure::isExposureModeSupported(QCameraExposure::ExposureMode
        mode ) const**

        Returns true if the exposure **mode** is supported.
        """
        ...

    def exposureMode(self) -> "QCameraExposure.ExposureMode":
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#exposureMode-prop

        **exposureMode : QCameraExposure::ExposureMode**

        This property holds the exposure mode being used.

        **Access functions:**

        QCameraExposure::ExposureMode **exposureMode** () const
        void
        **setExposureMode** (QCameraExposure::ExposureMode **mode** )

        **See also** **QCameraExposure::isExposureModeSupported** ().
        """
        ...

    def isFlashReady(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#isFlashReady

        **bool QCameraExposure::isFlashReady() const**

        Returns true if flash is charged.

        **Note:** Getter function for property **flashReady** .
        """
        ...

    def isFlashModeSupported(
        self,
        mode: typing.Union["QCameraExposure.FlashModes", "QCameraExposure.FlashMode"],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#isFlashModeSupported

        **bool QCameraExposure::isFlashModeSupported(QCameraExposure::FlashModes
        mode ) const**

        Returns true if the flash **mode** is supported.
        """
        ...

    def flashMode(self) -> "QCameraExposure.FlashModes":
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#flashMode-prop

        **flashMode : QCameraExposure::FlashModes**

        This property holds the flash mode being used.

        Usually the single **QCameraExposure::FlashMode**  flag is used, but
        some non conflicting flags combination are also allowed, like
        **QCameraExposure::FlashManual**  |
        **QCameraExposure::FlashSlowSyncRearCurtain** .

        **Access functions:**

        QCameraExposure::FlashModes **flashMode** () const
        void
        **setFlashMode** (QCameraExposure::FlashModes **mode** )

        **See also** **QCameraExposure::isFlashModeSupported** () and
        **QCameraExposure::isFlashReady** ().
        """
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#isAvailable

        **bool QCameraExposure::isAvailable() const**

        Returns true if exposure settings are supported by this camera.
        """
        ...

    @property
    def apertureChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#apertureChanged

        **[signal] void QCameraExposure::apertureChanged(qreal value )**

        Signal emitted when aperature changes to **value**.

        **Note:** Notifier signal for property **aperture** .
        """
        ...

    @property
    def apertureRangeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#apertureRangeChanged

        **[signal] void QCameraExposure::apertureRangeChanged()**

        Signal emitted when aperature range has changed.
        """
        ...

    @property
    def exposureCompensationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#exposureCompensationChanged

        **[signal] void QCameraExposure::exposureCompensationChanged(qreal value
        )**

        Signal emitted when the exposure compensation changes to **value**.

        **Note:** Notifier signal for property **exposureCompensation** .
        """
        ...

    @property
    def flashReady(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#flashReady

        **[signal] void QCameraExposure::flashReady(bool ready )**

        Signal the flash **ready** status has changed.

        **Note:** Notifier signal for property flashReady.
        """
        ...

    @property
    def isoSensitivityChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#isoSensitivityChanged

        **[signal] void QCameraExposure::isoSensitivityChanged(int value )**

        Signal emitted when sensitivity changes to **value**.

        **Note:** Notifier signal for property **isoSensitivity** .
        """
        ...

    @property
    def shutterSpeedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#shutterSpeedChanged

        **[signal] void QCameraExposure::shutterSpeedChanged(qreal speed )**

        Signals that a camera's shutter **speed** has changed.

        **Note:** Notifier signal for property **shutterSpeed** .
        """
        ...

    @property
    def shutterSpeedRangeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraexposure.html#shutterSpeedRangeChanged

        **[signal] void QCameraExposure::shutterSpeedRangeChanged()**

        Signal emitted when the shutter speed range has changed.
        """
        ...
