"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraCaptureDestinationControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcameracapturedestinationcontrol.html

    **Detailed Description**

    Depending on backend capabilities capture to file, buffer or both can be
    supported.

    The interface name of QCameraCaptureDestinationControl is `org.qt-
    project.qt.cameracapturedestinationcontrol/5.0` as defined in
    **QCameraCaptureDestinationControl_iid** .

    **See also** **QMediaService::requestControl** ().
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcameracapturedestinationcontrol.html#QCameraCapt
        ureDestinationControl

        **[protected] QCameraCaptureDestinationControl::QCameraCaptureDestinatio
        nControl(QObject * parent = nullptr)**

        Constructs a new image capture destination control object with the given
        **parent**
        """
        ...

    def setCaptureDestination(
        self,
        destination: typing.Union[
            "QCameraImageCapture.CaptureDestinations",
            "QCameraImageCapture.CaptureDestination",
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameracapturedestinationcontrol.html#setCaptureD
        estination

        **[pure virtual] void QCameraCaptureDestinationControl::setCaptureDestin
        ation(QCameraImageCapture::CaptureDestinations destination )**

        Sets the capture **destination**.

        **See also** **captureDestination** ().
        """
        ...

    def captureDestination(self) -> "QCameraImageCapture.CaptureDestinations":
        """
        https://doc.qt.io/qt-5/qcameracapturedestinationcontrol.html#captureDest
        ination

        **[pure virtual] QCameraImageCapture::CaptureDestinations
        QCameraCaptureDestinationControl::captureDestination() const**

        Returns the current capture destination. The default destination is
        **QCameraImageCapture::CaptureToFile** .

        **See also** **setCaptureDestination** ().
        """
        ...

    def isCaptureDestinationSupported(
        self,
        destination: typing.Union[
            "QCameraImageCapture.CaptureDestinations",
            "QCameraImageCapture.CaptureDestination",
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameracapturedestinationcontrol.html#isCaptureDe
        stinationSupported

        **[pure virtual] bool QCameraCaptureDestinationControl::isCaptureDestina
        tionSupported(QCameraImageCapture::CaptureDestinations destination )
        const**

        Returns true if the capture **destination** is supported; and false if
        it is not.
        """
        ...

    @property
    def captureDestinationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameracapturedestinationcontrol.html#captureDest
        inationChanged

        **[signal] void QCameraCaptureDestinationControl::captureDestinationChan
        ged(QCameraImageCapture::CaptureDestinations destination )**

        Signals the image capture **destination** changed.
        """
        ...
