"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QCamera(QMediaObject):
    """
    https://doc.qt.io/qt-5/qcamera.html

    **Detailed Description**

    QCamera can be used with **QCameraViewfinder**  for viewfinder display,
    **QMediaRecorder**  for video recording and **QCameraImageCapture**  for
    image taking.

    You can use **QCameraInfo**  to list available cameras and choose which one
    to use.

    const **QList** <**QCameraInfo** > cameras = **QCameraInfo**
    ::availableCameras();
        for (const **QCameraInfo**  &cameraInfo : cameras)
    {
            if (cameraInfo.deviceName() == "mycamera")
                camera =
    new **QCamera** (cameraInfo);
        }

    See the **camera overview**  for more information.
    """

    class Position(int):
        UnspecifiedPosition: QCamera = ...
        BackFace: QCamera = ...
        FrontFace: QCamera = ...

    class LockType(int):
        NoLock: QCamera = ...
        LockExposure: QCamera = ...
        LockWhiteBalance: QCamera = ...
        LockFocus: QCamera = ...

    class LockChangeReason(int):
        UserRequest: QCamera = ...
        LockAcquired: QCamera = ...
        LockFailed: QCamera = ...
        LockLost: QCamera = ...
        LockTemporaryLost: QCamera = ...

    class LockStatus(int):
        Unlocked: QCamera = ...
        Searching: QCamera = ...
        Locked: QCamera = ...

    class Error(int):
        NoError: QCamera = ...
        CameraError: QCamera = ...
        InvalidRequestError: QCamera = ...
        ServiceMissingError: QCamera = ...
        NotSupportedFeatureError: QCamera = ...

    class CaptureMode(int):
        CaptureViewfinder: QCamera = ...
        CaptureStillImage: QCamera = ...
        CaptureVideo: QCamera = ...

    class State(int):
        UnloadedState: QCamera = ...
        LoadedState: QCamera = ...
        ActiveState: QCamera = ...

    class Status(int):
        UnavailableStatus: QCamera = ...
        UnloadedStatus: QCamera = ...
        LoadingStatus: QCamera = ...
        UnloadingStatus: QCamera = ...
        LoadedStatus: QCamera = ...
        StandbyStatus: QCamera = ...
        StartingStatus: QCamera = ...
        StoppingStatus: QCamera = ...
        ActiveStatus: QCamera = ...

    class CaptureModes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QCamera.CaptureModes", "QCamera.CaptureMode"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QCamera.CaptureModes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QCamera.CaptureModes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class LockTypes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QCamera.LockTypes", "QCamera.LockType"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QCamera.LockTypes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QCamera.LockTypes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class FrameRateRange(sip.simplewrapper):
        maximumFrameRate: float = ...
        minimumFrameRate: float = ...

        @typing.overload
        def __init__(self, minimum: float, maximum: float) -> None:
            ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QCamera.FrameRateRange") -> None:
            ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#QCamera

        **QCamera::QCamera(QObject * parent = nullptr)**

        Construct a QCamera with a **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        device: typing.Union[QtCore.QByteArray, bytes, bytearray],
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#QCamera-1

        **QCamera::QCamera(const QByteArray & deviceName , QObject * parent =
        nullptr)**

        Construct a QCamera from **deviceName** and **parent**.

        If no camera with that **deviceName** exists, the camera object will be
        invalid.
        """
        ...

    @typing.overload
    def __init__(
        self, cameraInfo: "QCameraInfo", parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#QCamera-2

        **QCamera::QCamera(const QCameraInfo & cameraInfo , QObject * parent =
        nullptr)**

        Construct a QCamera from a camera description **cameraInfo** and
        **parent**.

        This function was introduced in Qt 5.3.
        """
        ...

    @typing.overload
    def __init__(
        self,
        position: "QCamera.Position",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#QCamera-3

        **QCamera::QCamera(QCamera::Position position , QObject * parent =
        nullptr)**

        Construct a QCamera which uses a hardware camera located a the specified
        **position**.

        For example on a mobile phone it can be used to easily choose between
        front-facing and back-facing cameras.

        If no camera is available at the specified **position** or if
        **position** is **QCamera::UnspecifiedPosition** , the default camera is
        used.

        This function was introduced in Qt 5.3.
        """
        ...

    def supportedViewfinderPixelFormats(
        self, settings: "QCameraViewfinderSettings" = ...
    ) -> typing.List["QVideoFrame.PixelFormat"]:
        """
        https://doc.qt.io/qt-5/qcamera.html#supportedViewfinderPixelFormats

        **QList<QVideoFrame::PixelFormat>
        QCamera::supportedViewfinderPixelFormats(const QCameraViewfinderSettings
        & settings = QCameraViewfinderSettings()) const**

        Returns a list of supported viewfinder pixel formats.

        This is a convenience function which retrieves unique pixel formats from
        the supported settings.

        If non null viewfinder **settings** are passed, the returned list is
        reduced to pixel formats supported with partial **settings** applied.

        The camera must be loaded before calling this function, otherwise the
        returned list is empty.

        This function was introduced in Qt 5.5.

        **See also** **QCameraViewfinderSettings::pixelFormat** () and
        **setViewfinderSettings** ().
        """
        ...

    def supportedViewfinderFrameRateRanges(
        self, settings: "QCameraViewfinderSettings" = ...
    ) -> typing.List["QCamera.FrameRateRange"]:
        """
        https://doc.qt.io/qt-5/qcamera.html#supportedViewfinderFrameRateRanges

        **QList<QCamera::FrameRateRange>
        QCamera::supportedViewfinderFrameRateRanges(const
        QCameraViewfinderSettings & settings = QCameraViewfinderSettings())
        const**

        Returns a list of supported viewfinder frame rate ranges.

        This is a convenience function which retrieves unique frame rate ranges
        from the supported settings.

        If non null viewfinder **settings** are passed, the returned list is
        reduced to frame rate ranges supported with partial **settings**
        applied.

        The camera must be loaded before calling this function, otherwise the
        returned list is empty.

        This function was introduced in Qt 5.5.

        **See also** **QCameraViewfinderSettings::minimumFrameRate** (),
        **QCameraViewfinderSettings::maximumFrameRate** (), and
        **setViewfinderSettings** ().
        """
        ...

    def supportedViewfinderResolutions(
        self, settings: "QCameraViewfinderSettings" = ...
    ) -> typing.List[QtCore.QSize]:
        """
        https://doc.qt.io/qt-5/qcamera.html#supportedViewfinderResolutions

        **QList<QSize> QCamera::supportedViewfinderResolutions(const
        QCameraViewfinderSettings & settings = QCameraViewfinderSettings())
        const**

        Returns a list of supported viewfinder resolutions.

        This is a convenience function which retrieves unique resolutions from
        the supported settings.

        If non null viewfinder **settings** are passed, the returned list is
        reduced to resolutions supported with partial **settings** applied.

        The camera must be loaded before calling this function, otherwise the
        returned list is empty.

        This function was introduced in Qt 5.5.

        **See also** **QCameraViewfinderSettings::resolution** () and
        **setViewfinderSettings** ().
        """
        ...

    def supportedViewfinderSettings(
        self, settings: "QCameraViewfinderSettings" = ...
    ) -> typing.List["QCameraViewfinderSettings"]:
        """
        https://doc.qt.io/qt-5/qcamera.html#supportedViewfinderSettings

        **QList<QCameraViewfinderSettings>
        QCamera::supportedViewfinderSettings(const QCameraViewfinderSettings &
        settings = QCameraViewfinderSettings()) const**

        Returns a list of supported viewfinder settings.

        The list is ordered by preference; preferred settings come first.

        The optional **settings** argument can be used to conveniently filter
        the results. If **settings** is non null, the returned list is reduced
        to settings matching the given partial **settings**.

        The status of the camera must be **LoadedStatus**  before calling this
        function, otherwise the returned list is empty.

        This function was introduced in Qt 5.5.

        **See also** **setViewfinderSettings** (),
        **supportedViewfinderResolutions** (),
        **supportedViewfinderFrameRateRanges** (), and
        **supportedViewfinderPixelFormats** ().
        """
        ...

    def setViewfinderSettings(self, settings: "QCameraViewfinderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#setViewfinderSettings

        **void QCamera::setViewfinderSettings(const QCameraViewfinderSettings &
        settings )**

        Sets the viewfinder **settings**.

        If some parameters are not specified, or null settings are passed, the
        camera will choose default values.

        If the camera is used to capture videos or images, the viewfinder
        settings might be ignored if they conflict with the capture settings.
        You can check the actual viewfinder settings once the camera is in the
        `QCamera::ActiveStatus` status.

        Changing the viewfinder settings while the camera is in the
        **QCamera::ActiveState**  state may cause the camera to be restarted.

        This function was introduced in Qt 5.5.

        **See also** **viewfinderSettings** (),
        **supportedViewfinderResolutions** (),
        **supportedViewfinderFrameRateRanges** (), and
        **supportedViewfinderPixelFormats** ().
        """
        ...

    def viewfinderSettings(self) -> "QCameraViewfinderSettings":
        """
        https://doc.qt.io/qt-5/qcamera.html#viewfinderSettings

        **QCameraViewfinderSettings QCamera::viewfinderSettings() const**

        Returns the viewfinder settings being used by the camera.

        Settings may change when the camera is started, for example if the
        viewfinder settings are undefined or if unsupported values are set.

        If viewfinder settings are not supported by the camera, it always
        returns a null **QCameraViewfinderSettings**  object.

        This function was introduced in Qt 5.5.

        **See also** **setViewfinderSettings** ().
        """
        ...

    @typing.overload
    def unlock(self) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#unlock

        **[slot] void QCamera::unlock()**

        Unlock all the requested camera locks.
        """
        ...

    @typing.overload
    def unlock(
        self, locks: typing.Union["QCamera.LockTypes", "QCamera.LockType"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#unlock-1

        **[slot] void QCamera::unlock(QCamera::LockTypes locks )**

        Unlocks the camera settings specified with **locks** or cancel the
        current locking if one is active.
        """
        ...

    @typing.overload
    def searchAndLock(self) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#searchAndLock

        **[slot] void QCamera::searchAndLock()**

        Lock all the supported camera settings.
        """
        ...

    @typing.overload
    def searchAndLock(
        self, locks: typing.Union["QCamera.LockTypes", "QCamera.LockType"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#searchAndLock-1

        **[slot] void QCamera::searchAndLock(QCamera::LockTypes locks )**

        Locks the camera settings with the requested **locks** , including
        focusing in the single autofocus mode, exposure and white balance if the
        exposure and white balance modes are not manual.

        The camera settings are usually locked before taking one or multiple
        still images, in responce to the shutter button being half pressed.

        The **QCamera::locked** () signal is emitted when camera settings are
        successfully locked, otherwise **QCamera::lockFailed** () is emitted.

        **QCamera**  also emits **lockStatusChanged** (**QCamera::LockType** ,
        **QCamera::LockStatus** ) on individual lock status changes and
        **lockStatusChanged** (**QCamera::LockStatus** ) signal on composite
        status changes.

        Locking serves two roles: it initializes calculation of automatic
        parameter (focusing, calculating the correct exposure and white balance)
        and allows to keep some or all of those parameters during number of
        shots.

        If the camera doesn't support keeping one of parameters between shots,
        the related lock state changes to **QCamera::Unlocked** .

        It's also acceptable to relock already locked settings, depending on the
        lock parameter this initiates new focusing, exposure or white balance
        calculation.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#stop

        **[slot] void QCamera::stop()**

        Stops the camera. The camera state is changed from
        **QCamera::ActiveState**  to **QCamera::LoadedState** .

        In this state, the camera still consumes power.

        **See also** **unload** () and **QCamera::UnloadedState** .
        """
        ...

    def start(self) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#start

        **[slot] void QCamera::start()**

        Starts the camera.

        State is changed to **QCamera::ActiveState**  if camera is started
        successfully, otherwise **errorOccurred** () signal is emitted.

        While the camera state is changed to **QCamera::ActiveState** , starting
        the camera service can be asynchronous with the actual status reported
        with **QCamera::status**  property.
        """
        ...

    def unload(self) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#unload

        **[slot] void QCamera::unload()**

        Closes the camera device and deallocates the related resources. The
        camera state is changed to **QCamera::UnloadedState** .
        """
        ...

    def load(self) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#load

        **[slot] void QCamera::load()**

        Opens the camera device. The camera state is changed to
        **QCamera::LoadedState** .

        It's not necessary to explicitly load the camera, unless the application
        needs to read the supported camera settings and change the default
        values according to the camera capabilities.

        In all the other cases, it's possible to start the camera directly from
        the unloaded state.

        /sa **QCamera::UnloadedState**
        """
        ...

    def setCaptureMode(
        self, mode: typing.Union["QCamera.CaptureModes", "QCamera.CaptureMode"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#captureMode-prop

        **captureMode : QCamera::CaptureModes**

        The type of media (video or still images), the camera is configured to
        capture.

        It's allowed to change capture mode in any camera state, but if the
        camera is currently active, chaging capture mode is likely to lead to
        camera status chaged to **QCamera::LoadedStatus** ,
        **QCamera::LoadingStatus** , and when the camera is ready to
        **QCamera::ActiveStatus** .

        **Access functions:**

        QCamera::CaptureModes **captureMode** () const
        void **setCaptureMode**
        (QCamera::CaptureModes **mode** )

        **Notifier signal:**

        void ****captureModeChanged** ** (QCamera::CaptureModes **mode** )
        """
        ...

    @typing.overload
    def lockStatus(self) -> "QCamera.LockStatus":
        """
        https://doc.qt.io/qt-5/qcamera.html#lockStatus

        **QCamera::LockStatus QCamera::lockStatus() const**

        Returns the status of requested camera settings locks.

        **Note:** Getter function for property lockStatus.
        """
        ...

    @typing.overload
    def lockStatus(self, lock: "QCamera.LockType") -> "QCamera.LockStatus":
        """
        https://doc.qt.io/qt-5/qcamera.html#lockStatus-prop

        **lockStatus : const QCamera::LockStatus**

        This property holds the overall status for all the requested camera
        locks.

        **Access functions:**

        QCamera::LockStatus ****lockStatus** ** () const
        QCamera::LockStatus
        ****lockStatus** ** (QCamera::LockType **lockType** ) const

        **Notifier signal:**

        void ****lockStatusChanged** ** (QCamera::LockStatus **status** ,
        QCamera::LockChangeReason **reason** )
        void ****lockStatusChanged** **
        (QCamera::LockType **lock** , QCamera::LockStatus **status** ,
        QCamera::LockChangeReason **reason** )
        """
        ...

    def requestedLocks(self) -> "QCamera.LockTypes":
        """
        https://doc.qt.io/qt-5/qcamera.html#requestedLocks

        **QCamera::LockTypes QCamera::requestedLocks() const**

        Returns the requested lock types.
        """
        ...

    def supportedLocks(self) -> "QCamera.LockTypes":
        """
        https://doc.qt.io/qt-5/qcamera.html#supportedLocks

        **QCamera::LockTypes QCamera::supportedLocks() const**

        Returns the lock types that the camera supports.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qcamera.html#errorString

        **QString QCamera::errorString() const**

        Returns a string describing a camera's error state.
        """
        ...

    @typing.overload
    def error(self) -> "QCamera.Error":
        """
        https://doc.qt.io/qt-5/qcamera.html#error

        **QCamera::Error QCamera::error() const**

        Returns the error state of the object.
        """
        ...

    @typing.overload
    def error(self, a0: "QCamera.Error") -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#error

        **QCamera::Error QCamera::error() const**

        Returns the error state of the object.
        """
        ...

    @typing.overload
    def setViewfinder(self, viewfinder: QVideoWidget) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#setViewfinder

        **void QCamera::setViewfinder(QVideoWidget * viewfinder )**

        Sets the **QVideoWidget**  based camera **viewfinder**. The previously
        set viewfinder is detached.
        """
        ...

    @typing.overload
    def setViewfinder(self, viewfinder: QGraphicsVideoItem) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#setViewfinder-1

        **void QCamera::setViewfinder(QGraphicsVideoItem * viewfinder )**

        Sets the **QGraphicsVideoItem**  based camera **viewfinder**. The
        previously set viewfinder is detached.
        """
        ...

    @typing.overload
    def setViewfinder(self, surface: QAbstractVideoSurface) -> None:
        """
        https://doc.qt.io/qt-5/qcamera.html#setViewfinder-2

        **void QCamera::setViewfinder(QAbstractVideoSurface * surface )**

        Sets a video **surface** as the viewfinder of a camera.

        If a viewfinder has already been set on the camera the new surface will
        replace it.
        """
        ...

    def imageProcessing(self) -> "QCameraImageProcessing":
        """
        https://doc.qt.io/qt-5/qcamera.html#imageProcessing

        **QCameraImageProcessing *QCamera::imageProcessing() const**

        Returns the camera image processing control object.
        """
        ...

    def focus(self) -> "QCameraFocus":
        """
        https://doc.qt.io/qt-5/qcamera.html#focus

        **QCameraFocus *QCamera::focus() const**

        Returns the camera focus control object.
        """
        ...

    def exposure(self) -> "QCameraExposure":
        """
        https://doc.qt.io/qt-5/qcamera.html#exposure

        **QCameraExposure *QCamera::exposure() const**

        Returns the camera exposure control object.
        """
        ...

    def isCaptureModeSupported(
        self, mode: typing.Union["QCamera.CaptureModes", "QCamera.CaptureMode"]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcamera.html#isCaptureModeSupported

        **bool QCamera::isCaptureModeSupported(QCamera::CaptureModes mode )
        const**

        Returns true if the capture **mode** is suported.
        """
        ...

    def captureMode(self) -> "QCamera.CaptureModes":
        """
        https://doc.qt.io/qt-5/qcamera.html#captureMode-prop

        **captureMode : QCamera::CaptureModes**

        The type of media (video or still images), the camera is configured to
        capture.

        It's allowed to change capture mode in any camera state, but if the
        camera is currently active, chaging capture mode is likely to lead to
        camera status chaged to **QCamera::LoadedStatus** ,
        **QCamera::LoadingStatus** , and when the camera is ready to
        **QCamera::ActiveStatus** .

        **Access functions:**

        QCamera::CaptureModes **captureMode** () const
        void **setCaptureMode**
        (QCamera::CaptureModes **mode** )

        **Notifier signal:**

        void ****captureModeChanged** ** (QCamera::CaptureModes **mode** )
        """
        ...

    def status(self) -> "QCamera.Status":
        """
        https://doc.qt.io/qt-5/qcamera.html#status-prop

        **status : const QCamera::Status**

        This property holds the current status of the camera object.

        **Access functions:**

        QCamera::Status **status** () const

        **Notifier signal:**

        void ****statusChanged** ** (QCamera::Status **status** )

        **Member Function Documentation**
        """
        ...

    def state(self) -> "QCamera.State":
        """
        https://doc.qt.io/qt-5/qcamera.html#state-prop

        **state : const QCamera::State**

        This property holds the current state of the camera object.

        **Access functions:**

        QCamera::State **state** () const

        **Notifier signal:**

        void ****stateChanged** ** (QCamera::State **state** )
        """
        ...

    def availability(self) -> "QMultimedia.AvailabilityStatus":
        """
        https://doc.qt.io/qt-5/qcamera.html#availability

        **[override virtual] QMultimedia::AvailabilityStatus
        QCamera::availability() const**

        Reimplements: **QMediaObject::availability** () const.

        Returns the availability state of the camera service.
        """
        ...

    @staticmethod
    def deviceDescription(
        device: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> str:
        ...

    @staticmethod
    def availableDevices() -> typing.List[QtCore.QByteArray]:
        ...

    @property
    def captureModeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamera.html#captureModeChanged

        **[signal] void QCamera::captureModeChanged(QCamera::CaptureModes mode
        )**

        Signals the capture **mode** has changed.

        **Note:** Notifier signal for property **captureMode** .
        """
        ...

    @property
    def errorOccurred(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamera.html#errorOccurred

        **[signal] void QCamera::errorOccurred(QCamera::Error value )**

        Signal emitted when error state changes to **value**.

        This function was introduced in Qt 5.15.
        """
        ...

    @property
    def lockFailed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamera.html#lockFailed

        **[signal] void QCamera::lockFailed()**

        Signals locking of at least one requested camera settings failed.
        """
        ...

    @property
    def lockStatusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamera.html#lockStatusChanged

        **[signal] void QCamera::lockStatusChanged(QCamera::LockStatus status ,
        QCamera::LockChangeReason reason )**

        Signals the overall **status** for all the requested camera locks was
        changed with specified **reason**.

        **Note:** Notifier signal for property **lockStatus** .

        **Note:** Signal **lockStatusChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(camera, QOverload<**QCamera** ::LockStatus, **QCamera**
        ::LockChangeReason>::of(&**QCamera** ::lockStatusChanged),
        [=](**QCamera** ::LockStatus status, **QCamera** ::LockChangeReason
        reason){ /* ... */ });
        """
        ...

    @property
    def lockStatusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamera.html#lockStatusChanged-1

        **[signal] void QCamera::lockStatusChanged(QCamera::LockType lock ,
        QCamera::LockStatus status , QCamera::LockChangeReason reason )**

        Signals the **lock** **status** was changed with specified **reason**.

        **Note:** Notifier signal for property **lockStatus** .

        **Note:** Signal **lockStatusChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(camera, QOverload<**QCamera** ::LockType, **QCamera**
        ::LockStatus, **QCamera** ::LockChangeReason>::of(&**QCamera**
        ::lockStatusChanged),
                [=](**QCamera** ::LockType lock,
        **QCamera** ::LockStatus status, **QCamera** ::LockChangeReason reason){
        /* ... */ });
        """
        ...

    @property
    def locked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamera.html#locked

        **[signal] void QCamera::locked()**

        Signals all the requested camera settings are locked.
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamera.html#stateChanged

        **[signal] void QCamera::stateChanged(QCamera::State state )**

        Signals the camera **state** has changed.

        Usually the state changes is caused by calling **load** (), **unload**
        (), **start** () and **stop** (), but the state can also be changed
        change as a result of camera error.

        **Note:** Notifier signal for property **state** .
        """
        ...

    @property
    def statusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamera.html#statusChanged

        **[signal] void QCamera::statusChanged(QCamera::Status status )**

        Signals the camera **status** has changed.

        **Note:** Notifier signal for property **status** .
        """
        ...
