"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QAudioRecorder(QMediaRecorder):
    """
    https://doc.qt.io/qt-5/qaudiorecorder.html

    **Detailed Description**

    The QAudioRecorder class is a high level media recording class and contains
    the same functionality as **QMediaRecorder** .

    audioRecorder = new **QAudioRecorder** ;

        **QAudioEncoderSettings**
    audioSettings;
        audioSettings.setCodec("audio/amr");
    audioSettings.setQuality(QMultimedia::HighQuality);
    audioRecorder->setEncodingSettings(audioSettings);
    audioRecorder->setOutputLocation(**QUrl** ::fromLocalFile("test.amr"));
    audioRecorder->record();

    In addition QAudioRecorder provides functionality for selecting the audio
    input.

    const **QStringList**  inputs = audioRecorder->audioInputs();
    **QString**  selectedInput = audioRecorder->defaultAudioInput();
    for (const **QString**  &input : inputs) {
            **QString**  description
    = audioRecorder->audioInputDescription(input);
            // show descriptions
    to user and allow selection
            selectedInput = input;
        }
    audioRecorder->setAudioInput(selectedInput);

    The **Audio Recorder Example**  shows how to use this class in more detail.

    **See also** **QMediaRecorder**  and **QAudioInputSelectorControl** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qaudiorecorder.html#QAudioRecorder

        **QAudioRecorder::QAudioRecorder(QObject * parent = nullptr)**

        Constructs an audio recorder. The **parent** is passed to
        **QMediaObject** .
        """
        ...

    def setAudioInput(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qaudiorecorder.html#setAudioInput

        **[slot] void QAudioRecorder::setAudioInput(const QString & name )**

        Set the active audio input to **name**.

        **Note:** Setter function for property **audioInput** .

        **See also** **audioInput** ().
        """
        ...

    def audioInput(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudiorecorder.html#audioInput

        **QString QAudioRecorder::audioInput() const**

        Returns the active audio input name.

        **Note:** Getter function for property audioInput.

        **See also** **setAudioInput** ().
        """
        ...

    def audioInputDescription(self, name: str) -> str:
        """
        https://doc.qt.io/qt-5/qaudiorecorder.html#audioInputDescription

        **QString QAudioRecorder::audioInputDescription(const QString & name )
        const**

        Returns the readable translated description of the audio input device
        with **name**.
        """
        ...

    def defaultAudioInput(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudiorecorder.html#defaultAudioInput

        **QString QAudioRecorder::defaultAudioInput() const**

        Returns the default audio input name.
        """
        ...

    def audioInputs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qaudiorecorder.html#audioInputs

        **QStringList QAudioRecorder::audioInputs() const**

        Returns a list of available audio inputs
        """
        ...

    @property
    def audioInputChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiorecorder.html#audioInputChanged

        **[signal] void QAudioRecorder::audioInputChanged(const QString & name
        )**

        Signal emitted when active audio input changes to **name**.

        **Note:** Notifier signal for property **audioInput** .
        """
        ...

    @property
    def availableAudioInputsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiorecorder.html#availableAudioInputsChanged

        **[signal] void QAudioRecorder::availableAudioInputsChanged()**

        Signal is emitted when the available audio inputs change.
        """
        ...
