"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QAudioDecoder(QMediaObject):
    """
    https://doc.qt.io/qt-5/qaudiodecoder.html

    **Detailed Description**

    The QAudioDecoder class is a high level class for decoding local audio media
    files. It is similar to the **QMediaPlayer**  class except that audio is
    provided back through this API rather than routed directly to audio
    hardware, and playlists and network and streaming based media is not
    supported.

    **See also** **QAudioBuffer** .
    """

    class Error(int):
        NoError: QAudioDecoder = ...
        ResourceError: QAudioDecoder = ...
        FormatError: QAudioDecoder = ...
        AccessDeniedError: QAudioDecoder = ...
        ServiceMissingError: QAudioDecoder = ...

    class State(int):
        StoppedState: QAudioDecoder = ...
        DecodingState: QAudioDecoder = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#QAudioDecoder

        **QAudioDecoder::QAudioDecoder(QObject * parent = nullptr)**

        Construct an QAudioDecoder instance parented to **parent**.
        """
        ...

    def unbind(self, a0: QtCore.QObject) -> None:
        ...

    def bind(self, a0: QtCore.QObject) -> bool:
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#stop

        **[slot] void QAudioDecoder::stop()**

        Stop decoding audio. Calling **start** () again will resume decoding
        from the beginning.
        """
        ...

    def start(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#start

        **[slot] void QAudioDecoder::start()**

        Starts decoding the audio resource.

        As data gets decoded, the **bufferReady** () signal will be emitted when
        enough data has been decoded. Calling **read** () will then return an
        audio buffer without blocking.

        If you call **read** () before a buffer is ready, an invalid buffer will
        be returned, again without blocking.

        **See also** **read** ().
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#duration

        **qint64 QAudioDecoder::duration() const**

        Returns total duration (in milliseconds) of the audio stream or -1 if
        not available.
        """
        ...

    def position(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#position

        **qint64 QAudioDecoder::position() const**

        Returns position (in milliseconds) of the last buffer read from the
        decoder or -1 if no buffers have been read.
        """
        ...

    def bufferAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#bufferAvailable

        **bool QAudioDecoder::bufferAvailable() const**

        Returns true if a buffer is available to be read, and false otherwise.
        If there is no buffer available, calling the **read** () function will
        return an invalid buffer.

        **Note:** Getter function for property bufferAvailable.
        """
        ...

    def read(self) -> QAudioBuffer:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#read

        **QAudioBuffer QAudioDecoder::read() const**

        Read a buffer from the decoder, if one is available. Returns an invalid
        buffer if there are no decoded buffers currently available, or on
        failure. In both cases this function will not block.

        You should either respond to the **bufferReady** () signal or check the
        **bufferAvailable** () function before calling read() to make sure you
        get useful data.
        """
        ...

    def errorString(self) -> str:
        ...

    def setAudioFormat(self, format: "QAudioFormat") -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#setAudioFormat

        **void QAudioDecoder::setAudioFormat(const QAudioFormat & format )**

        Set the desired audio format for decoded samples to **format**.

        This property can only be set while the decoder is stopped. Setting this
        property at other times will be ignored.

        If the decoder does not support this format, **error** () will be set to
        `FormatError`.

        If you do not specify a format, the format of the decoded audio itself
        will be used. Otherwise, some format conversion will be applied.

        If you wish to reset the decoded format to that of the original audio
        file, you can specify an invalid **format**.

        **See also** **audioFormat** ().
        """
        ...

    def audioFormat(self) -> "QAudioFormat":
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#audioFormat

        **QAudioFormat QAudioDecoder::audioFormat() const**

        Returns the current audio format of the decoded stream.

        Any buffers returned should have this format.

        **See also** **setAudioFormat** () and **formatChanged** ().
        """
        ...

    def setSourceDevice(self, device: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#setSourceDevice

        **void QAudioDecoder::setSourceDevice(QIODevice * device )**

        Sets the current audio **QIODevice**  to **device**.

        When this property is set any current decoding is stopped, and any audio
        buffers are discarded.

        You can only specify either a source filename or a source **QIODevice**
        . Setting one will unset the other.

        **See also** **sourceDevice** ().
        """
        ...

    def sourceDevice(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#sourceDevice

        **QIODevice *QAudioDecoder::sourceDevice() const**

        Returns the current source **QIODevice** , if one was set. If
        **setSourceFilename** () was called, this will be 0.

        **See also** **setSourceDevice** ().
        """
        ...

    def setSourceFilename(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#setSourceFilename

        **void QAudioDecoder::setSourceFilename(const QString & fileName )**

        Sets the current audio file name to **fileName**.

        When this property is set any current decoding is stopped, and any audio
        buffers are discarded.

        You can only specify either a source filename or a source **QIODevice**
        . Setting one will unset the other.

        **Note:** Setter function for property **sourceFilename** .

        **See also** **sourceFilename** ().
        """
        ...

    def sourceFilename(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#sourceFilename

        **QString QAudioDecoder::sourceFilename() const**

        Returns the current file name to decode. If **setSourceDevice**  was
        called, this will be empty.

        **Note:** Getter function for property sourceFilename.

        **See also** **setSourceFilename** ().
        """
        ...

    def state(self) -> "QAudioDecoder.State":
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#state-prop

        **state : const State**

        This property holds the audio decoder's playback state.

        By default this property is QAudioDecoder::Stopped

        **Access functions:**

        QAudioDecoder::State **state** () const

        **Notifier signal:**

        void ****stateChanged** ** (QAudioDecoder::State **state** )

        **See also** **start** () and **stop** ().

        **Member Function Documentation**
        """
        ...

    @staticmethod
    def hasSupport(
        mimeType: str, codecs: typing.Iterable[str] = ...
    ) -> "QMultimedia.SupportEstimate":
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#hasSupport

        **[static] QMultimedia::SupportEstimate QAudioDecoder::hasSupport(const
        QString & mimeType , const QStringList & codecs = QStringList())**

        Returns the level of support an audio decoder has for a **mimeType** and
        a set of **codecs**.
        """
        ...

    @property
    def bufferAvailableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#bufferAvailableChanged

        **[signal] void QAudioDecoder::bufferAvailableChanged(bool available )**

        Signals the availability (if **available** is true) of a new buffer.

        If **available** is false, there are no buffers available.

        **Note:** Notifier signal for property **bufferAvailable** .

        **See also** **bufferAvailable** () and **bufferReady** ().
        """
        ...

    @property
    def bufferReady(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#bufferReady

        **[signal] void QAudioDecoder::bufferReady()**

        Signals that a new decoded audio buffer is available to be read.

        **See also** **read** () and **bufferAvailable** ().
        """
        ...

    @property
    def durationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#durationChanged

        **[signal] void QAudioDecoder::durationChanged(qint64 duration )**

        Signals that the estimated **duration** of the decoded data has changed.

        **See also** **positionChanged** ().
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#error

        **QAudioDecoder::Error QAudioDecoder::error() const**

        Returns the current error state.
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#finished

        **[signal] void QAudioDecoder::finished()**

        Signals that the decoding has finished successfully. If decoding fails,
        error signal is emitted instead.

        **See also** **start** (), **stop** (), and **error** ().
        """
        ...

    @property
    def formatChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#formatChanged

        **[signal] void QAudioDecoder::formatChanged(const QAudioFormat & format
        )**

        Signals that the current audio format of the decoder has changed to
        **format**.

        **See also** **audioFormat** () and **setAudioFormat** ().
        """
        ...

    @property
    def positionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#positionChanged

        **[signal] void QAudioDecoder::positionChanged(qint64 position )**

        Signals that the current **position** of the decoder has changed.

        **See also** **durationChanged** ().
        """
        ...

    @property
    def sourceChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#sourceChanged

        **[signal] void QAudioDecoder::sourceChanged()**

        Signals that the current source of the decoder has changed.

        **Note:** Notifier signal for property **sourceFilename** .

        **See also** **sourceFilename** () and **sourceDevice** ().
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecoder.html#stateChanged

        **[signal] void QAudioDecoder::stateChanged(QAudioDecoder::State state
        )**

        Signal the **state** of the decoder object has changed.

        **Note:** Notifier signal for property **state** .
        """
        ...
