"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QAudioBuffer(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qaudiobuffer.html

    **Detailed Description**
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#QAudioBuffer

        **QAudioBuffer::QAudioBuffer()**

        Create a new, empty, invalid buffer.
        """
        ...

    @typing.overload
    def __init__(
        self,
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
        format: "QAudioFormat",
        startTime: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#QAudioBuffer-1

        **QAudioBuffer::QAudioBuffer(const QByteArray & data , const
        QAudioFormat & format , qint64 startTime = -1)**

        Creates a new audio buffer from the supplied **data** , in the given
        **format**. The format will determine how the number and sizes of the
        samples are interpreted from the **data**.

        If the supplied **data** is not an integer multiple of the calculated
        frame size, the excess data will not be used.

        This audio buffer will copy the contents of **data**.

        **startTime** (in microseconds) indicates when this buffer starts in the
        stream. If this buffer is not part of a stream, set it to -1.
        """
        ...

    @typing.overload
    def __init__(
        self, numFrames: int, format: "QAudioFormat", startTime: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#QAudioBuffer-2

        **QAudioBuffer::QAudioBuffer(int numFrames , const QAudioFormat & format
        , qint64 startTime = -1)**

        Creates a new audio buffer with space for **numFrames** frames of the
        given **format**. The individual samples will be initialized to the
        default for the format.

        **startTime** (in microseconds) indicates when this buffer starts in the
        stream. If this buffer is not part of a stream, set it to -1.
        """
        ...

    @typing.overload
    def __init__(self, other: "QAudioBuffer") -> None:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#QAudioBuffer

        **QAudioBuffer::QAudioBuffer()**

        Create a new, empty, invalid buffer.
        """
        ...

    def data(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#data

        **const void *QAudioBuffer::data() const**

        Returns a pointer to this buffer's data. You can only read it.

        You should use the **constData** () function rather than this to prevent
        accidental deep copying.

        There is also a templatized version of this data() function that allows
        you to retrieve a specific type of read-only pointer to the data. Note
        that there is no checking done on the format of the audio buffer - this
        is simply a convenience function.

        // With a 16bit sample const buffer:
            const **quint16**  *data =
        buffer->data<**quint16** >();
        """
        ...

    def constData(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#constData

        **const void *QAudioBuffer::constData() const**

        Returns a pointer to this buffer's data. You can only read it.

        This method is preferred over the const version of **data** () to
        prevent unnecessary copying.

        There is also a templatized version of this constData() function that
        allows you to retrieve a specific type of read-only pointer to the data.
        Note that there is no checking done on the format of the audio buffer -
        this is simply a convenience function.

        // With a 16bit sample buffer:
            const **quint16**  *data =
        buffer->constData<**quint16** >();
        """
        ...

    def startTime(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#startTime

        **qint64 QAudioBuffer::startTime() const**

        Returns the time in a stream that this buffer starts at (in
        microseconds).

        If this buffer is not part of a stream, this will return -1.
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#duration

        **qint64 QAudioBuffer::duration() const**

        Returns the duration of audio in this buffer, in microseconds.

        This depends on the **format** (), and the **frameCount** ().
        """
        ...

    def byteCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#byteCount

        **int QAudioBuffer::byteCount() const**

        Returns the size of this buffer, in bytes.
        """
        ...

    def sampleCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#sampleCount

        **int QAudioBuffer::sampleCount() const**

        Returns the number of samples in this buffer.

        If the format of this buffer has multiple channels, then this count
        includes all channels. This means that a stereo buffer with 1000 samples
        in total will have 500 left samples and 500 right samples (interleaved),
        and this function will return 1000.

        **See also** **frameCount** ().
        """
        ...

    def frameCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#frameCount

        **int QAudioBuffer::frameCount() const**

        Returns the number of complete audio frames in this buffer.

        An audio frame is an interleaved set of one sample per channel for the
        same instant in time.
        """
        ...

    def format(self) -> "QAudioFormat":
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#format

        **QAudioFormat QAudioBuffer::format() const**

        Returns the **format**  of this buffer.

        Several properties of this format influence how the **duration** () or
        **byteCount** () are calculated from the **frameCount** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qaudiobuffer.html#isValid

        **bool QAudioBuffer::isValid() const**

        Returns true if this is a valid buffer. A valid buffer has more than
        zero frames in it and a valid format.
        """
        ...
