"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtLocation import *
from PyQt5 import sip


class QPlaceSupplier(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplacesupplier.html

    **Detailed Description**

    Each instance represents a set of data about a supplier, which can include
    supplier's name, url and icon. The supplier is typically a business or
    organization.

    Note: The Places API only supports suppliers as 'retrieve-only' objects.
    Submitting suppliers to a provider is not a supported use case.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#QPlaceSupplier

        **QPlaceSupplier::QPlaceSupplier()**

        Constructs a new supplier object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlaceSupplier") -> None:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#QPlaceSupplier-1

        **QPlaceSupplier::QPlaceSupplier(const QPlaceSupplier & other )**

        Constructs a copy of **other**.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#isEmpty

        **bool QPlaceSupplier::isEmpty() const**

        Returns true if all fields of the place supplier are 0; otherwise
        returns false.
        """
        ...

    def setIcon(self, icon: QPlaceIcon) -> None:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#setIcon

        **void QPlaceSupplier::setIcon(const QPlaceIcon & icon )**

        Sets the **icon** of the supplier.

        **See also** **icon** ().
        """
        ...

    def icon(self) -> QPlaceIcon:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#icon

        **QPlaceIcon QPlaceSupplier::icon() const**

        Returns the icon of the supplier.

        **See also** **setIcon** ().
        """
        ...

    def setUrl(self, data: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#setUrl

        **void QPlaceSupplier::setUrl(const QUrl & url )**

        Sets the **url** of the supplier's website.

        **See also** **url** ().
        """
        ...

    def url(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#url

        **QUrl QPlaceSupplier::url() const**

        Returns the URL of the supplier's website.

        **See also** **setUrl** ().
        """
        ...

    def setSupplierId(self, identifier: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#setSupplierId

        **void QPlaceSupplier::setSupplierId(const QString & identifier )**

        Sets the **identifier** of the supplier.

        **See also** **supplierId** ().
        """
        ...

    def supplierId(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#supplierId

        **QString QPlaceSupplier::supplierId() const**

        Returns the identifier of the supplier. The identifier is unique to the
        manager backend which provided the supplier and is generally not
        suitable for displaying to the user.

        **See also** **setSupplierId** ().
        """
        ...

    def setName(self, data: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#setName

        **void QPlaceSupplier::setName(const QString & name )**

        Sets the **name** of the supplier.

        **See also** **name** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacesupplier.html#name

        **QString QPlaceSupplier::name() const**

        Returns the name of the supplier which can be displayed to the user.

        The name can potentially be localized. The language is dependent on the
        entity that sets it, typically this is the **QPlaceManager** . The
        **QPlaceManager::locales** () field defines what language is used.

        **See also** **setName** ().
        """
        ...
