"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtPositioning
from PyQt5.QtLocation import *
from PyQt5 import sip


class QPlaceSearchRequest(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplacesearchrequest.html

    **Detailed Description**

    A typical search request may look like the following:

    **QPlaceSearchRequest**  searchRequest;
    searchRequest.setSearchTerm("Fast food"); //search term for what we are
    interested in

        //set a search center
    searchRequest.setSearchArea(**QGeoCircle** (**QGeoCoordinate** (2.3,
    48.87)));

        //set a distance hint as a relevancy hint.
        //closer
    places have greater weighting in the ranking of results.
    searchRequest.setRelevanceHint(**QPlaceSearchRequest** ::DistanceHint);
    //use limit to adjust pagination.
        //this limits the number of place
    results to 5 per page.
        searchRequest.setLimit(5);

        //provide
    some categories to narrow down search
        **QList** <**QPlaceCategory** >
    categories;
        categories << diner << restaurant;
    searchRequest.setCategories(categories);

    Note that specifying a search center can be done by setting a circular
    search area that has a center but no radius. The default radius is set to
    -1, which indicates an undefined radius. The provider will interpret this as
    being free to choose its own default radius.

    The QPlaceSearchRequest is primarily used with the **QPlaceManager**  to
    **search for places** , however it is also used to provide parameters for
    **generating search term suggestions** . Note that in this context only some
    of the parameters may be relevant. For example, the search area is useful in
    narrowing down relevant search suggestions, while other parameters such as
    relevance hint are not so applicable.

    Also be aware that providers may vary by which parameters they support for
    example some providers may not support paging while others do, some
    providers may honor relevance hints while others may completely ignore them,
    see the **plugin documentation**  for more details.
    """

    class RelevanceHint(int):
        UnspecifiedHint: QPlaceSearchRequest = ...
        DistanceHint: QPlaceSearchRequest = ...
        LexicalPlaceNameHint: QPlaceSearchRequest = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#QPlaceSearchRequest

        **QPlaceSearchRequest::QPlaceSearchRequest()**

        Default constructor. Constructs an new request object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlaceSearchRequest") -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#QPlaceSearchRequest-1

        **QPlaceSearchRequest::QPlaceSearchRequest(const QPlaceSearchRequest &
        other )**

        Constructs a copy of **other**.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#clear

        **void QPlaceSearchRequest::clear()**

        Clears the search request.
        """
        ...

    def setLimit(self, limit: int) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#setLimit

        **void QPlaceSearchRequest::setLimit(int limit )**

        Set the maximum number of search results to retrieve to **limit**.

        **See also** **limit** ().
        """
        ...

    def limit(self) -> int:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#limit

        **int QPlaceSearchRequest::limit() const**

        Returns the maximum number of search results to retrieve.

        A negative value for limit means that it is undefined. It is left up to
        the backend provider to choose an appropriate number of results to
        return. The default limit is -1.

        **See also** **setLimit** ().
        """
        ...

    def setRelevanceHint(self, hint: "QPlaceSearchRequest.RelevanceHint") -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#setRelevanceHint

        **void
        QPlaceSearchRequest::setRelevanceHint(QPlaceSearchRequest::RelevanceHint
        hint )**

        Sets the relevance **hint** to be used when searching for a place.

        **See also** **relevanceHint** ().
        """
        ...

    def relevanceHint(self) -> "QPlaceSearchRequest.RelevanceHint":
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#relevanceHint

        **QPlaceSearchRequest::RelevanceHint
        QPlaceSearchRequest::relevanceHint() const**

        Returns the relevance hint of the request. The hint is given to the
        provider to help but not dictate the ranking of results. For example
        providing a distance hint may give closer places a higher ranking but it
        doesn't necessarily mean that he results will be ordered strictly
        according to distance.

        **See also** **setRelevanceHint** ().
        """
        ...

    def setVisibilityScope(
        self,
        visibilityScopes: typing.Union[QLocation.VisibilityScope, QLocation.Visibility],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#setVisibilityScope

        **void
        QPlaceSearchRequest::setVisibilityScope(QLocation::VisibilityScope scope
        )**

        Sets the visibility **scope** used when searching for places.

        **See also** **visibilityScope** ().
        """
        ...

    def visibilityScope(self) -> QLocation.VisibilityScope:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#visibilityScope

        **QLocation::VisibilityScope QPlaceSearchRequest::visibilityScope()
        const**

        Returns the visibility scope used when searching for places. The default
        value is **QLocation::UnspecifiedVisibility**  meaning that no explicit
        scope has been assigned. Places of any scope may be returned during the
        search.

        **See also** **setVisibilityScope** ().
        """
        ...

    def setSearchContext(self, context: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#setSearchContext

        **void QPlaceSearchRequest::setSearchContext(const QVariant & context
        )**

        Sets the search context to **context**.

        **Note:** This method is intended to be used by geo service plugins when
        returning search results of type
        **QPlaceSearchResult::ProposedSearchResult** .

        The search context is used by backends to store additional search
        context related to the search request. Other relevant fields should also
        be filled in. For example, if the search context encodes a text search
        the search term should also be set with **setSearchTerm** (). The search
        context allows additional search context to be kept which is not
        directly accessible via the Qt Location API.

        The search context can be of any type storable in a **QVariant** . The
        value of the search context is not intended to be use directly by
        applications.

        **See also** **searchContext** ().
        """
        ...

    def searchContext(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#searchContext

        **QVariant QPlaceSearchRequest::searchContext() const**

        Returns backend specific additional search context associated with this
        place search request. The search context is typically set as part of a
        **proposed search results** .

        **See also** **setSearchContext** ().
        """
        ...

    def setRecommendationId(self, recommendationId: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#setRecommendationId

        **void QPlaceSearchRequest::setRecommendationId(const QString & placeId
        )**

        Sets the **placeId** which will be used to search for recommendations.

        **See also** **recommendationId** ().
        """
        ...

    def recommendationId(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#recommendationId

        **QString QPlaceSearchRequest::recommendationId() const**

        Returns the place id which will be used to search for recommendations
        for similar places.

        **See also** **setRecommendationId** ().
        """
        ...

    def setSearchArea(self, area: QtPositioning.QGeoShape) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#setSearchArea

        **void QPlaceSearchRequest::setSearchArea(const QGeoShape & area )**

        Sets the search request to search within the given **area**.

        **See also** **searchArea** ().
        """
        ...

    def searchArea(self) -> QtPositioning.QGeoShape:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#searchArea

        **QGeoShape QPlaceSearchRequest::searchArea() const**

        Returns the search area which will be used to limit search results. The
        default search area is an invalid **QGeoShape** , indicating that no
        specific search area is defined.

        **See also** **setSearchArea** ().
        """
        ...

    def setCategories(self, categories: typing.Iterable[QPlaceCategory]) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#setCategories

        **void QPlaceSearchRequest::setCategories(const QList<QPlaceCategory> &
        categories )**

        Sets the search request to search from the list of given **categories**.
        Any places returned during the search will match at least one of the
        **categories**.

        **See also** **categories** () and **setCategory** ().
        """
        ...

    def setCategory(self, category: QPlaceCategory) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#setCategory

        **void QPlaceSearchRequest::setCategory(const QPlaceCategory & category
        )**

        Sets the search request to search by a single **category**

        **See also** **setCategories** ().
        """
        ...

    def categories(self) -> typing.List[QPlaceCategory]:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#categories

        **QList<QPlaceCategory> QPlaceSearchRequest::categories() const**

        Return the categories to be used in the search request. Places need only
        to belong to one of the categories to be considered a match by the
        request.

        **See also** **setCategories** ().
        """
        ...

    def setSearchTerm(self, term: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#setSearchTerm

        **void QPlaceSearchRequest::setSearchTerm(const QString & term )**

        Sets the search **term**.

        **See also** **searchTerm** ().
        """
        ...

    def searchTerm(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacesearchrequest.html#searchTerm

        **QString QPlaceSearchRequest::searchTerm() const**

        Returns the search term.

        **See also** **setSearchTerm** ().
        """
        ...
